# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appplatform.aio import AppPlatformManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAppPlatformManagementAppsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AppPlatformManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.apps.get(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.apps.begin_create_or_update(
                resource_group_name=resource_group.name,
                service_name="str",
                app_name="str",
                app_resource={
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "addonConfigs": {"str": {}},
                        "customPersistentDisks": [
                            {"storageId": "str", "customPersistentDiskProperties": "custom_persistent_disk_properties"}
                        ],
                        "enableEndToEndTLS": False,
                        "fqdn": "str",
                        "httpsOnly": False,
                        "ingressSettings": {
                            "backendProtocol": "str",
                            "clientAuth": {"certificates": ["str"]},
                            "readTimeoutInSeconds": 0,
                            "sendTimeoutInSeconds": 0,
                            "sessionAffinity": "str",
                            "sessionCookieMaxAge": 0,
                        },
                        "loadedCertificates": [{"resourceId": "str", "loadTrustStore": False}],
                        "persistentDisk": {"mountPath": "str", "sizeInGB": 0, "usedInGB": 0},
                        "provisioningState": "str",
                        "public": bool,
                        "temporaryDisk": {"mountPath": "/tmp", "sizeInGB": 0},
                        "url": "str",
                        "vnetAddons": {"publicEndpoint": False, "publicEndpointUrl": "str"},
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2023-12-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.apps.begin_delete(
                resource_group_name=resource_group.name,
                service_name="str",
                app_name="str",
                api_version="2023-12-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.apps.begin_update(
                resource_group_name=resource_group.name,
                service_name="str",
                app_name="str",
                app_resource={
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "addonConfigs": {"str": {}},
                        "customPersistentDisks": [
                            {"storageId": "str", "customPersistentDiskProperties": "custom_persistent_disk_properties"}
                        ],
                        "enableEndToEndTLS": False,
                        "fqdn": "str",
                        "httpsOnly": False,
                        "ingressSettings": {
                            "backendProtocol": "str",
                            "clientAuth": {"certificates": ["str"]},
                            "readTimeoutInSeconds": 0,
                            "sendTimeoutInSeconds": 0,
                            "sessionAffinity": "str",
                            "sessionCookieMaxAge": 0,
                        },
                        "loadedCertificates": [{"resourceId": "str", "loadTrustStore": False}],
                        "persistentDisk": {"mountPath": "str", "sizeInGB": 0, "usedInGB": 0},
                        "provisioningState": "str",
                        "public": bool,
                        "temporaryDisk": {"mountPath": "/tmp", "sizeInGB": 0},
                        "url": "str",
                        "vnetAddons": {"publicEndpoint": False, "publicEndpointUrl": "str"},
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2023-12-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.apps.list(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_resource_upload_url(self, resource_group):
        response = await self.client.apps.get_resource_upload_url(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_set_active_deployments(self, resource_group):
        response = await (
            await self.client.apps.begin_set_active_deployments(
                resource_group_name=resource_group.name,
                service_name="str",
                app_name="str",
                active_deployment_collection={"activeDeploymentNames": ["str"]},
                api_version="2023-12-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_validate_domain(self, resource_group):
        response = await self.client.apps.validate_domain(
            resource_group_name=resource_group.name,
            service_name="str",
            app_name="str",
            validate_payload={"name": "str"},
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...
