# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementBillingRequestsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_billing_profile(self, resource_group):
        response = self.client.billing_requests.list_by_billing_profile(
            billing_account_name="str",
            billing_profile_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_customer(self, resource_group):
        response = self.client.billing_requests.list_by_customer(
            billing_account_name="str",
            billing_profile_name="str",
            customer_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_invoice_section(self, resource_group):
        response = self.client.billing_requests.list_by_invoice_section(
            billing_account_name="str",
            billing_profile_name="str",
            invoice_section_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_billing_account(self, resource_group):
        response = self.client.billing_requests.list_by_billing_account(
            billing_account_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.billing_requests.get(
            billing_request_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.billing_requests.begin_create_or_update(
            billing_request_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "properties": {
                    "additionalInformation": {"str": "str"},
                    "billingAccountDisplayName": "str",
                    "billingAccountId": "str",
                    "billingAccountName": "str",
                    "billingAccountPrimaryBillingTenantId": "str",
                    "billingProfileDisplayName": "str",
                    "billingProfileId": "str",
                    "billingProfileName": "str",
                    "billingScope": "str",
                    "createdBy": {"objectId": "str", "tenantId": "str", "upn": "str"},
                    "creationDate": "2020-02-20 00:00:00",
                    "customerDisplayName": "str",
                    "customerId": "str",
                    "customerName": "str",
                    "decisionReason": "str",
                    "expirationDate": "2020-02-20 00:00:00",
                    "invoiceSectionDisplayName": "str",
                    "invoiceSectionId": "str",
                    "invoiceSectionName": "str",
                    "justification": "str",
                    "lastUpdatedBy": {"objectId": "str", "tenantId": "str", "upn": "str"},
                    "lastUpdatedDate": "2020-02-20 00:00:00",
                    "provisioningState": "str",
                    "recipients": [{"objectId": "str", "tenantId": "str", "upn": "str"}],
                    "requestScope": "str",
                    "reviewalDate": "2020-02-20 00:00:00",
                    "reviewedBy": {"objectId": "str", "tenantId": "str", "upn": "str"},
                    "status": "str",
                    "subscriptionDisplayName": "str",
                    "subscriptionId": "str",
                    "subscriptionName": "str",
                    "type": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_user(self, resource_group):
        response = self.client.billing_requests.list_by_user(
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
