/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.op.JitFloatBinOp;

/**
 * An extension for floating-point binary operators
 * 
 * @param <T> the class of p-code op node in the use-def graph
 */
public interface FloatBinOpGen<T extends JitFloatBinOp> extends BinOpGen<T> {
	@Override
	default boolean isSigned() {
		return false;
	}
}
