# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class EntitySearchType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """EntitySearchType."""

    ALLOWED_PARENTS = "AllowedParents"
    ALLOWED_CHILDREN = "AllowedChildren"
    PARENT_AND_FIRST_LEVEL_CHILDREN = "ParentAndFirstLevelChildren"
    PARENT_ONLY = "ParentOnly"
    CHILDREN_ONLY = "ChildrenOnly"


class EntityViewParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """EntityViewParameterType."""

    FULL_HIERARCHY = "FullHierarchy"
    GROUPS_ONLY = "GroupsOnly"
    SUBSCRIPTIONS_ONLY = "SubscriptionsOnly"
    AUDIT = "Audit"


class ManagementGroupChildType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of child resource."""

    MICROSOFT_MANAGEMENT_MANAGEMENT_GROUPS = "Microsoft.Management/managementGroups"
    _SUBSCRIPTIONS = "/subscriptions"


class ManagementGroupExpandType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ManagementGroupExpandType."""

    CHILDREN = "children"
    PATH = "path"
    ANCESTORS = "ancestors"


class Permissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The users specific permissions to this item."""

    NOACCESS = "noaccess"
    VIEW = "view"
    EDIT = "edit"
    DELETE = "delete"


class Reason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Required if nameAvailable == false. Invalid indicates the name provided does not match the
    resource provider's naming requirements (incorrect length, unsupported characters, etc.)
    AlreadyExists indicates that the name is already in use and is therefore unavailable.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the Tenant Backfill."""

    NOT_STARTED = "NotStarted"
    NOT_STARTED_BUT_GROUPS_EXIST = "NotStartedButGroupsExist"
    STARTED = "Started"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    COMPLETED = "Completed"
