# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python put_sensitivity_settings_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.sensitivity_settings.create_or_update(
        sensitivity_settings={
            "sensitiveInfoTypesIds": [
                "f2f8a7a1-28c0-404b-9ab4-30a0a7af18cb",
                "b452f22b-f87d-4f48-8490-ecf0873325b5",
                "d59ee8b6-2618-404b-a5e7-aa377cd67543",
            ],
            "sensitivityThresholdLabelId": "f2f8a7a1-28c0-404b-9ab4-30a0a7af18cb",
            "sensitivityThresholdLabelOrder": 2,
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/preview/2023-02-15-preview/examples/SensitivitySettings/PutSensitivitySettings_example.json
if __name__ == "__main__":
    main()
