// Copyright 2019 The libgav1 Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "src/utils/segmentation.h"

namespace libgav1 {

const int8_t kSegmentationFeatureBits[kSegmentFeatureMax] = {8, 6, 6, 6,
                                                             6, 3, 0, 0};
const int kSegmentationFeatureMaxValues[kSegmentFeatureMax] = {
    255,
    kMaxLoopFilterValue,
    kMaxLoopFilterValue,
    kMaxLoopFilterValue,
    kMaxLoopFilterValue,
    7,
    0,
    0};

}  // namespace libgav1
