//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import "time"

// AADConnectivityStateAutoGenerated - Describes an Azure resource with kind
type AADConnectivityStateAutoGenerated struct {
	// The connectivity state of the external AAD solution
	ConnectivityState *AADConnectivityState
}

// AADExternalSecuritySolution - Represents an AAD identity protection solution which sends logs to an OMS workspace.
type AADExternalSecuritySolution struct {
	// REQUIRED; The kind of the external solution
	Kind *ExternalSecuritySolutionKind

	// The external security solution properties for AAD solutions
	Properties *AADSolutionProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GetExternalSecuritySolution implements the ExternalSecuritySolutionClassification interface for type AADExternalSecuritySolution.
func (a *AADExternalSecuritySolution) GetExternalSecuritySolution() *ExternalSecuritySolution {
	return &ExternalSecuritySolution{
		ID:       a.ID,
		Kind:     a.Kind,
		Location: a.Location,
		Name:     a.Name,
		Type:     a.Type,
	}
}

// AADSolutionProperties - The external security solution properties for AAD solutions
type AADSolutionProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The connectivity state of the external AAD solution
	ConnectivityState *AADConnectivityState
	DeviceType        *string
	DeviceVendor      *string

	// Represents an OMS workspace to which the solution is connected
	Workspace *ConnectedWorkspace
}

// APICollectionProperties - Describes the properties of an API collection.
type APICollectionProperties struct {
	// Additional data regarding the API collection.
	AdditionalData map[string]*string

	// The display name of the Azure API Management API.
	DisplayName *string
}

// APICollectionResponse - An API collection as represented by Defender for APIs.
type APICollectionResponse struct {
	// Describes the properties of an API collection.
	Properties *APICollectionProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// APICollectionResponseList - Page of a list of API collections as represented by Defender for APIs.
type APICollectionResponseList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY; API collections in this page.
	Value []*APICollectionResponse
}

// ActiveConnectionsNotInAllowedRange - Number of active connections is not in allowed range.
type ActiveConnectionsNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ActiveConnectionsNotInAllowedRange.
func (a *ActiveConnectionsNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: a.Description,
		DisplayName: a.DisplayName,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type ActiveConnectionsNotInAllowedRange.
func (a *ActiveConnectionsNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  a.Description,
		DisplayName:  a.DisplayName,
		IsEnabled:    a.IsEnabled,
		MaxThreshold: a.MaxThreshold,
		MinThreshold: a.MinThreshold,
		RuleType:     a.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type ActiveConnectionsNotInAllowedRange.
func (a *ActiveConnectionsNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    a.Description,
		DisplayName:    a.DisplayName,
		IsEnabled:      a.IsEnabled,
		MaxThreshold:   a.MaxThreshold,
		MinThreshold:   a.MinThreshold,
		RuleType:       a.RuleType,
		TimeWindowSize: a.TimeWindowSize,
	}
}

type AdaptiveApplicationControlGroup struct {
	// REQUIRED; Represents a machines group and set of rules to be allowed running on a machine
	Properties *AdaptiveApplicationControlGroupData

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AdaptiveApplicationControlGroupData - Represents a machines group and set of rules to be allowed running on a machine
type AdaptiveApplicationControlGroupData struct {
	// The application control policy enforcement/protection mode of the machine group
	EnforcementMode     *EnforcementMode
	PathRecommendations []*PathRecommendation

	// The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
	ProtectionMode    *ProtectionMode
	VMRecommendations []*VMRecommendation

	// READ-ONLY; The configuration status of the machines group or machine or rule
	ConfigurationStatus *ConfigurationStatus

	// READ-ONLY
	Issues []*AdaptiveApplicationControlIssueSummary

	// READ-ONLY; The initial recommendation status of the machine group or machine
	RecommendationStatus *RecommendationStatus

	// READ-ONLY; The source type of the machine group
	SourceSystem *SourceSystem
}

// AdaptiveApplicationControlGroups - Represents a list of VM/server groups and set of rules that are Recommended by Microsoft
// Defender for Cloud to be allowed
type AdaptiveApplicationControlGroups struct {
	Value []*AdaptiveApplicationControlGroup
}

// AdaptiveApplicationControlIssueSummary - Represents a summary of the alerts of the machine group
type AdaptiveApplicationControlIssueSummary struct {
	// An alert that machines within a group can have
	Issue *AdaptiveApplicationControlIssue

	// The number of machines in the group that have this alert
	NumberOfVMs *float32
}

// AdaptiveNetworkHardening - The resource whose properties describes the Adaptive Network Hardening settings for some Azure
// resource
type AdaptiveNetworkHardening struct {
	// Properties of the Adaptive Network Hardening resource
	Properties *AdaptiveNetworkHardeningProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

type AdaptiveNetworkHardeningEnforceRequest struct {
	// REQUIRED; The Azure resource IDs of the effective network security groups that will be updated with the created security
	// rules from the Adaptive Network Hardening rules
	NetworkSecurityGroups []*string

	// REQUIRED; The rules to enforce
	Rules []*Rule
}

// AdaptiveNetworkHardeningProperties - Adaptive Network Hardening resource properties
type AdaptiveNetworkHardeningProperties struct {
	// The Network Security Groups effective on the network interfaces of the protected resource
	EffectiveNetworkSecurityGroups []*EffectiveNetworkSecurityGroups

	// The security rules which are recommended to be effective on the VM
	Rules []*Rule

	// The UTC time on which the rules were calculated
	RulesCalculationTime *time.Time
}

// AdaptiveNetworkHardeningsList - Response for ListAdaptiveNetworkHardenings API service call
type AdaptiveNetworkHardeningsList struct {
	// The URL to get the next set of results
	NextLink *string

	// A list of Adaptive Network Hardenings resources
	Value []*AdaptiveNetworkHardening
}

// AdditionalData - Details of the sub-assessment
type AdditionalData struct {
	// REQUIRED; Sub-assessment resource type
	AssessedResourceType *AssessedResourceType
}

// GetAdditionalData implements the AdditionalDataClassification interface for type AdditionalData.
func (a *AdditionalData) GetAdditionalData() *AdditionalData { return a }

// AdditionalWorkspacesProperties - Properties of the additional workspaces.
type AdditionalWorkspacesProperties struct {
	// List of data types sent to workspace
	DataTypes []*AdditionalWorkspaceDataType

	// Workspace type.
	Type *AdditionalWorkspaceType

	// Workspace resource id
	Workspace *string
}

// AdvancedThreatProtectionProperties - The Advanced Threat Protection settings.
type AdvancedThreatProtectionProperties struct {
	// Indicates whether Advanced Threat Protection is enabled.
	IsEnabled *bool
}

// AdvancedThreatProtectionSetting - The Advanced Threat Protection resource.
type AdvancedThreatProtectionSetting struct {
	// The Advanced Threat Protection settings.
	Properties *AdvancedThreatProtectionProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// Alert - Security alert
type Alert struct {
	// describes security alert properties.
	Properties *AlertProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AlertEntity - Changing set of properties depending on the entity type.
type AlertEntity struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Type of entity
	Type *string
}

// AlertList - List of security alerts
type AlertList struct {
	// describes security alert properties.
	Value []*Alert

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// AlertProperties - describes security alert properties.
type AlertProperties struct {
	// Custom properties for the alert.
	ExtendedProperties map[string]*string

	// Changing set of properties depending on the supportingEvidence type.
	SupportingEvidence *AlertPropertiesSupportingEvidence

	// READ-ONLY; The display name of the alert.
	AlertDisplayName *string

	// READ-ONLY; Unique identifier for the detection logic (all alert instances from the same detection logic will have the same
	// alertType).
	AlertType *string

	// READ-ONLY; A direct link to the alert page in Azure Portal.
	AlertURI *string

	// READ-ONLY; The display name of the resource most related to this alert.
	CompromisedEntity *string

	// READ-ONLY; Key for corelating related alerts. Alerts with the same correlation key considered to be related.
	CorrelationKey *string

	// READ-ONLY; Description of the suspicious activity that was detected.
	Description *string

	// READ-ONLY; The UTC time of the last event or activity included in the alert in ISO8601 format.
	EndTimeUTC *time.Time

	// READ-ONLY; A list of entities related to the alert.
	Entities []*AlertEntity

	// READ-ONLY; Links related to the alert
	ExtendedLinks []map[string]*string

	// READ-ONLY; The kill chain related intent behind the alert. For list of supported values, and explanations of Azure Security
	// Center's supported kill chain intents.
	Intent *Intent

	// READ-ONLY; This field determines whether the alert is an incident (a compound grouping of several alerts) or a single alert.
	IsIncident *bool

	// READ-ONLY; The UTC processing end time of the alert in ISO8601 format.
	ProcessingEndTimeUTC *time.Time

	// READ-ONLY; The name of Azure Security Center pricing tier which powering this alert. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-pricing
	ProductComponentName *string

	// READ-ONLY; The name of the product which published this alert (Microsoft Sentinel, Microsoft Defender for Identity, Microsoft
	// Defender for Endpoint, Microsoft Defender for Office, Microsoft Defender for Cloud
	// Apps, and so on).
	ProductName *string

	// READ-ONLY; Manual action items to take to remediate the alert.
	RemediationSteps []*string

	// READ-ONLY; The resource identifiers that can be used to direct the alert to the right product exposure group (tenant, workspace,
	// subscription etc.). There can be multiple identifiers of different type per alert.
	ResourceIdentifiers []ResourceIdentifierClassification

	// READ-ONLY; The risk level of the threat that was detected. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified.
	Severity *AlertSeverity

	// READ-ONLY; The UTC time of the first event or activity included in the alert in ISO8601 format.
	StartTimeUTC *time.Time

	// READ-ONLY; The life cycle status of the alert.
	Status *AlertStatus

	// READ-ONLY; Kill chain related sub-techniques behind the alert.
	SubTechniques []*string

	// READ-ONLY; Unique identifier for the alert.
	SystemAlertID *string

	// READ-ONLY; kill chain related techniques behind the alert.
	Techniques []*string

	// READ-ONLY; The UTC time the alert was generated in ISO8601 format.
	TimeGeneratedUTC *time.Time

	// READ-ONLY; The name of the vendor that raises the alert.
	VendorName *string

	// READ-ONLY; Schema version.
	Version *string
}

// AlertPropertiesSupportingEvidence - Changing set of properties depending on the supportingEvidence type.
type AlertPropertiesSupportingEvidence struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Type of the supportingEvidence
	Type *string
}

// AlertSimulatorBundlesRequestProperties - Simulate alerts according to this bundles.
type AlertSimulatorBundlesRequestProperties struct {
	// REQUIRED; The kind of alert simulation.
	Kind *Kind

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Bundles list.
	Bundles []*BundleType
}

// GetAlertSimulatorRequestProperties implements the AlertSimulatorRequestPropertiesClassification interface for type AlertSimulatorBundlesRequestProperties.
func (a *AlertSimulatorBundlesRequestProperties) GetAlertSimulatorRequestProperties() *AlertSimulatorRequestProperties {
	return &AlertSimulatorRequestProperties{
		AdditionalProperties: a.AdditionalProperties,
		Kind:                 a.Kind,
	}
}

// AlertSimulatorRequestBody - Alert Simulator request body.
type AlertSimulatorRequestBody struct {
	// Alert Simulator request body data.
	Properties AlertSimulatorRequestPropertiesClassification
}

// AlertSimulatorRequestProperties - Describes properties of an alert simulation request
type AlertSimulatorRequestProperties struct {
	// REQUIRED; The kind of alert simulation.
	Kind *Kind

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
}

// GetAlertSimulatorRequestProperties implements the AlertSimulatorRequestPropertiesClassification interface for type AlertSimulatorRequestProperties.
func (a *AlertSimulatorRequestProperties) GetAlertSimulatorRequestProperties() *AlertSimulatorRequestProperties {
	return a
}

// AlertSyncSettingProperties - The alert sync setting properties
type AlertSyncSettingProperties struct {
	// REQUIRED; Is the alert sync setting enabled
	Enabled *bool
}

// AlertSyncSettings - Represents an alert sync setting
type AlertSyncSettings struct {
	// REQUIRED; the kind of the settings string
	Kind *SettingKind

	// Alert sync setting data
	Properties *AlertSyncSettingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GetSetting implements the SettingClassification interface for type AlertSyncSettings.
func (a *AlertSyncSettings) GetSetting() *Setting {
	return &Setting{
		ID:   a.ID,
		Kind: a.Kind,
		Name: a.Name,
		Type: a.Type,
	}
}

// AlertsSuppressionRule - Describes the suppression rule
type AlertsSuppressionRule struct {
	// describes AlertsSuppressionRule properties
	Properties *AlertsSuppressionRuleProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AlertsSuppressionRuleProperties - describes AlertsSuppressionRule properties
type AlertsSuppressionRuleProperties struct {
	// REQUIRED; Type of the alert to automatically suppress. For all alert types, use '*'
	AlertType *string

	// REQUIRED; The reason for dismissing the alert
	Reason *string

	// REQUIRED; Possible states of the rule
	State *RuleState

	// Any comment regarding the rule
	Comment *string

	// Expiration date of the rule, if value is not provided or provided as null this field will default to the maximum allowed
	// expiration date.
	ExpirationDateUTC *time.Time

	// The suppression conditions
	SuppressionAlertsScope *SuppressionAlertsScope

	// READ-ONLY; The last time this rule was modified
	LastModifiedUTC *time.Time
}

// AlertsSuppressionRulesList - Suppression rules list for subscription.
type AlertsSuppressionRulesList struct {
	// REQUIRED
	Value []*AlertsSuppressionRule

	// READ-ONLY; URI to fetch the next page.
	NextLink *string
}

// AllowedConnectionsList - List of all possible traffic between Azure resources
type AllowedConnectionsList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY
	Value []*AllowedConnectionsResource
}

// AllowedConnectionsResource - The resource whose properties describes the allowed traffic between Azure resources
type AllowedConnectionsResource struct {
	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Describes the allowed traffic between Azure resources
	Properties *AllowedConnectionsResourceProperties

	// READ-ONLY; Resource type
	Type *string
}

// AllowedConnectionsResourceProperties - Describes the allowed traffic between Azure resources
type AllowedConnectionsResourceProperties struct {
	// READ-ONLY; The UTC time on which the allowed connections resource was calculated
	CalculatedDateTime *time.Time

	// READ-ONLY; List of connectable resources
	ConnectableResources []*ConnectableResource
}

// AllowlistCustomAlertRule - A custom alert rule that checks if a value (depends on the custom alert type) is allowed.
type AllowlistCustomAlertRule struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type AllowlistCustomAlertRule.
func (a *AllowlistCustomAlertRule) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule { return a }

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type AllowlistCustomAlertRule.
func (a *AllowlistCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: a.Description,
		DisplayName: a.DisplayName,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type AllowlistCustomAlertRule.
func (a *AllowlistCustomAlertRule) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		Description: a.Description,
		DisplayName: a.DisplayName,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
		ValueType:   a.ValueType,
	}
}

// AmqpC2DMessagesNotInAllowedRange - Number of cloud to device messages (AMQP protocol) is not in allowed range.
type AmqpC2DMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type AmqpC2DMessagesNotInAllowedRange.
func (a *AmqpC2DMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: a.Description,
		DisplayName: a.DisplayName,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type AmqpC2DMessagesNotInAllowedRange.
func (a *AmqpC2DMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  a.Description,
		DisplayName:  a.DisplayName,
		IsEnabled:    a.IsEnabled,
		MaxThreshold: a.MaxThreshold,
		MinThreshold: a.MinThreshold,
		RuleType:     a.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type AmqpC2DMessagesNotInAllowedRange.
func (a *AmqpC2DMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    a.Description,
		DisplayName:    a.DisplayName,
		IsEnabled:      a.IsEnabled,
		MaxThreshold:   a.MaxThreshold,
		MinThreshold:   a.MinThreshold,
		RuleType:       a.RuleType,
		TimeWindowSize: a.TimeWindowSize,
	}
}

// AmqpC2DRejectedMessagesNotInAllowedRange - Number of rejected cloud to device messages (AMQP protocol) is not in allowed
// range.
type AmqpC2DRejectedMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type AmqpC2DRejectedMessagesNotInAllowedRange.
func (a *AmqpC2DRejectedMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: a.Description,
		DisplayName: a.DisplayName,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type AmqpC2DRejectedMessagesNotInAllowedRange.
func (a *AmqpC2DRejectedMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  a.Description,
		DisplayName:  a.DisplayName,
		IsEnabled:    a.IsEnabled,
		MaxThreshold: a.MaxThreshold,
		MinThreshold: a.MinThreshold,
		RuleType:     a.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type AmqpC2DRejectedMessagesNotInAllowedRange.
func (a *AmqpC2DRejectedMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    a.Description,
		DisplayName:    a.DisplayName,
		IsEnabled:      a.IsEnabled,
		MaxThreshold:   a.MaxThreshold,
		MinThreshold:   a.MinThreshold,
		RuleType:       a.RuleType,
		TimeWindowSize: a.TimeWindowSize,
	}
}

// AmqpD2CMessagesNotInAllowedRange - Number of device to cloud messages (AMQP protocol) is not in allowed range.
type AmqpD2CMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type AmqpD2CMessagesNotInAllowedRange.
func (a *AmqpD2CMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: a.Description,
		DisplayName: a.DisplayName,
		IsEnabled:   a.IsEnabled,
		RuleType:    a.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type AmqpD2CMessagesNotInAllowedRange.
func (a *AmqpD2CMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  a.Description,
		DisplayName:  a.DisplayName,
		IsEnabled:    a.IsEnabled,
		MaxThreshold: a.MaxThreshold,
		MinThreshold: a.MinThreshold,
		RuleType:     a.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type AmqpD2CMessagesNotInAllowedRange.
func (a *AmqpD2CMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    a.Description,
		DisplayName:    a.DisplayName,
		IsEnabled:      a.IsEnabled,
		MaxThreshold:   a.MaxThreshold,
		MinThreshold:   a.MinThreshold,
		RuleType:       a.RuleType,
		TimeWindowSize: a.TimeWindowSize,
	}
}

// Application - Security Application over a given scope
type Application struct {
	// Properties of a security application
	Properties *ApplicationProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ApplicationCondition - Application's condition
type ApplicationCondition struct {
	// The application Condition's Operator, for example Contains for id or In for list of possible IDs, see examples
	Operator *ApplicationConditionOperator

	// The application Condition's Property, e.g. ID, see examples
	Property *string

	// The application Condition's Value like IDs that contain some string, see examples
	Value *string
}

// ApplicationProperties - Describes properties of an application
type ApplicationProperties struct {
	// REQUIRED; The application conditionSets - see examples
	ConditionSets []any

	// REQUIRED; The application source, what it affects, e.g. Assessments
	SourceResourceType *ApplicationSourceResourceType

	// description of the application
	Description *string

	// display name of the application
	DisplayName *string
}

// ApplicationsList - Page of a security applications list
type ApplicationsList struct {
	// READ-ONLY; The URI to fetch the next page
	NextLink *string

	// READ-ONLY; Collection of applications in this page
	Value []*Application
}

// AscLocation - The ASC location of the subscription is in the "name" field
type AscLocation struct {
	// An empty set of properties
	Properties any

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AscLocationList - List of locations where ASC saves your data
type AscLocationList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY
	Value []*AscLocation
}

// Assessment - Security assessment on a resource
type Assessment struct {
	// Describes properties of an assessment.
	Properties *AssessmentProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AssessmentLinks - Links relevant to the assessment
type AssessmentLinks struct {
	// READ-ONLY; Link to assessment in Azure Portal
	AzurePortalURI *string
}

// AssessmentList - Page of a security assessments list
type AssessmentList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY; Collection of security assessments in this page
	Value []*AssessmentResponse
}

// AssessmentMetadata - Security assessment metadata
type AssessmentMetadata struct {
	// Describes properties of an assessment metadata.
	Properties *AssessmentMetadataProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AssessmentMetadataPartnerData - Describes the partner that created the assessment
type AssessmentMetadataPartnerData struct {
	// REQUIRED; Name of the company of the partner
	PartnerName *string

	// REQUIRED; Secret to authenticate the partner and verify it created the assessment - write only
	Secret *string

	// Name of the product of the partner that created the assessment
	ProductName *string
}

// AssessmentMetadataProperties - Describes properties of an assessment metadata.
type AssessmentMetadataProperties struct {
	// REQUIRED; BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom
	// Azure Policy definition
	AssessmentType *AssessmentType

	// REQUIRED; User friendly display name of the assessment
	DisplayName *string

	// REQUIRED; The severity level of the assessment
	Severity   *Severity
	Categories []*Categories

	// Human readable description of the assessment
	Description *string

	// The implementation effort required to remediate this assessment
	ImplementationEffort *ImplementationEffort

	// Describes the partner that created the assessment
	PartnerData *AssessmentMetadataPartnerData

	// True if this assessment is in preview release status
	Preview *bool

	// Human readable description of what you should do to mitigate this security issue
	RemediationDescription *string
	Threats                []*Threats

	// The user impact of the assessment
	UserImpact *UserImpact

	// READ-ONLY; Azure resource ID of the policy definition that turns this assessment calculation on
	PolicyDefinitionID *string
}

// AssessmentMetadataPropertiesResponse - Describes properties of an assessment metadata response.
type AssessmentMetadataPropertiesResponse struct {
	// REQUIRED; BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom
	// Azure Policy definition
	AssessmentType *AssessmentType

	// REQUIRED; User friendly display name of the assessment
	DisplayName *string

	// REQUIRED; The severity level of the assessment
	Severity   *Severity
	Categories []*Categories

	// Human readable description of the assessment
	Description *string

	// The implementation effort required to remediate this assessment
	ImplementationEffort *ImplementationEffort

	// Describes the partner that created the assessment
	PartnerData            *AssessmentMetadataPartnerData
	PlannedDeprecationDate *string

	// True if this assessment is in preview release status
	Preview      *bool
	PublishDates *AssessmentMetadataPropertiesResponsePublishDates

	// Human readable description of what you should do to mitigate this security issue
	RemediationDescription *string
	Tactics                []*Tactics
	Techniques             []*Techniques
	Threats                []*Threats

	// The user impact of the assessment
	UserImpact *UserImpact

	// READ-ONLY; Azure resource ID of the policy definition that turns this assessment calculation on
	PolicyDefinitionID *string
}

type AssessmentMetadataPropertiesResponsePublishDates struct {
	// REQUIRED
	Public *string
	GA     *string
}

// AssessmentMetadataResponse - Security assessment metadata response
type AssessmentMetadataResponse struct {
	// Describes properties of an assessment metadata response.
	Properties *AssessmentMetadataPropertiesResponse

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AssessmentMetadataResponseList - List of security assessment metadata
type AssessmentMetadataResponseList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY
	Value []*AssessmentMetadataResponse
}

// AssessmentPartnerData - Data regarding 3rd party partner integration
type AssessmentPartnerData struct {
	// REQUIRED; Name of the company of the partner
	PartnerName *string

	// REQUIRED; secret to authenticate the partner - write only
	Secret *string
}

// AssessmentProperties - Describes properties of an assessment.
type AssessmentProperties struct {
	// REQUIRED; Details of the resource that was assessed
	ResourceDetails ResourceDetailsClassification

	// REQUIRED; The result of the assessment
	Status *AssessmentStatus

	// Additional data regarding the assessment
	AdditionalData map[string]*string

	// Describes properties of an assessment metadata.
	Metadata *AssessmentMetadataProperties

	// Data regarding 3rd party partner integration
	PartnersData *AssessmentPartnerData

	// READ-ONLY; User friendly display name of the assessment
	DisplayName *string

	// READ-ONLY; Links relevant to the assessment
	Links *AssessmentLinks
}

// AssessmentPropertiesBase - Describes properties of an assessment.
type AssessmentPropertiesBase struct {
	// REQUIRED; Details of the resource that was assessed
	ResourceDetails ResourceDetailsClassification

	// Additional data regarding the assessment
	AdditionalData map[string]*string

	// Describes properties of an assessment metadata.
	Metadata *AssessmentMetadataProperties

	// Data regarding 3rd party partner integration
	PartnersData *AssessmentPartnerData

	// READ-ONLY; User friendly display name of the assessment
	DisplayName *string

	// READ-ONLY; Links relevant to the assessment
	Links *AssessmentLinks
}

// AssessmentPropertiesResponse - Describes properties of an assessment.
type AssessmentPropertiesResponse struct {
	// REQUIRED; Details of the resource that was assessed
	ResourceDetails ResourceDetailsClassification

	// REQUIRED; The result of the assessment
	Status *AssessmentStatusResponse

	// Additional data regarding the assessment
	AdditionalData map[string]*string

	// Describes properties of an assessment metadata.
	Metadata *AssessmentMetadataProperties

	// Data regarding 3rd party partner integration
	PartnersData *AssessmentPartnerData

	// READ-ONLY; User friendly display name of the assessment
	DisplayName *string

	// READ-ONLY; Links relevant to the assessment
	Links *AssessmentLinks
}

// AssessmentResponse - Security assessment on a resource - response format
type AssessmentResponse struct {
	// Describes properties of an assessment.
	Properties *AssessmentPropertiesResponse

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AssessmentStatus - The result of the assessment
type AssessmentStatus struct {
	// REQUIRED; Programmatic code for the status of the assessment
	Code *AssessmentStatusCode

	// Programmatic code for the cause of the assessment status
	Cause *string

	// Human readable description of the assessment status
	Description *string
}

// AssessmentStatusResponse - The result of the assessment
type AssessmentStatusResponse struct {
	// REQUIRED; Programmatic code for the status of the assessment
	Code *AssessmentStatusCode

	// Programmatic code for the cause of the assessment status
	Cause *string

	// Human readable description of the assessment status
	Description *string

	// READ-ONLY; The time that the assessment was created and first evaluated. Returned as UTC time in ISO 8601 format
	FirstEvaluationDate *time.Time

	// READ-ONLY; The time that the status of the assessment last changed. Returned as UTC time in ISO 8601 format
	StatusChangeDate *time.Time
}

// AtaExternalSecuritySolution - Represents an ATA security solution which sends logs to an OMS workspace
type AtaExternalSecuritySolution struct {
	// REQUIRED; The kind of the external solution
	Kind *ExternalSecuritySolutionKind

	// The external security solution properties for ATA solutions
	Properties *AtaSolutionProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GetExternalSecuritySolution implements the ExternalSecuritySolutionClassification interface for type AtaExternalSecuritySolution.
func (a *AtaExternalSecuritySolution) GetExternalSecuritySolution() *ExternalSecuritySolution {
	return &ExternalSecuritySolution{
		ID:       a.ID,
		Kind:     a.Kind,
		Location: a.Location,
		Name:     a.Name,
		Type:     a.Type,
	}
}

// AtaSolutionProperties - The external security solution properties for ATA solutions
type AtaSolutionProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
	DeviceType           *string
	DeviceVendor         *string
	LastEventReceived    *string

	// Represents an OMS workspace to which the solution is connected
	Workspace *ConnectedWorkspace
}

// AuthenticationDetailsProperties - Settings for cloud authentication management
type AuthenticationDetailsProperties struct {
	// REQUIRED; Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use
	// account organization credentials.
	AuthenticationType *AuthenticationType

	// READ-ONLY; State of the multi-cloud connector
	AuthenticationProvisioningState *AuthenticationProvisioningState

	// READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions []*PermissionProperty
}

// GetAuthenticationDetailsProperties implements the AuthenticationDetailsPropertiesClassification interface for type AuthenticationDetailsProperties.
func (a *AuthenticationDetailsProperties) GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties {
	return a
}

// AutoProvisioningSetting - Auto provisioning setting
type AutoProvisioningSetting struct {
	// Auto provisioning setting data
	Properties *AutoProvisioningSettingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AutoProvisioningSettingList - List of all the auto provisioning settings response
type AutoProvisioningSettingList struct {
	// List of all the auto provisioning settings
	Value []*AutoProvisioningSetting

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// AutoProvisioningSettingProperties - describes properties of an auto provisioning setting
type AutoProvisioningSettingProperties struct {
	// REQUIRED; Describes what kind of security agent provisioning action to take
	AutoProvision *AutoProvision
}

// Automation - The security automation resource.
type Automation struct {
	// Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string

	// Kind of the resource
	Kind *string

	// Location where the resource is stored
	Location *string

	// Security automation data
	Properties *AutomationProperties

	// A list of key value pairs that describe the resource.
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AutomationAction - The action that should be triggered.
type AutomationAction struct {
	// REQUIRED; The type of the action that will be triggered by the Automation
	ActionType *ActionType
}

// GetAutomationAction implements the AutomationActionClassification interface for type AutomationAction.
func (a *AutomationAction) GetAutomationAction() *AutomationAction { return a }

// AutomationActionEventHub - The target Event Hub to which event data will be exported. To learn more about Microsoft Defender
// for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
type AutomationActionEventHub struct {
	// REQUIRED; The type of the action that will be triggered by the Automation
	ActionType *ActionType

	// The target Event Hub connection string (it will not be included in any response).
	ConnectionString *string

	// The target Event Hub Azure Resource ID.
	EventHubResourceID *string

	// READ-ONLY; The target Event Hub SAS policy name.
	SasPolicyName *string
}

// GetAutomationAction implements the AutomationActionClassification interface for type AutomationActionEventHub.
func (a *AutomationActionEventHub) GetAutomationAction() *AutomationAction {
	return &AutomationAction{
		ActionType: a.ActionType,
	}
}

// AutomationActionLogicApp - The logic app action that should be triggered. To learn more about Microsoft Defender for Cloud's
// Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
type AutomationActionLogicApp struct {
	// REQUIRED; The type of the action that will be triggered by the Automation
	ActionType *ActionType

	// The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions
	// to trigger the Logic App
	LogicAppResourceID *string

	// The Logic App trigger URI endpoint (it will not be included in any response).
	URI *string
}

// GetAutomationAction implements the AutomationActionClassification interface for type AutomationActionLogicApp.
func (a *AutomationActionLogicApp) GetAutomationAction() *AutomationAction {
	return &AutomationAction{
		ActionType: a.ActionType,
	}
}

// AutomationActionWorkspace - The Log Analytics Workspace to which event data will be exported. Security alerts data will
// reside in the 'SecurityAlert' table and the assessments data will reside in the 'SecurityRecommendation'
// table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order to view the data in the workspace, the
// Security Center Log Analytics free/standard solution needs to be enabled on that
// workspace. To learn more about Microsoft Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
type AutomationActionWorkspace struct {
	// REQUIRED; The type of the action that will be triggered by the Automation
	ActionType *ActionType

	// The fully qualified Log Analytics Workspace Azure Resource ID.
	WorkspaceResourceID *string
}

// GetAutomationAction implements the AutomationActionClassification interface for type AutomationActionWorkspace.
func (a *AutomationActionWorkspace) GetAutomationAction() *AutomationAction {
	return &AutomationAction{
		ActionType: a.ActionType,
	}
}

// AutomationList - List of security automations response.
type AutomationList struct {
	// REQUIRED; The list of security automations under the given scope.
	Value []*Automation

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// AutomationProperties - A set of properties that defines the behavior of the automation configuration. To learn more about
// the supported security events data models schemas - please visit https://aka.ms/ASCAutomationSchemas.
type AutomationProperties struct {
	// A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set,
	// are true.
	Actions []AutomationActionClassification

	// The security automation description.
	Description *string

	// Indicates whether the security automation is enabled.
	IsEnabled *bool

	// A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself
	// or a resource group under that subscription. The automation will only apply on
	// defined scopes.
	Scopes []*AutomationScope

	// A collection of the source event types which evaluate the security automation set of rules.
	Sources []*AutomationSource
}

// AutomationRuleSet - A rule set which evaluates all its rules upon an event interception. Only when all the included rules
// in the rule set will be evaluated as 'true', will the event trigger the defined actions.
type AutomationRuleSet struct {
	Rules []*AutomationTriggeringRule
}

// AutomationScope - A single automation scope.
type AutomationScope struct {
	// The resources scope description.
	Description *string

	// The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that
	// subscription (fully qualified Azure resource IDs).
	ScopePath *string
}

// AutomationSource - The source event types which evaluate the security automation set of rules. For example - security alerts
// and security assessments. To learn more about the supported security events data models
// schemas - please visit https://aka.ms/ASCAutomationSchemas.
type AutomationSource struct {
	// A valid event source type.
	EventSource *EventSource

	// A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical
	// 'or').
	RuleSets []*AutomationRuleSet
}

// AutomationTriggeringRule - A rule which is evaluated upon event interception. The rule is configured by comparing a specific
// value from the event model to an expected value. This comparison is done by using one of the supported
// operators set.
type AutomationTriggeringRule struct {
	// The expected value.
	ExpectedValue *string

	// A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
	Operator *Operator

	// The JPath of the entity model property that should be checked.
	PropertyJPath *string

	// The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
	PropertyType *PropertyType
}

// AutomationValidationStatus - The security automation model state property bag.
type AutomationValidationStatus struct {
	// Indicates whether the model is valid or not.
	IsValid *bool

	// The validation message.
	Message *string
}

// AwAssumeRoleAuthenticationDetailsProperties - AWS cloud account connector based assume role, the role enables delegating
// access to your AWS resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more details,
// refer to Creating a Role to Delegate Permissions to an IAM User (write only) [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html]
type AwAssumeRoleAuthenticationDetailsProperties struct {
	// REQUIRED; Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use
	// account organization credentials.
	AuthenticationType *AuthenticationType

	// REQUIRED; Assumed role ID is an identifier that you can use to create temporary security credentials.
	AwsAssumeRoleArn *string

	// REQUIRED; A unique identifier that is required when you assume a role in another account.
	AwsExternalID *string

	// READ-ONLY; The ID of the cloud account
	AccountID *string

	// READ-ONLY; State of the multi-cloud connector
	AuthenticationProvisioningState *AuthenticationProvisioningState

	// READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions []*PermissionProperty
}

// GetAuthenticationDetailsProperties implements the AuthenticationDetailsPropertiesClassification interface for type AwAssumeRoleAuthenticationDetailsProperties.
func (a *AwAssumeRoleAuthenticationDetailsProperties) GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties {
	return &AuthenticationDetailsProperties{
		AuthenticationProvisioningState: a.AuthenticationProvisioningState,
		AuthenticationType:              a.AuthenticationType,
		GrantedPermissions:              a.GrantedPermissions,
	}
}

// AwsCredsAuthenticationDetailsProperties - AWS cloud account connector based credentials, the credentials is composed of
// access key ID and secret key, for more details, refer to Creating an IAM User in Your AWS Account (write only)
// [https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html]
type AwsCredsAuthenticationDetailsProperties struct {
	// REQUIRED; Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use
	// account organization credentials.
	AuthenticationType *AuthenticationType

	// REQUIRED; Public key element of the AWS credential object (write only)
	AwsAccessKeyID *string

	// REQUIRED; Secret key element of the AWS credential object (write only)
	AwsSecretAccessKey *string

	// READ-ONLY; The ID of the cloud account
	AccountID *string

	// READ-ONLY; State of the multi-cloud connector
	AuthenticationProvisioningState *AuthenticationProvisioningState

	// READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions []*PermissionProperty
}

// GetAuthenticationDetailsProperties implements the AuthenticationDetailsPropertiesClassification interface for type AwsCredsAuthenticationDetailsProperties.
func (a *AwsCredsAuthenticationDetailsProperties) GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties {
	return &AuthenticationDetailsProperties{
		AuthenticationProvisioningState: a.AuthenticationProvisioningState,
		AuthenticationType:              a.AuthenticationType,
		GrantedPermissions:              a.GrantedPermissions,
	}
}

// AwsEnvironmentData - The AWS connector environment data
type AwsEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType

	// The AWS account's organizational data
	OrganizationalData AwsOrganizationalDataClassification

	// list of regions to scan
	Regions []*string

	// READ-ONLY; The AWS account name
	AccountName *string
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type AwsEnvironmentData.
func (a *AwsEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: a.EnvironmentType,
	}
}

// AwsOrganizationalData - The AWS organization data
type AwsOrganizationalData struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType
}

// GetAwsOrganizationalData implements the AwsOrganizationalDataClassification interface for type AwsOrganizationalData.
func (a *AwsOrganizationalData) GetAwsOrganizationalData() *AwsOrganizationalData { return a }

// AwsOrganizationalDataMaster - The AWS organization data for the master account
type AwsOrganizationalDataMaster struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType

	// If the multi cloud account is of membership type organization, list of accounts excluded from offering
	ExcludedAccountIDs []*string

	// If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
	StacksetName *string
}

// GetAwsOrganizationalData implements the AwsOrganizationalDataClassification interface for type AwsOrganizationalDataMaster.
func (a *AwsOrganizationalDataMaster) GetAwsOrganizationalData() *AwsOrganizationalData {
	return &AwsOrganizationalData{
		OrganizationMembershipType: a.OrganizationMembershipType,
	}
}

// AwsOrganizationalDataMember - The AWS organization data for the member account
type AwsOrganizationalDataMember struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType

	// If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
	ParentHierarchyID *string
}

// GetAwsOrganizationalData implements the AwsOrganizationalDataClassification interface for type AwsOrganizationalDataMember.
func (a *AwsOrganizationalDataMember) GetAwsOrganizationalData() *AwsOrganizationalData {
	return &AwsOrganizationalData{
		OrganizationMembershipType: a.OrganizationMembershipType,
	}
}

// AzureDevOpsScopeEnvironmentData - The AzureDevOps scope connector's environment data
type AzureDevOpsScopeEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type AzureDevOpsScopeEnvironmentData.
func (a *AzureDevOpsScopeEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: a.EnvironmentType,
	}
}

// AzureResourceDetails - Details of the Azure resource that was assessed
type AzureResourceDetails struct {
	// REQUIRED; The platform where the assessed resource resides
	Source *Source

	// READ-ONLY; Azure resource Id of the assessed resource
	ID *string
}

// GetResourceDetails implements the ResourceDetailsClassification interface for type AzureResourceDetails.
func (a *AzureResourceDetails) GetResourceDetails() *ResourceDetails {
	return &ResourceDetails{
		Source: a.Source,
	}
}

// AzureResourceIdentifier - Azure resource identifier.
type AzureResourceIdentifier struct {
	// REQUIRED; There can be multiple identifiers of different type per alert, this field specify the identifier type.
	Type *ResourceIdentifierType

	// READ-ONLY; ARM resource identifier for the cloud resource being alerted on
	AzureResourceID *string
}

// GetResourceIdentifier implements the ResourceIdentifierClassification interface for type AzureResourceIdentifier.
func (a *AzureResourceIdentifier) GetResourceIdentifier() *ResourceIdentifier {
	return &ResourceIdentifier{
		Type: a.Type,
	}
}

// AzureResourceLink - Describes an Azure resource with kind
type AzureResourceLink struct {
	// READ-ONLY; Azure resource Id
	ID *string
}

// AzureTrackedResourceLocation - Describes an Azure resource with location
type AzureTrackedResourceLocation struct {
	// Location where the resource is stored
	Location *string
}

// Baseline details.
type Baseline struct {
	// Expected results.
	ExpectedResults [][]*string

	// Baseline update time (UTC).
	UpdatedTime *time.Time
}

// BaselineAdjustedResult - The rule result adjusted with baseline.
type BaselineAdjustedResult struct {
	// Baseline details.
	Baseline *Baseline

	// Results the are not in baseline.
	ResultsNotInBaseline [][]*string

	// Results the are in baseline.
	ResultsOnlyInBaseline [][]*string

	// The rule result status.
	Status *RuleStatus
}

// BenchmarkReference - The benchmark references.
type BenchmarkReference struct {
	// The benchmark name.
	Benchmark *string

	// The benchmark reference.
	Reference *string
}

// BuiltInInfoType - Pre-configured sensitive information type
type BuiltInInfoType struct {
	// Id of the info type
	ID *string

	// Display name of the info type
	Name *string

	// Category of the built-in info type
	Type *string
}

// CVE details
type CVE struct {
	// READ-ONLY; Link url
	Link *string

	// READ-ONLY; CVE title
	Title *string
}

// CVSS details
type CVSS struct {
	// READ-ONLY; CVSS base
	Base *float32
}

// CefExternalSecuritySolution - Represents a security solution which sends CEF logs to an OMS workspace
type CefExternalSecuritySolution struct {
	// REQUIRED; The kind of the external solution
	Kind *ExternalSecuritySolutionKind

	// The external security solution properties for CEF solutions
	Properties *CefSolutionProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GetExternalSecuritySolution implements the ExternalSecuritySolutionClassification interface for type CefExternalSecuritySolution.
func (c *CefExternalSecuritySolution) GetExternalSecuritySolution() *ExternalSecuritySolution {
	return &ExternalSecuritySolution{
		ID:       c.ID,
		Kind:     c.Kind,
		Location: c.Location,
		Name:     c.Name,
		Type:     c.Type,
	}
}

// CefSolutionProperties - The external security solution properties for CEF solutions
type CefSolutionProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
	Agent                *string
	DeviceType           *string
	DeviceVendor         *string
	Hostname             *string
	LastEventReceived    *string

	// Represents an OMS workspace to which the solution is connected
	Workspace *ConnectedWorkspace
}

// CloudOffering - The security offering details
type CloudOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CloudOffering.
func (c *CloudOffering) GetCloudOffering() *CloudOffering { return c }

// Compliance of a scope
type Compliance struct {
	// Compliance data
	Properties *ComplianceProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ComplianceList - List of Compliance objects response
type ComplianceList struct {
	// List of Compliance objects
	Value []*Compliance

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// ComplianceProperties - The Compliance score (percentage) of a Subscription is a sum of all Resources' Compliances under
// the given Subscription. A Resource Compliance is defined as the compliant ('healthy') Policy
// Definitions out of all Policy Definitions applicable to a given resource.
type ComplianceProperties struct {
	// READ-ONLY; An array of segment, which is the actually the compliance assessment.
	AssessmentResult []*ComplianceSegment

	// READ-ONLY; The timestamp when the Compliance calculation was conducted.
	AssessmentTimestampUTCDate *time.Time

	// READ-ONLY; The resource count of the given subscription for which the Compliance calculation was conducted (needed for
	// Management Group Compliance calculation).
	ResourceCount *int32
}

// ComplianceResult - a compliance result
type ComplianceResult struct {
	// Compliance result data
	Properties *ComplianceResultProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ComplianceResultList - List of compliance results response
type ComplianceResultList struct {
	// REQUIRED; List of compliance results
	Value []*ComplianceResult

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// ComplianceResultProperties - Compliance result data
type ComplianceResultProperties struct {
	// READ-ONLY; The status of the resource regarding a single assessment
	ResourceStatus *ResourceStatus
}

// ComplianceSegment - A segment of a compliance assessment.
type ComplianceSegment struct {
	// READ-ONLY; The size (%) of the segment.
	Percentage *float64

	// READ-ONLY; The segment type, e.g. compliant, non-compliance, insufficient coverage, N/A, etc.
	SegmentType *string
}

// Condition - Governance rule's condition
type Condition struct {
	// The governance rule Condition's Operator, for example Equals for severity or In for list of assessments, see examples
	Operator *GovernanceRuleConditionOperator

	// The governance rule Condition's Property, e.g. Severity or AssessmentKey, see examples
	Property *string

	// The governance rule Condition's Value like severity Low, High or assessments keys, see examples
	Value *string
}

// ConnectableResource - Describes the allowed inbound and outbound traffic of an Azure resource
type ConnectableResource struct {
	// READ-ONLY; The Azure resource id
	ID *string

	// READ-ONLY; The list of Azure resources that the resource has inbound allowed connection from
	InboundConnectedResources []*ConnectedResource

	// READ-ONLY; The list of Azure resources that the resource has outbound allowed connection to
	OutboundConnectedResources []*ConnectedResource
}

// ConnectedResource - Describes properties of a connected resource
type ConnectedResource struct {
	// READ-ONLY; The Azure resource id of the connected resource
	ConnectedResourceID *string

	// READ-ONLY; The allowed tcp ports
	TCPPorts *string

	// READ-ONLY; The allowed udp ports
	UDPPorts *string
}

// ConnectedWorkspace - Represents an OMS workspace to which the solution is connected
type ConnectedWorkspace struct {
	// Azure resource ID of the connected OMS workspace
	ID *string
}

// ConnectionFromIPNotAllowed - Inbound connection from an ip that isn't allowed. Allow list consists of ipv4 or ipv6 range
// in CIDR notation.
type ConnectionFromIPNotAllowed struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type ConnectionFromIPNotAllowed.
func (c *ConnectionFromIPNotAllowed) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule {
	return &AllowlistCustomAlertRule{
		AllowlistValues: c.AllowlistValues,
		Description:     c.Description,
		DisplayName:     c.DisplayName,
		IsEnabled:       c.IsEnabled,
		RuleType:        c.RuleType,
		ValueType:       c.ValueType,
	}
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ConnectionFromIPNotAllowed.
func (c *ConnectionFromIPNotAllowed) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: c.Description,
		DisplayName: c.DisplayName,
		IsEnabled:   c.IsEnabled,
		RuleType:    c.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type ConnectionFromIPNotAllowed.
func (c *ConnectionFromIPNotAllowed) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		Description: c.Description,
		DisplayName: c.DisplayName,
		IsEnabled:   c.IsEnabled,
		RuleType:    c.RuleType,
		ValueType:   c.ValueType,
	}
}

// ConnectionStrings - Connection string for ingesting security data and logs
type ConnectionStrings struct {
	// REQUIRED; Connection strings
	Value []*IngestionConnectionString
}

// ConnectionToIPNotAllowed - Outbound connection to an ip that isn't allowed. Allow list consists of ipv4 or ipv6 range in
// CIDR notation.
type ConnectionToIPNotAllowed struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type ConnectionToIPNotAllowed.
func (c *ConnectionToIPNotAllowed) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule {
	return &AllowlistCustomAlertRule{
		AllowlistValues: c.AllowlistValues,
		Description:     c.Description,
		DisplayName:     c.DisplayName,
		IsEnabled:       c.IsEnabled,
		RuleType:        c.RuleType,
		ValueType:       c.ValueType,
	}
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ConnectionToIPNotAllowed.
func (c *ConnectionToIPNotAllowed) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: c.Description,
		DisplayName: c.DisplayName,
		IsEnabled:   c.IsEnabled,
		RuleType:    c.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type ConnectionToIPNotAllowed.
func (c *ConnectionToIPNotAllowed) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		Description: c.Description,
		DisplayName: c.DisplayName,
		IsEnabled:   c.IsEnabled,
		RuleType:    c.RuleType,
		ValueType:   c.ValueType,
	}
}

// Connector - The security connector resource.
type Connector struct {
	// Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string

	// Kind of the resource
	Kind *string

	// Location where the resource is stored
	Location *string

	// Security connector data
	Properties *ConnectorProperties

	// A list of key value pairs that describe the resource.
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// ConnectorProperties - A set of properties that defines the security connector configuration.
type ConnectorProperties struct {
	// The security connector environment data.
	EnvironmentData EnvironmentDataClassification

	// The multi cloud resource's cloud name.
	EnvironmentName *CloudName

	// The multi cloud resource identifier (account id in case of AWS connector, project number in case of GCP connector).
	HierarchyIdentifier *string

	// A collection of offerings for the security connector.
	Offerings []CloudOfferingClassification

	// READ-ONLY; The date on which the trial period will end, if applicable. Trial period exists for 30 days after upgrading
	// to payed offerings.
	HierarchyIdentifierTrialEndDate *time.Time
}

// ConnectorSetting - The connector setting
type ConnectorSetting struct {
	// Connector setting data
	Properties *ConnectorSettingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ConnectorSettingList - For a subscription, list of all cloud account connectors and their settings
type ConnectorSettingList struct {
	// List of all the cloud account connector settings
	Value []*ConnectorSetting

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// ConnectorSettingProperties - Describes properties of a connector setting
type ConnectorSettingProperties struct {
	// Settings for authentication management, these settings are relevant only for the cloud connector.
	AuthenticationDetails AuthenticationDetailsPropertiesClassification

	// Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
	HybridComputeSettings *HybridComputeSettingsProperties
}

// ConnectorsList - List of security connectors response.
type ConnectorsList struct {
	// REQUIRED; The list of security connectors under the given scope.
	Value []*Connector

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
type Contact struct {
	// Security contact data
	Properties *ContactProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ContactList - List of security contacts response
type ContactList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY; List of security contacts
	Value []*Contact
}

// ContactProperties - Describes security contact properties
type ContactProperties struct {
	// Defines whether to send email notifications about new security alerts
	AlertNotifications *ContactPropertiesAlertNotifications

	// List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in
	// this security contact.
	Emails *string

	// Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the
	// subscription.
	NotificationsByRole *ContactPropertiesNotificationsByRole

	// The security contact's phone number
	Phone *string
}

// ContactPropertiesAlertNotifications - Defines whether to send email notifications about new security alerts
type ContactPropertiesAlertNotifications struct {
	// Defines the minimal alert severity which will be sent as email notifications
	MinimalSeverity *MinimalSeverity

	// Defines if email notifications will be sent about new security alerts
	State *State
}

// ContactPropertiesNotificationsByRole - Defines whether to send email notifications from Microsoft Defender for Cloud to
// persons with specific RBAC roles on the subscription.
type ContactPropertiesNotificationsByRole struct {
	// Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
	Roles []*Roles

	// Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the
	// subscription.
	State *State
}

// ContainerRegistryVulnerabilityProperties - Additional context fields for container registry Vulnerability assessment
type ContainerRegistryVulnerabilityProperties struct {
	// REQUIRED; Sub-assessment resource type
	AssessedResourceType *AssessedResourceType

	// READ-ONLY; List of CVEs
	Cve []*CVE

	// READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS

	// READ-ONLY; Digest of the vulnerable image
	ImageDigest *string

	// READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool

	// READ-ONLY; Published time
	PublishedTime *time.Time

	// READ-ONLY; Name of the repository which the vulnerable image belongs to
	RepositoryName *string

	// READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered, Vulnerability
	Type *string

	// READ-ONLY
	VendorReferences []*VendorReference
}

// GetAdditionalData implements the AdditionalDataClassification interface for type ContainerRegistryVulnerabilityProperties.
func (c *ContainerRegistryVulnerabilityProperties) GetAdditionalData() *AdditionalData {
	return &AdditionalData{
		AssessedResourceType: c.AssessedResourceType,
	}
}

// CspmMonitorAwsOffering - The CSPM monitoring for AWS offering
type CspmMonitorAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// The native cloud connection configuration
	NativeCloudConnection *CspmMonitorAwsOfferingNativeCloudConnection

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorAwsOffering.
func (c *CspmMonitorAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  c.Description,
		OfferingType: c.OfferingType,
	}
}

// CspmMonitorAwsOfferingNativeCloudConnection - The native cloud connection configuration
type CspmMonitorAwsOfferingNativeCloudConnection struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string
}

// CspmMonitorAzureDevOpsOffering - The CSPM monitoring for AzureDevOps offering
type CspmMonitorAzureDevOpsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorAzureDevOpsOffering.
func (c *CspmMonitorAzureDevOpsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  c.Description,
		OfferingType: c.OfferingType,
	}
}

// CspmMonitorGcpOffering - The CSPM monitoring for GCP offering
type CspmMonitorGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// The native cloud connection configuration
	NativeCloudConnection *CspmMonitorGcpOfferingNativeCloudConnection

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorGcpOffering.
func (c *CspmMonitorGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  c.Description,
		OfferingType: c.OfferingType,
	}
}

// CspmMonitorGcpOfferingNativeCloudConnection - The native cloud connection configuration
type CspmMonitorGcpOfferingNativeCloudConnection struct {
	// The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string

	// The GCP workload identity provider id for the offering
	WorkloadIdentityProviderID *string
}

// CspmMonitorGitLabOffering - The CSPM (Cloud security posture management) monitoring for gitlab offering
type CspmMonitorGitLabOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorGitLabOffering.
func (c *CspmMonitorGitLabOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  c.Description,
		OfferingType: c.OfferingType,
	}
}

// CspmMonitorGithubOffering - The CSPM monitoring for github offering
type CspmMonitorGithubOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type CspmMonitorGithubOffering.
func (c *CspmMonitorGithubOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  c.Description,
		OfferingType: c.OfferingType,
	}
}

// CustomAlertRule - A custom alert rule.
type CustomAlertRule struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type CustomAlertRule.
func (c *CustomAlertRule) GetCustomAlertRule() *CustomAlertRule { return c }

// CustomAssessmentAutomation - Custom Assessment Automation
type CustomAssessmentAutomation struct {
	// describes Custom Assessment Automation properties.
	Properties *CustomAssessmentAutomationProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// CustomAssessmentAutomationProperties - describes the Custom Assessment Automation properties
type CustomAssessmentAutomationProperties struct {
	// The assessment metadata key used when an assessment is generated for this assessment automation.
	AssessmentKey *string

	// GZip encoded KQL query representing the assessment automation results required.
	CompressedQuery *string

	// The description to relate to the assessments generated by this assessment automation.
	Description *string

	// The display name of the assessments generated by this assessment automation.
	DisplayName *string

	// The remediation description to relate to the assessments generated by this assessment automation.
	RemediationDescription *string

	// The severity to relate to the assessments generated by this assessment automation.
	Severity *SeverityEnum

	// Relevant cloud for the custom assessment automation.
	SupportedCloud *SupportedCloudEnum
}

// CustomAssessmentAutomationRequest - Custom Assessment Automation request
type CustomAssessmentAutomationRequest struct {
	// describes Custom Assessment Automation request properties.
	Properties *CustomAssessmentAutomationRequestProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// CustomAssessmentAutomationRequestProperties - describes the Custom Assessment Automation properties
type CustomAssessmentAutomationRequestProperties struct {
	// Base 64 encoded KQL query representing the assessment automation results required.
	CompressedQuery *string

	// The description to relate to the assessments generated by this assessment automation.
	Description *string

	// The display name of the assessments generated by this assessment automation.
	DisplayName *string

	// The remediation description to relate to the assessments generated by this assessment automation.
	RemediationDescription *string

	// The severity to relate to the assessments generated by this assessment automation.
	Severity *SeverityEnum

	// Relevant cloud for the custom assessment automation.
	SupportedCloud *SupportedCloudEnum
}

// CustomAssessmentAutomationsListResult - A list of Custom Assessment Automations
type CustomAssessmentAutomationsListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// READ-ONLY; Collection of Custom Assessment Automations
	Value []*CustomAssessmentAutomation
}

// CustomEntityStoreAssignment - Custom entity store assignment
type CustomEntityStoreAssignment struct {
	// describes custom entity store assignment properties.
	Properties *CustomEntityStoreAssignmentProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// CustomEntityStoreAssignmentProperties - describes the custom entity store assignment properties
type CustomEntityStoreAssignmentProperties struct {
	// The link to entity store database.
	EntityStoreDatabaseLink *string

	// The principal assigned with entity store. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
	Principal *string
}

// CustomEntityStoreAssignmentRequest - describes the custom entity store assignment request
type CustomEntityStoreAssignmentRequest struct {
	// describes properties of custom entity store assignment request
	Properties *CustomEntityStoreAssignmentRequestProperties
}

// CustomEntityStoreAssignmentRequestProperties - describes properties of custom entity store assignment request
type CustomEntityStoreAssignmentRequestProperties struct {
	// The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
	Principal *string
}

// CustomEntityStoreAssignmentsListResult - A list of custom entity store assignments
type CustomEntityStoreAssignmentsListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// READ-ONLY; Collection of custom entity store assignments
	Value []*CustomEntityStoreAssignment
}

// DataExportSettingProperties - The data export setting properties
type DataExportSettingProperties struct {
	// REQUIRED; Is the data export setting enabled
	Enabled *bool
}

// DataExportSettings - Represents a data export setting
type DataExportSettings struct {
	// REQUIRED; the kind of the settings string
	Kind *SettingKind

	// Data export setting data
	Properties *DataExportSettingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GetSetting implements the SettingClassification interface for type DataExportSettings.
func (d *DataExportSettings) GetSetting() *Setting {
	return &Setting{
		ID:   d.ID,
		Kind: d.Kind,
		Name: d.Name,
		Type: d.Type,
	}
}

// DefenderCspmAwsOffering - The CSPM P1 for AWS offering
type DefenderCspmAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// The Microsoft Defender Data Sensitivity discovery configuration
	DataSensitivityDiscovery *DefenderCspmAwsOfferingDataSensitivityDiscovery

	// The databases DSPM configuration
	DatabasesDspm *DefenderCspmAwsOfferingDatabasesDspm

	// The Microsoft Defender for Server VM scanning configuration
	VMScanners *DefenderCspmAwsOfferingVMScanners

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderCspmAwsOffering.
func (d *DefenderCspmAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderCspmAwsOfferingDataSensitivityDiscovery - The Microsoft Defender Data Sensitivity discovery configuration
type DefenderCspmAwsOfferingDataSensitivityDiscovery struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string

	// Is Microsoft Defender Data Sensitivity discovery enabled
	Enabled *bool
}

// DefenderCspmAwsOfferingDatabasesDspm - The databases DSPM configuration
type DefenderCspmAwsOfferingDatabasesDspm struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string

	// Is databases DSPM protection enabled
	Enabled *bool
}

// DefenderCspmAwsOfferingVMScanners - The Microsoft Defender for Server VM scanning configuration
type DefenderCspmAwsOfferingVMScanners struct {
	// configuration for Microsoft Defender for Server VM scanning
	Configuration *DefenderCspmAwsOfferingVMScannersConfiguration

	// Is Microsoft Defender for Server VM scanning enabled
	Enabled *bool
}

// DefenderCspmAwsOfferingVMScannersConfiguration - configuration for Microsoft Defender for Server VM scanning
type DefenderCspmAwsOfferingVMScannersConfiguration struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string

	// VM tags that indicates that VM should not be scanned
	ExclusionTags map[string]*string

	// The scanning mode for the VM scan.
	ScanningMode *ScanningMode
}

// DefenderCspmGcpOffering - The CSPM P1 for GCP offering
type DefenderCspmGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderCspmGcpOffering.
func (d *DefenderCspmGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderFoDatabasesAwsOffering - The Defender for Databases AWS offering
type DefenderFoDatabasesAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderFoDatabasesAwsOfferingArcAutoProvisioning

	// The databases data security posture management (DSPM) configuration
	DatabasesDspm *DefenderFoDatabasesAwsOfferingDatabasesDspm

	// The RDS configuration
	Rds *DefenderFoDatabasesAwsOfferingRds

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderFoDatabasesAwsOffering.
func (d *DefenderFoDatabasesAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderFoDatabasesAwsOfferingArcAutoProvisioning - The ARC autoprovisioning configuration
type DefenderFoDatabasesAwsOfferingArcAutoProvisioning struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string

	// Configuration for servers Arc auto provisioning
	Configuration *DefenderFoDatabasesAwsOfferingArcAutoProvisioningConfiguration

	// Is arc auto provisioning enabled
	Enabled *bool
}

// DefenderFoDatabasesAwsOfferingArcAutoProvisioningConfiguration - Configuration for servers Arc auto provisioning
type DefenderFoDatabasesAwsOfferingArcAutoProvisioningConfiguration struct {
	// Optional Arc private link scope resource id to link the Arc agent
	PrivateLinkScope *string

	// Optional http proxy endpoint to use for the Arc agent
	Proxy *string
}

// DefenderFoDatabasesAwsOfferingDatabasesDspm - The databases data security posture management (DSPM) configuration
type DefenderFoDatabasesAwsOfferingDatabasesDspm struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string

	// Is databases data security posture management (DSPM) protection enabled
	Enabled *bool
}

// DefenderFoDatabasesAwsOfferingRds - The RDS configuration
type DefenderFoDatabasesAwsOfferingRds struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string

	// Is RDS protection enabled
	Enabled *bool
}

// DefenderForContainersAwsOffering - The Defender for Containers AWS offering
type DefenderForContainersAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// Is audit logs pipeline auto provisioning enabled
	AutoProvisioning *bool

	// The cloudwatch to kinesis connection configuration
	CloudWatchToKinesis *DefenderForContainersAwsOfferingCloudWatchToKinesis

	// The container vulnerability assessment configuration
	ContainerVulnerabilityAssessment *DefenderForContainersAwsOfferingContainerVulnerabilityAssessment

	// The container vulnerability assessment task configuration
	ContainerVulnerabilityAssessmentTask *DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask

	// Enable container vulnerability assessment feature
	EnableContainerVulnerabilityAssessment *bool

	// The kinesis to s3 connection configuration
	KinesisToS3 *DefenderForContainersAwsOfferingKinesisToS3

	// The retention time in days of kube audit logs set on the CloudWatch log group
	KubeAuditRetentionTime *int64

	// The kubernetes to scuba connection configuration
	KubernetesScubaReader *DefenderForContainersAwsOfferingKubernetesScubaReader

	// The kubernetes service connection configuration
	KubernetesService *DefenderForContainersAwsOfferingKubernetesService

	// The externalId used by the data reader to prevent the confused deputy attack
	ScubaExternalID *string

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForContainersAwsOffering.
func (d *DefenderForContainersAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderForContainersAwsOfferingCloudWatchToKinesis - The cloudwatch to kinesis connection configuration
type DefenderForContainersAwsOfferingCloudWatchToKinesis struct {
	// The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis
	CloudRoleArn *string
}

// DefenderForContainersAwsOfferingContainerVulnerabilityAssessment - The container vulnerability assessment configuration
type DefenderForContainersAwsOfferingContainerVulnerabilityAssessment struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string
}

// DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask - The container vulnerability assessment task configuration
type DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string
}

// DefenderForContainersAwsOfferingKinesisToS3 - The kinesis to s3 connection configuration
type DefenderForContainersAwsOfferingKinesisToS3 struct {
	// The cloud role ARN in AWS used by Kinesis to transfer data into S3
	CloudRoleArn *string
}

// DefenderForContainersAwsOfferingKubernetesScubaReader - The kubernetes to scuba connection configuration
type DefenderForContainersAwsOfferingKubernetesScubaReader struct {
	// The cloud role ARN in AWS for this feature used for reading data
	CloudRoleArn *string
}

// DefenderForContainersAwsOfferingKubernetesService - The kubernetes service connection configuration
type DefenderForContainersAwsOfferingKubernetesService struct {
	// The cloud role ARN in AWS for this feature used for provisioning resources
	CloudRoleArn *string
}

// DefenderForContainersGcpOffering - The containers GCP offering
type DefenderForContainersGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// Is audit logs data collection enabled
	AuditLogsAutoProvisioningFlag *bool

	// The native cloud connection configuration
	DataPipelineNativeCloudConnection *DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection

	// Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
	DefenderAgentAutoProvisioningFlag *bool

	// The native cloud connection configuration
	NativeCloudConnection *DefenderForContainersGcpOfferingNativeCloudConnection

	// Is Policy Kubernetes agent auto provisioning enabled
	PolicyAgentAutoProvisioningFlag *bool

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForContainersGcpOffering.
func (d *DefenderForContainersGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection - The native cloud connection configuration
type DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection struct {
	// The data collection service account email address in GCP for this offering
	ServiceAccountEmailAddress *string

	// The data collection GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string
}

// DefenderForContainersGcpOfferingNativeCloudConnection - The native cloud connection configuration
type DefenderForContainersGcpOfferingNativeCloudConnection struct {
	// The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string

	// The GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string
}

// DefenderForDatabasesGcpOffering - The Defender for Databases GCP offering configurations
type DefenderForDatabasesGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForDatabasesGcpOfferingArcAutoProvisioning

	// The native cloud connection configuration
	DefenderForDatabasesArcAutoProvisioning *DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForDatabasesGcpOffering.
func (d *DefenderForDatabasesGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderForDatabasesGcpOfferingArcAutoProvisioning - The ARC autoprovisioning configuration
type DefenderForDatabasesGcpOfferingArcAutoProvisioning struct {
	// Configuration for servers Arc auto provisioning
	Configuration *DefenderForDatabasesGcpOfferingArcAutoProvisioningConfiguration

	// Is arc auto provisioning enabled
	Enabled *bool
}

// DefenderForDatabasesGcpOfferingArcAutoProvisioningConfiguration - Configuration for servers Arc auto provisioning
type DefenderForDatabasesGcpOfferingArcAutoProvisioningConfiguration struct {
	// Optional Arc private link scope resource id to link the Arc agent
	PrivateLinkScope *string

	// Optional http proxy endpoint to use for the Arc agent
	Proxy *string
}

// DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning - The native cloud connection configuration
type DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning struct {
	// The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string

	// The GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string
}

// DefenderForDevOpsAzureDevOpsOffering - The Defender for DevOps for Azure DevOps offering
type DefenderForDevOpsAzureDevOpsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForDevOpsAzureDevOpsOffering.
func (d *DefenderForDevOpsAzureDevOpsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderForDevOpsGitLabOffering - The Defender for DevOps for Gitlab offering
type DefenderForDevOpsGitLabOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForDevOpsGitLabOffering.
func (d *DefenderForDevOpsGitLabOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderForDevOpsGithubOffering - The Defender for DevOps for Github offering
type DefenderForDevOpsGithubOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForDevOpsGithubOffering.
func (d *DefenderForDevOpsGithubOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderForServersAwsOffering - The Defender for Servers AWS offering
type DefenderForServersAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForServersAwsOfferingArcAutoProvisioning

	// The Defender for servers connection configuration
	DefenderForServers *DefenderForServersAwsOfferingDefenderForServers

	// The Microsoft Defender for Endpoint autoprovisioning configuration
	MdeAutoProvisioning *DefenderForServersAwsOfferingMdeAutoProvisioning

	// configuration for the servers offering subPlan
	SubPlan *DefenderForServersAwsOfferingSubPlan

	// The Microsoft Defender for Server VM scanning configuration
	VMScanners *DefenderForServersAwsOfferingVMScanners

	// The Vulnerability Assessment autoprovisioning configuration
	VaAutoProvisioning *DefenderForServersAwsOfferingVaAutoProvisioning

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForServersAwsOffering.
func (d *DefenderForServersAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderForServersAwsOfferingArcAutoProvisioning - The ARC autoprovisioning configuration
type DefenderForServersAwsOfferingArcAutoProvisioning struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string

	// Configuration for servers Arc auto provisioning
	Configuration *DefenderForServersAwsOfferingArcAutoProvisioningConfiguration

	// Is arc auto provisioning enabled
	Enabled *bool
}

// DefenderForServersAwsOfferingArcAutoProvisioningConfiguration - Configuration for servers Arc auto provisioning
type DefenderForServersAwsOfferingArcAutoProvisioningConfiguration struct {
	// Optional Arc private link scope resource id to link the Arc agent
	PrivateLinkScope *string

	// Optional HTTP proxy endpoint to use for the Arc agent
	Proxy *string
}

// DefenderForServersAwsOfferingDefenderForServers - The Defender for servers connection configuration
type DefenderForServersAwsOfferingDefenderForServers struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string
}

// DefenderForServersAwsOfferingMdeAutoProvisioning - The Microsoft Defender for Endpoint autoprovisioning configuration
type DefenderForServersAwsOfferingMdeAutoProvisioning struct {
	// configuration for Microsoft Defender for Endpoint autoprovisioning
	Configuration any

	// Is Microsoft Defender for Endpoint auto provisioning enabled
	Enabled *bool
}

// DefenderForServersAwsOfferingSubPlan - configuration for the servers offering subPlan
type DefenderForServersAwsOfferingSubPlan struct {
	// The available sub plans
	Type *SubPlan
}

// DefenderForServersAwsOfferingVMScanners - The Microsoft Defender for Server VM scanning configuration
type DefenderForServersAwsOfferingVMScanners struct {
	// configuration for Microsoft Defender for Server VM scanning
	Configuration *DefenderForServersAwsOfferingVMScannersConfiguration

	// Is Microsoft Defender for Server VM scanning enabled
	Enabled *bool
}

// DefenderForServersAwsOfferingVMScannersConfiguration - configuration for Microsoft Defender for Server VM scanning
type DefenderForServersAwsOfferingVMScannersConfiguration struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string

	// VM tags that indicates that VM should not be scanned
	ExclusionTags map[string]*string

	// The scanning mode for the VM scan.
	ScanningMode *ScanningMode
}

// DefenderForServersAwsOfferingVaAutoProvisioning - The Vulnerability Assessment autoprovisioning configuration
type DefenderForServersAwsOfferingVaAutoProvisioning struct {
	// configuration for Vulnerability Assessment autoprovisioning
	Configuration *DefenderForServersAwsOfferingVaAutoProvisioningConfiguration

	// Is Vulnerability Assessment auto provisioning enabled
	Enabled *bool
}

// DefenderForServersAwsOfferingVaAutoProvisioningConfiguration - configuration for Vulnerability Assessment autoprovisioning
type DefenderForServersAwsOfferingVaAutoProvisioningConfiguration struct {
	// The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
	Type *Type
}

// DefenderForServersGcpOffering - The Defender for Servers GCP offering configurations
type DefenderForServersGcpOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForServersGcpOfferingArcAutoProvisioning

	// The Defender for servers connection configuration
	DefenderForServers *DefenderForServersGcpOfferingDefenderForServers

	// The Microsoft Defender for Endpoint autoprovisioning configuration
	MdeAutoProvisioning *DefenderForServersGcpOfferingMdeAutoProvisioning

	// configuration for the servers offering subPlan
	SubPlan *DefenderForServersGcpOfferingSubPlan

	// The Microsoft Defender for Server VM scanning configuration
	VMScanners *DefenderForServersGcpOfferingVMScanners

	// The Vulnerability Assessment autoprovisioning configuration
	VaAutoProvisioning *DefenderForServersGcpOfferingVaAutoProvisioning

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type DefenderForServersGcpOffering.
func (d *DefenderForServersGcpOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  d.Description,
		OfferingType: d.OfferingType,
	}
}

// DefenderForServersGcpOfferingArcAutoProvisioning - The ARC autoprovisioning configuration
type DefenderForServersGcpOfferingArcAutoProvisioning struct {
	// Configuration for servers Arc auto provisioning
	Configuration *DefenderForServersGcpOfferingArcAutoProvisioningConfiguration

	// Is arc auto provisioning enabled
	Enabled *bool
}

// DefenderForServersGcpOfferingArcAutoProvisioningConfiguration - Configuration for servers Arc auto provisioning
type DefenderForServersGcpOfferingArcAutoProvisioningConfiguration struct {
	// Optional Arc private link scope resource id to link the Arc agent
	PrivateLinkScope *string

	// Optional HTTP proxy endpoint to use for the Arc agent
	Proxy *string
}

// DefenderForServersGcpOfferingDefenderForServers - The Defender for servers connection configuration
type DefenderForServersGcpOfferingDefenderForServers struct {
	// The service account email address in GCP for this feature
	ServiceAccountEmailAddress *string

	// The workload identity provider id in GCP for this feature
	WorkloadIdentityProviderID *string
}

// DefenderForServersGcpOfferingMdeAutoProvisioning - The Microsoft Defender for Endpoint autoprovisioning configuration
type DefenderForServersGcpOfferingMdeAutoProvisioning struct {
	// configuration for Microsoft Defender for Endpoint autoprovisioning
	Configuration any

	// Is Microsoft Defender for Endpoint auto provisioning enabled
	Enabled *bool
}

// DefenderForServersGcpOfferingSubPlan - configuration for the servers offering subPlan
type DefenderForServersGcpOfferingSubPlan struct {
	// The available sub plans
	Type *SubPlan
}

// DefenderForServersGcpOfferingVMScanners - The Microsoft Defender for Server VM scanning configuration
type DefenderForServersGcpOfferingVMScanners struct {
	// configuration for Microsoft Defender for Server VM scanning
	Configuration *DefenderForServersGcpOfferingVMScannersConfiguration

	// Is Microsoft Defender for Server VM scanning enabled
	Enabled *bool
}

// DefenderForServersGcpOfferingVMScannersConfiguration - configuration for Microsoft Defender for Server VM scanning
type DefenderForServersGcpOfferingVMScannersConfiguration struct {
	// VM tags that indicate that VM should not be scanned
	ExclusionTags map[string]*string

	// The scanning mode for the VM scan.
	ScanningMode *ScanningMode
}

// DefenderForServersGcpOfferingVaAutoProvisioning - The Vulnerability Assessment autoprovisioning configuration
type DefenderForServersGcpOfferingVaAutoProvisioning struct {
	// configuration for Vulnerability Assessment autoprovisioning
	Configuration *DefenderForServersGcpOfferingVaAutoProvisioningConfiguration

	// Is Vulnerability Assessment auto provisioning enabled
	Enabled *bool
}

// DefenderForServersGcpOfferingVaAutoProvisioningConfiguration - configuration for Vulnerability Assessment autoprovisioning
type DefenderForServersGcpOfferingVaAutoProvisioningConfiguration struct {
	// The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
	Type *Type
}

// DenylistCustomAlertRule - A custom alert rule that checks if a value (depends on the custom alert type) is denied.
type DenylistCustomAlertRule struct {
	// REQUIRED; The values to deny. The format of the values depends on the rule type.
	DenylistValues []*string

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type DenylistCustomAlertRule.
func (d *DenylistCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: d.Description,
		DisplayName: d.DisplayName,
		IsEnabled:   d.IsEnabled,
		RuleType:    d.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type DenylistCustomAlertRule.
func (d *DenylistCustomAlertRule) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		Description: d.Description,
		DisplayName: d.DisplayName,
		IsEnabled:   d.IsEnabled,
		RuleType:    d.RuleType,
		ValueType:   d.ValueType,
	}
}

// DeviceSecurityGroup - The device security group resource
type DeviceSecurityGroup struct {
	// Device Security group data
	Properties *DeviceSecurityGroupProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// DeviceSecurityGroupList - List of device security groups
type DeviceSecurityGroupList struct {
	// List of device security group objects
	Value []*DeviceSecurityGroup

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// DeviceSecurityGroupProperties - describes properties of a security group.
type DeviceSecurityGroupProperties struct {
	// The allow-list custom alert rules.
	AllowlistRules []AllowlistCustomAlertRuleClassification

	// The deny-list custom alert rules.
	DenylistRules []*DenylistCustomAlertRule

	// The list of custom alert threshold rules.
	ThresholdRules []ThresholdCustomAlertRuleClassification

	// The list of custom alert time-window rules.
	TimeWindowRules []TimeWindowCustomAlertRuleClassification
}

// DirectMethodInvokesNotInAllowedRange - Number of direct method invokes is not in allowed range.
type DirectMethodInvokesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type DirectMethodInvokesNotInAllowedRange.
func (d *DirectMethodInvokesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: d.Description,
		DisplayName: d.DisplayName,
		IsEnabled:   d.IsEnabled,
		RuleType:    d.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type DirectMethodInvokesNotInAllowedRange.
func (d *DirectMethodInvokesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  d.Description,
		DisplayName:  d.DisplayName,
		IsEnabled:    d.IsEnabled,
		MaxThreshold: d.MaxThreshold,
		MinThreshold: d.MinThreshold,
		RuleType:     d.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type DirectMethodInvokesNotInAllowedRange.
func (d *DirectMethodInvokesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    d.Description,
		DisplayName:    d.DisplayName,
		IsEnabled:      d.IsEnabled,
		MaxThreshold:   d.MaxThreshold,
		MinThreshold:   d.MinThreshold,
		RuleType:       d.RuleType,
		TimeWindowSize: d.TimeWindowSize,
	}
}

type DiscoveredSecuritySolution struct {
	// REQUIRED
	Properties *DiscoveredSecuritySolutionProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

type DiscoveredSecuritySolutionList struct {
	Value []*DiscoveredSecuritySolution

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

type DiscoveredSecuritySolutionProperties struct {
	// REQUIRED; The security solutions' image offer
	Offer *string

	// REQUIRED; The security solutions' image publisher
	Publisher *string

	// REQUIRED; The security solutions' image sku
	SKU *string

	// REQUIRED; The security family of the discovered solution
	SecurityFamily *SecurityFamily
}

// ETag - Entity tag is used for comparing two or more entities from the same requested resource.
type ETag struct {
	// Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string
}

// EffectiveNetworkSecurityGroups - Describes the Network Security Groups effective on a network interface
type EffectiveNetworkSecurityGroups struct {
	// The Azure resource ID of the network interface
	NetworkInterface *string

	// The Network Security Groups effective on the network interface
	NetworkSecurityGroups []*string
}

// EnvironmentData - The security connector environment data.
type EnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type EnvironmentData.
func (e *EnvironmentData) GetEnvironmentData() *EnvironmentData { return e }

// EnvironmentDetails - The environment details of the resource
type EnvironmentDetails struct {
	// The hierarchy id of the connector (in case of Azure - the subscription Id, in case of MC - the hierarchyId id)
	EnvironmentHierarchyID *string

	// The native resource id of the resource (in case of Azure - the resource Id, in case of MC - the native resource id)
	NativeResourceID *string

	// The organizational hierarchy id of the connector (in case of Azure - the subscription Id, in case of MC - the organizational
	// hierarchyId id)
	OrganizationalHierarchyID *string

	// The subscription Id
	SubscriptionID *string

	// The tenant Id
	TenantID *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorDetailAutoGenerated - The error detail.
type ErrorDetailAutoGenerated struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetailAutoGenerated

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// ErrorResponseAutoGenerated - Common error response for all Azure Resource Manager APIs to return error details for failed
// operations. (This also follows the OData error response format.).
type ErrorResponseAutoGenerated struct {
	// The error object.
	Error *ErrorDetailAutoGenerated
}

// ExecuteGovernanceRuleParams - Governance rule execution parameters
type ExecuteGovernanceRuleParams struct {
	// Describe if governance rule should be override
	Override *bool
}

// Extension - A plan's extension properties
type Extension struct {
	// REQUIRED; Indicates whether the extension is enabled.
	IsEnabled *IsEnabled

	// REQUIRED; The extension name. Supported values are:
	// AgentlessDiscoveryForKubernetes - API-based discovery of information about Kubernetes cluster architecture, workload objects,
	// and setup. Required for Kubernetes inventory, identity and network
	// exposure detection, attack path analysis and risk hunting as part of the cloud security explorer. Available for CloudPosture
	// plan.
	// OnUploadMalwareScanning - Limits the GB to be scanned per month for each storage account within the subscription. Once
	// this limit reached on a given storage account, Blobs won't be scanned during
	// current calendar month. Available for StorageAccounts plan.
	// SensitiveDataDiscovery - Sensitive data discovery identifies Blob storage container with sensitive data such as credentials,
	// credit cards, and more, to help prioritize and investigate security events.
	// Available for StorageAccounts and CloudPosture plans.
	// ContainerRegistriesVulnerabilityAssessments - Provides vulnerability management for images stored in your container registries.
	// Available for CloudPosture and Containers plans.
	Name *string

	// Property values associated with the extension.
	AdditionalExtensionProperties map[string]any

	// READ-ONLY; Optional. A status describing the success/failure of the extension's enablement/disablement operation.
	OperationStatus *OperationStatus
}

// ExternalSecuritySolution - Represents a security solution external to Microsoft Defender for Cloud which sends information
// to an OMS workspace and whose data is displayed by Microsoft Defender for Cloud.
type ExternalSecuritySolution struct {
	// REQUIRED; The kind of the external solution
	Kind *ExternalSecuritySolutionKind

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GetExternalSecuritySolution implements the ExternalSecuritySolutionClassification interface for type ExternalSecuritySolution.
func (e *ExternalSecuritySolution) GetExternalSecuritySolution() *ExternalSecuritySolution { return e }

type ExternalSecuritySolutionList struct {
	Value []ExternalSecuritySolutionClassification

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// ExternalSecuritySolutionProperties - The solution properties (correspond to the solution kind)
type ExternalSecuritySolutionProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any
	DeviceType           *string
	DeviceVendor         *string

	// Represents an OMS workspace to which the solution is connected
	Workspace *ConnectedWorkspace
}

// FailedLocalLoginsNotInAllowedRange - Number of failed local logins is not in allowed range.
type FailedLocalLoginsNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type FailedLocalLoginsNotInAllowedRange.
func (f *FailedLocalLoginsNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: f.Description,
		DisplayName: f.DisplayName,
		IsEnabled:   f.IsEnabled,
		RuleType:    f.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type FailedLocalLoginsNotInAllowedRange.
func (f *FailedLocalLoginsNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  f.Description,
		DisplayName:  f.DisplayName,
		IsEnabled:    f.IsEnabled,
		MaxThreshold: f.MaxThreshold,
		MinThreshold: f.MinThreshold,
		RuleType:     f.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type FailedLocalLoginsNotInAllowedRange.
func (f *FailedLocalLoginsNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    f.Description,
		DisplayName:    f.DisplayName,
		IsEnabled:      f.IsEnabled,
		MaxThreshold:   f.MaxThreshold,
		MinThreshold:   f.MinThreshold,
		RuleType:       f.RuleType,
		TimeWindowSize: f.TimeWindowSize,
	}
}

// FileUploadsNotInAllowedRange - Number of file uploads is not in allowed range.
type FileUploadsNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type FileUploadsNotInAllowedRange.
func (f *FileUploadsNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: f.Description,
		DisplayName: f.DisplayName,
		IsEnabled:   f.IsEnabled,
		RuleType:    f.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type FileUploadsNotInAllowedRange.
func (f *FileUploadsNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  f.Description,
		DisplayName:  f.DisplayName,
		IsEnabled:    f.IsEnabled,
		MaxThreshold: f.MaxThreshold,
		MinThreshold: f.MinThreshold,
		RuleType:     f.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type FileUploadsNotInAllowedRange.
func (f *FileUploadsNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    f.Description,
		DisplayName:    f.DisplayName,
		IsEnabled:      f.IsEnabled,
		MaxThreshold:   f.MaxThreshold,
		MinThreshold:   f.MinThreshold,
		RuleType:       f.RuleType,
		TimeWindowSize: f.TimeWindowSize,
	}
}

// GcpCredentialsDetailsProperties - GCP cloud account connector based service to service credentials, the credentials are
// composed of the organization ID and a JSON API key (write only)
type GcpCredentialsDetailsProperties struct {
	// REQUIRED; Auth provider x509 certificate URL field of the API key (write only)
	AuthProviderX509CertURL *string

	// REQUIRED; Auth URI field of the API key (write only)
	AuthURI *string

	// REQUIRED; Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use
	// account organization credentials.
	AuthenticationType *AuthenticationType

	// REQUIRED; Client email field of the API key (write only)
	ClientEmail *string

	// REQUIRED; Client ID field of the API key (write only)
	ClientID *string

	// REQUIRED; Client x509 certificate URL field of the API key (write only)
	ClientX509CertURL *string

	// REQUIRED; The organization ID of the GCP cloud account
	OrganizationID *string

	// REQUIRED; Private key field of the API key (write only)
	PrivateKey *string

	// REQUIRED; Private key ID field of the API key (write only)
	PrivateKeyID *string

	// REQUIRED; Project ID field of the API key (write only)
	ProjectID *string

	// REQUIRED; Token URI field of the API key (write only)
	TokenURI *string

	// REQUIRED; Type field of the API key (write only)
	Type *string

	// READ-ONLY; State of the multi-cloud connector
	AuthenticationProvisioningState *AuthenticationProvisioningState

	// READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions []*PermissionProperty
}

// GetAuthenticationDetailsProperties implements the AuthenticationDetailsPropertiesClassification interface for type GcpCredentialsDetailsProperties.
func (g *GcpCredentialsDetailsProperties) GetAuthenticationDetailsProperties() *AuthenticationDetailsProperties {
	return &AuthenticationDetailsProperties{
		AuthenticationProvisioningState: g.AuthenticationProvisioningState,
		AuthenticationType:              g.AuthenticationType,
		GrantedPermissions:              g.GrantedPermissions,
	}
}

// GcpOrganizationalData - The gcpOrganization data
type GcpOrganizationalData struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType
}

// GetGcpOrganizationalData implements the GcpOrganizationalDataClassification interface for type GcpOrganizationalData.
func (g *GcpOrganizationalData) GetGcpOrganizationalData() *GcpOrganizationalData { return g }

// GcpOrganizationalDataMember - The gcpOrganization data for the member account
type GcpOrganizationalDataMember struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType

	// The GCP management project number from organizational onboarding
	ManagementProjectNumber *string

	// If the multi cloud account is not of membership type organization, this will be the ID of the project's parent
	ParentHierarchyID *string
}

// GetGcpOrganizationalData implements the GcpOrganizationalDataClassification interface for type GcpOrganizationalDataMember.
func (g *GcpOrganizationalDataMember) GetGcpOrganizationalData() *GcpOrganizationalData {
	return &GcpOrganizationalData{
		OrganizationMembershipType: g.OrganizationMembershipType,
	}
}

// GcpOrganizationalDataOrganization - The gcpOrganization data for the parent account
type GcpOrganizationalDataOrganization struct {
	// REQUIRED; The multi cloud account's membership type in the organization
	OrganizationMembershipType *OrganizationMembershipType

	// If the multi cloud account is of membership type organization, list of accounts excluded from offering
	ExcludedProjectNumbers []*string

	// The service account email address which represents the organization level permissions container.
	ServiceAccountEmailAddress *string

	// The GCP workload identity provider id which represents the permissions required to auto provision security connectors
	WorkloadIdentityProviderID *string

	// READ-ONLY; GCP organization name
	OrganizationName *string
}

// GetGcpOrganizationalData implements the GcpOrganizationalDataClassification interface for type GcpOrganizationalDataOrganization.
func (g *GcpOrganizationalDataOrganization) GetGcpOrganizationalData() *GcpOrganizationalData {
	return &GcpOrganizationalData{
		OrganizationMembershipType: g.OrganizationMembershipType,
	}
}

// GcpProjectDetails - The details about the project represented by the security connector
type GcpProjectDetails struct {
	// The GCP Project id
	ProjectID *string

	// The unique GCP Project number
	ProjectNumber *string

	// READ-ONLY; GCP project name
	ProjectName *string

	// READ-ONLY; The GCP workload identity federation pool id
	WorkloadIdentityPoolID *string
}

// GcpProjectEnvironmentData - The GCP project connector environment data
type GcpProjectEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType

	// The Gcp project's organizational data
	OrganizationalData GcpOrganizationalDataClassification

	// The Gcp project's details
	ProjectDetails *GcpProjectDetails
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type GcpProjectEnvironmentData.
func (g *GcpProjectEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: g.EnvironmentType,
	}
}

// GetSensitivitySettingsListResponse - A list with a single sensitivity settings resource
type GetSensitivitySettingsListResponse struct {
	Value []*GetSensitivitySettingsResponse
}

// GetSensitivitySettingsResponse - Data sensitivity settings for sensitive data discovery
type GetSensitivitySettingsResponse struct {
	// The sensitivity settings properties
	Properties *GetSensitivitySettingsResponseProperties

	// READ-ONLY; The ID of the sensitivity settings
	ID *string

	// READ-ONLY; The name of the sensitivity settings
	Name *string

	// READ-ONLY; The type of the sensitivity settings
	Type *string
}

// GetSensitivitySettingsResponseProperties - The sensitivity settings properties
type GetSensitivitySettingsResponseProperties struct {
	// Microsoft information protection built-in and custom information types, labels, and integration status.
	MipInformation *GetSensitivitySettingsResponsePropertiesMipInformation

	// List of selected sensitive info types' IDs.
	SensitiveInfoTypesIDs []*string

	// The id of the sensitivity threshold label. Any label at or above this rank will be considered sensitive.
	SensitivityThresholdLabelID *string

	// The order of the sensitivity threshold label. Any label at or above this order will be considered sensitive. If set to
	// -1, sensitivity by labels is turned off
	SensitivityThresholdLabelOrder *float32
}

// GetSensitivitySettingsResponsePropertiesMipInformation - Microsoft information protection built-in and custom information
// types, labels, and integration status.
type GetSensitivitySettingsResponsePropertiesMipInformation struct {
	// List of pre-configured sensitive information types
	BuiltInInfoTypes []*BuiltInInfoType

	// List of custom user-defined information types
	CustomInfoTypes []*InfoType

	// List of Microsoft information protection sensitivity labels
	Labels []*Label

	// Microsoft information protection integration status
	MipIntegrationStatus *MipIntegrationStatus
}

// GithubScopeEnvironmentData - The github scope connector's environment data
type GithubScopeEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type GithubScopeEnvironmentData.
func (g *GithubScopeEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: g.EnvironmentType,
	}
}

// GitlabScopeEnvironmentData - The GitLab scope connector's environment data
type GitlabScopeEnvironmentData struct {
	// REQUIRED; The type of the environment data.
	EnvironmentType *EnvironmentType
}

// GetEnvironmentData implements the EnvironmentDataClassification interface for type GitlabScopeEnvironmentData.
func (g *GitlabScopeEnvironmentData) GetEnvironmentData() *EnvironmentData {
	return &EnvironmentData{
		EnvironmentType: g.EnvironmentType,
	}
}

// GovernanceAssignment - Governance assignment over a given scope
type GovernanceAssignment struct {
	// The properties of a governance assignment
	Properties *GovernanceAssignmentProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GovernanceAssignmentAdditionalData - Describe the additional data of governance assignment - optional
type GovernanceAssignmentAdditionalData struct {
	// Ticket link associated with this governance assignment - for example: https://snow.com
	TicketLink *string

	// Ticket number associated with this governance assignment
	TicketNumber *int32

	// The ticket status associated with this governance assignment - for example: Active
	TicketStatus *string
}

// GovernanceAssignmentProperties - Describes properties of an governance assignment
type GovernanceAssignmentProperties struct {
	// REQUIRED; The remediation due-date - after this date Secure Score will be affected (in case of active grace-period)
	RemediationDueDate *time.Time

	// The additional data for the governance assignment - e.g. links to ticket (optional), see example
	AdditionalData *GovernanceAssignmentAdditionalData

	// The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
	GovernanceEmailNotification *GovernanceEmailNotification

	// Defines whether there is a grace period on the governance assignment
	IsGracePeriod *bool

	// The Owner for the governance assignment - e.g. user@contoso.com - see example
	Owner *string

	// The ETA (estimated time of arrival) for remediation (optional), see example
	RemediationEta *RemediationEta
}

// GovernanceAssignmentsList - Page of a governance assignments list
type GovernanceAssignmentsList struct {
	// READ-ONLY; The URI to fetch the next page
	NextLink *string

	// READ-ONLY; Collection of governance assignments in this page
	Value []*GovernanceAssignment
}

// GovernanceEmailNotification - The governance email weekly notification configuration.
type GovernanceEmailNotification struct {
	// Exclude manager from weekly email notification.
	DisableManagerEmailNotification *bool

	// Exclude owner from weekly email notification.
	DisableOwnerEmailNotification *bool
}

// GovernanceRule - Governance rule over a given scope
type GovernanceRule struct {
	// Properties of a governance rule
	Properties *GovernanceRuleProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GovernanceRuleEmailNotification - The governance email weekly notification configuration
type GovernanceRuleEmailNotification struct {
	// Defines whether manager email notifications are disabled
	DisableManagerEmailNotification *bool

	// Defines whether owner email notifications are disabled
	DisableOwnerEmailNotification *bool
}

// GovernanceRuleList - Page of a governance rules list
type GovernanceRuleList struct {
	// READ-ONLY; The URI to fetch the next page
	NextLink *string

	// READ-ONLY; Collection of governance rules in this page
	Value []*GovernanceRule
}

// GovernanceRuleMetadata - The governance rule metadata
type GovernanceRuleMetadata struct {
	// READ-ONLY; Governance rule Created by object id (GUID)
	CreatedBy *string

	// READ-ONLY; Governance rule creation date
	CreatedOn *time.Time

	// READ-ONLY; Governance rule last updated by object id (GUID)
	UpdatedBy *string

	// READ-ONLY; Governance rule last update date
	UpdatedOn *time.Time
}

// GovernanceRuleOwnerSource - Describe the owner source of governance rule
type GovernanceRuleOwnerSource struct {
	// The owner type for the governance rule owner source
	Type *GovernanceRuleOwnerSourceType

	// The source value e.g. tag key like owner name or email address
	Value *string
}

// GovernanceRuleProperties - Describes properties of an governance rule
type GovernanceRuleProperties struct {
	// REQUIRED; The governance rule conditionSets - see examples
	ConditionSets []any

	// REQUIRED; Display name of the governance rule
	DisplayName *string

	// REQUIRED; The owner source for the governance rule - e.g. Manually by user@contoso.com - see example
	OwnerSource *GovernanceRuleOwnerSource

	// REQUIRED; The governance rule priority, priority to the lower number. Rules with the same priority on the same scope will
	// not be allowed
	RulePriority *int32

	// REQUIRED; The rule type of the governance rule, defines the source of the rule e.g. Integrated
	RuleType *GovernanceRuleType

	// REQUIRED; The governance rule source, what the rule affects, e.g. Assessments
	SourceResourceType *GovernanceRuleSourceResourceType

	// Description of the governance rule
	Description *string

	// Excluded scopes, filter out the descendants of the scope (on management scopes)
	ExcludedScopes []*string

	// The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
	GovernanceEmailNotification *GovernanceRuleEmailNotification

	// Defines whether the rule is management scope rule (master connector as a single scope or management scope)
	IncludeMemberScopes *bool

	// Defines whether the rule is active/inactive
	IsDisabled *bool

	// Defines whether there is a grace period on the governance rule
	IsGracePeriod *bool

	// The governance rule metadata
	Metadata *GovernanceRuleMetadata

	// Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00
	// - means 7 days
	RemediationTimeframe *string

	// READ-ONLY; The tenantId (GUID)
	TenantID *string
}

// HTTPC2DMessagesNotInAllowedRange - Number of cloud to device messages (HTTP protocol) is not in allowed range.
type HTTPC2DMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type HTTPC2DMessagesNotInAllowedRange.
func (h *HTTPC2DMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: h.Description,
		DisplayName: h.DisplayName,
		IsEnabled:   h.IsEnabled,
		RuleType:    h.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type HTTPC2DMessagesNotInAllowedRange.
func (h *HTTPC2DMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  h.Description,
		DisplayName:  h.DisplayName,
		IsEnabled:    h.IsEnabled,
		MaxThreshold: h.MaxThreshold,
		MinThreshold: h.MinThreshold,
		RuleType:     h.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type HTTPC2DMessagesNotInAllowedRange.
func (h *HTTPC2DMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    h.Description,
		DisplayName:    h.DisplayName,
		IsEnabled:      h.IsEnabled,
		MaxThreshold:   h.MaxThreshold,
		MinThreshold:   h.MinThreshold,
		RuleType:       h.RuleType,
		TimeWindowSize: h.TimeWindowSize,
	}
}

// HTTPC2DRejectedMessagesNotInAllowedRange - Number of rejected cloud to device messages (HTTP protocol) is not in allowed
// range.
type HTTPC2DRejectedMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type HTTPC2DRejectedMessagesNotInAllowedRange.
func (h *HTTPC2DRejectedMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: h.Description,
		DisplayName: h.DisplayName,
		IsEnabled:   h.IsEnabled,
		RuleType:    h.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type HTTPC2DRejectedMessagesNotInAllowedRange.
func (h *HTTPC2DRejectedMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  h.Description,
		DisplayName:  h.DisplayName,
		IsEnabled:    h.IsEnabled,
		MaxThreshold: h.MaxThreshold,
		MinThreshold: h.MinThreshold,
		RuleType:     h.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type HTTPC2DRejectedMessagesNotInAllowedRange.
func (h *HTTPC2DRejectedMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    h.Description,
		DisplayName:    h.DisplayName,
		IsEnabled:      h.IsEnabled,
		MaxThreshold:   h.MaxThreshold,
		MinThreshold:   h.MinThreshold,
		RuleType:       h.RuleType,
		TimeWindowSize: h.TimeWindowSize,
	}
}

// HTTPD2CMessagesNotInAllowedRange - Number of device to cloud messages (HTTP protocol) is not in allowed range.
type HTTPD2CMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type HTTPD2CMessagesNotInAllowedRange.
func (h *HTTPD2CMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: h.Description,
		DisplayName: h.DisplayName,
		IsEnabled:   h.IsEnabled,
		RuleType:    h.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type HTTPD2CMessagesNotInAllowedRange.
func (h *HTTPD2CMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  h.Description,
		DisplayName:  h.DisplayName,
		IsEnabled:    h.IsEnabled,
		MaxThreshold: h.MaxThreshold,
		MinThreshold: h.MinThreshold,
		RuleType:     h.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type HTTPD2CMessagesNotInAllowedRange.
func (h *HTTPD2CMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    h.Description,
		DisplayName:    h.DisplayName,
		IsEnabled:      h.IsEnabled,
		MaxThreshold:   h.MaxThreshold,
		MinThreshold:   h.MinThreshold,
		RuleType:       h.RuleType,
		TimeWindowSize: h.TimeWindowSize,
	}
}

// HealthDataClassification - The classification of the health report
type HealthDataClassification struct {
	// The component describes the name of the agent/service that scans the issue
	Component *string

	// The scenario describes the health scenario issue of the component
	Scenario *string

	// The resource scope of the health report
	Scope *ScopeName
}

// HealthReport - The health report resource
type HealthReport struct {
	// Properties of a health report
	Properties *HealthReportProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// HealthReportProperties - Describes properties of the health report
type HealthReportProperties struct {
	// The affected defenders plans by unhealthy report
	AffectedDefendersPlans []*string

	// The environment details of the resource
	EnvironmentDetails *EnvironmentDetails

	// The classification of the health report
	HealthDataClassification *HealthDataClassification

	// A collection of the issues in the report
	Issues []*Issue

	// The resource details of the health report
	ResourceDetails *ResourceDetailsAutoGenerated

	// The status of the health report
	Status *StatusAutoGenerated
}

// HealthReportsList - Page of health reports list
type HealthReportsList struct {
	// READ-ONLY; The URI to fetch the next page
	NextLink *string

	// READ-ONLY; Collection of health reports in this page
	Value []*HealthReport
}

// HybridComputeSettingsProperties - Settings for hybrid compute management
type HybridComputeSettingsProperties struct {
	// REQUIRED; Whether or not to automatically install Azure Arc (hybrid compute) agents on machines
	AutoProvision *AutoProvision

	// For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine
	// can use.
	ProxyServer *ProxyServerProperties

	// The location where the metadata of machines will be stored
	Region *string

	// The name of the resource group where Arc (Hybrid Compute) connectors are connected.
	ResourceGroupName *string

	// An object to access resources that are secured by an Azure AD tenant.
	ServicePrincipal *ServicePrincipalProperties

	// READ-ONLY; State of the service principal and its secret
	HybridComputeProvisioningState *HybridComputeProvisioningState
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// InfoType - Custom user-defined information type
type InfoType struct {
	// Description of the info type
	Description *string

	// Id of the info type
	ID *string

	// Display name of the info type
	Name *string
}

// InformationProtectionAwsOffering - The information protection for AWS offering
type InformationProtectionAwsOffering struct {
	// REQUIRED; The type of the security offering.
	OfferingType *OfferingType

	// The native cloud connection configuration
	InformationProtection *InformationProtectionAwsOfferingInformationProtection

	// READ-ONLY; The offering description.
	Description *string
}

// GetCloudOffering implements the CloudOfferingClassification interface for type InformationProtectionAwsOffering.
func (i *InformationProtectionAwsOffering) GetCloudOffering() *CloudOffering {
	return &CloudOffering{
		Description:  i.Description,
		OfferingType: i.OfferingType,
	}
}

// InformationProtectionAwsOfferingInformationProtection - The native cloud connection configuration
type InformationProtectionAwsOfferingInformationProtection struct {
	// The cloud role ARN in AWS for this feature
	CloudRoleArn *string
}

// InformationProtectionKeyword - The information type keyword.
type InformationProtectionKeyword struct {
	// Indicates whether the keyword can be applied on numeric types or not.
	CanBeNumeric *bool

	// Indicates whether the keyword is custom or not.
	Custom *bool

	// Indicates whether the keyword is excluded or not.
	Excluded *bool

	// The keyword pattern.
	Pattern *string
}

// InformationProtectionPolicy - Information protection policy.
type InformationProtectionPolicy struct {
	// Information protection policy data
	Properties *InformationProtectionPolicyProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// InformationProtectionPolicyList - Information protection policies response.
type InformationProtectionPolicyList struct {
	// List of information protection policies.
	Value []*InformationProtectionPolicy

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// InformationProtectionPolicyProperties - describes properties of an information protection policy.
type InformationProtectionPolicyProperties struct {
	// The sensitivity information types.
	InformationTypes map[string]*InformationType

	// Dictionary of sensitivity labels.
	Labels map[string]*SensitivityLabel

	// READ-ONLY; Describes the last UTC time the policy was modified.
	LastModifiedUTC *time.Time

	// READ-ONLY; Describes the version of the policy.
	Version *string
}

// InformationType - The information type.
type InformationType struct {
	// Indicates whether the information type is custom or not.
	Custom *bool

	// The description of the information type.
	Description *string

	// The name of the information type.
	DisplayName *string

	// Indicates whether the information type is enabled or not.
	Enabled *bool

	// The information type keywords.
	Keywords []*InformationProtectionKeyword

	// The order of the information type.
	Order *int32

	// The recommended label id to be associated with this information type.
	RecommendedLabelID *string
}

// IngestionConnectionString - Connection string for ingesting security data and logs
type IngestionConnectionString struct {
	// READ-ONLY; The region where ingested logs and data resides
	Location *string

	// READ-ONLY; Connection string value
	Value *string
}

// IngestionSetting - Configures how to correlate scan data and logs with resources associated with the subscription.
type IngestionSetting struct {
	// Ingestion setting data
	Properties any

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// IngestionSettingList - List of ingestion settings
type IngestionSettingList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY; List of ingestion settings
	Value []*IngestionSetting
}

// IngestionSettingToken - Configures how to correlate scan data and logs with resources associated with the subscription.
type IngestionSettingToken struct {
	// READ-ONLY; The token is used for correlating security data and logs with the resources in the subscription.
	Token *string
}

// IoTSecurityAggregatedAlert - Security Solution Aggregated Alert information
type IoTSecurityAggregatedAlert struct {
	// IoT Security solution aggregated alert details.
	Properties *IoTSecurityAggregatedAlertProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// IoTSecurityAggregatedAlertList - List of IoT Security solution aggregated alert data.
type IoTSecurityAggregatedAlertList struct {
	// REQUIRED; List of aggregated alerts data.
	Value []*IoTSecurityAggregatedAlert

	// READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string
}

// IoTSecurityAggregatedAlertProperties - IoT Security solution aggregated alert details.
type IoTSecurityAggregatedAlertProperties struct {
	// READ-ONLY; IoT Security solution alert response.
	ActionTaken *string

	// READ-ONLY; Date of detection.
	AggregatedDateUTC *time.Time

	// READ-ONLY; Display name of the alert type.
	AlertDisplayName *string

	// READ-ONLY; Name of the alert type.
	AlertType *string

	// READ-ONLY; Number of alerts occurrences within the aggregated time window.
	Count *int64

	// READ-ONLY; Description of the suspected vulnerability and meaning.
	Description *string

	// READ-ONLY; Azure resource ID of the resource that received the alerts.
	EffectedResourceType *string

	// READ-ONLY; Log analytics query for getting the list of affected devices/alerts.
	LogAnalyticsQuery *string

	// READ-ONLY; Recommended steps for remediation.
	RemediationSteps *string

	// READ-ONLY; Assessed alert severity.
	ReportedSeverity *ReportedSeverity

	// READ-ONLY; The type of the alerted resource (Azure, Non-Azure).
	SystemSource *string

	// READ-ONLY; 10 devices with the highest number of occurrences of this alert type, on this day.
	TopDevicesList []*IoTSecurityAggregatedAlertPropertiesTopDevicesListItem

	// READ-ONLY; Name of the organization that raised the alert.
	VendorName *string
}

type IoTSecurityAggregatedAlertPropertiesTopDevicesListItem struct {
	// READ-ONLY; Number of alerts raised for this device.
	AlertsCount *int64

	// READ-ONLY; Name of the device.
	DeviceID *string

	// READ-ONLY; Most recent time this alert was raised for this device, on this day.
	LastOccurrence *string
}

// IoTSecurityAggregatedRecommendation - IoT Security solution recommendation information.
type IoTSecurityAggregatedRecommendation struct {
	// Security Solution data
	Properties *IoTSecurityAggregatedRecommendationProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// IoTSecurityAggregatedRecommendationList - List of IoT Security solution aggregated recommendations.
type IoTSecurityAggregatedRecommendationList struct {
	// REQUIRED; List of aggregated recommendations data.
	Value []*IoTSecurityAggregatedRecommendation

	// READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string
}

// IoTSecurityAggregatedRecommendationProperties - IoT Security solution aggregated recommendation information
type IoTSecurityAggregatedRecommendationProperties struct {
	// Name of the recommendation.
	RecommendationName *string

	// READ-ONLY; Description of the suspected vulnerability and meaning.
	Description *string

	// READ-ONLY; Name of the organization that made the recommendation.
	DetectedBy *string

	// READ-ONLY; Number of healthy devices within the IoT Security solution.
	HealthyDevices *int64

	// READ-ONLY; Log analytics query for getting the list of affected devices/alerts.
	LogAnalyticsQuery *string

	// READ-ONLY; Display name of the recommendation type.
	RecommendationDisplayName *string

	// READ-ONLY; Recommendation-type GUID.
	RecommendationTypeID *string

	// READ-ONLY; Recommended steps for remediation
	RemediationSteps *string

	// READ-ONLY; Assessed recommendation severity.
	ReportedSeverity *ReportedSeverity

	// READ-ONLY; Number of unhealthy devices within the IoT Security solution.
	UnhealthyDeviceCount *int64
}

// IoTSecurityAlertedDevice - Statistical information about the number of alerts per device during last set number of days.
type IoTSecurityAlertedDevice struct {
	// READ-ONLY; Number of alerts raised for this device.
	AlertsCount *int64

	// READ-ONLY; Device identifier.
	DeviceID *string
}

// IoTSecurityDeviceAlert - Statistical information about the number of alerts per alert type during last set number of days
type IoTSecurityDeviceAlert struct {
	// READ-ONLY; Display name of the alert
	AlertDisplayName *string

	// READ-ONLY; Number of alerts raised for this alert type.
	AlertsCount *int64

	// READ-ONLY; Assessed Alert severity.
	ReportedSeverity *ReportedSeverity
}

// IoTSecurityDeviceRecommendation - Statistical information about the number of recommendations per device, per recommendation
// type.
type IoTSecurityDeviceRecommendation struct {
	// READ-ONLY; Number of devices with this recommendation.
	DevicesCount *int64

	// READ-ONLY; Display name of the recommendation.
	RecommendationDisplayName *string

	// READ-ONLY; Assessed recommendation severity.
	ReportedSeverity *ReportedSeverity
}

// IoTSecuritySolutionAnalyticsModel - Security analytics of your IoT Security solution
type IoTSecuritySolutionAnalyticsModel struct {
	// Security Solution Aggregated Alert data
	Properties *IoTSecuritySolutionAnalyticsModelProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// IoTSecuritySolutionAnalyticsModelList - List of Security analytics of your IoT Security solution
type IoTSecuritySolutionAnalyticsModelList struct {
	// REQUIRED; List of Security analytics of your IoT Security solution
	Value []*IoTSecuritySolutionAnalyticsModel

	// READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string
}

// IoTSecuritySolutionAnalyticsModelProperties - Security analytics properties of your IoT Security solution
type IoTSecuritySolutionAnalyticsModelProperties struct {
	// List of the 3 most prevalent device alerts.
	MostPrevalentDeviceAlerts []*IoTSecurityDeviceAlert

	// List of the 3 most prevalent device recommendations.
	MostPrevalentDeviceRecommendations []*IoTSecurityDeviceRecommendation

	// List of the 3 devices with the most alerts.
	TopAlertedDevices []*IoTSecurityAlertedDevice

	// READ-ONLY; List of device metrics by the aggregation date.
	DevicesMetrics []*IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem

	// READ-ONLY; Security analytics of your IoT Security solution.
	Metrics *IoTSeverityMetrics

	// READ-ONLY; Number of unhealthy devices within your IoT Security solution.
	UnhealthyDeviceCount *int64
}

type IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem struct {
	// Aggregation of IoT Security solution device alert metrics by date.
	Date *time.Time

	// Device alert count by severity.
	DevicesMetrics *IoTSeverityMetrics
}

// IoTSecuritySolutionModel - IoT Security solution configuration and resource information.
type IoTSecuritySolutionModel struct {
	// The resource location.
	Location *string

	// Security Solution data
	Properties *IoTSecuritySolutionProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// IoTSecuritySolutionProperties - Security Solution setting data
type IoTSecuritySolutionProperties struct {
	// REQUIRED; Resource display name.
	DisplayName *string

	// REQUIRED; IoT Hub resource IDs
	IotHubs []*string

	// List of additional workspaces
	AdditionalWorkspaces []*AdditionalWorkspacesProperties

	// Disabled data sources. Disabling these data sources compromises the system.
	DisabledDataSources []*DataSource

	// List of additional options for exporting to workspace data.
	Export []*ExportData

	// List of the configuration status for each recommendation type.
	RecommendationsConfiguration []*RecommendationConfigurationProperties

	// Status of the IoT Security solution.
	Status *SecuritySolutionStatus

	// Unmasked IP address logging status
	UnmaskedIPLoggingStatus *UnmaskedIPLoggingStatus

	// Properties of the IoT Security solution's user defined resources.
	UserDefinedResources *UserDefinedResourcesProperties

	// Workspace resource ID
	Workspace *string

	// READ-ONLY; List of resources that were automatically discovered as relevant to the security solution.
	AutoDiscoveredResources []*string
}

// IoTSecuritySolutionsList - List of IoT Security solutions.
type IoTSecuritySolutionsList struct {
	// REQUIRED; List of IoT Security solutions
	Value []*IoTSecuritySolutionModel

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// IoTSeverityMetrics - IoT Security solution analytics severity metrics.
type IoTSeverityMetrics struct {
	// Count of high severity alerts/recommendations.
	High *int64

	// Count of low severity alerts/recommendations.
	Low *int64

	// Count of medium severity alerts/recommendations.
	Medium *int64
}

// Issue - The issue that caused the resource to by unhealthy
type Issue struct {
	// REQUIRED; The unique issue key
	IssueKey *string

	// Additional data for the given issue. The additional data depends on the issue type
	IssueAdditionalData map[string]*string

	// The issue description
	IssueDescription *string

	// The issue name
	IssueName *string

	// The remediation script to solve this issue
	RemediationScript *string

	// Human readable description of what you should do to mitigate this health issue
	RemediationSteps *string

	// The affected security values that MDC offers that will be affected by the issue, for example: recommendations, alerts,
	// etc
	SecurityValues []*string
}

type JitNetworkAccessPoliciesList struct {
	Value []*JitNetworkAccessPolicy

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

type JitNetworkAccessPolicy struct {
	// REQUIRED
	Properties *JitNetworkAccessPolicyProperties

	// Kind of the resource
	Kind *string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

type JitNetworkAccessPolicyInitiatePort struct {
	// REQUIRED; The time to close the request in UTC
	EndTimeUTC *time.Time

	// REQUIRED
	Number *int32

	// Source of the allowed traffic. If omitted, the request will be for the source IP address of the initiate request.
	AllowedSourceAddressPrefix *string
}

type JitNetworkAccessPolicyInitiateRequest struct {
	// REQUIRED; A list of virtual machines & ports to open access for
	VirtualMachines []*JitNetworkAccessPolicyInitiateVirtualMachine

	// The justification for making the initiate request
	Justification *string
}

type JitNetworkAccessPolicyInitiateVirtualMachine struct {
	// REQUIRED; Resource ID of the virtual machine that is linked to this policy
	ID *string

	// REQUIRED; The ports to open for the resource with the id
	Ports []*JitNetworkAccessPolicyInitiatePort
}

type JitNetworkAccessPolicyProperties struct {
	// REQUIRED; Configurations for Microsoft.Compute/virtualMachines resource type.
	VirtualMachines []*JitNetworkAccessPolicyVirtualMachine
	Requests        []*JitNetworkAccessRequest

	// READ-ONLY; Gets the provisioning state of the Just-in-Time policy.
	ProvisioningState *string
}

type JitNetworkAccessPolicyVirtualMachine struct {
	// REQUIRED; Resource ID of the virtual machine that is linked to this policy
	ID *string

	// REQUIRED; Port configurations for the virtual machine
	Ports []*JitNetworkAccessPortRule

	// Public IP address of the Azure Firewall that is linked to this policy, if applicable
	PublicIPAddress *string
}

type JitNetworkAccessPortRule struct {
	// REQUIRED; Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
	MaxRequestAccessDuration *string

	// REQUIRED
	Number *int32

	// REQUIRED
	Protocol *Protocol

	// Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3"
	// or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string

	// Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes []*string
}

type JitNetworkAccessRequest struct {
	// REQUIRED; The identity of the person who made the request
	Requestor *string

	// REQUIRED; The start time of the request in UTC
	StartTimeUTC *time.Time

	// REQUIRED
	VirtualMachines []*JitNetworkAccessRequestVirtualMachine

	// The justification for making the initiate request
	Justification *string
}

type JitNetworkAccessRequestPort struct {
	// REQUIRED; The date & time at which the request ends in UTC
	EndTimeUTC *time.Time

	// REQUIRED
	Number *int32

	// REQUIRED; The status of the port
	Status *Status

	// REQUIRED; A description of why the status has its value
	StatusReason *StatusReason

	// Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3"
	// or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string

	// Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes []*string

	// The port which is mapped to this port's number in the Azure Firewall, if applicable
	MappedPort *int32
}

type JitNetworkAccessRequestVirtualMachine struct {
	// REQUIRED; Resource ID of the virtual machine that is linked to this policy
	ID *string

	// REQUIRED; The ports that were opened for the virtual machine
	Ports []*JitNetworkAccessRequestPort
}

// KindAutoGenerated - Describes an Azure resource with kind
type KindAutoGenerated struct {
	// Kind of the resource
	Kind *string
}

// Label - Microsoft information protection sensitivity label
type Label struct {
	// The ID of the label
	ID *string

	// The display name of the label
	Name *string

	// Labels are ordered by sensitivity level. The higher the order of the label, the more sensitive it is.
	Order *float32
}

// ListCustomAlertRule - A List custom alert rule.
type ListCustomAlertRule struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ListCustomAlertRule.
func (l *ListCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: l.Description,
		DisplayName: l.DisplayName,
		IsEnabled:   l.IsEnabled,
		RuleType:    l.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type ListCustomAlertRule.
func (l *ListCustomAlertRule) GetListCustomAlertRule() *ListCustomAlertRule { return l }

// LocalUserNotAllowed - Login by a local user that isn't allowed. Allow list consists of login names to allow.
type LocalUserNotAllowed struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type LocalUserNotAllowed.
func (l *LocalUserNotAllowed) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule {
	return &AllowlistCustomAlertRule{
		AllowlistValues: l.AllowlistValues,
		Description:     l.Description,
		DisplayName:     l.DisplayName,
		IsEnabled:       l.IsEnabled,
		RuleType:        l.RuleType,
		ValueType:       l.ValueType,
	}
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type LocalUserNotAllowed.
func (l *LocalUserNotAllowed) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: l.Description,
		DisplayName: l.DisplayName,
		IsEnabled:   l.IsEnabled,
		RuleType:    l.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type LocalUserNotAllowed.
func (l *LocalUserNotAllowed) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		Description: l.Description,
		DisplayName: l.DisplayName,
		IsEnabled:   l.IsEnabled,
		RuleType:    l.RuleType,
		ValueType:   l.ValueType,
	}
}

// Location - Describes an Azure resource with location
type Location struct {
	// READ-ONLY; Location where the resource is stored
	Location *string
}

// LogAnalyticsIdentifier - Represents a Log Analytics workspace scope identifier.
type LogAnalyticsIdentifier struct {
	// REQUIRED; There can be multiple identifiers of different type per alert, this field specify the identifier type.
	Type *ResourceIdentifierType

	// READ-ONLY; (optional) The LogAnalytics agent id reporting the event that this alert is based on.
	AgentID *string

	// READ-ONLY; The LogAnalytics workspace id that stores this alert.
	WorkspaceID *string

	// READ-ONLY; The azure resource group for the LogAnalytics workspace storing this alert
	WorkspaceResourceGroup *string

	// READ-ONLY; The azure subscription id for the LogAnalytics workspace storing this alert.
	WorkspaceSubscriptionID *string
}

// GetResourceIdentifier implements the ResourceIdentifierClassification interface for type LogAnalyticsIdentifier.
func (l *LogAnalyticsIdentifier) GetResourceIdentifier() *ResourceIdentifier {
	return &ResourceIdentifier{
		Type: l.Type,
	}
}

// MdeOnboardingData - The resource of the configuration or data needed to onboard the machine to MDE
type MdeOnboardingData struct {
	// Properties of the MDE configuration or data parameter needed to onboard the machine to MDE
	Properties *MdeOnboardingDataProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// MdeOnboardingDataList - List of all MDE onboarding data resources
type MdeOnboardingDataList struct {
	// List of the resources of the configuration or data needed to onboard the machine to MDE
	Value []*MdeOnboardingData
}

// MdeOnboardingDataProperties - Properties of the MDE configuration or data parameter needed to onboard the machine to MDE
type MdeOnboardingDataProperties struct {
	// The onboarding package used to onboard Linux machines to MDE, coded in base64. This can also be used for onboarding using
	// the dedicated VM Extension
	OnboardingPackageLinux []byte

	// The onboarding package used to onboard Windows machines to MDE, coded in base64. This can also be used for onboarding using
	// the dedicated VM Extension
	OnboardingPackageWindows []byte
}

// MqttC2DMessagesNotInAllowedRange - Number of cloud to device messages (MQTT protocol) is not in allowed range.
type MqttC2DMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type MqttC2DMessagesNotInAllowedRange.
func (m *MqttC2DMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: m.Description,
		DisplayName: m.DisplayName,
		IsEnabled:   m.IsEnabled,
		RuleType:    m.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type MqttC2DMessagesNotInAllowedRange.
func (m *MqttC2DMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  m.Description,
		DisplayName:  m.DisplayName,
		IsEnabled:    m.IsEnabled,
		MaxThreshold: m.MaxThreshold,
		MinThreshold: m.MinThreshold,
		RuleType:     m.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type MqttC2DMessagesNotInAllowedRange.
func (m *MqttC2DMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    m.Description,
		DisplayName:    m.DisplayName,
		IsEnabled:      m.IsEnabled,
		MaxThreshold:   m.MaxThreshold,
		MinThreshold:   m.MinThreshold,
		RuleType:       m.RuleType,
		TimeWindowSize: m.TimeWindowSize,
	}
}

// MqttC2DRejectedMessagesNotInAllowedRange - Number of rejected cloud to device messages (MQTT protocol) is not in allowed
// range.
type MqttC2DRejectedMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type MqttC2DRejectedMessagesNotInAllowedRange.
func (m *MqttC2DRejectedMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: m.Description,
		DisplayName: m.DisplayName,
		IsEnabled:   m.IsEnabled,
		RuleType:    m.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type MqttC2DRejectedMessagesNotInAllowedRange.
func (m *MqttC2DRejectedMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  m.Description,
		DisplayName:  m.DisplayName,
		IsEnabled:    m.IsEnabled,
		MaxThreshold: m.MaxThreshold,
		MinThreshold: m.MinThreshold,
		RuleType:     m.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type MqttC2DRejectedMessagesNotInAllowedRange.
func (m *MqttC2DRejectedMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    m.Description,
		DisplayName:    m.DisplayName,
		IsEnabled:      m.IsEnabled,
		MaxThreshold:   m.MaxThreshold,
		MinThreshold:   m.MinThreshold,
		RuleType:       m.RuleType,
		TimeWindowSize: m.TimeWindowSize,
	}
}

// MqttD2CMessagesNotInAllowedRange - Number of device to cloud messages (MQTT protocol) is not in allowed range.
type MqttD2CMessagesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type MqttD2CMessagesNotInAllowedRange.
func (m *MqttD2CMessagesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: m.Description,
		DisplayName: m.DisplayName,
		IsEnabled:   m.IsEnabled,
		RuleType:    m.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type MqttD2CMessagesNotInAllowedRange.
func (m *MqttD2CMessagesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  m.Description,
		DisplayName:  m.DisplayName,
		IsEnabled:    m.IsEnabled,
		MaxThreshold: m.MaxThreshold,
		MinThreshold: m.MinThreshold,
		RuleType:     m.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type MqttD2CMessagesNotInAllowedRange.
func (m *MqttD2CMessagesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    m.Description,
		DisplayName:    m.DisplayName,
		IsEnabled:      m.IsEnabled,
		MaxThreshold:   m.MaxThreshold,
		MinThreshold:   m.MinThreshold,
		RuleType:       m.RuleType,
		TimeWindowSize: m.TimeWindowSize,
	}
}

// OnPremiseResourceDetails - Details of the On Premise resource that was assessed
type OnPremiseResourceDetails struct {
	// REQUIRED; The name of the machine
	MachineName *string

	// REQUIRED; The platform where the assessed resource resides
	Source *Source

	// REQUIRED; The oms agent Id installed on the machine
	SourceComputerID *string

	// REQUIRED; The unique Id of the machine
	Vmuuid *string

	// REQUIRED; Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string
}

// GetOnPremiseResourceDetails implements the OnPremiseResourceDetailsClassification interface for type OnPremiseResourceDetails.
func (o *OnPremiseResourceDetails) GetOnPremiseResourceDetails() *OnPremiseResourceDetails { return o }

// GetResourceDetails implements the ResourceDetailsClassification interface for type OnPremiseResourceDetails.
func (o *OnPremiseResourceDetails) GetResourceDetails() *ResourceDetails {
	return &ResourceDetails{
		Source: o.Source,
	}
}

// OnPremiseSQLResourceDetails - Details of the On Premise Sql resource that was assessed
type OnPremiseSQLResourceDetails struct {
	// REQUIRED; The Sql database name installed on the machine
	DatabaseName *string

	// REQUIRED; The name of the machine
	MachineName *string

	// REQUIRED; The Sql server name installed on the machine
	ServerName *string

	// REQUIRED; The platform where the assessed resource resides
	Source *Source

	// REQUIRED; The oms agent Id installed on the machine
	SourceComputerID *string

	// REQUIRED; The unique Id of the machine
	Vmuuid *string

	// REQUIRED; Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string
}

// GetOnPremiseResourceDetails implements the OnPremiseResourceDetailsClassification interface for type OnPremiseSQLResourceDetails.
func (o *OnPremiseSQLResourceDetails) GetOnPremiseResourceDetails() *OnPremiseResourceDetails {
	return &OnPremiseResourceDetails{
		MachineName:      o.MachineName,
		Source:           o.Source,
		SourceComputerID: o.SourceComputerID,
		Vmuuid:           o.Vmuuid,
		WorkspaceID:      o.WorkspaceID,
	}
}

// GetResourceDetails implements the ResourceDetailsClassification interface for type OnPremiseSQLResourceDetails.
func (o *OnPremiseSQLResourceDetails) GetResourceDetails() *ResourceDetails {
	return &ResourceDetails{
		Source: o.Source,
	}
}

// Operation - Possible operation in the REST API of Microsoft.Security
type Operation struct {
	// Security operation display
	Display *OperationDisplay

	// READ-ONLY; Name of the operation
	Name *string

	// READ-ONLY; Where the operation is originated
	Origin *string
}

// OperationDisplay - Security operation display
type OperationDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string

	// READ-ONLY; The display name of the security operation.
	Operation *string

	// READ-ONLY; The resource provider for the operation.
	Provider *string

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string
}

// OperationList - List of possible operations for Microsoft.Security resource provider
type OperationList struct {
	// List of Security operations
	Value []*Operation

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// OperationResultAutoGenerated - Long run operation status of governance rule over a given scope
type OperationResultAutoGenerated struct {
	// READ-ONLY; The status of the long run operation result of governance rule
	Status *OperationResult
}

// OperationStatus - A status describing the success/failure of the extension's enablement/disablement operation.
type OperationStatus struct {
	// The operation status code.
	Code *Code

	// Additional information regarding the success/failure of the operation.
	Message *string
}

// OperatorList - List of SecurityOperator response.
type OperatorList struct {
	// REQUIRED; List of SecurityOperator configurations
	Value []*OperatorResource
}

// OperatorResource - Security operator under a given subscription and pricing
type OperatorResource struct {
	// Identity for the resource.
	Identity *Identity

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// PathRecommendation - Represents a path that is recommended to be allowed and its properties
type PathRecommendation struct {
	// The recommendation action of the machine or rule
	Action *RecommendationAction

	// Whether the application is commonly run on the machine
	Common *bool

	// The configuration status of the machines group or machine or rule
	ConfigurationStatus *ConfigurationStatus

	// The type of the file (for Linux files - Executable is used)
	FileType *FileType

	// The full path of the file, or an identifier of the application
	Path *string

	// Represents the publisher information of a process/rule
	PublisherInfo *PublisherInfo

	// The type of IoT Security recommendation.
	Type      *RecommendationType
	UserSids  []*string
	Usernames []*UserRecommendation
}

// Pricing - Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced
// security capabilities, while the free tier offers basic security features.
type Pricing struct {
	// Pricing data
	Properties *PricingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// PricingList - List of pricing configurations response.
type PricingList struct {
	// REQUIRED; List of pricing configurations
	Value []*Pricing
}

// PricingProperties - Pricing properties for the relevant scope
type PricingProperties struct {
	// REQUIRED; The pricing tier value. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The
	// standard tier offers advanced security capabilities, while the free tier offers basic
	// security features.
	PricingTier *PricingTier

	// Optional. List of extensions offered under a plan.
	Extensions []*Extension

	// The sub-plan selected for a Standard pricing configuration, when more than one sub-plan is available. Each sub-plan enables
	// a set of security features. When not specified, full plan is applied.
	SubPlan *string

	// READ-ONLY; Optional. True if the plan is deprecated. If there are replacing plans they will appear in replacedBy property
	Deprecated *bool

	// READ-ONLY; Optional. If pricingTier is Standard then this property holds the date of the last time the pricingTier was
	// set to Standard, when available (e.g 2023-03-01T12:42:42.1921106Z).
	EnablementTime *time.Time

	// READ-ONLY; The duration left for the subscriptions free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
	FreeTrialRemainingTime *string

	// READ-ONLY; Optional. List of plans that replace this plan. This property exists only if this plan is deprecated.
	ReplacedBy []*string
}

// ProcessNotAllowed - Execution of a process that isn't allowed. Allow list consists of process names to allow.
type ProcessNotAllowed struct {
	// REQUIRED; The values to allow. The format of the values depends on the rule type.
	AllowlistValues []*string

	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string

	// READ-ONLY; The value type of the items in the list.
	ValueType *ValueType
}

// GetAllowlistCustomAlertRule implements the AllowlistCustomAlertRuleClassification interface for type ProcessNotAllowed.
func (p *ProcessNotAllowed) GetAllowlistCustomAlertRule() *AllowlistCustomAlertRule {
	return &AllowlistCustomAlertRule{
		AllowlistValues: p.AllowlistValues,
		Description:     p.Description,
		DisplayName:     p.DisplayName,
		IsEnabled:       p.IsEnabled,
		RuleType:        p.RuleType,
		ValueType:       p.ValueType,
	}
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ProcessNotAllowed.
func (p *ProcessNotAllowed) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: p.Description,
		DisplayName: p.DisplayName,
		IsEnabled:   p.IsEnabled,
		RuleType:    p.RuleType,
	}
}

// GetListCustomAlertRule implements the ListCustomAlertRuleClassification interface for type ProcessNotAllowed.
func (p *ProcessNotAllowed) GetListCustomAlertRule() *ListCustomAlertRule {
	return &ListCustomAlertRule{
		Description: p.Description,
		DisplayName: p.DisplayName,
		IsEnabled:   p.IsEnabled,
		RuleType:    p.RuleType,
		ValueType:   p.ValueType,
	}
}

// ProtectionMode - The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used
// for Linux.
type ProtectionMode struct {
	// The application control policy enforcement/protection mode of the machine group
	Exe *EnforcementMode

	// The application control policy enforcement/protection mode of the machine group
	Executable *EnforcementMode

	// The application control policy enforcement/protection mode of the machine group
	Msi *EnforcementMode

	// The application control policy enforcement/protection mode of the machine group
	Script *EnforcementMode
}

// ProxyServerProperties - For a non-Azure machine that is not connected directly to the internet, specify a proxy server
// that the non-Azure machine can use.
type ProxyServerProperties struct {
	// Proxy server IP
	IP *string

	// Proxy server port
	Port *string
}

// PublisherInfo - Represents the publisher information of a process/rule
type PublisherInfo struct {
	// The "OriginalName" field taken from the file's version resource
	BinaryName *string

	// The product name taken from the file's version resource
	ProductName *string

	// The Subject field of the x.509 certificate used to sign the code, using the following fields - O = Organization, L = Locality,
	// S = State or Province, and C = Country
	PublisherName *string

	// The binary file version taken from the file's version resource
	Version *string
}

// QueryCheck - The rule query details.
type QueryCheck struct {
	// Column names of expected result.
	ColumnNames []*string

	// Expected result.
	ExpectedResult [][]*string

	// The rule query.
	Query *string
}

// QueuePurgesNotInAllowedRange - Number of device queue purges is not in allowed range.
type QueuePurgesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type QueuePurgesNotInAllowedRange.
func (q *QueuePurgesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: q.Description,
		DisplayName: q.DisplayName,
		IsEnabled:   q.IsEnabled,
		RuleType:    q.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type QueuePurgesNotInAllowedRange.
func (q *QueuePurgesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  q.Description,
		DisplayName:  q.DisplayName,
		IsEnabled:    q.IsEnabled,
		MaxThreshold: q.MaxThreshold,
		MinThreshold: q.MinThreshold,
		RuleType:     q.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type QueuePurgesNotInAllowedRange.
func (q *QueuePurgesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    q.Description,
		DisplayName:    q.DisplayName,
		IsEnabled:      q.IsEnabled,
		MaxThreshold:   q.MaxThreshold,
		MinThreshold:   q.MinThreshold,
		RuleType:       q.RuleType,
		TimeWindowSize: q.TimeWindowSize,
	}
}

// RecommendationConfigurationProperties - The type of IoT Security recommendation.
type RecommendationConfigurationProperties struct {
	// REQUIRED; The type of IoT Security recommendation.
	RecommendationType *RecommendationType

	// REQUIRED; Recommendation status. When the recommendation status is disabled recommendations are not generated.
	Status *RecommendationConfigStatus

	// READ-ONLY
	Name *string
}

// RegulatoryComplianceAssessment - Regulatory compliance assessment details and state
type RegulatoryComplianceAssessment struct {
	// Regulatory compliance assessment data
	Properties *RegulatoryComplianceAssessmentProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// RegulatoryComplianceAssessmentList - List of regulatory compliance assessment response
type RegulatoryComplianceAssessmentList struct {
	// REQUIRED
	Value []*RegulatoryComplianceAssessment

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// RegulatoryComplianceAssessmentProperties - Regulatory compliance assessment data
type RegulatoryComplianceAssessmentProperties struct {
	// Aggregative state based on the assessment's scanned resources states
	State *State

	// READ-ONLY; Link to more detailed assessment results data. The response type will be according to the assessmentType field
	AssessmentDetailsLink *string

	// READ-ONLY; The expected type of assessment contained in the AssessmentDetailsLink
	AssessmentType *string

	// READ-ONLY; The description of the regulatory compliance assessment
	Description *string

	// READ-ONLY; The given assessment's related resources count with failed state.
	FailedResources *int32

	// READ-ONLY; The given assessment's related resources count with passed state.
	PassedResources *int32

	// READ-ONLY; The given assessment's related resources count with skipped state.
	SkippedResources *int32

	// READ-ONLY; The given assessment's related resources count with unsupported state.
	UnsupportedResources *int32
}

// RegulatoryComplianceControl - Regulatory compliance control details and state
type RegulatoryComplianceControl struct {
	// Regulatory compliance control data
	Properties *RegulatoryComplianceControlProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// RegulatoryComplianceControlList - List of regulatory compliance controls response
type RegulatoryComplianceControlList struct {
	// REQUIRED; List of regulatory compliance controls
	Value []*RegulatoryComplianceControl

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// RegulatoryComplianceControlProperties - Regulatory compliance control data
type RegulatoryComplianceControlProperties struct {
	// Aggregative state based on the control's supported assessments states
	State *State

	// READ-ONLY; The description of the regulatory compliance control
	Description *string

	// READ-ONLY; The number of supported regulatory compliance assessments of the given control with a failed state
	FailedAssessments *int32

	// READ-ONLY; The number of supported regulatory compliance assessments of the given control with a passed state
	PassedAssessments *int32

	// READ-ONLY; The number of supported regulatory compliance assessments of the given control with a skipped state
	SkippedAssessments *int32
}

// RegulatoryComplianceStandard - Regulatory compliance standard details and state
type RegulatoryComplianceStandard struct {
	// Regulatory compliance standard data
	Properties *RegulatoryComplianceStandardProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// RegulatoryComplianceStandardList - List of regulatory compliance standards response
type RegulatoryComplianceStandardList struct {
	// REQUIRED
	Value []*RegulatoryComplianceStandard

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// RegulatoryComplianceStandardProperties - Regulatory compliance standard data
type RegulatoryComplianceStandardProperties struct {
	// Aggregative state based on the standard's supported controls states
	State *State

	// READ-ONLY; The number of supported regulatory compliance controls of the given standard with a failed state
	FailedControls *int32

	// READ-ONLY; The number of supported regulatory compliance controls of the given standard with a passed state
	PassedControls *int32

	// READ-ONLY; The number of supported regulatory compliance controls of the given standard with a skipped state
	SkippedControls *int32

	// READ-ONLY; The number of regulatory compliance controls of the given standard which are unsupported by automated assessments
	UnsupportedControls *int32
}

// Remediation details.
type Remediation struct {
	// Is remediation automated.
	Automated *bool

	// Remediation description.
	Description *string

	// Optional link to remediate in Azure Portal.
	PortalLink *string

	// Remediation script.
	Scripts []*string
}

// RemediationEta - The ETA (estimated time of arrival) for remediation
type RemediationEta struct {
	// REQUIRED; ETA for remediation.
	Eta *time.Time

	// REQUIRED; Justification for change of Eta.
	Justification *string
}

// Resource - Describes an Azure resource.
type Resource struct {
	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ResourceDetails - Details of the resource that was assessed
type ResourceDetails struct {
	// REQUIRED; The platform where the assessed resource resides
	Source *Source
}

// GetResourceDetails implements the ResourceDetailsClassification interface for type ResourceDetails.
func (r *ResourceDetails) GetResourceDetails() *ResourceDetails { return r }

// ResourceDetailsAutoGenerated - The resource details of the health report
type ResourceDetailsAutoGenerated struct {
	// The status of the health report
	Source *Source

	// READ-ONLY; The id of the connector
	ConnectorID *string

	// READ-ONLY; The azure id of the resource
	ID *string
}

// ResourceIdentifier - A resource identifier for an alert which can be used to direct the alert to the right product exposure
// group (tenant, workspace, subscription etc.).
type ResourceIdentifier struct {
	// REQUIRED; There can be multiple identifiers of different type per alert, this field specify the identifier type.
	Type *ResourceIdentifierType
}

// GetResourceIdentifier implements the ResourceIdentifierClassification interface for type ResourceIdentifier.
func (r *ResourceIdentifier) GetResourceIdentifier() *ResourceIdentifier { return r }

// Rule - Describes remote addresses that is recommended to communicate with the Azure resource on some (Protocol, Port, Direction).
// All other remote addresses are recommended to be blocked
type Rule struct {
	// The rule's destination port
	DestinationPort *int32

	// The rule's direction
	Direction *Direction

	// The remote IP addresses that should be able to communicate with the Azure resource on the rule's destination port and protocol
	IPAddresses []*string

	// The name of the rule
	Name *string

	// The rule's transport protocols
	Protocols []*TransportProtocol
}

// RuleResults - Rule results.
type RuleResults struct {
	// Rule results properties.
	Properties *RuleResultsProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// RuleResultsInput - Rule results input.
type RuleResultsInput struct {
	// Take results from latest scan.
	LatestScan *bool

	// Expected results to be inserted into the baseline. Leave this field empty it LatestScan == true.
	Results [][]*string
}

// RuleResultsProperties - Rule results properties.
type RuleResultsProperties struct {
	// Expected results in the baseline.
	Results [][]*string
}

// RulesResults - A list of rules results.
type RulesResults struct {
	// List of rule results.
	Value []*RuleResults
}

// RulesResultsInput - Rules results input.
type RulesResultsInput struct {
	// Take results from latest scan.
	LatestScan *bool

	// Expected results to be inserted into the baseline. Leave this field empty it LatestScan == true.
	Results map[string][][]*string
}

// SQLServerVulnerabilityProperties - Details of the resource that was assessed
type SQLServerVulnerabilityProperties struct {
	// REQUIRED; Sub-assessment resource type
	AssessedResourceType *AssessedResourceType

	// READ-ONLY; The T-SQL query that runs on your SQL database to perform the particular check
	Query *string

	// READ-ONLY; The resource type the sub assessment refers to in its resource details
	Type *string
}

// GetAdditionalData implements the AdditionalDataClassification interface for type SQLServerVulnerabilityProperties.
func (s *SQLServerVulnerabilityProperties) GetAdditionalData() *AdditionalData {
	return &AdditionalData{
		AssessedResourceType: s.AssessedResourceType,
	}
}

// Scan - A vulnerability assessment scan record.
type Scan struct {
	// A vulnerability assessment scan record properties.
	Properties *ScanProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ScanProperties - A vulnerability assessment scan record properties.
type ScanProperties struct {
	// The database name.
	Database *string

	// Scan results are valid until end time (UTC).
	EndTime *time.Time

	// The number of failed rules with high severity.
	HighSeverityFailedRulesCount *int32

	// Baseline created for this database, and has one or more rules.
	IsBaselineApplied *bool

	// Last scan time.
	LastScanTime *time.Time

	// The number of failed rules with low severity.
	LowSeverityFailedRulesCount *int32

	// The number of failed rules with medium severity.
	MediumSeverityFailedRulesCount *int32

	// The SQL version.
	SQLVersion *string

	// The server name.
	Server *string

	// The scan start time (UTC).
	StartTime *time.Time

	// The scan status.
	State *ScanState

	// The number of total failed rules.
	TotalFailedRulesCount *int32

	// The number of total passed rules.
	TotalPassedRulesCount *int32

	// The number of total rules assessed.
	TotalRulesCount *int32

	// The scan trigger type.
	TriggerType *ScanTriggerType
}

// ScanResult - A vulnerability assessment scan result for a single rule.
type ScanResult struct {
	// A vulnerability assessment scan result properties for a single rule.
	Properties *ScanResultProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ScanResultProperties - A vulnerability assessment scan result properties for a single rule.
type ScanResultProperties struct {
	// The rule result adjusted with baseline.
	BaselineAdjustedResult *BaselineAdjustedResult

	// Indicated whether the results specified here are trimmed.
	IsTrimmed *bool

	// The results of the query that was run.
	QueryResults [][]*string

	// Remediation details.
	Remediation *Remediation

	// The rule Id.
	RuleID *string

	// vulnerability assessment rule metadata details.
	RuleMetadata *VaRule

	// The rule result status.
	Status *RuleStatus
}

// ScanResults - A list of vulnerability assessment scan results.
type ScanResults struct {
	// List of vulnerability assessment scan results.
	Value []*ScanResult
}

// Scans - A list of vulnerability assessment scan records.
type Scans struct {
	// List of vulnerability assessment scan records.
	Value []*Scan
}

// ScopeElement - A more specific scope used to identify the alerts to suppress.
type ScopeElement struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// The alert entity type to suppress by.
	Field *string
}

// ScoreDetails - Calculation result data
type ScoreDetails struct {
	// READ-ONLY; Current score
	Current *float64

	// READ-ONLY; Maximum score available
	Max *int32

	// READ-ONLY; Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point
	Percentage *float64
}

// SecureScoreControlDefinitionItem - Information about the security control.
type SecureScoreControlDefinitionItem struct {
	// Security Control Definition Properties.
	Properties *SecureScoreControlDefinitionItemProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SecureScoreControlDefinitionItemProperties - Security Control Definition Properties.
type SecureScoreControlDefinitionItemProperties struct {
	// READ-ONLY; Array of assessments metadata IDs that are included in this security control
	AssessmentDefinitions []*AzureResourceLink

	// READ-ONLY; User friendly description of the control
	Description *string

	// READ-ONLY; User friendly display name of the control
	DisplayName *string

	// READ-ONLY; Maximum control score (0..10)
	MaxScore *int32

	// READ-ONLY; Source object from which the control was created
	Source *SecureScoreControlDefinitionSource
}

// SecureScoreControlDefinitionList - List of security controls definition
type SecureScoreControlDefinitionList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY; Collection of security controls definition in this page
	Value []*SecureScoreControlDefinitionItem
}

// SecureScoreControlDefinitionSource - The type of the security control (For example, BuiltIn)
type SecureScoreControlDefinitionSource struct {
	// The type of security control (for example, BuiltIn)
	SourceType *ControlType
}

// SecureScoreControlDetails - Details of the security control, its score, and the health status of the relevant resources.
type SecureScoreControlDetails struct {
	// Calculation result data in control level
	Properties *SecureScoreControlScoreDetails

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SecureScoreControlList - List of security controls
type SecureScoreControlList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY; Collection of security controls in this page
	Value []*SecureScoreControlDetails
}

// SecureScoreControlScore - Calculation result data
type SecureScoreControlScore struct {
	// READ-ONLY; Actual score for the control = (achieved points / total points) * max score. if total points is zeroed, the
	// return number is 0.00
	Current *float64

	// READ-ONLY; Maximum control score (0..10)
	Max *int32

	// READ-ONLY; Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point
	Percentage *float64
}

// SecureScoreControlScoreDetails - Calculation result data in control level
type SecureScoreControlScoreDetails struct {
	// Information about the security control.
	Definition *SecureScoreControlDefinitionItem

	// READ-ONLY; User friendly display name of the control
	DisplayName *string

	// READ-ONLY; Number of healthy resources in the control
	HealthyResourceCount *int32

	// READ-ONLY; Number of not applicable resources in the control
	NotApplicableResourceCount *int32

	// READ-ONLY; Actual score object for the control
	Score *ScoreDetails

	// READ-ONLY; Number of unhealthy resources in the control
	UnhealthyResourceCount *int32

	// READ-ONLY; The relative weight for this specific control in each of your subscriptions. Used when calculating an aggregated
	// score for this control across all of your subscriptions.
	Weight *int64
}

// SecureScoreItem - Secure score item data model
type SecureScoreItem struct {
	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Secure score item
	Properties *SecureScoreItemProperties

	// READ-ONLY; Resource type
	Type *string
}

// SecureScoreItemProperties - Describes properties of a calculated secure score.
type SecureScoreItemProperties struct {
	// READ-ONLY; The initiative’s name
	DisplayName *string

	// READ-ONLY; score object
	Score *ScoreDetails

	// READ-ONLY; The relative weight for each subscription. Used when calculating an aggregated secure score for multiple subscriptions.
	Weight *int64
}

// SecureScoresList - List of secure scores
type SecureScoresList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY; Collection of secure scores in this page
	Value []*SecureScoreItem
}

// SensitivityLabel - The sensitivity label.
type SensitivityLabel struct {
	// The description of the sensitivity label.
	Description *string

	// The name of the sensitivity label.
	DisplayName *string

	// Indicates whether the label is enabled or not.
	Enabled *bool

	// The order of the sensitivity label.
	Order *int32

	// The rank of the sensitivity label.
	Rank *Rank
}

// ServerVulnerabilityAssessment - Describes the server vulnerability assessment details on a resource
type ServerVulnerabilityAssessment struct {
	// describes ServerVulnerabilityAssessment properties.
	Properties *ServerVulnerabilityAssessmentProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ServerVulnerabilityAssessmentProperties - describes ServerVulnerabilityAssessment properties.
type ServerVulnerabilityAssessmentProperties struct {
	// READ-ONLY; The provisioningState of the vulnerability assessment capability on the VM
	ProvisioningState *ServerVulnerabilityAssessmentPropertiesProvisioningState
}

// ServerVulnerabilityAssessmentsList - List of server vulnerability assessments
type ServerVulnerabilityAssessmentsList struct {
	Value []*ServerVulnerabilityAssessment
}

// ServerVulnerabilityProperties - Additional context fields for server vulnerability assessment
type ServerVulnerabilityProperties struct {
	// REQUIRED; Sub-assessment resource type
	AssessedResourceType *AssessedResourceType

	// READ-ONLY; List of CVEs
	Cve []*CVE

	// READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS

	// READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool

	// READ-ONLY; Published time
	PublishedTime *time.Time

	// READ-ONLY; Threat name
	Threat *string

	// READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered
	Type *string

	// READ-ONLY
	VendorReferences []*VendorReference
}

// GetAdditionalData implements the AdditionalDataClassification interface for type ServerVulnerabilityProperties.
func (s *ServerVulnerabilityProperties) GetAdditionalData() *AdditionalData {
	return &AdditionalData{
		AssessedResourceType: s.AssessedResourceType,
	}
}

// ServicePrincipalProperties - Details of the service principal.
type ServicePrincipalProperties struct {
	// Application ID of service principal.
	ApplicationID *string

	// A secret string that the application uses to prove its identity, also can be referred to as application password (write
	// only).
	Secret *string
}

// Setting - The kind of the security setting
type Setting struct {
	// REQUIRED; the kind of the settings string
	Kind *SettingKind

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// GetSetting implements the SettingClassification interface for type Setting.
func (s *Setting) GetSetting() *Setting { return s }

// SettingsList - Subscription settings list.
type SettingsList struct {
	// The settings list.
	Value []SettingClassification

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// Software - Represents a software data
type Software struct {
	// REQUIRED; Properties of the Software Inventory resource
	Properties *SoftwareProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SoftwareProperties - Software Inventory resource properties
type SoftwareProperties struct {
	// Unique identifier for the virtual machine in the service.
	DeviceID *string

	// The end of support date in case the product is upcoming end of support.
	EndOfSupportDate *string

	// End of support status.
	EndOfSupportStatus *EndOfSupportStatus

	// First time that the software was seen in the device.
	FirstSeenAt *string

	// Number of weaknesses.
	NumberOfKnownVulnerabilities *int32

	// Platform of the operating system running on the device.
	OSPlatform *string

	// Name of the software product.
	SoftwareName *string

	// Name of the software vendor.
	Vendor *string

	// Version number of the software product.
	Version *string
}

// SoftwaresList - Represents the software inventory of the virtual machine.
type SoftwaresList struct {
	Value []*Software

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

type Solution struct {
	Properties *SolutionProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

type SolutionList struct {
	Value []*Solution

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

type SolutionProperties struct {
	// REQUIRED; The security solutions' status
	ProtectionStatus *string

	// REQUIRED; The security family provisioning State
	ProvisioningState *ProvisioningState

	// REQUIRED; The security family of the security solution
	SecurityFamily *SecurityFamily

	// REQUIRED; The security solutions' template
	Template *string
}

type SolutionsReferenceData struct {
	// REQUIRED
	Properties *SolutionsReferenceDataProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

type SolutionsReferenceDataList struct {
	Value []*SolutionsReferenceData
}

type SolutionsReferenceDataProperties struct {
	// REQUIRED; The security solutions' vendor name
	AlertVendorName *string

	// REQUIRED; The security solutions' package info url
	PackageInfoURL *string

	// REQUIRED; The security solutions' product name
	ProductName *string

	// REQUIRED; The security solutions' publisher
	Publisher *string

	// REQUIRED; The security solutions' publisher display name
	PublisherDisplayName *string

	// REQUIRED; The security family of the security solution
	SecurityFamily *SecurityFamily

	// REQUIRED; The security solutions' template
	Template *string
}

// StatusAutoGenerated - The status of the health report
type StatusAutoGenerated struct {
	// The status of the health report
	Code *StatusName

	// READ-ONLY; The date of when the resource of the health report was scanned in the first time
	FirstEvaluationDate *time.Time

	// READ-ONLY; The date of when the status of the health report was changed in the last time
	StatusChangeDate *time.Time
}

// SubAssessment - Security sub-assessment on a resource
type SubAssessment struct {
	// Describes properties of an sub-assessment.
	Properties *SubAssessmentProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SubAssessmentList - List of security sub-assessments
type SubAssessmentList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY
	Value []*SubAssessment
}

// SubAssessmentProperties - Describes properties of an sub-assessment.
type SubAssessmentProperties struct {
	// Details of the sub-assessment
	AdditionalData AdditionalDataClassification

	// Details of the resource that was assessed
	ResourceDetails ResourceDetailsClassification

	// Status of the sub-assessment
	Status *SubAssessmentStatus

	// READ-ONLY; Category of the sub-assessment
	Category *string

	// READ-ONLY; Human readable description of the assessment status
	Description *string

	// READ-ONLY; User friendly display name of the sub-assessment
	DisplayName *string

	// READ-ONLY; Vulnerability ID
	ID *string

	// READ-ONLY; Description of the impact of this sub-assessment
	Impact *string

	// READ-ONLY; Information on how to remediate this sub-assessment
	Remediation *string

	// READ-ONLY; The date and time the sub-assessment was generated
	TimeGenerated *time.Time
}

// SubAssessmentStatus - Status of the sub-assessment
type SubAssessmentStatus struct {
	// READ-ONLY; Programmatic code for the cause of the assessment status
	Cause *string

	// READ-ONLY; Programmatic code for the status of the assessment
	Code *SubAssessmentStatusCode

	// READ-ONLY; Human readable description of the assessment status
	Description *string

	// READ-ONLY; The sub-assessment severity level
	Severity *Severity
}

type SuppressionAlertsScope struct {
	// REQUIRED; All the conditions inside need to be true in order to suppress the alert
	AllOf []*ScopeElement
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// Tags - A list of key value pairs that describe the resource.
type Tags struct {
	// A list of key value pairs that describe the resource.
	Tags map[string]*string
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string
}

// Task - Security task that we recommend to do in order to strengthen security
type Task struct {
	// Describes properties of a task.
	Properties *TaskProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// TaskList - List of security task recommendations
type TaskList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY
	Value []*Task
}

// TaskParameters - Changing set of properties, depending on the task type that is derived from the name field
type TaskParameters struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// READ-ONLY; Name of the task type
	Name *string
}

// TaskProperties - Describes properties of a task.
type TaskProperties struct {
	// Changing set of properties, depending on the task type that is derived from the name field
	SecurityTaskParameters *TaskParameters

	// READ-ONLY; The time this task was discovered in UTC
	CreationTimeUTC *time.Time

	// READ-ONLY; The time this task's details were last changed in UTC
	LastStateChangeTimeUTC *time.Time

	// READ-ONLY; State of the task (Active, Resolved etc.)
	State *string

	// READ-ONLY; Additional data on the state of the task
	SubState *string
}

// ThresholdCustomAlertRule - A custom alert rule that checks if a value (depends on the custom alert type) is within the
// given range.
type ThresholdCustomAlertRule struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type ThresholdCustomAlertRule.
func (t *ThresholdCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: t.Description,
		DisplayName: t.DisplayName,
		IsEnabled:   t.IsEnabled,
		RuleType:    t.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type ThresholdCustomAlertRule.
func (t *ThresholdCustomAlertRule) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule { return t }

// TimeWindowCustomAlertRule - A custom alert rule that checks if the number of activities (depends on the custom alert type)
// in a time window is within the given range.
type TimeWindowCustomAlertRule struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type TimeWindowCustomAlertRule.
func (t *TimeWindowCustomAlertRule) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: t.Description,
		DisplayName: t.DisplayName,
		IsEnabled:   t.IsEnabled,
		RuleType:    t.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type TimeWindowCustomAlertRule.
func (t *TimeWindowCustomAlertRule) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  t.Description,
		DisplayName:  t.DisplayName,
		IsEnabled:    t.IsEnabled,
		MaxThreshold: t.MaxThreshold,
		MinThreshold: t.MinThreshold,
		RuleType:     t.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type TimeWindowCustomAlertRule.
func (t *TimeWindowCustomAlertRule) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return t
}

type TopologyList struct {
	// READ-ONLY; The URI to fetch the next page.
	NextLink *string

	// READ-ONLY
	Value []*TopologyResource
}

type TopologyResource struct {
	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Location where the resource is stored
	Location *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY
	Properties *TopologyResourceProperties

	// READ-ONLY; Resource type
	Type *string
}

type TopologyResourceProperties struct {
	// READ-ONLY; The UTC time on which the topology was calculated
	CalculatedDateTime *time.Time

	// READ-ONLY; Azure resources which are part of this topology resource
	TopologyResources []*TopologySingleResource
}

type TopologySingleResource struct {
	// READ-ONLY; Azure resources connected to this resource which are in lower level in the topology view
	Children []*TopologySingleResourceChild

	// READ-ONLY; The location of this resource
	Location *string

	// READ-ONLY; Indicates the resource connectivity level to the Internet (InternetFacing, Internal ,etc.)
	NetworkZones *string

	// READ-ONLY; Azure resources connected to this resource which are in higher level in the topology view
	Parents []*TopologySingleResourceParent

	// READ-ONLY; Indicates if the resource has security recommendations
	RecommendationsExist *bool

	// READ-ONLY; Azure resource id
	ResourceID *string

	// READ-ONLY; The security severity of the resource
	Severity *string

	// READ-ONLY; Score of the resource based on its security severity
	TopologyScore *int32
}

type TopologySingleResourceChild struct {
	// READ-ONLY; Azure resource id which serves as child resource in topology view
	ResourceID *string
}

type TopologySingleResourceParent struct {
	// READ-ONLY; Azure resource id which serves as parent resource in topology view
	ResourceID *string
}

// TrackedResource - Describes an Azure tracked resource.
type TrackedResource struct {
	// Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string

	// Kind of the resource
	Kind *string

	// Location where the resource is stored
	Location *string

	// A list of key value pairs that describe the resource.
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// TwinUpdatesNotInAllowedRange - Number of twin updates is not in allowed range.
type TwinUpdatesNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type TwinUpdatesNotInAllowedRange.
func (t *TwinUpdatesNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: t.Description,
		DisplayName: t.DisplayName,
		IsEnabled:   t.IsEnabled,
		RuleType:    t.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type TwinUpdatesNotInAllowedRange.
func (t *TwinUpdatesNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  t.Description,
		DisplayName:  t.DisplayName,
		IsEnabled:    t.IsEnabled,
		MaxThreshold: t.MaxThreshold,
		MinThreshold: t.MinThreshold,
		RuleType:     t.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type TwinUpdatesNotInAllowedRange.
func (t *TwinUpdatesNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    t.Description,
		DisplayName:    t.DisplayName,
		IsEnabled:      t.IsEnabled,
		MaxThreshold:   t.MaxThreshold,
		MinThreshold:   t.MinThreshold,
		RuleType:       t.RuleType,
		TimeWindowSize: t.TimeWindowSize,
	}
}

// UnauthorizedOperationsNotInAllowedRange - Number of unauthorized operations is not in allowed range.
type UnauthorizedOperationsNotInAllowedRange struct {
	// REQUIRED; Status of the custom alert.
	IsEnabled *bool

	// REQUIRED; The maximum threshold.
	MaxThreshold *int32

	// REQUIRED; The minimum threshold.
	MinThreshold *int32

	// REQUIRED; The type of the custom alert rule.
	RuleType *string

	// REQUIRED; The time window size in iso8601 format.
	TimeWindowSize *string

	// READ-ONLY; The description of the custom alert.
	Description *string

	// READ-ONLY; The display name of the custom alert.
	DisplayName *string
}

// GetCustomAlertRule implements the CustomAlertRuleClassification interface for type UnauthorizedOperationsNotInAllowedRange.
func (u *UnauthorizedOperationsNotInAllowedRange) GetCustomAlertRule() *CustomAlertRule {
	return &CustomAlertRule{
		Description: u.Description,
		DisplayName: u.DisplayName,
		IsEnabled:   u.IsEnabled,
		RuleType:    u.RuleType,
	}
}

// GetThresholdCustomAlertRule implements the ThresholdCustomAlertRuleClassification interface for type UnauthorizedOperationsNotInAllowedRange.
func (u *UnauthorizedOperationsNotInAllowedRange) GetThresholdCustomAlertRule() *ThresholdCustomAlertRule {
	return &ThresholdCustomAlertRule{
		Description:  u.Description,
		DisplayName:  u.DisplayName,
		IsEnabled:    u.IsEnabled,
		MaxThreshold: u.MaxThreshold,
		MinThreshold: u.MinThreshold,
		RuleType:     u.RuleType,
	}
}

// GetTimeWindowCustomAlertRule implements the TimeWindowCustomAlertRuleClassification interface for type UnauthorizedOperationsNotInAllowedRange.
func (u *UnauthorizedOperationsNotInAllowedRange) GetTimeWindowCustomAlertRule() *TimeWindowCustomAlertRule {
	return &TimeWindowCustomAlertRule{
		Description:    u.Description,
		DisplayName:    u.DisplayName,
		IsEnabled:      u.IsEnabled,
		MaxThreshold:   u.MaxThreshold,
		MinThreshold:   u.MinThreshold,
		RuleType:       u.RuleType,
		TimeWindowSize: u.TimeWindowSize,
	}
}

// UpdateIoTSecuritySolutionProperties - Update Security Solution setting data
type UpdateIoTSecuritySolutionProperties struct {
	// List of the configuration status for each recommendation type.
	RecommendationsConfiguration []*RecommendationConfigurationProperties

	// Properties of the IoT Security solution's user defined resources.
	UserDefinedResources *UserDefinedResourcesProperties
}

type UpdateIotSecuritySolutionData struct {
	// Security Solution data
	Properties *UpdateIoTSecuritySolutionProperties

	// Resource tags
	Tags map[string]*string
}

// UpdateSensitivitySettingsRequest - Request to update data sensitivity settings for sensitive data discovery
type UpdateSensitivitySettingsRequest struct {
	// REQUIRED; List of selected sensitive info types' IDs.
	SensitiveInfoTypesIDs []*string

	// The id of the sensitivity threshold label. Any label at or above this rank will be considered sensitive.
	SensitivityThresholdLabelID *string

	// The order of the sensitivity threshold label. Any label at or above this order will be considered sensitive. If set to
	// -1, sensitivity by labels is turned off
	SensitivityThresholdLabelOrder *float32
}

// UserDefinedResourcesProperties - Properties of the IoT Security solution's user defined resources.
type UserDefinedResourcesProperties struct {
	// REQUIRED; Azure Resource Graph query which represents the security solution's user defined resources. Required to start
	// with "where type != "Microsoft.Devices/IotHubs""
	Query *string

	// REQUIRED; List of Azure subscription ids on which the user defined resources query should be executed.
	QuerySubscriptions []*string
}

// UserRecommendation - Represents a user that is recommended to be allowed for a certain rule
type UserRecommendation struct {
	// The recommendation action of the machine or rule
	RecommendationAction *RecommendationAction

	// Represents a user that is recommended to be allowed for a certain rule
	Username *string
}

// VMRecommendation - Represents a machine that is part of a machine group
type VMRecommendation struct {
	// The configuration status of the machines group or machine or rule
	ConfigurationStatus *ConfigurationStatus

	// The machine supportability of Enforce feature
	EnforcementSupport *EnforcementSupport

	// The recommendation action of the machine or rule
	RecommendationAction *RecommendationAction

	// The full resource id of the machine
	ResourceID *string
}

// VaRule - vulnerability assessment rule metadata details.
type VaRule struct {
	// The benchmark references.
	BenchmarkReferences []*BenchmarkReference

	// The rule category.
	Category *string

	// The rule description.
	Description *string

	// The rule query details.
	QueryCheck *QueryCheck

	// The rule rationale.
	Rationale *string

	// The rule Id.
	RuleID *string

	// The rule type.
	RuleType *RuleType

	// The rule severity.
	Severity *RuleSeverity

	// The rule title.
	Title *string
}

// VendorReference - Vendor reference
type VendorReference struct {
	// READ-ONLY; Link url
	Link *string

	// READ-ONLY; Link title
	Title *string
}

// WorkspaceSetting - Configures where to store the OMS agent data for workspaces under a scope
type WorkspaceSetting struct {
	// Workspace setting data
	Properties *WorkspaceSettingProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// WorkspaceSettingList - List of workspace settings response
type WorkspaceSettingList struct {
	// REQUIRED; List of workspace settings
	Value []*WorkspaceSetting

	// READ-ONLY; The URI to fetch the next page.
	NextLink *string
}

// WorkspaceSettingProperties - Workspace setting data
type WorkspaceSettingProperties struct {
	// REQUIRED; All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting
	// with more specific scope
	Scope *string

	// REQUIRED; The full Azure ID of the workspace to save the data in
	WorkspaceID *string
}
