//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-list-all.json
func ExampleStreamingEndpointsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewStreamingEndpointsClient().NewListPager("mediaresources", "slitestmedia10", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StreamingEndpointListResult = armmediaservices.StreamingEndpointListResult{
		// 	Value: []*armmediaservices.StreamingEndpoint{
		// 		{
		// 			Name: to.Ptr("myStreamingEndpoint1"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/streamingEndpoints"),
		// 			ID: to.Ptr("/subscriptions/0a6ec948-5a62-437d-b9df-934dc7c1b722/resourceGroups/mediaresources/providers/Microsoft.Media/mediaservices/slitestmedia10/streamingendpoints/myStreamingEndpoint1"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"tag1": to.Ptr("value1"),
		// 				"tag2": to.Ptr("value2"),
		// 			},
		// 			Properties: &armmediaservices.StreamingEndpointProperties{
		// 				Description: to.Ptr("test event 1"),
		// 				AvailabilitySetName: to.Ptr("availableset"),
		// 				CdnEnabled: to.Ptr(false),
		// 				CdnProfile: to.Ptr(""),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.202Z"); return t}()),
		// 				CustomHostNames: []*string{
		// 				},
		// 				FreeTrialEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T08:00:00.000Z"); return t}()),
		// 				HostName: to.Ptr("mystreamingendpoint1-slitestmedia10.streaming.mediaservices.windows.net"),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.202Z"); return t}()),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceState: to.Ptr(armmediaservices.StreamingEndpointResourceStateStopped),
		// 				ScaleUnits: to.Ptr[int32](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/streamingEndpoints"),
		// 			ID: to.Ptr("/subscriptions/0a6ec948-5a62-437d-b9df-934dc7c1b722/resourceGroups/mediaresources/providers/Microsoft.Media/mediaservices/slitestmedia10/streamingendpoints/default"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armmediaservices.StreamingEndpointProperties{
		// 				Description: to.Ptr(""),
		// 				CdnEnabled: to.Ptr(true),
		// 				CdnProfile: to.Ptr("AzureMediaStreamingPlatformCdnProfile-StandardVerizon"),
		// 				CdnProvider: to.Ptr("StandardVerizon"),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.231Z"); return t}()),
		// 				CustomHostNames: []*string{
		// 				},
		// 				FreeTrialEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T08:00:00.000Z"); return t}()),
		// 				HostName: to.Ptr("slitestmedia10.streaming.mediaservices.windows.net"),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.231Z"); return t}()),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ResourceState: to.Ptr(armmediaservices.StreamingEndpointResourceStateStarting),
		// 				ScaleUnits: to.Ptr[int32](0),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-list-by-name.json
func ExampleStreamingEndpointsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStreamingEndpointsClient().Get(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingEndpoint = armmediaservices.StreamingEndpoint{
	// 	Name: to.Ptr("myStreamingEndpoint1"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/streamingEndpoints"),
	// 	ID: to.Ptr("/subscriptions/0a6ec948-5a62-437d-b9df-934dc7c1b722/resourceGroups/mediaresources/providers/Microsoft.Media/mediaservices/slitestmedia10/streamingendpoints/myStreamingEndpoint1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armmediaservices.StreamingEndpointProperties{
	// 		Description: to.Ptr("test event 1"),
	// 		AvailabilitySetName: to.Ptr("availableset"),
	// 		CdnEnabled: to.Ptr(false),
	// 		CdnProfile: to.Ptr(""),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.350Z"); return t}()),
	// 		CustomHostNames: []*string{
	// 		},
	// 		FreeTrialEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T08:00:00.000Z"); return t}()),
	// 		HostName: to.Ptr("mystreamingendpoint1-slitestmedia10.streaming.mediaservices.windows.net"),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.350Z"); return t}()),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceState: to.Ptr(armmediaservices.StreamingEndpointResourceStateStopped),
	// 		ScaleUnits: to.Ptr[int32](1),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-create.json
func ExampleStreamingEndpointsClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingEndpointsClient().BeginCreate(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", armmediaservices.StreamingEndpoint{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
		Properties: &armmediaservices.StreamingEndpointProperties{
			Description: to.Ptr("test event 1"),
			AccessControl: &armmediaservices.StreamingEndpointAccessControl{
				Akamai: &armmediaservices.AkamaiAccessControl{
					AkamaiSignatureHeaderAuthenticationKeyList: []*armmediaservices.AkamaiSignatureHeaderAuthenticationKey{
						{
							Base64Key:  to.Ptr("dGVzdGlkMQ=="),
							Expiration: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2030-01-01T00:00:00.000Z"); return t }()),
							Identifier: to.Ptr("id1"),
						},
						{
							Base64Key:  to.Ptr("dGVzdGlkMQ=="),
							Expiration: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2031-01-01T00:00:00.000Z"); return t }()),
							Identifier: to.Ptr("id2"),
						}},
				},
				IP: &armmediaservices.IPAccessControl{
					Allow: []*armmediaservices.IPRange{
						{
							Name:    to.Ptr("AllowedIp"),
							Address: to.Ptr("192.168.1.1"),
						}},
				},
			},
			AvailabilitySetName: to.Ptr("availableset"),
			CdnEnabled:          to.Ptr(false),
			ScaleUnits:          to.Ptr[int32](1),
		},
	}, &armmediaservices.StreamingEndpointsClientBeginCreateOptions{AutoStart: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingEndpoint = armmediaservices.StreamingEndpoint{
	// 	Name: to.Ptr("myStreamingEndpoint1"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/streamingEndpoints"),
	// 	ID: to.Ptr("/subscriptions/0a6ec948-5a62-437d-b9df-934dc7c1b722/resourceGroups/mediaresources/providers/Microsoft.Media/mediaservices/slitestmedia10/streamingendpoints/myStreamingEndpoint1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armmediaservices.StreamingEndpointProperties{
	// 		Description: to.Ptr("test event 1"),
	// 		AccessControl: &armmediaservices.StreamingEndpointAccessControl{
	// 			Akamai: &armmediaservices.AkamaiAccessControl{
	// 				AkamaiSignatureHeaderAuthenticationKeyList: []*armmediaservices.AkamaiSignatureHeaderAuthenticationKey{
	// 					{
	// 						Base64Key: to.Ptr("dGVzdGlkMQ=="),
	// 						Expiration: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2030-01-01T00:00:00.000Z"); return t}()),
	// 						Identifier: to.Ptr("id1"),
	// 					},
	// 					{
	// 						Base64Key: to.Ptr("dGVzdGlkMQ=="),
	// 						Expiration: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2031-01-01T00:00:00.000Z"); return t}()),
	// 						Identifier: to.Ptr("id2"),
	// 				}},
	// 			},
	// 			IP: &armmediaservices.IPAccessControl{
	// 				Allow: []*armmediaservices.IPRange{
	// 					{
	// 						Name: to.Ptr("AllowedIp"),
	// 						Address: to.Ptr("192.168.1.1"),
	// 				}},
	// 			},
	// 		},
	// 		AvailabilitySetName: to.Ptr("availableset"),
	// 		CdnEnabled: to.Ptr(false),
	// 		CdnProfile: to.Ptr(""),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.756Z"); return t}()),
	// 		CustomHostNames: []*string{
	// 		},
	// 		FreeTrialEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T08:00:00.000Z"); return t}()),
	// 		HostName: to.Ptr("mystreamingendpoint1-slitestmedia10.streaming.mediaservices.windows.net"),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.756Z"); return t}()),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceState: to.Ptr(armmediaservices.StreamingEndpointResourceStateStopped),
	// 		ScaleUnits: to.Ptr[int32](1),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-update.json
func ExampleStreamingEndpointsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingEndpointsClient().BeginUpdate(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", armmediaservices.StreamingEndpoint{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"tag3": to.Ptr("value3"),
			"tag5": to.Ptr("value5"),
		},
		Properties: &armmediaservices.StreamingEndpointProperties{
			Description:         to.Ptr("test event 2"),
			AvailabilitySetName: to.Ptr("availableset"),
			ScaleUnits:          to.Ptr[int32](5),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingEndpoint = armmediaservices.StreamingEndpoint{
	// 	Name: to.Ptr("myStreamingEndpoint1"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/streamingEndpoints"),
	// 	ID: to.Ptr("/subscriptions/0a6ec948-5a62-437d-b9df-934dc7c1b722/resourceGroups/mediaresources/providers/Microsoft.Media/mediaservices/slitestmedia10/streamingendpoints/myStreamingEndpoint1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"tag3": to.Ptr("value3"),
	// 		"tag5": to.Ptr("value5"),
	// 	},
	// 	Properties: &armmediaservices.StreamingEndpointProperties{
	// 		Description: to.Ptr("test event 2"),
	// 		AvailabilitySetName: to.Ptr("availableset"),
	// 		CdnEnabled: to.Ptr(false),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		CustomHostNames: []*string{
	// 		},
	// 		FreeTrialEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ScaleUnits: to.Ptr[int32](5),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-delete.json
func ExampleStreamingEndpointsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingEndpointsClient().BeginDelete(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-list-skus.json
func ExampleStreamingEndpointsClient_SKUs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStreamingEndpointsClient().SKUs(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingEndpointSKUInfoListResult = armmediaservices.StreamingEndpointSKUInfoListResult{
	// 	Value: []*armmediaservices.ArmStreamingEndpointSKUInfo{
	// 		{
	// 			Capacity: &armmediaservices.ArmStreamingEndpointCapacity{
	// 				Default: to.Ptr[int32](1),
	// 				Maximum: to.Ptr[int32](10),
	// 				Minimum: to.Ptr[int32](1),
	// 				ScaleType: to.Ptr("Automatic"),
	// 			},
	// 			ResourceType: to.Ptr("Microsoft.Media/mediaservices/streamingEndpoints"),
	// 			SKU: &armmediaservices.ArmStreamingEndpointSKU{
	// 				Name: to.Ptr("Premium"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-start.json
func ExampleStreamingEndpointsClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingEndpointsClient().BeginStart(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-stop.json
func ExampleStreamingEndpointsClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingEndpointsClient().BeginStop(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-scale.json
func ExampleStreamingEndpointsClient_BeginScale() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewStreamingEndpointsClient().BeginScale(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", armmediaservices.StreamingEntityScaleUnit{
		ScaleUnit: to.Ptr[int32](5),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/async-operation-result.json
func ExampleStreamingEndpointsClient_AsyncOperation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStreamingEndpointsClient().AsyncOperation(ctx, "mediaresources", "slitestmedia10", "62e4d893-d233-4005-988e-a428d9f77076", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AsyncOperationResult = armmediaservices.AsyncOperationResult{
	// 	Name: to.Ptr("62e4d893-d233-4005-988e-a428d9f77076"),
	// 	Error: &armmediaservices.ErrorDetail{
	// 		Code: to.Ptr("None"),
	// 		Target: to.Ptr("d7aea790-8acb-40b9-8f9f-21cc37c9e519"),
	// 	},
	// 	Status: to.Ptr(armmediaservices.AsyncOperationStatusInProgress),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Streaming/stable/2022-08-01/examples/streamingendpoint-operation-location.json
func ExampleStreamingEndpointsClient_OperationLocation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewStreamingEndpointsClient().OperationLocation(ctx, "mediaresources", "slitestmedia10", "myStreamingEndpoint1", "62e4d893-d233-4005-988e-a428d9f77076", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StreamingEndpoint = armmediaservices.StreamingEndpoint{
	// 	Name: to.Ptr("myStreamingEndpoint1"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/streamingEndpoints"),
	// 	ID: to.Ptr("/subscriptions/0a6ec948-5a62-437d-b9df-934dc7c1b722/resourceGroups/mediaresources/providers/Microsoft.Media/mediaservices/slitestmedia10/streamingendpoints/myStreamingEndpoint1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armmediaservices.StreamingEndpointProperties{
	// 		Description: to.Ptr("test event 1"),
	// 		AvailabilitySetName: to.Ptr("availableset"),
	// 		CdnEnabled: to.Ptr(false),
	// 		CdnProfile: to.Ptr(""),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.350Z"); return t}()),
	// 		CustomHostNames: []*string{
	// 		},
	// 		FreeTrialEndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T08:00:00.000Z"); return t}()),
	// 		HostName: to.Ptr("mystreamingendpoint1-slitestmedia10.streaming.mediaservices.windows.net"),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.350Z"); return t}()),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ResourceState: to.Ptr(armmediaservices.StreamingEndpointResourceStateStopped),
	// 		ScaleUnits: to.Ptr[int32](1),
	// 	},
	// 	SKU: &armmediaservices.ArmStreamingEndpointCurrentSKU{
	// 		Name: to.Ptr("Premium"),
	// 		Capacity: to.Ptr[int32](1),
	// 	},
	// 	SystemData: &armmediaservices.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.350Z"); return t}()),
	// 		CreatedBy: to.Ptr("example@microsoft.com"),
	// 		CreatedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-03-03T02:25:09.350Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("example@microsoft.com"),
	// 		LastModifiedByType: to.Ptr(armmediaservices.CreatedByTypeUser),
	// 	},
	// }
}
