// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CAST_COMMON_CERTIFICATE_EUREKA_ROOT_CA_DER_INC_H_
#define CAST_COMMON_CERTIFICATE_EUREKA_ROOT_CA_DER_INC_H_

// Certificate:
//     Data:
//         Version: 3 (0x2)
//         Serial Number: 1 (0x1)
//     Signature Algorithm: sha1WithRSAEncryption
//         Issuer: C=US, ST=California, L=Mountain View, O=Google Inc,
//                 OU=Google TV, CN=Eureka Root CA
//         Validity
//             Not Before: Dec 17 22:39:33 2012 GMT
//             Not After : Dec 12 22:39:33 2032 GMT
//         Subject: C=US, ST=California, L=Mountain View, O=Google Inc,
//                  OU=Google TV, CN=Eureka Root CA
//         Subject Public Key Info:
//             Public Key Algorithm: rsaEncryption
//                 Public-Key: (2048 bit)
//                 Modulus:
//                     00:b9:11:d0:ea:12:dc:32:e1:df:5c:33:6b:19:73:
//                     1d:9d:9e:d0:39:76:bf:a5:84:09:a6:fd:6e:6d:e9:
//                     dc:8f:36:4e:e9:88:02:bd:9f:f4:e8:44:fd:4c:f5:
//                     9a:02:56:6a:47:2a:63:6c:58:45:cc:7c:66:24:dc:
//                     79:79:c3:2a:a4:b2:8b:a0:f7:a2:b5:cd:06:7e:db:
//                     be:ec:0c:86:f2:0d:24:60:74:84:ca:29:23:84:02:
//                     d8:a7:ed:3b:f1:ec:26:47:54:e3:b1:2d:e6:64:0f:
//                     f6:72:c5:e9:98:52:17:c0:fc:f2:2c:20:c8:40:f8:
//                     47:c9:32:9e:3b:97:b1:8b:f5:98:24:70:63:66:19:
//                     c1:52:e8:04:05:3d:5f:8d:bc:d8:4b:af:77:98:6f:
//                     1f:78:d1:b6:50:27:4d:e4:ec:14:69:67:1f:58:af:
//                     a9:a0:11:26:3c:94:32:07:7f:d7:e9:69:1f:ae:3f:
//                     4f:63:8a:8f:89:d6:f2:19:78:5c:21:8e:b1:b6:57:
//                     d8:c0:e1:ee:7d:6e:dd:f1:3a:0a:6a:f1:ba:ff:f9:
//                     83:2f:dc:b5:a4:20:17:63:36:ef:c8:62:19:cc:56:
//                     ce:b2:ea:31:89:4b:78:58:c1:bf:03:13:99:e0:12:
//                     f2:88:aa:9b:94:da:dd:76:79:17:1e:34:d1:0a:c4:
//                     07:45
//                 Exponent: 65537 (0x10001)
//         X509v3 extensions:
//             X509v3 Subject Key Identifier:
//                 44:4E:2A:47:58:D8:B9:48:91:F6:4F:CE:74:A9:1D:32:9A:8D:8D:E9
//             X509v3 Authority Key Identifier:
//                 keyid:44:4E:2A:47:58:D8:B9:48:91:F6:4F:CE:74:A9:1D:32:9A:8D
//                      :8D:E9
//
//             X509v3 Basic Constraints:
//                 CA:TRUE
//     Signature Algorithm: sha1WithRSAEncryption
//          3f:c8:26:a0:6e:5c:05:40:79:a1:98:a9:33:de:68:74:85:ee:
//          ae:b7:1c:33:59:b0:11:de:9f:f4:4f:d3:eb:51:09:7d:47:7e:
//          6e:51:85:f4:54:cd:83:98:25:b1:ba:b0:57:ec:93:db:12:e2:
//          ec:51:49:7a:96:73:9b:c8:96:6d:85:8c:d3:e1:3c:fa:32:e2:
//          58:0c:77:6d:87:0c:34:01:aa:30:a9:76:e0:c0:e7:db:5e:1b:
//          e9:10:30:a4:e0:09:49:26:b9:58:cd:5a:07:e5:50:75:de:9a:
//          3b:f6:53:7e:b1:53:5e:45:27:4f:17:e3:08:33:b2:50:0a:bb:
//          f4:fc:25:97:29:de:41:75:30:fa:77:38:aa:65:8a:73:4f:ea:
//          11:7b:eb:7c:17:60:27:0e:bc:3e:76:52:d8:8b:ed:1a:f8:eb:
//          37:bb:11:fd:ae:70:17:0a:fe:e0:ad:06:b3:1f:69:8a:72:04:
//          c2:c0:33:0b:d6:2f:63:4c:33:11:14:b8:62:36:88:c5:03:65:
//          01:19:a3:ef:00:bb:6f:0e:92:ff:34:1c:a1:d6:31:d0:5c:5e:
//          9f:99:7d:c7:ca:bd:7c:72:0b:f4:5c:a5:7e:6e:04:a8:d2:99:
//          2c:51:01:14:fe:a2:48:f0:7e:be:84:0d:b4:d3:e2:f3:0e:7d:
//          de:8b:f5:33
const unsigned char kEurekaRootCaDer[] = {
    0x30, 0x82, 0x03, 0xc3, 0x30, 0x82, 0x02, 0xab, 0xa0, 0x03, 0x02, 0x01,
    0x02, 0x02, 0x01, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
    0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x7c, 0x31, 0x0b, 0x30,
    0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x13,
    0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c, 0x0a, 0x43, 0x61, 0x6c,
    0x69, 0x66, 0x6f, 0x72, 0x6e, 0x69, 0x61, 0x31, 0x16, 0x30, 0x14, 0x06,
    0x03, 0x55, 0x04, 0x07, 0x0c, 0x0d, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x61,
    0x69, 0x6e, 0x20, 0x56, 0x69, 0x65, 0x77, 0x31, 0x13, 0x30, 0x11, 0x06,
    0x03, 0x55, 0x04, 0x0a, 0x0c, 0x0a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
    0x20, 0x49, 0x6e, 0x63, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04,
    0x0b, 0x0c, 0x09, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x20, 0x54, 0x56,
    0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0e, 0x45,
    0x75, 0x72, 0x65, 0x6b, 0x61, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43,
    0x41, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x32, 0x31, 0x32, 0x31, 0x37, 0x32,
    0x32, 0x33, 0x39, 0x33, 0x33, 0x5a, 0x17, 0x0d, 0x33, 0x32, 0x31, 0x32,
    0x31, 0x32, 0x32, 0x32, 0x33, 0x39, 0x33, 0x33, 0x5a, 0x30, 0x7c, 0x31,
    0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
    0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0c, 0x0a, 0x43,
    0x61, 0x6c, 0x69, 0x66, 0x6f, 0x72, 0x6e, 0x69, 0x61, 0x31, 0x16, 0x30,
    0x14, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x0d, 0x4d, 0x6f, 0x75, 0x6e,
    0x74, 0x61, 0x69, 0x6e, 0x20, 0x56, 0x69, 0x65, 0x77, 0x31, 0x13, 0x30,
    0x11, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x0a, 0x47, 0x6f, 0x6f, 0x67,
    0x6c, 0x65, 0x20, 0x49, 0x6e, 0x63, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03,
    0x55, 0x04, 0x0b, 0x0c, 0x09, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x20,
    0x54, 0x56, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c,
    0x0e, 0x45, 0x75, 0x72, 0x65, 0x6b, 0x61, 0x20, 0x52, 0x6f, 0x6f, 0x74,
    0x20, 0x43, 0x41, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a,
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82,
    0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00,
    0xb9, 0x11, 0xd0, 0xea, 0x12, 0xdc, 0x32, 0xe1, 0xdf, 0x5c, 0x33, 0x6b,
    0x19, 0x73, 0x1d, 0x9d, 0x9e, 0xd0, 0x39, 0x76, 0xbf, 0xa5, 0x84, 0x09,
    0xa6, 0xfd, 0x6e, 0x6d, 0xe9, 0xdc, 0x8f, 0x36, 0x4e, 0xe9, 0x88, 0x02,
    0xbd, 0x9f, 0xf4, 0xe8, 0x44, 0xfd, 0x4c, 0xf5, 0x9a, 0x02, 0x56, 0x6a,
    0x47, 0x2a, 0x63, 0x6c, 0x58, 0x45, 0xcc, 0x7c, 0x66, 0x24, 0xdc, 0x79,
    0x79, 0xc3, 0x2a, 0xa4, 0xb2, 0x8b, 0xa0, 0xf7, 0xa2, 0xb5, 0xcd, 0x06,
    0x7e, 0xdb, 0xbe, 0xec, 0x0c, 0x86, 0xf2, 0x0d, 0x24, 0x60, 0x74, 0x84,
    0xca, 0x29, 0x23, 0x84, 0x02, 0xd8, 0xa7, 0xed, 0x3b, 0xf1, 0xec, 0x26,
    0x47, 0x54, 0xe3, 0xb1, 0x2d, 0xe6, 0x64, 0x0f, 0xf6, 0x72, 0xc5, 0xe9,
    0x98, 0x52, 0x17, 0xc0, 0xfc, 0xf2, 0x2c, 0x20, 0xc8, 0x40, 0xf8, 0x47,
    0xc9, 0x32, 0x9e, 0x3b, 0x97, 0xb1, 0x8b, 0xf5, 0x98, 0x24, 0x70, 0x63,
    0x66, 0x19, 0xc1, 0x52, 0xe8, 0x04, 0x05, 0x3d, 0x5f, 0x8d, 0xbc, 0xd8,
    0x4b, 0xaf, 0x77, 0x98, 0x6f, 0x1f, 0x78, 0xd1, 0xb6, 0x50, 0x27, 0x4d,
    0xe4, 0xec, 0x14, 0x69, 0x67, 0x1f, 0x58, 0xaf, 0xa9, 0xa0, 0x11, 0x26,
    0x3c, 0x94, 0x32, 0x07, 0x7f, 0xd7, 0xe9, 0x69, 0x1f, 0xae, 0x3f, 0x4f,
    0x63, 0x8a, 0x8f, 0x89, 0xd6, 0xf2, 0x19, 0x78, 0x5c, 0x21, 0x8e, 0xb1,
    0xb6, 0x57, 0xd8, 0xc0, 0xe1, 0xee, 0x7d, 0x6e, 0xdd, 0xf1, 0x3a, 0x0a,
    0x6a, 0xf1, 0xba, 0xff, 0xf9, 0x83, 0x2f, 0xdc, 0xb5, 0xa4, 0x20, 0x17,
    0x63, 0x36, 0xef, 0xc8, 0x62, 0x19, 0xcc, 0x56, 0xce, 0xb2, 0xea, 0x31,
    0x89, 0x4b, 0x78, 0x58, 0xc1, 0xbf, 0x03, 0x13, 0x99, 0xe0, 0x12, 0xf2,
    0x88, 0xaa, 0x9b, 0x94, 0xda, 0xdd, 0x76, 0x79, 0x17, 0x1e, 0x34, 0xd1,
    0x0a, 0xc4, 0x07, 0x45, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x50, 0x30,
    0x4e, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14,
    0x44, 0x4e, 0x2a, 0x47, 0x58, 0xd8, 0xb9, 0x48, 0x91, 0xf6, 0x4f, 0xce,
    0x74, 0xa9, 0x1d, 0x32, 0x9a, 0x8d, 0x8d, 0xe9, 0x30, 0x1f, 0x06, 0x03,
    0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x44, 0x4e, 0x2a,
    0x47, 0x58, 0xd8, 0xb9, 0x48, 0x91, 0xf6, 0x4f, 0xce, 0x74, 0xa9, 0x1d,
    0x32, 0x9a, 0x8d, 0x8d, 0xe9, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d, 0x13,
    0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0d, 0x06, 0x09, 0x2a,
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82,
    0x01, 0x01, 0x00, 0x3f, 0xc8, 0x26, 0xa0, 0x6e, 0x5c, 0x05, 0x40, 0x79,
    0xa1, 0x98, 0xa9, 0x33, 0xde, 0x68, 0x74, 0x85, 0xee, 0xae, 0xb7, 0x1c,
    0x33, 0x59, 0xb0, 0x11, 0xde, 0x9f, 0xf4, 0x4f, 0xd3, 0xeb, 0x51, 0x09,
    0x7d, 0x47, 0x7e, 0x6e, 0x51, 0x85, 0xf4, 0x54, 0xcd, 0x83, 0x98, 0x25,
    0xb1, 0xba, 0xb0, 0x57, 0xec, 0x93, 0xdb, 0x12, 0xe2, 0xec, 0x51, 0x49,
    0x7a, 0x96, 0x73, 0x9b, 0xc8, 0x96, 0x6d, 0x85, 0x8c, 0xd3, 0xe1, 0x3c,
    0xfa, 0x32, 0xe2, 0x58, 0x0c, 0x77, 0x6d, 0x87, 0x0c, 0x34, 0x01, 0xaa,
    0x30, 0xa9, 0x76, 0xe0, 0xc0, 0xe7, 0xdb, 0x5e, 0x1b, 0xe9, 0x10, 0x30,
    0xa4, 0xe0, 0x09, 0x49, 0x26, 0xb9, 0x58, 0xcd, 0x5a, 0x07, 0xe5, 0x50,
    0x75, 0xde, 0x9a, 0x3b, 0xf6, 0x53, 0x7e, 0xb1, 0x53, 0x5e, 0x45, 0x27,
    0x4f, 0x17, 0xe3, 0x08, 0x33, 0xb2, 0x50, 0x0a, 0xbb, 0xf4, 0xfc, 0x25,
    0x97, 0x29, 0xde, 0x41, 0x75, 0x30, 0xfa, 0x77, 0x38, 0xaa, 0x65, 0x8a,
    0x73, 0x4f, 0xea, 0x11, 0x7b, 0xeb, 0x7c, 0x17, 0x60, 0x27, 0x0e, 0xbc,
    0x3e, 0x76, 0x52, 0xd8, 0x8b, 0xed, 0x1a, 0xf8, 0xeb, 0x37, 0xbb, 0x11,
    0xfd, 0xae, 0x70, 0x17, 0x0a, 0xfe, 0xe0, 0xad, 0x06, 0xb3, 0x1f, 0x69,
    0x8a, 0x72, 0x04, 0xc2, 0xc0, 0x33, 0x0b, 0xd6, 0x2f, 0x63, 0x4c, 0x33,
    0x11, 0x14, 0xb8, 0x62, 0x36, 0x88, 0xc5, 0x03, 0x65, 0x01, 0x19, 0xa3,
    0xef, 0x00, 0xbb, 0x6f, 0x0e, 0x92, 0xff, 0x34, 0x1c, 0xa1, 0xd6, 0x31,
    0xd0, 0x5c, 0x5e, 0x9f, 0x99, 0x7d, 0xc7, 0xca, 0xbd, 0x7c, 0x72, 0x0b,
    0xf4, 0x5c, 0xa5, 0x7e, 0x6e, 0x04, 0xa8, 0xd2, 0x99, 0x2c, 0x51, 0x01,
    0x14, 0xfe, 0xa2, 0x48, 0xf0, 0x7e, 0xbe, 0x84, 0x0d, 0xb4, 0xd3, 0xe2,
    0xf3, 0x0e, 0x7d, 0xde, 0x8b, 0xf5, 0x33};

#endif  // CAST_COMMON_CERTIFICATE_EUREKA_ROOT_CA_DER_INC_H_
