#!/usr/bin/env python3
#
# MIT - (c) 2016 ThomasTJ (TTJ)
# Module for WMDframe


import os
try:
    import core.core as core
    import core.commands as comm
    import core.modules as cmodules
    from core.colors import bc as bc
except:
    import sys
    sys.path.append('././')
    import core.core as core
    import core.commands as comm
    import core.modules as cmodules
    from core.colors import bc as bc


# START Log files, global variables, etc.
config = core.config()
global exploitdb
EXPLOITDB_SYM = (config['TOOLS']['EXPLOITDB_SYM'])
EXPLOITDB_GITNAME = (config['TOOLS']['EXPLOITDB_GITNAME'])
EXPLOITDB_GITRUN = (config['TOOLS']['EXPLOITDB_GITRUN'])
# END Log files, global variables, etc.


# OPTIONS
class options():
    Author = 'Thomas TJ (TTJ)'
    Name = 'Exploitdb'
    Call = 'exploitdb'
    Modulename = 'gitexploitdb'
    Category = 'exploit'
    Type = 'search'  # sin = single action/program, aut = multiple programs combined for attack
    Version = '0.1'
    License = 'MIT'
    Description = 'Shell-style script to search exploit-db.com exploits. (Arthur: mattoufoutu)'
    Datecreation = '2017/01/01'
    Lastmodified = '2017/01/01'

    def __init__(self):
        self.show_all()

    # Show options
    def show_opt(self):
        print('\t' + bc.OKBLUE + 'Options are only available after the command "run"' + bc.ENDC)
        print('\tSEARCH: search description:windows')
        print('\tSEARCH: search description:"windows XP"')
        print('\tUPDATE: updatedb')
        print('\tINFO  : info 8140')
        print('')

    # Show commands
    def show_commands(self):
        print(
            ''
            + '\n\t' + bc.OKBLUE + 'COMMANDS:' + bc.ENDC
            + '\n\t' + '---------'
            + '\n\t' + ('%-*s ->\t%s' % (9, 'run', 'Run the script'))
            + '\n\t' + ('%-*s ->\t%s' % (9, 'help', 'Help'))
            + '\n\t' + ('%-*s ->\t%s' % (9, 'so', 'Show options'))
            + '\n\t' + ('%-*s ->\t%s' % (9, 'sa', 'Show module info'))
            + '\n\t' + ('%-*s ->\t%s' % (9, 'invoke', 'Invoke module'))
            + '\n\t' + ('%-*s ->\t%s' % (9, 'exit', 'Exit'))
            + '\n'
            )

    # Show all info
    def show_all(self):
        cmodules.showModuleData(
            options.Author,
            options.Name,
            options.Call,
            options.Category,
            options.Type,
            options.Version,
            options.Description,
            options.License,
            options.Datecreation,
            options.Lastmodified
            )
        self.show_commands()
        self.show_opt()
# END OPTIONS


def run():
    print('\t-> For exit push "Ctrl+c" continous')
    abspath = os.path.abspath(__file__)
    dname = os.path.dirname(abspath)
    os.chdir('tools/exploitdb')
    os.system('python3 ' + exploitdb)
    os.chdir(dname)


def helpMe():
    """ SEARCH:
        The search command allows you to search for a given pattern in any field of the original exploit-db's CSV file.
        The search query must be in the form of field_name:pattern couples, if no field name is given, description is the default.

        SEARCHFIELDS:
        Available fields are:
            id - the internal exploit's ID
            file - the path where the exploit file can be found
            description - informations about exploit and targetted software
            date - the date the exploit was released
            author - well, self-explanatory, huh?
            platform - the platform type the exploit runs on
            type - exploit classification, possible values are:
            local
            shellcode
            dos
            remote
            webapps

        If the pattern you want to search contains spaces, you can quote it using either single or double quotes.

        INFO:
        To show all the available details about an exploit, use the info command.
        This command takes a single argument, which is the ID of the exploit you want details for.

        UPDATING DB:
        Running the updatedb command will download the latest exploits archive from exploit-db.com
        and extract it in an exploits folder in current directory."""


# CONSOLE
def console():
    value = input('   -> ' + bc.FAIL + 'wmd' + bc.ENDC + '@' + bc.FAIL + 'exploitdb:' + bc.ENDC + ' ')
    userinput = value.split()
    if 'so' in userinput[:1]:
        sop.show_opt()
    elif 'sa' in userinput[:1]:
        sop.show_all()
    elif 'run' in userinput[:1]:
        run()
    elif 'help' in userinput[:1]:
        helpMe()
    elif 'invoke' in userinput[:1]:
        comm.invokeModule(options.Call)
        return None
    elif 'back' in userinput[:1] or 'exit' in userinput[:1]:
        return None
    else:
        command = str(userinput[:1]).strip('[]\'')
        print(bc.WARN + '\n    Error, no options for: ' + command + '\n' + bc.ENDC)
    console()
# END console


def main():
    print('\n')
    print('     ____           __     _ __   ___  ___   ')
    print('    / __/_ __ ___  / /__  (_) /_ / _ \/ _ )  ')
    print('   / _/ \ \ // _ \/ / _ \/ / __// // / _  |  ')
    print('  /___//_\_\/ .__/_/\___/_/\__//____/____/   ')
    print('           /_/                              ')
    print('\n')
    print('\t' + bc.OKBLUE + 'CHECKING REQUIREMENTS' + bc.ENDC)
    global exploitdb
    exploitdb = comm.checkInstalledFull(EXPLOITDB_SYM, EXPLOITDB_GITNAME, EXPLOITDB_GITRUN)
    print('')
    global sop
    sop = options()
    console()
