/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import java.time.Instant;
import java.time.ZoneOffset;
import org.sleuthkit.caseuco.CyberItem;
import org.sleuthkit.caseuco.Facet;

class Message
extends Facet {
    private String messageText;
    private String application;
    private String sentTime;
    private String messageType;

    Message() {
        super(Message.class.getSimpleName());
    }

    Message setMessageText(String messageText) {
        this.messageText = messageText;
        return this;
    }

    Message setApplication(CyberItem application) {
        this.application = application.getId();
        return this;
    }

    Message setSentTime(Long sentTime) {
        if (sentTime != null) {
            this.sentTime = Instant.ofEpochSecond(sentTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    Message setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    @Override
    Message setId(String id) {
        super.setId("_:" + id);
        return this;
    }

    String getMessageText() {
        return this.messageText;
    }

    String getApplication() {
        return this.application;
    }

    String getSentTime() {
        return this.sentTime;
    }

    String getMessageType() {
        return this.messageType;
    }
}

