/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.sleuthkit.caseuco.Account;
import org.sleuthkit.caseuco.AccountAuthentication;
import org.sleuthkit.caseuco.Action;
import org.sleuthkit.caseuco.ActionArgument;
import org.sleuthkit.caseuco.Annotation;
import org.sleuthkit.caseuco.Application;
import org.sleuthkit.caseuco.ApplicationAccount;
import org.sleuthkit.caseuco.Assertion;
import org.sleuthkit.caseuco.Attachment;
import org.sleuthkit.caseuco.BlankAssertionNode;
import org.sleuthkit.caseuco.BlankIdentityNode;
import org.sleuthkit.caseuco.BlankLocationNode;
import org.sleuthkit.caseuco.BlankOrganizationNode;
import org.sleuthkit.caseuco.BlankPersonNode;
import org.sleuthkit.caseuco.BlankRelationshipNode;
import org.sleuthkit.caseuco.BlankTraceNode;
import org.sleuthkit.caseuco.BrowserBookmark;
import org.sleuthkit.caseuco.BrowserCookie;
import org.sleuthkit.caseuco.CalendarEntry;
import org.sleuthkit.caseuco.CaseUcoUUIDService;
import org.sleuthkit.caseuco.CaseUcoUUIDServiceImpl;
import org.sleuthkit.caseuco.ComputerSpecification;
import org.sleuthkit.caseuco.Contact;
import org.sleuthkit.caseuco.ContentData;
import org.sleuthkit.caseuco.ContentNotExportableException;
import org.sleuthkit.caseuco.Device;
import org.sleuthkit.caseuco.DigitalAccount;
import org.sleuthkit.caseuco.Domain;
import org.sleuthkit.caseuco.DomainName;
import org.sleuthkit.caseuco.EmailAddress;
import org.sleuthkit.caseuco.EmailMessage;
import org.sleuthkit.caseuco.EnvironmentVariable;
import org.sleuthkit.caseuco.ExtractedString;
import org.sleuthkit.caseuco.File;
import org.sleuthkit.caseuco.FileSystem;
import org.sleuthkit.caseuco.HTTPConnection;
import org.sleuthkit.caseuco.Hash;
import org.sleuthkit.caseuco.IdentityFacet;
import org.sleuthkit.caseuco.LatLongCoordinates;
import org.sleuthkit.caseuco.MACAddress;
import org.sleuthkit.caseuco.Message;
import org.sleuthkit.caseuco.MobileDevice;
import org.sleuthkit.caseuco.Note;
import org.sleuthkit.caseuco.OperatingSystem;
import org.sleuthkit.caseuco.PathRelation;
import org.sleuthkit.caseuco.PhoneAccount;
import org.sleuthkit.caseuco.PhoneCall;
import org.sleuthkit.caseuco.SIMCard;
import org.sleuthkit.caseuco.SMSMessage;
import org.sleuthkit.caseuco.SimpleAddress;
import org.sleuthkit.caseuco.Software;
import org.sleuthkit.caseuco.StandardAttributeTypes;
import org.sleuthkit.caseuco.Trace;
import org.sleuthkit.caseuco.URL;
import org.sleuthkit.caseuco.UcoObject;
import org.sleuthkit.caseuco.Volume;
import org.sleuthkit.caseuco.WindowsAccount;
import org.sleuthkit.caseuco.WindowsComputerSpecification;
import org.sleuthkit.caseuco.WindowsRegistryValue;
import org.sleuthkit.caseuco.WirelessNetworkConnection;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentTag;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.Pool;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TimelineEventType;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.VolumeSystem;
import org.sleuthkit.datamodel.blackboardutils.attributes.BlackboardJsonAttrUtil;
import org.sleuthkit.datamodel.blackboardutils.attributes.GeoTrackPoints;
import org.sleuthkit.datamodel.blackboardutils.attributes.MessageAttachments;

public class CaseUcoExporter {
    private static final String INCLUDE_PARENT_CHILD_RELATIONSHIPS_PROP = "exporter.relationships.includeParentChild";
    private static final String DEFAULT_PARENT_CHILD_RELATIONSHIPS_VALUE = "true";
    private final Gson gson;
    private final SleuthkitCase sleuthkitCase;
    private CaseUcoUUIDService uuidService;
    private Properties props;

    public CaseUcoExporter(SleuthkitCase sleuthkitCase) {
        this(sleuthkitCase, new Properties());
    }

    public CaseUcoExporter(SleuthkitCase sleuthkitCase, Properties props) {
        this.sleuthkitCase = sleuthkitCase;
        this.props = props;
        this.setUUIDService(new CaseUcoUUIDServiceImpl(sleuthkitCase));
        this.gson = new Gson();
    }

    public final CaseUcoExporter setUUIDService(CaseUcoUUIDService uuidService) {
        this.uuidService = uuidService;
        return this;
    }

    public List<JsonElement> exportSleuthkitCase() throws TskCoreException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        String caseDirPath = this.sleuthkitCase.getDbDirPath().replaceAll("\\\\", "/");
        Trace export = new Trace(this.uuidService.createUUID(this.sleuthkitCase));
        if (this.sleuthkitCase.getDatabaseType().equals((Object)TskData.DbType.POSTGRESQL)) {
            export.addBundle(new File().setFilePath(caseDirPath).setIsDirectory(true));
        } else {
            export.addBundle(new File().setFilePath(caseDirPath + "/" + this.sleuthkitCase.getDatabaseName()).setIsDirectory(false));
        }
        this.addToOutput(export, output);
        return output;
    }

    public List<JsonElement> exportAbstractFile(AbstractFile file) throws TskCoreException {
        return this.exportAbstractFile(file, null);
    }

    public List<JsonElement> exportAbstractFile(AbstractFile file, String localPath) throws TskCoreException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        ContentData contentData = new ContentData().setMimeType(file.getMIMEType()).setSizeInBytes(file.getSize()).setMd5Hash(file.getMd5Hash());
        if (localPath != null) {
            Trace localPathTrace = new BlankTraceNode().addBundle(new URL().setFullValue(localPath));
            contentData.setDataPayloadReferenceUrl(localPathTrace);
            this.addToOutput(localPathTrace, output);
        }
        File fileExport = new File().setAccessedTime(file.getAtime()).setExtension(file.getNameExtension()).setFileName(file.getName()).setFilePath(file.getUniquePath()).setIsDirectory(file.isDir()).setSizeInBytes(file.getSize());
        fileExport.setModifiedTime(file.getMtime());
        fileExport.setCreatedTime(file.getCrtime());
        Trace export = new Trace(this.uuidService.createUUID((Content)file)).addBundle(contentData).addBundle(fileExport);
        this.addToOutput(export, output);
        this.addParentChildRelationship(output, export.getId(), this.uuidService.createUUID(file.getDataSource()));
        return output;
    }

    public List<JsonElement> exportContentTag(ContentTag contentTag) throws TskCoreException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        Annotation annotation = new Annotation(this.uuidService.createUUID(contentTag)).addObject(this.uuidService.createUUID(contentTag.getContent()));
        annotation.setDescription(contentTag.getComment());
        annotation.addTag(contentTag.getName().getDisplayName());
        this.addToOutput(annotation, output);
        return output;
    }

    public List<JsonElement> exportDataSource(DataSource dataSource) throws TskCoreException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        Trace export = new Trace(this.uuidService.createUUID((Content)dataSource)).addBundle(new File().setFilePath(this.getDataSourcePath(dataSource))).addBundle(new ContentData().setSizeInBytes(dataSource.getSize()));
        this.addToOutput(export, output);
        this.addParentChildRelationship(output, export.getId(), this.uuidService.createUUID(this.sleuthkitCase));
        return output;
    }

    String getDataSourcePath(DataSource dataSource) {
        String dataSourcePath = "";
        if (dataSource instanceof Image) {
            String[] paths = ((Image)dataSource).getPaths();
            if (paths.length > 0) {
                dataSourcePath = paths[0];
            }
        } else {
            dataSourcePath = dataSource.getName();
        }
        dataSourcePath = dataSourcePath.replaceAll("\\\\", "/");
        return dataSourcePath;
    }

    public List<JsonElement> exportFileSystem(org.sleuthkit.datamodel.FileSystem fileSystem) throws TskCoreException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        Trace export = new Trace(this.uuidService.createUUID((Content)fileSystem)).addBundle(new FileSystem().setFileSystemType(fileSystem.getFsType()).setCluserSize(fileSystem.getBlock_size()));
        this.addToOutput(export, output);
        this.addParentChildRelationship(output, export.getId(), this.uuidService.createUUID(fileSystem.getParent()));
        return output;
    }

    public List<JsonElement> exportPool(Pool pool) throws TskCoreException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        Trace export = new Trace(this.uuidService.createUUID((Content)pool)).addBundle(new ContentData().setSizeInBytes(pool.getSize()));
        this.addToOutput(export, output);
        this.addParentChildRelationship(output, export.getId(), this.uuidService.createUUID(pool.getParent()));
        return output;
    }

    public List<JsonElement> exportVolume(org.sleuthkit.datamodel.Volume volume) throws TskCoreException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        Trace export = new Trace(this.uuidService.createUUID((Content)volume));
        Volume volumeFacet = new Volume();
        if (volume.getLength() > 0L) {
            volumeFacet.setSectorSize(volume.getSize() / volume.getLength());
        }
        export.addBundle(volumeFacet).addBundle(new ContentData().setSizeInBytes(volume.getSize()));
        this.addToOutput(export, output);
        this.addParentChildRelationship(output, export.getId(), this.uuidService.createUUID(volume.getParent()));
        return output;
    }

    public List<JsonElement> exportVolumeSystem(VolumeSystem volumeSystem) throws TskCoreException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        Trace export = new Trace(this.uuidService.createUUID((Content)volumeSystem)).addBundle(new ContentData().setSizeInBytes(volumeSystem.getSize()));
        this.addToOutput(export, output);
        this.addParentChildRelationship(output, export.getId(), this.uuidService.createUUID(volumeSystem.getParent()));
        return output;
    }

    public List<JsonElement> exportBlackboardArtifact(BlackboardArtifact artifact) throws TskCoreException, ContentNotExportableException, BlackboardJsonAttrUtil.InvalidJsonException {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        String uuid = this.uuidService.createUUID((Content)artifact);
        int artifactTypeId = artifact.getArtifactTypeID();
        if (BlackboardArtifact.ARTIFACT_TYPE.TSK_GEN_INFO.getTypeID() == artifactTypeId) {
            this.assembleGenInfo(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_BOOKMARK.getTypeID() == artifactTypeId) {
            this.assembleWebBookmark(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_COOKIE.getTypeID() == artifactTypeId) {
            this.assembleWebCookie(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_HISTORY.getTypeID() == artifactTypeId) {
            this.assembleWebHistory(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_DOWNLOAD.getTypeID() == artifactTypeId) {
            this.assembleWebDownload(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_RECENT_OBJECT.getTypeID() == artifactTypeId) {
            this.assembleRecentObject(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_INSTALLED_PROG.getTypeID() == artifactTypeId) {
            this.assembleInstalledProg(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_HASHSET_HIT.getTypeID() == artifactTypeId) {
            this.assembleHashsetHit(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_DEVICE_ATTACHED.getTypeID() == artifactTypeId) {
            this.assembleDeviceAttached(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_EMAIL_MSG.getTypeID() == artifactTypeId) {
            this.assembleEmailMessage(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_EXTRACTED_TEXT.getTypeID() == artifactTypeId) {
            this.assembleExtractedText(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_SEARCH_QUERY.getTypeID() == artifactTypeId) {
            this.assembleWebSearchQuery(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_METADATA_EXIF.getTypeID() == artifactTypeId) {
            this.assembleMetadataExif(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_OS_INFO.getTypeID() == artifactTypeId) {
            this.assembleOsInfo(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_OS_ACCOUNT.getTypeID() == artifactTypeId) {
            this.assembleOsAccount(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_SERVICE_ACCOUNT.getTypeID() == artifactTypeId) {
            this.assembleServiceAccount(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_CONTACT.getTypeID() == artifactTypeId) {
            this.assembleContact(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_MESSAGE.getTypeID() == artifactTypeId) {
            this.assembleMessage(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_CALLLOG.getTypeID() == artifactTypeId) {
            this.assembleCallog(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_CALENDAR_ENTRY.getTypeID() == artifactTypeId) {
            this.assembleCalendarEntry(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_SPEED_DIAL_ENTRY.getTypeID() == artifactTypeId) {
            this.assembleSpeedDialEntry(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_BLUETOOTH_PAIRING.getTypeID() == artifactTypeId) {
            this.assembleBluetoothPairing(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_BOOKMARK.getTypeID() == artifactTypeId) {
            this.assembleGpsBookmark(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_LAST_KNOWN_LOCATION.getTypeID() == artifactTypeId) {
            this.assembleGpsLastKnownLocation(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_SEARCH.getTypeID() == artifactTypeId) {
            this.assembleGpsSearch(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_PROG_RUN.getTypeID() == artifactTypeId) {
            this.assembleProgRun(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_ENCRYPTION_DETECTED.getTypeID() == artifactTypeId) {
            this.assembleEncryptionDetected(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_INTERESTING_FILE_HIT.getTypeID() == artifactTypeId || BlackboardArtifact.ARTIFACT_TYPE.TSK_INTERESTING_ARTIFACT_HIT.getTypeID() == artifactTypeId || BlackboardArtifact.ARTIFACT_TYPE.TSK_INTERESTING_ITEM.getTypeID() == artifactTypeId) {
            this.assembleInterestingItem(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_ROUTE.getTypeID() == artifactTypeId) {
            this.assembleGPSRoute(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_REMOTE_DRIVE.getTypeID() == artifactTypeId) {
            this.assembleRemoteDrive(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_ACCOUNT.getTypeID() == artifactTypeId) {
            this.assembleAccount(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_ENCRYPTION_SUSPECTED.getTypeID() == artifactTypeId) {
            this.assembleEncryptionSuspected(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_OBJECT_DETECTED.getTypeID() == artifactTypeId) {
            this.assembleObjectDetected(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WIFI_NETWORK.getTypeID() == artifactTypeId) {
            this.assembleWifiNetwork(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_DEVICE_INFO.getTypeID() == artifactTypeId) {
            this.assembleDeviceInfo(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_SIM_ATTACHED.getTypeID() == artifactTypeId) {
            this.assembleSimAttached(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_BLUETOOTH_ADAPTER.getTypeID() == artifactTypeId) {
            this.assembleBluetoothAdapter(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WIFI_NETWORK_ADAPTER.getTypeID() == artifactTypeId) {
            this.assembleWifiNetworkAdapter(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_VERIFICATION_FAILED.getTypeID() == artifactTypeId) {
            this.assembleVerificationFailed(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_DATA_SOURCE_USAGE.getTypeID() == artifactTypeId) {
            this.assembleDataSourceUsage(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_FORM_ADDRESS.getTypeID() == artifactTypeId) {
            this.assembleWebFormAddress(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_CACHE.getTypeID() == artifactTypeId) {
            this.assembleWebCache(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_TL_EVENT.getTypeID() == artifactTypeId) {
            this.assembleTimelineEvent(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_CLIPBOARD_CONTENT.getTypeID() == artifactTypeId) {
            this.assembleClipboardContent(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_ASSOCIATED_OBJECT.getTypeID() == artifactTypeId) {
            this.assembleAssociatedObject(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_USER_CONTENT_SUSPECTED.getTypeID() == artifactTypeId) {
            this.assembleUserContentSuspected(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_METADATA.getTypeID() == artifactTypeId) {
            this.assembleMetadata(uuid, artifact, output);
        } else if (BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_TRACK.getTypeID() == artifactTypeId) {
            this.assembleGpsTrack(uuid, artifact, output);
        }
        if (output.isEmpty()) {
            throw new ContentNotExportableException(String.format("Artifact [id:%d, type:%d] is either not supported or did not have any exported attributes.", artifact.getId(), artifactTypeId));
        }
        this.addParentChildRelationship(output, uuid, this.uuidService.createUUID(artifact.getParent()));
        return output;
    }

    private void assembleWebCookie(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new URL().setFullValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_URL))).addBundle(new ContentData().setDataPayload(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_VALUE)));
        Trace cookieDomainNode = new BlankTraceNode().addBundle(new DomainName().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DOMAIN)));
        Trace applicationNode = new BlankTraceNode().addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        BrowserCookie cookie = new BrowserCookie().setCookieName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME)).setCookieDomain(cookieDomainNode).setApplication(applicationNode).setAccessedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_START)).setExpirationTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_END));
        cookie.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_CREATED));
        export.addBundle(cookie);
        this.addToOutput(export, output);
        this.addToOutput(cookieDomainNode, output);
        this.addToOutput(applicationNode, output);
    }

    private void assembleWebBookmark(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace applicationNode = new BlankTraceNode().addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        BrowserBookmark bookmark = new BrowserBookmark().setUrlTargeted(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_URL)).setApplication(applicationNode);
        bookmark.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME));
        bookmark.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_CREATED));
        Trace export = new Trace(uuid).addBundle(bookmark).addBundle(new DomainName().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DOMAIN)));
        this.addToOutput(export, output);
        this.addToOutput(applicationNode, output);
    }

    private void assembleGenInfo(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Hash hash = new Hash(uuid, this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_HASH_PHOTODNA));
        this.addToOutput(hash, output);
    }

    private void assembleWebHistory(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        BlankTraceNode userNameNode = new BlankTraceNode();
        IdentityFacet identityFacet = new IdentityFacet();
        identityFacet.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_USER_NAME));
        userNameNode.addBundle(identityFacet);
        Trace export = new Trace(uuid).addBundle(new URL().setUserName(userNameNode).setFullValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_URL))).addBundle(new DomainName().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DOMAIN))).addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        this.addToOutput(export, output);
        this.addToOutput(userNameNode, output);
    }

    private void assembleWebDownload(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new URL().setFullValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_URL))).addBundle(new DomainName().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DOMAIN))).addBundle(new File().setFilePath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PATH))).addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        this.addToOutput(export, output);
    }

    private void assembleDeviceAttached(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new Device().setManufacturer(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DEVICE_MAKE)).setModel(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DEVICE_MODEL)).setId(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DEVICE_ID))).addBundle(new MACAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_MAC_ADDRESS)));
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        this.addToOutput(export, output);
    }

    private void assembleHashsetHit(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Assertion export = new Assertion(uuid);
        export.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_SET_NAME));
        export.setStatement(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_COMMENT));
        this.addToOutput(export, output);
    }

    private void assembleInstalledProg(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new File().setFilePath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PATH_SOURCE)));
        Software software = new Software();
        software.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME));
        export.addBundle(software);
        File file = new File().setFilePath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PATH));
        file.setModifiedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        file.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_CREATED));
        export.addBundle(file);
        this.addToOutput(export, output);
    }

    private void assembleRecentObject(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        WindowsRegistryValue registryValue = new WindowsRegistryValue().setData(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_VALUE));
        registryValue.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME));
        export.addBundle(registryValue);
        File file = new File().setAccessedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_ACCESSED));
        file.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        export.addBundle(file);
        this.addToOutput(export, output);
        Assertion assertion = new BlankAssertionNode().setStatement(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_COMMENT));
        this.addToOutput(assertion, output);
        this.addToOutput(new BlankRelationshipNode().setSource(assertion.getId()).setTarget(uuid), output);
    }

    private void assembleExtractedText(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new ExtractedString().setStringValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_TEXT)));
        this.addToOutput(export, output);
    }

    private void assembleEmailMessage(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace bccNode = new BlankTraceNode().addBundle(new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_BCC)));
        Trace ccNode = new BlankTraceNode().addBundle(new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_CC)));
        Trace fromNode = new BlankTraceNode().addBundle(new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_FROM)));
        Trace headerRawNode = new BlankTraceNode().addBundle(new ExtractedString().setStringValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_HEADERS)));
        EmailMessage emailMessage = new EmailMessage();
        String html = this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_CONTENT_HTML);
        String plain = this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_CONTENT_PLAIN);
        String rtf = this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_CONTENT_RTF);
        if (html != null) {
            emailMessage.setBody(html);
            emailMessage.setContentType("text/html");
        } else if (rtf != null) {
            emailMessage.setBody(rtf);
            emailMessage.setContentType("text/rtf");
        } else if (plain != null) {
            emailMessage.setBody(plain);
            emailMessage.setContentType("text/plain");
        }
        Trace export = new Trace(uuid).addBundle(emailMessage.setReceivedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_RCVD)).setSentTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_SENT)).setBcc(bccNode).setCc(ccNode).setFrom(fromNode).setHeaderRaw(headerRawNode).setMessageID(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_MSG_ID)).setSubject(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_SUBJECT))).addBundle(new File().setFilePath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PATH)));
        this.addToOutput(export, output);
        this.addToOutput(bccNode, output);
        this.addToOutput(ccNode, output);
        this.addToOutput(fromNode, output);
        this.addToOutput(headerRawNode, output);
    }

    private void assembleWebSearchQuery(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace applicationNode = new BlankTraceNode().addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        Trace export = new Trace(uuid).addBundle(new Note().setText(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_TEXT))).addBundle(new Domain().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DOMAIN))).addBundle(new ApplicationAccount().setApplication(applicationNode));
        this.addToOutput(export, output);
        this.addToOutput(applicationNode, output);
    }

    private void assembleOsInfo(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        BlankIdentityNode registeredOwnerNode = new BlankIdentityNode();
        registeredOwnerNode.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_OWNER));
        BlankIdentityNode registeredOrganizationNode = new BlankIdentityNode();
        registeredOrganizationNode.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_ORGANIZATION));
        OperatingSystem operatingSystem = new OperatingSystem().setInstallDate(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME)).setVersion(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_VERSION));
        operatingSystem.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME));
        EnvironmentVariable envVar = new EnvironmentVariable().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_TEMP_DIR));
        envVar.setName("TEMP");
        Trace tempDirectoryNode = new BlankTraceNode().addBundle(envVar);
        Trace export = new Trace(uuid).addBundle(operatingSystem).addBundle(new DomainName().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DOMAIN))).addBundle(new Device().setSerialNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PRODUCT_ID))).addBundle(new ComputerSpecification().setHostName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME)).setProcessorArchitecture(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROCESSOR_ARCHITECTURE))).addBundle(new WindowsComputerSpecification().setRegisteredOrganization(registeredOrganizationNode).setRegisteredOwner(registeredOwnerNode).setWindowsTempDirectory(tempDirectoryNode));
        this.addToOutput(export, output);
        this.addToOutput(registeredOwnerNode, output);
        this.addToOutput(registeredOrganizationNode, output);
        this.addToOutput(tempDirectoryNode, output);
    }

    private void assembleOsAccount(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL))).addBundle(new PathRelation().setPath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PATH))).addBundle(new WindowsAccount().setGroups(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_GROUPS)));
        export.setTag(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_FLAG));
        DigitalAccount digitalAccount = new DigitalAccount().setDisplayName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DISPLAY_NAME)).setLastLoginTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_ACCESSED));
        digitalAccount.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DESCRIPTION));
        export.addBundle(digitalAccount);
        BlankIdentityNode ownerNode = new BlankIdentityNode();
        ownerNode.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME));
        Account account = new Account().setAccountType(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_ACCOUNT_TYPE)).setOwner(ownerNode).setAccountIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_USER_ID));
        account.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_CREATED));
        export.addBundle(account);
        this.addToOutput(export, output);
        this.addToOutput(ownerNode, output);
    }

    private void assembleServiceAccount(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace inReplyToNode = new BlankTraceNode().addBundle(new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_REPLYTO)));
        Trace export = new Trace(uuid).addBundle(new Account().setAccountType(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_CATEGORY))).addBundle(new DomainName().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DOMAIN))).addBundle(new EmailMessage().setInReplyTo(inReplyToNode)).addBundle(new DigitalAccount().setDisplayName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME))).addBundle(new AccountAuthentication().setPassword(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PASSWORD))).addBundle(new PathRelation().setPath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PATH))).addBundle(new URL().setFullValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_URL))).addBundle(new DigitalAccount().setDisplayName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_USER_NAME)));
        export.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DESCRIPTION));
        Trace applicationNode = new BlankTraceNode().addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        ApplicationAccount account = new ApplicationAccount().setApplication(applicationNode);
        account.setId(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_USER_ID));
        account.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_CREATED));
        export.addBundle(account);
        this.addToOutput(export, output);
        this.addToOutput(applicationNode, output);
        this.addToOutput(inReplyToNode, output);
    }

    private void assembleContact(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        EmailAddress homeAddress = new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_HOME));
        homeAddress.setTag("Home");
        EmailAddress workAddress = new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_OFFICE));
        workAddress.setTag("Work");
        PhoneAccount homePhone = new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER_HOME));
        homePhone.setTag("Home");
        PhoneAccount workPhone = new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER_OFFICE));
        workPhone.setTag("Work");
        PhoneAccount mobilePhone = new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER_MOBILE));
        mobilePhone.setTag("Mobile");
        Trace export = new Trace(uuid).addBundle(new URL().setFullValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_URL))).addBundle(new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL))).addBundle(homeAddress).addBundle(workAddress).addBundle(new Contact().setContactName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME))).addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER))).addBundle(homePhone).addBundle(workPhone).addBundle(mobilePhone);
        this.addToOutput(export, output);
    }

    private void assembleMessage(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException, BlackboardJsonAttrUtil.InvalidJsonException {
        Trace applicationNode = new BlankTraceNode().addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_MESSAGE_TYPE)));
        Trace senderNode = new BlankTraceNode().addBundle(new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL_FROM)));
        Trace fromNode = new BlankTraceNode().addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER_FROM)));
        Trace toNode = new BlankTraceNode().addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER_TO)));
        Trace export = new Trace(uuid).addBundle(new Message().setMessageText(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_TEXT)).setApplication(applicationNode).setSentTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME)).setMessageType(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DIRECTION)).setId(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_THREAD_ID))).addBundle(new EmailMessage().setSender(senderNode)).addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER))).addBundle(new PhoneCall().setFrom(fromNode).setTo(toNode)).addBundle(new SMSMessage().setIsRead(this.getIntegerIfPresent(artifact, StandardAttributeTypes.TSK_READ_STATUS)));
        BlackboardAttribute attachments = artifact.getAttribute(StandardAttributeTypes.TSK_ATTACHMENTS);
        if (attachments != null) {
            MessageAttachments attachmentsContainer = (MessageAttachments)BlackboardJsonAttrUtil.fromAttribute((BlackboardAttribute)attachments, MessageAttachments.class);
            ArrayList tskAttachments = new ArrayList();
            tskAttachments.addAll(attachmentsContainer.getUrlAttachments());
            tskAttachments.addAll(attachmentsContainer.getFileAttachments());
            tskAttachments.forEach(tskAttachment -> export.addBundle(new Attachment().setUrl(tskAttachment.getLocation())));
        }
        this.addToOutput(export, output);
        this.addToOutput(applicationNode, output);
        this.addToOutput(senderNode, output);
        this.addToOutput(fromNode, output);
        this.addToOutput(toNode, output);
    }

    private void assembleMetadataExif(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new Device().setManufacturer(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DEVICE_MAKE)).setModel(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DEVICE_MODEL))).addBundle(new LatLongCoordinates().setAltitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_ALTITUDE)).setLatitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_LATITUDE)).setLongitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_LONGITUDE)));
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_CREATED));
        this.addToOutput(export, output);
    }

    private void assembleCallog(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace fromNode = new BlankTraceNode().addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER_FROM)));
        Trace toNode = new BlankTraceNode().addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER_TO)));
        Trace export = new Trace(uuid).addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER))).addBundle(new PhoneCall().setFrom(fromNode).setTo(toNode).setEndTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_END)).setStartTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_START)).setCallType(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DIRECTION))).addBundle(new Contact().setContactName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME)));
        this.addToOutput(export, output);
        this.addToOutput(toNode, output);
        this.addToOutput(fromNode, output);
    }

    private void assembleCalendarEntry(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid);
        CalendarEntry calendarEntry = new CalendarEntry().setStartTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_START)).setEndTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_END)).setEventType(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_CALENDAR_ENTRY_TYPE));
        calendarEntry.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DESCRIPTION));
        BlankLocationNode locationNode = new BlankLocationNode();
        locationNode.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_LOCATION));
        calendarEntry.setLocation(locationNode);
        export.addBundle(calendarEntry);
        this.addToOutput(export, output);
        this.addToOutput(locationNode, output);
    }

    private void assembleSpeedDialEntry(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new Contact().setContactName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME_PERSON))).addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER)));
        this.addToOutput(export, output);
    }

    private void assembleBluetoothPairing(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new MobileDevice().setBluetoothDeviceName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DEVICE_NAME))).addBundle(new MACAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_MAC_ADDRESS)));
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        this.addToOutput(export, output);
    }

    private void assembleGpsBookmark(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new LatLongCoordinates().setAltitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_ALTITUDE)).setLatitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_LATITUDE)).setLongitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_LONGITUDE))).addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        SimpleAddress simpleAddress = new SimpleAddress();
        simpleAddress.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_LOCATION));
        export.addBundle(simpleAddress);
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        export.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME));
        this.addToOutput(export, output);
    }

    private void assembleGpsLastKnownLocation(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new LatLongCoordinates().setAltitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_ALTITUDE)).setLatitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_LATITUDE)).setLongitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_LONGITUDE)));
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        BlankLocationNode locationNode = new BlankLocationNode();
        locationNode.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME));
        SimpleAddress simpleAddress = new SimpleAddress();
        simpleAddress.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_LOCATION));
        export.addBundle(simpleAddress);
        this.addToOutput(export, output);
        this.addToOutput(locationNode, output);
        this.addToOutput(new BlankRelationshipNode().setSource(locationNode.getId()).setTarget(export.getId()), output);
    }

    private void assembleGpsSearch(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new LatLongCoordinates().setAltitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_ALTITUDE)).setLatitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_LATITUDE)).setLongitude(this.getDoubleIfPresent(artifact, StandardAttributeTypes.TSK_GEO_LONGITUDE)));
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        BlankLocationNode locationNode = new BlankLocationNode();
        locationNode.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME));
        SimpleAddress simpleAddress = new SimpleAddress();
        simpleAddress.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_LOCATION));
        export.addBundle(simpleAddress);
        this.addToOutput(export, output);
        this.addToOutput(locationNode, output);
        this.addToOutput(new BlankRelationshipNode().setSource(locationNode.getId()).setTarget(export.getId()), output);
    }

    private void assembleProgRun(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)).setNumberOfLaunches(this.getIntegerIfPresent(artifact, StandardAttributeTypes.TSK_COUNT)));
        this.addToOutput(export, output);
    }

    private void assembleEncryptionDetected(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Assertion export = new Assertion(uuid).setStatement(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_COMMENT));
        this.addToOutput(export, output);
    }

    private void assembleInterestingItem(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Assertion export = new Assertion(uuid);
        export.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_SET_NAME));
        export.setStatement(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_COMMENT));
        Long associatedArtifactId = this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_ASSOCIATED_ARTIFACT);
        if (associatedArtifactId != null) {
            BlackboardArtifact associatedArtifact = artifact.getSleuthkitCase().getBlackboardArtifact(associatedArtifactId.longValue());
            this.addToOutput(new BlankRelationshipNode().setSource(export.getId()).setTarget(this.uuidService.createUUID((Content)associatedArtifact)), output);
        }
        this.addToOutput(export, output);
    }

    private void assembleGPSRoute(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        SimpleAddress simpleAddress = new SimpleAddress();
        simpleAddress.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_LOCATION));
        export.addBundle(simpleAddress);
        BlankLocationNode location = new BlankLocationNode();
        location.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME));
        this.addToOutput(export, output);
        this.addToOutput(location, output);
        this.addToOutput(new BlankRelationshipNode().setSource(location.getId()).setTarget(export.getId()), output);
    }

    private void assembleRemoteDrive(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new PathRelation().setPath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_REMOTE_PATH))).addBundle(new PathRelation().setPath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_LOCAL_PATH)));
        this.addToOutput(export, output);
    }

    private void assembleAccount(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Account account = new Account().setAccountType(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_ACCOUNT_TYPE)).setAccountIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_ID));
        Account creditCardAccount = new Account().setAccountIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_CARD_NUMBER));
        creditCardAccount.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_SET_NAME));
        Trace export = new Trace(uuid).addBundle(account).addBundle(creditCardAccount);
        this.addToOutput(export, output);
    }

    private void assembleEncryptionSuspected(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Assertion export = new Assertion(uuid).setStatement(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_COMMENT));
        this.addToOutput(export, output);
    }

    private void assembleObjectDetected(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Assertion export = new Assertion(uuid).setStatement(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_COMMENT));
        export.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DESCRIPTION));
        this.addToOutput(export, output);
    }

    private void assembleWifiNetwork(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        WirelessNetworkConnection wirelessNetwork = new WirelessNetworkConnection().setSSID(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_SSID));
        wirelessNetwork.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        String networkId = this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DEVICE_ID);
        if (networkId != null) {
            wirelessNetwork.setId("_:" + networkId);
        }
        Trace export = new Trace(uuid).addBundle(wirelessNetwork);
        this.addToOutput(export, output);
    }

    private void assembleDeviceInfo(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new MobileDevice().setIMEI(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_IMEI))).addBundle(new SIMCard().setICCID(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_ICCID)).setIMSI(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_IMSI)));
        this.addToOutput(export, output);
    }

    private void assembleSimAttached(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new SIMCard().setICCID(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_ICCID)).setIMSI(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_IMSI)));
        this.addToOutput(export, output);
    }

    private void assembleBluetoothAdapter(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new MACAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_MAC_ADDRESS)));
        this.addToOutput(export, output);
    }

    private void assembleWifiNetworkAdapter(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new MACAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_MAC_ADDRESS)));
        this.addToOutput(export, output);
    }

    private void assembleVerificationFailed(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Assertion export = new Assertion(uuid);
        export.setStatement(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_COMMENT));
        this.addToOutput(export, output);
    }

    private void assembleDataSourceUsage(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid);
        export.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DESCRIPTION));
        this.addToOutput(export, output);
    }

    private void assembleWebFormAddress(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        SimpleAddress simpleAddress = new SimpleAddress();
        simpleAddress.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_LOCATION));
        Trace export = new Trace(uuid).addBundle(simpleAddress).addBundle(new EmailAddress().setValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_EMAIL))).addBundle(new PhoneAccount().setPhoneNumber(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PHONE_NUMBER)));
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_ACCESSED));
        export.setModifiedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_MODIFIED));
        BlankPersonNode person = new BlankPersonNode();
        person.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME_PERSON));
        this.addToOutput(export, output);
        this.addToOutput(person, output);
        this.addToOutput(new BlankRelationshipNode().setSource(person.getId()).setTarget(export.getId()), output);
    }

    private void assembleWebCache(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new PathRelation().setPath(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PATH))).addBundle(new URL().setFullValue(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_URL))).addBundle(new HTTPConnection().setHttpRequestHeader(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_HEADERS)));
        export.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_CREATED));
        this.addToOutput(export, output);
    }

    private void assembleTimelineEvent(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Optional timelineEventType;
        Action export = new Action(uuid).setStartTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME));
        export.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DESCRIPTION));
        Long eventType = this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_TL_EVENT_TYPE);
        if (eventType != null && (timelineEventType = artifact.getSleuthkitCase().getTimelineManager().getEventType(eventType.longValue())).isPresent()) {
            Trace actionArg = new BlankTraceNode().addBundle(new ActionArgument().setArgumentName(((TimelineEventType)timelineEventType.get()).getDisplayName()));
            this.addToOutput(actionArg, output);
            this.addToOutput(new BlankRelationshipNode().setSource(actionArg.getId()).setTarget(export.getId()), output);
        }
        this.addToOutput(export, output);
    }

    private void assembleClipboardContent(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new Note().setText(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_TEXT)));
        this.addToOutput(export, output);
    }

    private void assembleAssociatedObject(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        BlackboardArtifact associatedArtifact;
        Trace export = new Trace(uuid);
        this.addToOutput(export, output);
        Long associatedArtifactId = this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_ASSOCIATED_ARTIFACT);
        if (associatedArtifactId != null && (associatedArtifact = artifact.getSleuthkitCase().getBlackboardArtifact(associatedArtifactId.longValue())) != null) {
            this.addToOutput(new BlankRelationshipNode().setSource(uuid).setTarget(this.uuidService.createUUID((Content)associatedArtifact)), output);
        }
    }

    private void assembleUserContentSuspected(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Assertion export = new Assertion(uuid);
        export.setStatement(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_COMMENT));
        this.addToOutput(export, output);
    }

    private void assembleMetadata(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException {
        Trace export = new Trace(uuid).addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)).setVersion(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_VERSION)));
        ContentData contentData = new ContentData();
        contentData.setCreatedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_CREATED));
        contentData.setModifiedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_DATETIME_MODIFIED));
        contentData.setDescription(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_DESCRIPTION));
        BlankIdentityNode owner = new BlankIdentityNode();
        owner.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_OWNER));
        contentData.setOwner(owner);
        export.addBundle(contentData);
        ContentData contentDataTwo = new ContentData();
        contentDataTwo.setTag("Last Printed");
        contentDataTwo.setModifiedTime(this.getLongIfPresent(artifact, StandardAttributeTypes.TSK_LAST_PRINTED_DATETIME));
        export.addBundle(contentDataTwo);
        BlankOrganizationNode organization = new BlankOrganizationNode();
        organization.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_ORGANIZATION));
        BlankIdentityNode lastAuthor = new BlankIdentityNode();
        lastAuthor.setTag("Last Author");
        lastAuthor.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_USER_ID));
        this.addToOutput(export, output);
        this.addToOutput(owner, output);
        this.addToOutput(organization, output);
        this.addToOutput(new BlankRelationshipNode().setSource(organization.getId()).setTarget(export.getId()), output);
        this.addToOutput(lastAuthor, output);
        this.addToOutput(new BlankRelationshipNode().setSource(lastAuthor.getId()).setTarget(export.getId()), output);
    }

    private void assembleGpsTrack(String uuid, BlackboardArtifact artifact, List<JsonElement> output) throws TskCoreException, BlackboardJsonAttrUtil.InvalidJsonException {
        Trace export = new Trace(uuid).addBundle(new Application().setApplicationIdentifier(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_PROG_NAME)));
        export.setName(this.getValueIfPresent(artifact, StandardAttributeTypes.TSK_NAME));
        BlackboardAttribute trackpoints = artifact.getAttribute(StandardAttributeTypes.TSK_GEO_TRACKPOINTS);
        if (trackpoints != null) {
            GeoTrackPoints points = (GeoTrackPoints)BlackboardJsonAttrUtil.fromAttribute((BlackboardAttribute)trackpoints, GeoTrackPoints.class);
            for (GeoTrackPoints.TrackPoint point : points) {
                export.addBundle(new LatLongCoordinates().setAltitude(point.getAltitude()).setLatitude(point.getLatitude()).setLongitude(point.getLongitude()));
            }
        }
        this.addToOutput(export, output);
    }

    private Integer getIntegerIfPresent(BlackboardArtifact artifact, BlackboardAttribute.Type type) throws TskCoreException {
        if (artifact.getAttribute(type) != null) {
            return artifact.getAttribute(type).getValueInt();
        }
        return null;
    }

    private Double getDoubleIfPresent(BlackboardArtifact artifact, BlackboardAttribute.Type type) throws TskCoreException {
        if (artifact.getAttribute(type) != null) {
            return artifact.getAttribute(type).getValueDouble();
        }
        return null;
    }

    private Long getLongIfPresent(BlackboardArtifact artifact, BlackboardAttribute.Type type) throws TskCoreException {
        if (artifact.getAttribute(type) != null) {
            return artifact.getAttribute(type).getValueLong();
        }
        return null;
    }

    private String getValueIfPresent(BlackboardArtifact artifact, BlackboardAttribute.Type type) throws TskCoreException {
        if (artifact.getAttribute(type) != null) {
            return artifact.getAttribute(type).getDisplayString();
        }
        return null;
    }

    private void addParentChildRelationship(List<JsonElement> output, String sourceId, String parentId) {
        String parentChildProperty = this.props.getProperty(INCLUDE_PARENT_CHILD_RELATIONSHIPS_PROP, DEFAULT_PARENT_CHILD_RELATIONSHIPS_VALUE);
        if (Boolean.valueOf(parentChildProperty).booleanValue()) {
            this.addToOutput(new BlankRelationshipNode().setSource(sourceId).setTarget(parentId).setKindOfRelationship("contained-within").isDirectional(true), output);
        }
    }

    private void addToOutput(UcoObject ucoObject, List<JsonElement> output) {
        output.add(this.gson.toJsonTree((Object)ucoObject));
    }
}

