/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.Account;
import org.sleuthkit.datamodel.AccountFileInstance;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.InvalidAccountIDException;
import org.sleuthkit.datamodel.Relationship;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskDataException;
import org.sleuthkit.datamodel.blackboardutils.ArtifactHelperBase;
import org.sleuthkit.datamodel.blackboardutils.attributes.BlackboardJsonAttrUtil;
import org.sleuthkit.datamodel.blackboardutils.attributes.MessageAttachments;

public final class CommunicationArtifactsHelper
extends ArtifactHelperBase {
    private static final Logger LOGGER = Logger.getLogger(CommunicationArtifactsHelper.class.getName());
    private static final BlackboardArtifact.Type CONTACT_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_CONTACT);
    private static final BlackboardArtifact.Type MESSAGE_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_MESSAGE);
    private static final BlackboardArtifact.Type CALLOG_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_CALLLOG);
    private static final BlackboardArtifact.Type ASSOCIATED_OBJ_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_ASSOCIATED_OBJECT);
    private static final BlackboardAttribute.Type ATTACHMENTS_ATTR_TYPE = new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ATTACHMENTS);
    private final Account.Type selfAccountType;
    private final String selfAccountId;
    private AccountFileInstance selfAccountInstance = null;
    private final Account.Type moduleAccountsType;

    public CommunicationArtifactsHelper(SleuthkitCase caseDb, String moduleName, Content srcContent, Account.Type accountsType, Long ingestJobId) throws TskCoreException {
        super(caseDb, moduleName, srcContent, ingestJobId);
        this.moduleAccountsType = accountsType;
        this.selfAccountType = Account.Type.DEVICE;
        this.selfAccountId = ((DataSource)this.getContent().getDataSource()).getDeviceId();
    }

    public CommunicationArtifactsHelper(SleuthkitCase caseDb, String moduleName, Content srcContent, Account.Type accountsType, Account.Type selfAccountType, String selfAccountId, Long ingestJobId) throws TskCoreException {
        super(caseDb, moduleName, srcContent, ingestJobId);
        this.moduleAccountsType = accountsType;
        this.selfAccountType = selfAccountType;
        this.selfAccountId = selfAccountId;
    }

    @Deprecated
    public CommunicationArtifactsHelper(SleuthkitCase caseDb, String moduleName, Content srcContent, Account.Type accountsType) throws TskCoreException {
        this(caseDb, moduleName, srcContent, accountsType, null);
    }

    @Deprecated
    public CommunicationArtifactsHelper(SleuthkitCase caseDb, String moduleName, Content srcContent, Account.Type accountsType, Account.Type selfAccountType, String selfAccountId) throws TskCoreException {
        this(caseDb, moduleName, srcContent, accountsType, selfAccountType, selfAccountId, null);
    }

    public BlackboardArtifact addContact(String contactName, String phoneNumber, String homePhoneNumber, String mobilePhoneNumber, String emailAddr) throws TskCoreException, Blackboard.BlackboardException {
        return this.addContact(contactName, phoneNumber, homePhoneNumber, mobilePhoneNumber, emailAddr, Collections.emptyList());
    }

    public BlackboardArtifact addContact(String contactName, String phoneNumber, String homePhoneNumber, String mobilePhoneNumber, String emailAddr, Collection<BlackboardAttribute> additionalAttributes) throws TskCoreException, Blackboard.BlackboardException {
        boolean hasAnyIdAttribute = false;
        if (additionalAttributes != null) {
            for (BlackboardAttribute attr : additionalAttributes) {
                if (!attr.getAttributeType().getTypeName().startsWith("TSK_PHONE") && !attr.getAttributeType().getTypeName().startsWith("TSK_EMAIL") && !attr.getAttributeType().getTypeName().startsWith("TSK_ID")) continue;
                hasAnyIdAttribute = true;
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)phoneNumber) && StringUtils.isEmpty((CharSequence)homePhoneNumber) && StringUtils.isEmpty((CharSequence)mobilePhoneNumber) && StringUtils.isEmpty((CharSequence)emailAddr) && !hasAnyIdAttribute) {
            throw new IllegalArgumentException("At least one phone number or email address or an id must be provided.");
        }
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, contactName, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER, phoneNumber, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_HOME, homePhoneNumber, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_MOBILE, mobilePhoneNumber, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL, emailAddr, attributes);
        attributes.addAll(additionalAttributes);
        Content content = this.getContent();
        DataArtifact contactArtifact = content.newDataArtifact(CONTACT_TYPE, attributes);
        this.createContactMethodAccountAndRelationship(Account.Type.PHONE, phoneNumber, contactArtifact, 0L);
        this.createContactMethodAccountAndRelationship(Account.Type.PHONE, homePhoneNumber, contactArtifact, 0L);
        this.createContactMethodAccountAndRelationship(Account.Type.PHONE, mobilePhoneNumber, contactArtifact, 0L);
        this.createContactMethodAccountAndRelationship(Account.Type.EMAIL, emailAddr, contactArtifact, 0L);
        if (additionalAttributes != null && hasAnyIdAttribute) {
            for (BlackboardAttribute bba : additionalAttributes) {
                if (bba.getAttributeType().getTypeName().startsWith("TSK_PHONE")) {
                    this.createContactMethodAccountAndRelationship(Account.Type.PHONE, bba.getValueString(), contactArtifact, 0L);
                    continue;
                }
                if (bba.getAttributeType().getTypeName().startsWith("TSK_EMAIL")) {
                    this.createContactMethodAccountAndRelationship(Account.Type.EMAIL, bba.getValueString(), contactArtifact, 0L);
                    continue;
                }
                if (!bba.getAttributeType().getTypeName().startsWith("TSK_ID")) continue;
                this.createContactMethodAccountAndRelationship(this.moduleAccountsType, bba.getValueString(), contactArtifact, 0L);
            }
        }
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(contactArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return contactArtifact;
    }

    private void createContactMethodAccountAndRelationship(Account.Type accountType, String accountUniqueID, BlackboardArtifact sourceArtifact, long dateTime) throws TskCoreException {
        if (StringUtils.isNotBlank((CharSequence)accountUniqueID)) {
            try {
                AccountFileInstance contactAccountInstance = this.createAccountInstance(accountType, accountUniqueID);
                try {
                    this.getSleuthkitCase().getCommunicationsManager().addRelationships(this.getSelfAccountInstance(), Collections.singletonList(contactAccountInstance), sourceArtifact, Relationship.Type.CONTACT, dateTime);
                }
                catch (TskDataException ex) {
                    throw new TskCoreException(String.format("Failed to create relationship between account = %s and account = %s.", this.getSelfAccountInstance().getAccount(), contactAccountInstance.getAccount()), ex);
                }
            }
            catch (InvalidAccountIDException ex) {
                LOGGER.log(Level.WARNING, String.format("Failed to create account with id %s", accountUniqueID));
            }
        }
    }

    private AccountFileInstance createAccountInstance(Account.Type accountType, String accountUniqueID) throws TskCoreException, InvalidAccountIDException {
        Optional<Long> ingestJobId = this.getIngestJobId();
        return this.getSleuthkitCase().getCommunicationsManager().createAccountFileInstance(accountType, accountUniqueID, this.getModuleName(), this.getContent(), null, ingestJobId.orElse(null));
    }

    public BlackboardArtifact addMessage(String messageType, CommunicationDirection direction, String senderId, String recipientId, long dateTime, MessageReadStatus readStatus, String subject, String messageText, String threadId) throws TskCoreException, Blackboard.BlackboardException {
        return this.addMessage(messageType, direction, senderId, recipientId, dateTime, readStatus, subject, messageText, threadId, Collections.emptyList());
    }

    public BlackboardArtifact addMessage(String messageType, CommunicationDirection direction, String senderId, String recipientId, long dateTime, MessageReadStatus readStatus, String subject, String messageText, String threadId, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        return this.addMessage(messageType, direction, senderId, Arrays.asList(recipientId), dateTime, readStatus, subject, messageText, threadId, otherAttributesList);
    }

    public BlackboardArtifact addMessage(String messageType, CommunicationDirection direction, String senderId, List<String> recipientIdsList, long dateTime, MessageReadStatus readStatus, String subject, String messageText, String threadId) throws TskCoreException, Blackboard.BlackboardException {
        return this.addMessage(messageType, direction, senderId, recipientIdsList, dateTime, readStatus, subject, messageText, threadId, Collections.emptyList());
    }

    public BlackboardArtifact addMessage(String messageType, CommunicationDirection direction, String senderId, List<String> recipientIdsList, long dateTime, MessageReadStatus readStatus, String subject, String messageText, String threadId, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_MESSAGE_TYPE, this.getModuleName(), messageType));
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME, dateTime, attributes);
        this.addMessageReadStatusIfKnown(readStatus, attributes);
        this.addCommDirectionIfKnown(direction, attributes);
        AccountFileInstance selfAccountInstanceLocal = null;
        try {
            selfAccountInstanceLocal = this.getSelfAccountInstance();
        }
        catch (InvalidAccountIDException ex) {
            LOGGER.log(Level.WARNING, String.format("Failed to get/create self account with id %s", this.selfAccountId), ex);
        }
        AccountFileInstance senderAccountInstance = null;
        if (StringUtils.isNotBlank((CharSequence)senderId)) {
            try {
                senderAccountInstance = this.createAccountInstance(this.moduleAccountsType, senderId);
            }
            catch (InvalidAccountIDException ex) {
                LOGGER.log(Level.WARNING, String.format("Invalid account identifier %s", senderId));
            }
        }
        ArrayList<AccountFileInstance> recipientAccountsList = new ArrayList<AccountFileInstance>();
        String recipientsStr = "";
        if (!this.isEffectivelyEmpty(recipientIdsList)) {
            for (String recipient : recipientIdsList) {
                if (!StringUtils.isNotBlank((CharSequence)recipient)) continue;
                try {
                    recipientAccountsList.add(this.createAccountInstance(this.moduleAccountsType, recipient));
                }
                catch (InvalidAccountIDException ex) {
                    LOGGER.log(Level.WARNING, String.format("Invalid account identifier %s", recipient));
                }
            }
            recipientsStr = this.addressListToString(recipientIdsList);
        }
        switch (direction.ordinal()) {
            case 2: {
                if (StringUtils.isEmpty((CharSequence)senderId) && selfAccountInstanceLocal != null) {
                    senderAccountInstance = selfAccountInstanceLocal;
                }
                if (senderAccountInstance != null) {
                    this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM, senderAccountInstance.getAccount().getTypeSpecificID(), attributes);
                }
                this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO, recipientsStr, attributes);
                break;
            }
            case 1: {
                if (this.isEffectivelyEmpty(recipientIdsList) && selfAccountInstanceLocal != null) {
                    recipientsStr = selfAccountInstanceLocal.getAccount().getTypeSpecificID();
                    recipientAccountsList.add(selfAccountInstanceLocal);
                }
                if (senderAccountInstance != null) {
                    this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM, senderAccountInstance.getAccount().getTypeSpecificID(), attributes);
                }
                this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO, recipientsStr, attributes);
                break;
            }
            default: {
                if (StringUtils.isEmpty((CharSequence)senderId) && selfAccountInstanceLocal != null) {
                    senderAccountInstance = selfAccountInstanceLocal;
                } else if (this.isEffectivelyEmpty(recipientIdsList) && selfAccountInstanceLocal != null) {
                    recipientsStr = selfAccountInstanceLocal.getAccount().getTypeSpecificID();
                    recipientAccountsList.add(selfAccountInstanceLocal);
                }
                if (senderAccountInstance != null) {
                    this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER, senderAccountInstance.getAccount().getTypeSpecificID(), attributes);
                }
                this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER, recipientsStr, attributes);
            }
        }
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_SUBJECT, subject, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TEXT, messageText, attributes);
        this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_THREAD_ID, threadId, attributes);
        attributes.addAll(otherAttributesList);
        Content content = this.getContent();
        DataArtifact msgArtifact = content.newDataArtifact(MESSAGE_TYPE, attributes);
        try {
            this.getSleuthkitCase().getCommunicationsManager().addRelationships(senderAccountInstance, recipientAccountsList, msgArtifact, Relationship.Type.MESSAGE, dateTime);
        }
        catch (TskDataException ex) {
            throw new TskCoreException(String.format("Failed to create Message relationships between sender account = %s and recipients = %s.", senderAccountInstance != null ? senderAccountInstance.getAccount().getTypeSpecificID() : "Unknown", recipientsStr), ex);
        }
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(msgArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return msgArtifact;
    }

    public BlackboardArtifact addCalllog(CommunicationDirection direction, String callerId, String calleeId, long startDateTime, long endDateTime, CallMediaType mediaType) throws TskCoreException, Blackboard.BlackboardException {
        return this.addCalllog(direction, callerId, calleeId, startDateTime, endDateTime, mediaType, Collections.emptyList());
    }

    public BlackboardArtifact addCalllog(CommunicationDirection direction, String callerId, String calleeId, long startDateTime, long endDateTime, CallMediaType mediaType, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        return this.addCalllog(direction, callerId, Arrays.asList(calleeId), startDateTime, endDateTime, mediaType, otherAttributesList);
    }

    public BlackboardArtifact addCalllog(CommunicationDirection direction, String callerId, Collection<String> calleeIdsList, long startDateTime, long endDateTime, CallMediaType mediaType) throws TskCoreException, Blackboard.BlackboardException {
        return this.addCalllog(direction, callerId, calleeIdsList, startDateTime, endDateTime, mediaType, Collections.emptyList());
    }

    public BlackboardArtifact addCalllog(CommunicationDirection direction, String callerId, Collection<String> calleeIdsList, long startDateTime, long endDateTime, CallMediaType mediaType, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        if (StringUtils.isEmpty((CharSequence)callerId) && this.isEffectivelyEmpty(calleeIdsList)) {
            throw new IllegalArgumentException("Either a caller id, or at least one callee id must be provided for a call log.");
        }
        AccountFileInstance selfAccountInstanceLocal = null;
        try {
            selfAccountInstanceLocal = this.getSelfAccountInstance();
        }
        catch (InvalidAccountIDException ex) {
            LOGGER.log(Level.WARNING, String.format("Failed to get/create self account with id %s", this.selfAccountId), ex);
        }
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_START, startDateTime, attributes);
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_END, endDateTime, attributes);
        this.addCommDirectionIfKnown(direction, attributes);
        AccountFileInstance callerAccountInstance = null;
        if (StringUtils.isNotBlank((CharSequence)callerId)) {
            try {
                callerAccountInstance = this.createAccountInstance(this.moduleAccountsType, callerId);
            }
            catch (InvalidAccountIDException ex) {
                LOGGER.log(Level.WARNING, String.format("Failed to create account with id %s", callerId));
            }
        }
        ArrayList<AccountFileInstance> recipientAccountsList = new ArrayList<AccountFileInstance>();
        String calleesStr = "";
        if (!this.isEffectivelyEmpty(calleeIdsList)) {
            calleesStr = this.addressListToString(calleeIdsList);
            for (String callee : calleeIdsList) {
                if (!StringUtils.isNotBlank((CharSequence)callee)) continue;
                try {
                    recipientAccountsList.add(this.createAccountInstance(this.moduleAccountsType, callee));
                }
                catch (InvalidAccountIDException ex) {
                    LOGGER.log(Level.WARNING, String.format("Failed to create account with id %s", callee));
                }
            }
        }
        switch (direction.ordinal()) {
            case 2: {
                if (this.isEffectivelyEmpty(calleeIdsList)) {
                    throw new IllegalArgumentException("Callee not provided for an outgoing call.");
                }
                if (StringUtils.isEmpty((CharSequence)callerId) && selfAccountInstanceLocal != null) {
                    callerAccountInstance = selfAccountInstanceLocal;
                }
                if (callerAccountInstance != null) {
                    this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM, callerAccountInstance.getAccount().getTypeSpecificID(), attributes);
                }
                this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO, calleesStr, attributes);
                break;
            }
            case 1: {
                if (StringUtils.isEmpty((CharSequence)callerId)) {
                    throw new IllegalArgumentException("Caller Id not provided for incoming call.");
                }
                if (this.isEffectivelyEmpty(calleeIdsList) && selfAccountInstanceLocal != null) {
                    calleesStr = selfAccountInstanceLocal.getAccount().getTypeSpecificID();
                    recipientAccountsList.add(selfAccountInstanceLocal);
                }
                if (callerAccountInstance != null) {
                    this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM, callerAccountInstance.getAccount().getTypeSpecificID(), attributes);
                }
                this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO, calleesStr, attributes);
                break;
            }
            default: {
                if (callerAccountInstance != null) {
                    this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER, callerAccountInstance.getAccount().getTypeSpecificID(), attributes);
                }
                this.addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER, calleesStr, attributes);
            }
        }
        attributes.addAll(otherAttributesList);
        Content content = this.getContent();
        DataArtifact callLogArtifact = content.newDataArtifact(CALLOG_TYPE, attributes);
        callLogArtifact.addAttributes(attributes);
        try {
            this.getSleuthkitCase().getCommunicationsManager().addRelationships(callerAccountInstance, recipientAccountsList, callLogArtifact, Relationship.Type.CALL_LOG, startDateTime);
        }
        catch (TskDataException ex) {
            throw new TskCoreException(String.format("Failed to create Call log relationships between caller account = %s and callees = %s.", callerAccountInstance != null ? callerAccountInstance.getAccount() : "", calleesStr), ex);
        }
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(callLogArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return callLogArtifact;
    }

    public void addAttachments(BlackboardArtifact message, MessageAttachments attachments) throws TskCoreException {
        BlackboardAttribute blackboardAttribute = BlackboardJsonAttrUtil.toAttribute(ATTACHMENTS_ATTR_TYPE, this.getModuleName(), attachments);
        message.addAttribute(blackboardAttribute);
        ArrayList<BlackboardArtifact> assocObjectArtifacts = new ArrayList<BlackboardArtifact>();
        Collection<MessageAttachments.FileAttachment> fileAttachments = attachments.getFileAttachments();
        for (MessageAttachments.FileAttachment fileAttachment : fileAttachments) {
            long attachedFileObjId = fileAttachment.getObjectId();
            if (attachedFileObjId < 0L) continue;
            AbstractFile attachedFile = message.getSleuthkitCase().getAbstractFileById(attachedFileObjId);
            DataArtifact artifact = this.associateAttachmentWithMessage(message, attachedFile);
            assocObjectArtifacts.add(artifact);
        }
        try {
            Optional<Long> ingestJobId = this.getIngestJobId();
            this.getSleuthkitCase().getBlackboard().postArtifacts(assocObjectArtifacts, this.getModuleName(), ingestJobId.orElse(null));
        }
        catch (Blackboard.BlackboardException ex) {
            throw new TskCoreException("Error posting TSK_ASSOCIATED_ARTIFACT artifacts for attachments", ex);
        }
    }

    private DataArtifact associateAttachmentWithMessage(BlackboardArtifact message, AbstractFile attachedFile) throws TskCoreException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ASSOCIATED_ARTIFACT, this.getModuleName(), message.getArtifactID()));
        return attachedFile.newDataArtifact(ASSOCIATED_OBJ_TYPE, attributes);
    }

    private String addressListToString(Collection<String> addressList) {
        String toAddresses = "";
        if (addressList != null && !addressList.isEmpty()) {
            StringBuilder toAddressesSb = new StringBuilder();
            for (String address : addressList) {
                if (StringUtils.isEmpty((CharSequence)address)) continue;
                toAddressesSb = toAddressesSb.length() > 0 ? toAddressesSb.append(", ").append(address) : toAddressesSb.append(address);
            }
            toAddresses = toAddressesSb.toString();
        }
        return toAddresses;
    }

    private boolean isEffectivelyEmpty(Collection<String> idList) {
        if (idList == null || idList.isEmpty()) {
            return true;
        }
        for (String id : idList) {
            if (StringUtils.isEmpty((CharSequence)id)) continue;
            return false;
        }
        return true;
    }

    private void addCommDirectionIfKnown(CommunicationDirection direction, Collection<BlackboardAttribute> attributes) {
        if (direction != CommunicationDirection.UNKNOWN) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DIRECTION, this.getModuleName(), direction.getDisplayName()));
        }
    }

    private void addMessageReadStatusIfKnown(MessageReadStatus readStatus, Collection<BlackboardAttribute> attributes) {
        if (readStatus != MessageReadStatus.UNKNOWN) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_READ_STATUS, this.getModuleName(), readStatus == MessageReadStatus.READ ? 1 : 0));
        }
    }

    private synchronized AccountFileInstance getSelfAccountInstance() throws TskCoreException, InvalidAccountIDException {
        if (this.selfAccountInstance == null) {
            Optional<Long> ingestJobId = this.getIngestJobId();
            this.selfAccountInstance = this.getSleuthkitCase().getCommunicationsManager().createAccountFileInstance(this.selfAccountType, this.selfAccountId, this.getModuleName(), this.getContent(), null, ingestJobId.orElse(null));
        }
        return this.selfAccountInstance;
    }

    public static enum CommunicationDirection {
        UNKNOWN("Unknown"),
        INCOMING("Incoming"),
        OUTGOING("Outgoing");

        private final String dirStr;

        private CommunicationDirection(String dir) {
            this.dirStr = dir;
        }

        public String getDisplayName() {
            return this.dirStr;
        }
    }

    public static enum MessageReadStatus {
        UNKNOWN("Unknown"),
        UNREAD("Unread"),
        READ("Read");

        private final String msgReadStr;

        private MessageReadStatus(String readStatus) {
            this.msgReadStr = readStatus;
        }

        public String getDisplayName() {
            return this.msgReadStr;
        }
    }

    public static enum CallMediaType {
        UNKNOWN("Unknown"),
        AUDIO("Audio"),
        VIDEO("Video");

        private final String typeStr;

        private CallMediaType(String type) {
            this.typeStr = type;
        }

        public String getDisplayName() {
            return this.typeStr;
        }
    }
}

