/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.ResourceBundle;
import java.util.Set;

public class TskData {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");

    public static enum KeywordSearchQueryType {
        LITERAL(0),
        SUBSTRING(1),
        REGEX(2);

        private final int type;

        private KeywordSearchQueryType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static KeywordSearchQueryType valueOf(int type) {
            for (KeywordSearchQueryType v : KeywordSearchQueryType.values()) {
                if (v.type != type) continue;
                return v;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.keywordSearchQueryType.exception.msg1.text"), type));
        }
    }

    public static enum CollectedStatus {
        UNKNOWN(0),
        NO_SAVE_ERROR(1),
        NO_EMPTY_FILE(2),
        NO_NOT_FOUND(3),
        NO_UNRESOLVED(4),
        NO_READ_ERROR(5),
        NO_READ_ERROR_PARTIAL(6),
        NO_NOT_ATTEMPTED(7),
        NO_NOT_REGULAR_FILE(8),
        NO_FILE_TOO_LARGE(9),
        NO_ONLY_HASH_COLLECTED(10),
        NO_UNSUPPORTED_COMPRESSION(11),
        YES_TSK(12),
        YES_REPO(13);

        private final int type;

        private CollectedStatus(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static CollectedStatus valueOf(int type) {
            for (CollectedStatus v : CollectedStatus.values()) {
                if (v.type != type) continue;
                return v;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.collectedStatus.exception.msg1.text"), type));
        }
    }

    public static enum EncodingType {
        NONE(0),
        XOR1(1);

        private final int type;

        private EncodingType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static EncodingType valueOf(int type) {
            for (EncodingType v : EncodingType.values()) {
                if (v.type != type) continue;
                return v;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.encodingType.exception.msg1.text"), type));
        }
    }

    public static enum DbType {
        SQLITE(0),
        POSTGRESQL(1);

        private int value;

        private DbType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TagType {
        UNKNOWN(0, bundle.getString("TskData.tagType.unknown")),
        KNOWN(1, bundle.getString("TskData.tagType.known")),
        BAD(2, bundle.getString("TskData.tagType.knownBad")),
        SUSPICIOUS(3, bundle.getString("TskData.tagType.suspicious"));

        private byte type;
        private String name;

        private TagType(int type, String name) {
            this.type = (byte)type;
            this.name = name;
        }

        public static FileKnown convertTagTypeToFileKnown(TagType tagType) {
            switch (tagType.ordinal()) {
                case 2: {
                    return FileKnown.BAD;
                }
                case 1: {
                    return FileKnown.KNOWN;
                }
                case 0: 
                case 3: {
                    return FileKnown.UNKNOWN;
                }
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tagType.exception.msg1.text"), new Object[]{tagType}));
        }

        public static TagType convertFileKnownToTagType(FileKnown fileKnown) {
            switch (fileKnown.ordinal()) {
                case 2: {
                    return BAD;
                }
                case 1: {
                    return KNOWN;
                }
                case 0: {
                    return SUSPICIOUS;
                }
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.fileKnown.exception.msg1.text"), new Object[]{fileKnown}));
        }

        public static TagType valueOf(byte type) {
            for (TagType v : TagType.values()) {
                if (v.type != type) continue;
                return v;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tagType.exception.msg1.text"), type));
        }

        public String getName() {
            return this.name;
        }

        public byte getTagTypeValue() {
            return this.type;
        }
    }

    public static enum FileKnown {
        UNKNOWN(0, bundle.getString("TskData.fileKnown.unknown")),
        KNOWN(1, bundle.getString("TskData.fileKnown.known")),
        BAD(2, bundle.getString("TskData.fileKnown.knownBad"));

        private byte known;
        private String name;

        private FileKnown(int known, String name) {
            this.known = (byte)known;
            this.name = name;
        }

        public static FileKnown valueOf(byte known) {
            for (FileKnown v : FileKnown.values()) {
                if (v.known != known) continue;
                return v;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.fileKnown.exception.msg1.text"), known));
        }

        public String getName() {
            return this.name;
        }

        public byte getFileKnownValue() {
            return this.known;
        }
    }

    public static enum TSK_POOL_TYPE_ENUM {
        TSK_POOL_TYPE_DETECT(0, "Auto detect"),
        TSK_POOL_TYPE_APFS(1, "APFS Pool"),
        TSK_POOL_TYPE_UNSUPP(65535, "Unsupported");

        private final short poolType;
        private final String name;

        private TSK_POOL_TYPE_ENUM(int poolType, String name) {
            this.poolType = (short)poolType;
            this.name = name;
        }

        public static TSK_POOL_TYPE_ENUM valueOf(long poolType) {
            for (TSK_POOL_TYPE_ENUM type : TSK_POOL_TYPE_ENUM.values()) {
                if ((long)type.poolType != poolType) continue;
                return type;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tskDbFilesTypeEnum.exception.msg1.text"), poolType));
        }

        public short getValue() {
            return this.poolType;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum TSK_DB_FILES_TYPE_ENUM {
        FS(0, "File System"),
        CARVED(1, "Carved"),
        DERIVED(2, "Derived"),
        LOCAL(3, "Local"),
        UNALLOC_BLOCKS(4, "Unallocated Blocks"),
        UNUSED_BLOCKS(5, "Unused Blocks"),
        VIRTUAL_DIR(6, "Virtual Directory"),
        SLACK(7, "Slack"),
        LOCAL_DIR(8, "Local Directory"),
        LAYOUT_FILE(9, "Layout File");

        private final short fileType;
        private final String name;

        private TSK_DB_FILES_TYPE_ENUM(int fileType, String name) {
            this.fileType = (short)fileType;
            this.name = name;
        }

        public static TSK_DB_FILES_TYPE_ENUM valueOf(short fileType) {
            for (TSK_DB_FILES_TYPE_ENUM type : TSK_DB_FILES_TYPE_ENUM.values()) {
                if (type.fileType != fileType) continue;
                return type;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tskDbFilesTypeEnum.exception.msg1.text"), fileType));
        }

        public short getFileType() {
            return this.fileType;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ObjectType {
        IMG(0, bundle.getString("TskData.ObjectType.IMG.name")),
        VS(1, bundle.getString("TskData.ObjectType.VS.name")),
        VOL(2, bundle.getString("TskData.ObjectType.VOL.name")),
        FS(3, bundle.getString("TskData.ObjectType.FS.name")),
        ABSTRACTFILE(4, bundle.getString("TskData.ObjectType.AbstractFile.name")),
        ARTIFACT(5, bundle.getString("TskData.ObjectType.Artifact.name")),
        REPORT(6, bundle.getString("TskData.ObjectType.Report.name")),
        POOL(7, bundle.getString("TskData.ObjectType.Pool.name")),
        OS_ACCOUNT(8, bundle.getString("TskData.ObjectType.OsAccount.name")),
        HOST_ADDRESS(9, bundle.getString("TskData.ObjectType.HostAddress.name")),
        UNSUPPORTED(-1, bundle.getString("TskData.ObjectType.Unsupported.name"));

        private final short objectType;
        private final String displayName;

        private ObjectType(int objectType, String displayName) {
            this.objectType = (short)objectType;
            this.displayName = displayName;
        }

        public short getObjectType() {
            return this.objectType;
        }

        public String toString() {
            return this.displayName;
        }

        public static ObjectType valueOf(short objectType) {
            for (ObjectType v : ObjectType.values()) {
                if (v.objectType != objectType) continue;
                return v;
            }
            return UNSUPPORTED;
        }
    }

    public static enum TSK_VS_TYPE_ENUM {
        TSK_VS_TYPE_DETECT(0L, bundle.getString("TskData.tskVSTypeEnum.autoDetect")),
        TSK_VS_TYPE_DOS(1L, "DOS"),
        TSK_VS_TYPE_BSD(2L, "BSD"),
        TSK_VS_TYPE_SUN(4L, "SUN VTOC"),
        TSK_VS_TYPE_MAC(8L, "Mac"),
        TSK_VS_TYPE_GPT(16L, "GPT"),
        TSK_VS_TYPE_APFS(32L, "APFS"),
        TSK_VS_TYPE_DBFILLER(240L, bundle.getString("TskData.tskVSTypeEnum.fake")),
        TSK_VS_TYPE_UNSUPP(65535L, bundle.getString("TskData.tskVSTypeEnum.unsupported"));

        private long vsType;
        private String name;

        private TSK_VS_TYPE_ENUM(long type, String name) {
            this.vsType = type;
            this.name = name;
        }

        public static TSK_VS_TYPE_ENUM valueOf(long vsType) {
            for (TSK_VS_TYPE_ENUM type : TSK_VS_TYPE_ENUM.values()) {
                if (type.getVsType() != vsType) continue;
                return type;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tskVSTypeEnum.exception.msg1.text"), vsType));
        }

        public long getVsType() {
            return this.vsType;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum TSK_IMG_TYPE_ENUM {
        TSK_IMG_TYPE_DETECT(0L, bundle.getString("TskData.tskImgTypeEnum.autoDetect")),
        TSK_IMG_TYPE_RAW_SING(1L, bundle.getString("TskData.tskImgTypeEnum.rawSingle")),
        TSK_IMG_TYPE_RAW_SPLIT(2L, bundle.getString("TskData.tskImgTypeEnum.rawSplit")),
        TSK_IMG_TYPE_AFF_AFF(4L, "AFF"),
        TSK_IMG_TYPE_AFF_AFD(8L, "AFD"),
        TSK_IMG_TYPE_AFF_AFM(16L, "AFM"),
        TSK_IMG_TYPE_AFF_ANY(32L, "AFF"),
        TSK_IMG_TYPE_EWF_EWF(64L, "E01"),
        TSK_IMG_TYPE_VMDK_VMDK(128L, "VMDK"),
        TSK_IMG_TYPE_VHD_VHD(256L, "VHD"),
        TSK_IMG_TYPE_POOL_POOL(16384L, "POOL"),
        TSK_IMG_TYPE_LOGICAL(32768L, "Logical"),
        TSK_IMG_TYPE_UNSUPP(65535L, bundle.getString("TskData.tskImgTypeEnum.unknown"));

        private long imgType;
        private String name;

        private TSK_IMG_TYPE_ENUM(long type, String name) {
            this.imgType = type;
            this.name = name;
        }

        public static TSK_IMG_TYPE_ENUM valueOf(long imgType) {
            for (TSK_IMG_TYPE_ENUM type : TSK_IMG_TYPE_ENUM.values()) {
                if (type.getValue() != imgType) continue;
                return type;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tskImgTypeEnum.exception.msg1.text"), imgType));
        }

        public long getValue() {
            return this.imgType;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum TSK_FS_TYPE_ENUM {
        TSK_FS_TYPE_DETECT(0, bundle.getString("TskData.tskFsTypeEnum.autoDetect")),
        TSK_FS_TYPE_NTFS(1, "NTFS"),
        TSK_FS_TYPE_NTFS_DETECT(1, bundle.getString("TskData.tskFsTypeEnum.NTFSautoDetect")),
        TSK_FS_TYPE_FAT12(2, "FAT12"),
        TSK_FS_TYPE_FAT16(4, "FAT16"),
        TSK_FS_TYPE_FAT32(8, "FAT32"),
        TSK_FS_TYPE_EXFAT(10, "ExFAT"),
        TSK_FS_TYPE_FAT_DETECT(14, bundle.getString("TskData.tskFsTypeEnum.FATautoDetect")),
        TSK_FS_TYPE_FFS1(16, "UFS1"),
        TSK_FS_TYPE_FFS1B(32, "UFS1b"),
        TSK_FS_TYPE_FFS2(64, "UFS2"),
        TSK_FS_TYPE_FFS_DETECT(112, "UFS"),
        TSK_FS_TYPE_EXT2(128, "Ext2"),
        TSK_FS_TYPE_EXT3(256, "Ext3"),
        TSK_FS_TYPE_EXT_DETECT(384, bundle.getString("TskData.tskFsTypeEnum.ExtXautoDetect")),
        TSK_FS_TYPE_SWAP(512, "SWAP"),
        TSK_FS_TYPE_SWAP_DETECT(512, bundle.getString("TskData.tskFsTypeEnum.SWAPautoDetect")),
        TSK_FS_TYPE_RAW(1024, "RAW"),
        TSK_FS_TYPE_RAW_DETECT(1024, bundle.getString("TskData.tskFsTypeEnum.RAWautoDetect")),
        TSK_FS_TYPE_ISO9660(2048, "ISO9660"),
        TSK_FS_TYPE_ISO9660_DETECT(2048, bundle.getString("TskData.tskFsTypeEnum.ISO9660autoDetect")),
        TSK_FS_TYPE_HFS(4096, "HFS"),
        TSK_FS_TYPE_HFS_DETECT(4096, bundle.getString("TskData.tskFsTypeEnum.HFSautoDetect")),
        TSK_FS_TYPE_EXT4(8192, "Ext4"),
        TSK_FS_TYPE_YAFFS2(16384, "YAFFS2"),
        TSK_FS_TYPE_YAFFS2_DETECT(16384, bundle.getString("TskData.tskFsTypeEnum.YAFFS2autoDetect")),
        TSK_FS_TYPE_APFS(65536, "APFS"),
        TSK_FS_TYPE_APFS_DETECT(65536, bundle.getString("TskData.tskFsTypeEnum.APFSautoDetect")),
        TSK_FS_TYPE_LOGICAL(131072, "Logical"),
        TSK_FS_TYPE_UNSUPP(-1, bundle.getString("TskData.tskFsTypeEnum.unsupported"));

        private int value;
        private String displayName;

        private TSK_FS_TYPE_ENUM(int value, String displayName) {
            this.value = value;
            this.displayName = displayName;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static TSK_FS_TYPE_ENUM valueOf(int fsTypeValue) {
            for (TSK_FS_TYPE_ENUM type : TSK_FS_TYPE_ENUM.values()) {
                if (type.value != fsTypeValue) continue;
                return type;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tskFsTypeEnum.exception.msg1.text"), fsTypeValue));
        }
    }

    public static enum TSK_FS_META_MODE_ENUM {
        TSK_FS_META_MODE_ISUID(2048),
        TSK_FS_META_MODE_ISGID(1024),
        TSK_FS_META_MODE_ISVTX(512),
        TSK_FS_META_MODE_IRUSR(256),
        TSK_FS_META_MODE_IWUSR(128),
        TSK_FS_META_MODE_IXUSR(64),
        TSK_FS_META_MODE_IRGRP(32),
        TSK_FS_META_MODE_IWGRP(16),
        TSK_FS_META_MODE_IXGRP(8),
        TSK_FS_META_MODE_IROTH(4),
        TSK_FS_META_MODE_IWOTH(2),
        TSK_FS_META_MODE_IXOTH(1);

        private short mode;

        private TSK_FS_META_MODE_ENUM(int mode) {
            this.mode = (short)mode;
        }

        public short getMode() {
            return this.mode;
        }

        public static Set<TSK_FS_META_MODE_ENUM> valuesOf(short modes) {
            EnumSet<TSK_FS_META_MODE_ENUM> matchedFlags = EnumSet.noneOf(TSK_FS_META_MODE_ENUM.class);
            for (TSK_FS_META_MODE_ENUM v : TSK_FS_META_MODE_ENUM.values()) {
                long flag = v.getMode();
                if (((long)modes & flag) != flag) continue;
                matchedFlags.add(v);
            }
            return matchedFlags;
        }

        public static short toInt(Set<TSK_FS_META_MODE_ENUM> modes) {
            short modesInt = 0;
            for (TSK_FS_META_MODE_ENUM mode : modes) {
                modesInt = (short)(modesInt | mode.getMode());
            }
            return modesInt;
        }
    }

    public static enum TSK_VS_PART_FLAG_ENUM {
        TSK_VS_PART_FLAG_ALLOC(1L),
        TSK_VS_PART_FLAG_UNALLOC(2L),
        TSK_VS_PART_FLAG_META(4L),
        TSK_VS_PART_FLAG_ALL(7L);

        private long vs_flag;

        private TSK_VS_PART_FLAG_ENUM(long flag) {
            this.vs_flag = flag;
        }

        public long getVsFlag() {
            return this.vs_flag;
        }
    }

    public static enum TSK_FS_ATTR_TYPE_ENUM {
        TSK_FS_ATTR_TYPE_NOT_FOUND(0),
        TSK_FS_ATTR_TYPE_DEFAULT(1),
        TSK_FS_ATTR_TYPE_NTFS_SI(16),
        TSK_FS_ATTR_TYPE_NTFS_ATTRLIST(32),
        TSK_FS_ATTR_TYPE_NTFS_FNAME(48),
        TSK_FS_ATTR_TYPE_NTFS_VVER(64),
        TSK_FS_ATTR_TYPE_NTFS_OBJID(64),
        TSK_FS_ATTR_TYPE_NTFS_SEC(80),
        TSK_FS_ATTR_TYPE_NTFS_VNAME(96),
        TSK_FS_ATTR_TYPE_NTFS_VINFO(112),
        TSK_FS_ATTR_TYPE_NTFS_DATA(128),
        TSK_FS_ATTR_TYPE_NTFS_IDXROOT(144),
        TSK_FS_ATTR_TYPE_NTFS_IDXALLOC(160),
        TSK_FS_ATTR_TYPE_NTFS_BITMAP(176),
        TSK_FS_ATTR_TYPE_NTFS_SYMLNK(192),
        TSK_FS_ATTR_TYPE_NTFS_REPARSE(192),
        TSK_FS_ATTR_TYPE_NTFS_EAINFO(208),
        TSK_FS_ATTR_TYPE_NTFS_EA(224),
        TSK_FS_ATTR_TYPE_NTFS_PROP(240),
        TSK_FS_ATTR_TYPE_NTFS_LOG(256),
        TSK_FS_ATTR_TYPE_UNIX_INDIR(4097),
        TSK_FS_ATTR_TYPE_HFS_DEFAULT(1),
        TSK_FS_ATTR_TYPE_HFS_DATA(4352),
        TSK_FS_ATTR_TYPE_HFS_RSRC(4353),
        TSK_FS_ATTR_TYPE_HFS_EXT_ATTR(4354),
        TSK_FS_ATTR_TYPE_HFS_COMP_REC(4355);

        private int val;

        private TSK_FS_ATTR_TYPE_ENUM(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }

        public static TSK_FS_ATTR_TYPE_ENUM valueOf(int val) {
            for (TSK_FS_ATTR_TYPE_ENUM type : TSK_FS_ATTR_TYPE_ENUM.values()) {
                if (type.val != val) continue;
                return type;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tskFsAttrTypeEnum.exception.msg1.text"), val));
        }
    }

    public static enum TSK_FS_META_FLAG_ENUM {
        UNKNOWN(0, bundle.getString("TskData.tskFsMetaFlagEnum.unknown")),
        ALLOC(1, bundle.getString("TskData.tskFsMetaFlagEnum.allocated")),
        UNALLOC(2, bundle.getString("TskData.tskFsMetaFlagEnum.unallocated")),
        USED(4, bundle.getString("TskData.tskFsMetaFlagEnum.used")),
        UNUSED(8, bundle.getString("TskData.tskFsMetaFlagEnum.unused")),
        COMP(16, bundle.getString("TskData.tskFsMetaFlagEnum.compressed")),
        ORPHAN(32, bundle.getString("TskData.tskFsMetaFlagEnum.orphan"));

        private short meta_flag;
        private String label;

        private TSK_FS_META_FLAG_ENUM(int flag, String label) {
            this.meta_flag = (short)flag;
            this.label = label;
        }

        public short getValue() {
            return this.meta_flag;
        }

        public String toString() {
            return this.label;
        }

        public static Set<TSK_FS_META_FLAG_ENUM> valuesOf(short metaFlags) {
            EnumSet<TSK_FS_META_FLAG_ENUM> matchedFlags = EnumSet.noneOf(TSK_FS_META_FLAG_ENUM.class);
            if (metaFlags == UNKNOWN.getValue()) {
                matchedFlags.add(UNKNOWN);
                return matchedFlags;
            }
            for (TSK_FS_META_FLAG_ENUM v : TSK_FS_META_FLAG_ENUM.values()) {
                long flag = v.getValue();
                if (((long)metaFlags & flag) != flag) continue;
                matchedFlags.add(v);
            }
            return matchedFlags;
        }

        public static short toInt(Set<TSK_FS_META_FLAG_ENUM> metaFlags) {
            short val = 0;
            for (TSK_FS_META_FLAG_ENUM flag : metaFlags) {
                val = (short)(val | flag.getValue());
            }
            return val;
        }
    }

    public static enum TSK_FS_NAME_FLAG_ENUM {
        UNKNOWN(0, bundle.getString("TskData.tskFsNameFlagEnum.unknown")),
        ALLOC(1, bundle.getString("TskData.tskFsNameFlagEnum.allocated")),
        UNALLOC(2, bundle.getString("TskData.tskFsNameFlagEnum.unallocated"));

        private short dirFlag;
        private String dirFlagStr;

        private TSK_FS_NAME_FLAG_ENUM(int flag, String dirFlagStr) {
            this.dirFlag = (short)flag;
            this.dirFlagStr = dirFlagStr;
        }

        public short getValue() {
            return this.dirFlag;
        }

        public String toString() {
            return this.dirFlagStr;
        }

        public static TSK_FS_NAME_FLAG_ENUM valueOf(int dirFlag) {
            for (TSK_FS_NAME_FLAG_ENUM flag : TSK_FS_NAME_FLAG_ENUM.values()) {
                if (flag.dirFlag != dirFlag) continue;
                return flag;
            }
            return UNKNOWN;
        }
    }

    public static enum TSK_FS_META_TYPE_ENUM {
        TSK_FS_META_TYPE_UNDEF(0, "-"),
        TSK_FS_META_TYPE_REG(1, "r"),
        TSK_FS_META_TYPE_DIR(2, "d"),
        TSK_FS_META_TYPE_FIFO(3, "p"),
        TSK_FS_META_TYPE_CHR(4, "c"),
        TSK_FS_META_TYPE_BLK(5, "b"),
        TSK_FS_META_TYPE_LNK(6, "l"),
        TSK_FS_META_TYPE_SHAD(7, "s"),
        TSK_FS_META_TYPE_SOCK(8, "h"),
        TSK_FS_META_TYPE_WHT(9, "w"),
        TSK_FS_META_TYPE_VIRT(10, "v"),
        TSK_FS_META_TYPE_VIRT_DIR(11, "v");

        private short metaType;
        private String metaTypeStr;

        private TSK_FS_META_TYPE_ENUM(int type, String metaTypeStr) {
            this.metaType = (short)type;
            this.metaTypeStr = metaTypeStr;
        }

        public short getValue() {
            return this.metaType;
        }

        public String toString() {
            return this.metaTypeStr;
        }

        public static TSK_FS_META_TYPE_ENUM valueOf(short metaType) {
            for (TSK_FS_META_TYPE_ENUM type : TSK_FS_META_TYPE_ENUM.values()) {
                if (type.getValue() != metaType) continue;
                return type;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tskFsMetaTypeEnum.exception.msg1.text"), metaType));
        }
    }

    public static enum TSK_FS_NAME_TYPE_ENUM {
        UNDEF(0, "-"),
        FIFO(1, "p"),
        CHR(2, "c"),
        DIR(3, "d"),
        BLK(4, "b"),
        REG(5, "r"),
        LNK(6, "l"),
        SOCK(7, "s"),
        SHAD(8, "h"),
        WHT(9, "w"),
        VIRT(10, "v"),
        VIRT_DIR(11, "V");

        private short dirType;
        String label;

        private TSK_FS_NAME_TYPE_ENUM(int type, String label) {
            this.dirType = (short)type;
            this.label = label;
        }

        public short getValue() {
            return this.dirType;
        }

        public String getLabel() {
            return this.label;
        }

        public static TSK_FS_NAME_TYPE_ENUM valueOf(short dir_type) {
            for (TSK_FS_NAME_TYPE_ENUM v : TSK_FS_NAME_TYPE_ENUM.values()) {
                if (v.dirType != dir_type) continue;
                return v;
            }
            throw new IllegalArgumentException(MessageFormat.format(bundle.getString("TskData.tskFsNameTypeEnum.exception.msg1.text"), dir_type));
        }
    }
}

