/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.BundleProvider;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TimelineEventType;
import org.sleuthkit.datamodel.TimelineManager;
import org.sleuthkit.datamodel.TskData;

public abstract class TimelineFilter {
    public abstract String getDisplayName();

    abstract String getSQLWhere(TimelineManager var1);

    public abstract TimelineFilter copyOf();

    static <S extends TimelineFilter, T extends CompoundFilter<S>> T copySubFilters(T from, T to) {
        from.getSubFilters().forEach(subFilter -> to.addSubFilter(subFilter.copyOf()));
        return to;
    }

    public static abstract class CompoundFilter<SubFilterType extends TimelineFilter>
    extends TimelineFilter {
        private final List<SubFilterType> subFilters = new ArrayList<SubFilterType>();

        protected void addSubFilter(SubFilterType subfilter) {
            if (!this.getSubFilters().contains(subfilter)) {
                this.getSubFilters().add(subfilter);
            }
        }

        public final List<SubFilterType> getSubFilters() {
            return this.subFilters;
        }

        public boolean hasSubFilters() {
            return !this.getSubFilters().isEmpty();
        }

        protected CompoundFilter(List<SubFilterType> subFilters) {
            this.subFilters.addAll(subFilters);
        }

        @Override
        public abstract CompoundFilter<SubFilterType> copyOf();

        public int hashCode() {
            int hash = 3;
            hash = 23 * hash + Objects.hashCode(this.subFilters);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompoundFilter other = (CompoundFilter)obj;
            return Objects.equals(this.getSubFilters(), other.getSubFilters());
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{subFilters=" + String.valueOf(this.subFilters) + "}";
        }
    }

    public static class FileTypeFilter
    extends TimelineFilter {
        private final String displayName;
        private final String sqlWhere;
        Collection<String> mediaTypes = new HashSet<String>();

        private FileTypeFilter(String displayName, String sql) {
            this.displayName = displayName;
            this.sqlWhere = sql;
        }

        public FileTypeFilter(String displayName, Collection<String> mediaTypes) {
            this(displayName, mediaTypes.stream().map(MediaType::parse).map(FileTypeFilter::mediaTypeToSQL).collect(Collectors.joining(" OR ", "(", ")")));
            this.mediaTypes = mediaTypes;
        }

        private static String mediaTypeToSQL(MediaType mediaType) {
            return mediaType.hasWildcard() ? " (tsk_events.mime_type LIKE '" + SleuthkitCase.escapeSingleQuotes(mediaType.type()) + "/_%' ) " : " (tsk_events.mime_type = '" + SleuthkitCase.escapeSingleQuotes(mediaType.toString()) + "' ) ";
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public FileTypeFilter copyOf() {
            return new FileTypeFilter(this.displayName, this.sqlWhere);
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.displayName);
            hash = 17 * hash + Objects.hashCode(this.sqlWhere);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileTypeFilter other = (FileTypeFilter)obj;
            if (ObjectUtils.notEqual((Object)this.displayName, (Object)other.displayName)) {
                return false;
            }
            return Objects.equals(this.sqlWhere, other.sqlWhere);
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            return this.sqlWhere;
        }

        public String toString() {
            return "FileTypeFilter{displayName=" + this.displayName + ", sqlWhere=" + this.sqlWhere + "}";
        }
    }

    public static class InverseFileTypeFilter
    extends FileTypeFilter {
        public InverseFileTypeFilter(String displayName, Collection<String> mediaTypes) {
            super(displayName, mediaTypes);
        }

        @Override
        public InverseFileTypeFilter copyOf() {
            return new InverseFileTypeFilter(this.getDisplayName(), this.mediaTypes);
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            return " NOT " + super.getSQLWhere(manager);
        }
    }

    public static final class FileTypesFilter
    extends UnionFilter<FileTypeFilter> {
        @Override
        public FileTypesFilter copyOf() {
            return FileTypesFilter.copySubFilters(this, new FileTypesFilter());
        }

        @Override
        public String getDisplayName() {
            return BundleProvider.getBundle().getString("FileTypesFilter.displayName.text");
        }
    }

    public static final class DataSourcesFilter
    extends UnionFilter<DataSourceFilter> {
        @Override
        public DataSourcesFilter copyOf() {
            return DataSourcesFilter.copySubFilters(this, new DataSourcesFilter());
        }

        @Override
        public String getDisplayName() {
            return BundleProvider.getBundle().getString("DataSourcesFilter.displayName.text");
        }
    }

    public static final class HashHitsFilter
    extends TimelineFilter {
        private boolean eventSourcesHaveHashSetHits;

        public HashHitsFilter() {
        }

        public HashHitsFilter(boolean eventSourcesHaveHashSetHits) {
            this.eventSourcesHaveHashSetHits = eventSourcesHaveHashSetHits;
        }

        public synchronized void setEventSourcesHaveHashSetHits(boolean eventSourcesHaveHashSetHits) {
            this.eventSourcesHaveHashSetHits = eventSourcesHaveHashSetHits;
        }

        public synchronized boolean getEventSourcesHaveHashSetHits() {
            return this.eventSourcesHaveHashSetHits;
        }

        @Override
        public String getDisplayName() {
            return BundleProvider.getBundle().getString("hashHitsFilter.displayName.text");
        }

        @Override
        public HashHitsFilter copyOf() {
            return new HashHitsFilter(this.eventSourcesHaveHashSetHits);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HashHitsFilter)) {
                return false;
            }
            return ((HashHitsFilter)obj).getEventSourcesHaveHashSetHits() == this.getEventSourcesHaveHashSetHits();
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + Objects.hashCode(this.eventSourcesHaveHashSetHits);
            return hash;
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            String whereStr = "";
            whereStr = this.eventSourcesHaveHashSetHits ? "hash_hit = 1" : "hash_hit = 0";
            return whereStr;
        }
    }

    public static final class DataSourceFilter
    extends TimelineFilter {
        private final String dataSourceName;
        private final long dataSourceID;

        public long getDataSourceID() {
            return this.dataSourceID;
        }

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public DataSourceFilter(String dataSourceName, long dataSourceID) {
            this.dataSourceName = dataSourceName;
            this.dataSourceID = dataSourceID;
        }

        @Override
        public synchronized DataSourceFilter copyOf() {
            return new DataSourceFilter(this.getDataSourceName(), this.getDataSourceID());
        }

        @Override
        public String getDisplayName() {
            return this.getDataSourceName() + " (ID: " + this.getDataSourceID() + ")";
        }

        public int hashCode() {
            int hash = 3;
            hash = 47 * hash + Objects.hashCode(this.dataSourceName);
            hash = 47 * hash + (int)(this.dataSourceID ^ this.dataSourceID >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataSourceFilter other = (DataSourceFilter)obj;
            if (this.dataSourceID != other.dataSourceID) {
                return false;
            }
            return Objects.equals(this.dataSourceName, other.dataSourceName);
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            return "(data_source_obj_id = '" + this.getDataSourceID() + "')";
        }
    }

    public static final class HideKnownFilter
    extends TimelineFilter {
        @Override
        public String getDisplayName() {
            return BundleProvider.getBundle().getString("hideKnownFilter.displayName.text");
        }

        @Override
        public HideKnownFilter copyOf() {
            return new HideKnownFilter();
        }

        public int hashCode() {
            return 7;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            return "(known_state != " + TskData.FileKnown.KNOWN.getFileKnownValue() + ")";
        }

        public String toString() {
            return "HideKnownFilter{}";
        }
    }

    public static final class RootFilter
    extends IntersectionFilter<TimelineFilter> {
        private final HideKnownFilter knownFilesFilter;
        private final TagsFilter tagsFilter;
        private final HashHitsFilter hashSetHitsFilter;
        private final TextFilter descriptionSubstringFilter;
        private final EventTypeFilter eventTypesFilter;
        private final DataSourcesFilter dataSourcesFilter;
        private final FileTypesFilter fileTypesFilter;
        private final Set<TimelineFilter> additionalFilters = new HashSet<TimelineFilter>();

        public DataSourcesFilter getDataSourcesFilter() {
            return this.dataSourcesFilter;
        }

        public TagsFilter getTagsFilter() {
            return this.tagsFilter;
        }

        public HashHitsFilter getHashHitsFilter() {
            return this.hashSetHitsFilter;
        }

        public EventTypeFilter getEventTypeFilter() {
            return this.eventTypesFilter;
        }

        public HideKnownFilter getKnownFilter() {
            return this.knownFilesFilter;
        }

        public TextFilter getTextFilter() {
            return this.descriptionSubstringFilter;
        }

        public FileTypesFilter getFileTypesFilter() {
            return this.fileTypesFilter;
        }

        public RootFilter(HideKnownFilter knownFilesFilter, TagsFilter tagsFilter, HashHitsFilter hashSetHitsFilter, TextFilter descriptionSubstringFilter, EventTypeFilter eventTypesFilter, DataSourcesFilter dataSourcesFilter, FileTypesFilter fileTypesFilter, Collection<TimelineFilter> additionalFilters) {
            super(Arrays.asList(descriptionSubstringFilter, knownFilesFilter, tagsFilter, dataSourcesFilter, hashSetHitsFilter, fileTypesFilter, eventTypesFilter));
            this.getSubFilters().removeIf(Objects::isNull);
            this.knownFilesFilter = knownFilesFilter;
            this.tagsFilter = tagsFilter;
            this.hashSetHitsFilter = hashSetHitsFilter;
            this.descriptionSubstringFilter = descriptionSubstringFilter;
            this.eventTypesFilter = eventTypesFilter;
            this.dataSourcesFilter = dataSourcesFilter;
            this.fileTypesFilter = fileTypesFilter;
            this.additionalFilters.addAll(Arrays.asList(descriptionSubstringFilter, knownFilesFilter, tagsFilter, dataSourcesFilter, hashSetHitsFilter, fileTypesFilter, eventTypesFilter));
            this.additionalFilters.removeIf(Objects::isNull);
            additionalFilters.stream().filter(Objects::nonNull).filter(this::hasAdditionalFilter).map(TimelineFilter::copyOf).forEach(anonymousFilter -> this.getSubFilters().add(anonymousFilter));
        }

        @Override
        public RootFilter copyOf() {
            Set<TimelineFilter> subFilters = this.getSubFilters().stream().filter(this::hasAdditionalFilter).map(TimelineFilter::copyOf).collect(Collectors.toSet());
            return new RootFilter(this.knownFilesFilter.copyOf(), this.tagsFilter.copyOf(), this.hashSetHitsFilter.copyOf(), this.descriptionSubstringFilter.copyOf(), this.eventTypesFilter.copyOf(), this.dataSourcesFilter.copyOf(), this.fileTypesFilter.copyOf(), subFilters);
        }

        private boolean hasAdditionalFilter(TimelineFilter subFilter) {
            return !this.additionalFilters.contains(subFilter);
        }

        @Override
        public String toString() {
            return "RootFilter{knownFilter=" + String.valueOf(this.knownFilesFilter) + ", tagsFilter=" + String.valueOf(this.tagsFilter) + ", hashFilter=" + String.valueOf(this.hashSetHitsFilter) + ", textFilter=" + String.valueOf(this.descriptionSubstringFilter) + ", typeFilter=" + String.valueOf(this.eventTypesFilter) + ", dataSourcesFilter=" + String.valueOf(this.dataSourcesFilter) + ", fileTypesFilter=" + String.valueOf(this.fileTypesFilter) + ", namedSubFilters=" + String.valueOf(this.additionalFilters) + "}";
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.knownFilesFilter);
            hash = 17 * hash + Objects.hashCode(this.tagsFilter);
            hash = 17 * hash + Objects.hashCode(this.hashSetHitsFilter);
            hash = 17 * hash + Objects.hashCode(this.descriptionSubstringFilter);
            hash = 17 * hash + Objects.hashCode(this.eventTypesFilter);
            hash = 17 * hash + Objects.hashCode(this.dataSourcesFilter);
            hash = 17 * hash + Objects.hashCode(this.fileTypesFilter);
            hash = 17 * hash + Objects.hashCode(this.additionalFilters);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RootFilter other = (RootFilter)obj;
            if (ObjectUtils.notEqual((Object)this.knownFilesFilter, (Object)other.getKnownFilter())) {
                return false;
            }
            if (ObjectUtils.notEqual((Object)this.tagsFilter, (Object)other.getTagsFilter())) {
                return false;
            }
            if (ObjectUtils.notEqual((Object)this.hashSetHitsFilter, (Object)other.getHashHitsFilter())) {
                return false;
            }
            if (ObjectUtils.notEqual((Object)this.descriptionSubstringFilter, (Object)other.getTextFilter())) {
                return false;
            }
            if (ObjectUtils.notEqual((Object)this.eventTypesFilter, (Object)other.getEventTypeFilter())) {
                return false;
            }
            if (ObjectUtils.notEqual((Object)this.dataSourcesFilter, (Object)other.getDataSourcesFilter())) {
                return false;
            }
            if (ObjectUtils.notEqual((Object)this.fileTypesFilter, (Object)other.getFileTypesFilter())) {
                return false;
            }
            return Objects.equals(this.additionalFilters, new HashSet(other.getSubFilters()));
        }
    }

    public static final class TextFilter
    extends TimelineFilter {
        private String descriptionSubstring;

        public TextFilter() {
            this("");
        }

        public TextFilter(String descriptionSubstring) {
            this.descriptionSubstring = descriptionSubstring.trim();
        }

        public synchronized void setDescriptionSubstring(String descriptionSubstring) {
            this.descriptionSubstring = descriptionSubstring.trim();
        }

        @Override
        public String getDisplayName() {
            return BundleProvider.getBundle().getString("TextFilter.displayName.text");
        }

        public synchronized String getDescriptionSubstring() {
            return this.descriptionSubstring;
        }

        @Override
        public synchronized TextFilter copyOf() {
            return new TextFilter(this.getDescriptionSubstring());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TextFilter other = (TextFilter)obj;
            return Objects.equals(this.getDescriptionSubstring(), other.getDescriptionSubstring());
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + Objects.hashCode(this.descriptionSubstring);
            return hash;
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            if (StringUtils.isNotBlank((CharSequence)this.getDescriptionSubstring())) {
                return "((med_description like '%" + SleuthkitCase.escapeSingleQuotes(this.getDescriptionSubstring()) + "%') or (full_description like '%" + SleuthkitCase.escapeSingleQuotes(this.getDescriptionSubstring()) + "%') or (short_description like '%" + SleuthkitCase.escapeSingleQuotes(this.getDescriptionSubstring()) + "%'))";
            }
            return manager.getSQLWhere(null);
        }

        public String toString() {
            return "TextFilter{textProperty=" + this.descriptionSubstring + "}";
        }
    }

    public static abstract class UnionFilter<SubFilterType extends TimelineFilter>
    extends CompoundFilter<SubFilterType> {
        UnionFilter(List<SubFilterType> subFilters) {
            super(subFilters);
        }

        UnionFilter() {
            super(new ArrayList());
        }

        @Override
        public void addSubFilter(SubFilterType subfilter) {
            super.addSubFilter(subfilter);
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            String join = this.getSubFilters().stream().map(subFilter -> subFilter.getSQLWhere(manager)).collect(Collectors.joining(" OR "));
            return join.isEmpty() ? manager.getSQLWhere(null) : "(" + join + ")";
        }
    }

    public static final class TagsFilter
    extends TimelineFilter {
        private boolean eventSourcesAreTagged;

        public TagsFilter() {
        }

        public TagsFilter(boolean eventSourcesAreTagged) {
            this.eventSourcesAreTagged = eventSourcesAreTagged;
        }

        public synchronized void setEventSourcesAreTagged(boolean eventSourcesAreTagged) {
            this.eventSourcesAreTagged = eventSourcesAreTagged;
        }

        public synchronized boolean getEventSourceAreTagged() {
            return this.eventSourcesAreTagged;
        }

        @Override
        public String getDisplayName() {
            return BundleProvider.getBundle().getString("tagsFilter.displayName.text");
        }

        @Override
        public TagsFilter copyOf() {
            return new TagsFilter(this.eventSourcesAreTagged);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TagsFilter)) {
                return false;
            }
            return ((TagsFilter)obj).getEventSourceAreTagged() == this.getEventSourceAreTagged();
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + Objects.hashCode(this.eventSourcesAreTagged);
            return hash;
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            String whereStr = this.eventSourcesAreTagged ? "tagged = 1" : "tagged = 0";
            return whereStr;
        }
    }

    public static final class EventTypeFilter
    extends UnionFilter<EventTypeFilter> {
        private final TimelineEventType rootEventType;

        private EventTypeFilter(TimelineEventType rootEventType, boolean recursive) {
            super(new ArrayList());
            this.rootEventType = rootEventType;
            if (recursive) {
                for (TimelineEventType timelineEventType : rootEventType.getChildren()) {
                    if (timelineEventType.isDeprecated()) continue;
                    this.addSubFilter(new EventTypeFilter(timelineEventType));
                }
            }
        }

        public EventTypeFilter(TimelineEventType rootEventType) {
            this(rootEventType, true);
        }

        public TimelineEventType getRootEventType() {
            return this.rootEventType;
        }

        @Override
        public String getDisplayName() {
            return TimelineEventType.ROOT_EVENT_TYPE.equals(this.rootEventType) ? BundleProvider.getBundle().getString("TypeFilter.displayName.text") : this.rootEventType.getDisplayName();
        }

        @Override
        public EventTypeFilter copyOf() {
            return EventTypeFilter.copySubFilters(this, new EventTypeFilter(this.rootEventType, false));
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.rootEventType);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventTypeFilter other = (EventTypeFilter)obj;
            if (ObjectUtils.notEqual((Object)this.rootEventType, (Object)other.getRootEventType())) {
                return false;
            }
            return Objects.equals(this.getSubFilters(), other.getSubFilters());
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            return "(tsk_events.event_type_id IN (" + this.getSubTypeIDs().collect(Collectors.joining(",")) + "))";
        }

        private Stream<String> getSubTypeIDs() {
            if (this.getSubFilters().isEmpty()) {
                return Stream.of(String.valueOf(this.getRootEventType().getTypeID()));
            }
            return this.getSubFilters().stream().flatMap(EventTypeFilter::getSubTypeIDs);
        }

        @Override
        public String toString() {
            return "EventTypeFilter{rootEventType=" + String.valueOf(this.rootEventType) + ", subfilters=" + String.valueOf(this.getSubFilters()) + "}";
        }
    }

    public static class IntersectionFilter<SubFilterType extends TimelineFilter>
    extends CompoundFilter<SubFilterType> {
        @VisibleForTesting
        public IntersectionFilter(List<SubFilterType> subFilters) {
            super(subFilters);
        }

        @Override
        public IntersectionFilter<SubFilterType> copyOf() {
            List subfilters = Lists.transform(this.getSubFilters(), f -> f.copyOf());
            return new IntersectionFilter<SubFilterType>(subfilters);
        }

        @Override
        public String getDisplayName() {
            String subFilterDisplayNames = this.getSubFilters().stream().map(TimelineFilter::getDisplayName).collect(Collectors.joining(","));
            return BundleProvider.getBundle().getString("IntersectionFilter.displayName.text") + "[" + subFilterDisplayNames + "]";
        }

        @Override
        String getSQLWhere(TimelineManager manager) {
            String trueLiteral = manager.getSQLWhere(null);
            String join = this.getSubFilters().stream().filter(Objects::nonNull).map(filter -> filter.getSQLWhere(manager)).filter(sqlString -> ObjectUtils.notEqual((Object)sqlString, (Object)trueLiteral)).collect(Collectors.joining(" AND "));
            return join.isEmpty() ? trueLiteral : "(" + join + ")";
        }
    }
}

