/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.net.InternetDomainName;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.TimelineEventDescriptionWithTime;
import org.sleuthkit.datamodel.TimelineEventType;
import org.sleuthkit.datamodel.TimelineEventTypeImpl;
import org.sleuthkit.datamodel.TskCoreException;

class TimelineEventArtifactTypeImpl
extends TimelineEventTypeImpl {
    private static final Logger logger = Logger.getLogger(TimelineEventArtifactTypeImpl.class.getName());
    static final int EMAIL_FULL_DESCRIPTION_LENGTH_MAX = 150;
    static final int EMAIL_TO_FROM_LENGTH_MAX = 75;
    private final BlackboardArtifact.Type artifactType;
    private final BlackboardAttribute.Type dateTimeAttributeType;
    private final TSKCoreCheckedFunction<BlackboardArtifact, String> fullExtractor;
    private final TSKCoreCheckedFunction<BlackboardArtifact, String> medExtractor;
    private final TSKCoreCheckedFunction<BlackboardArtifact, String> shortExtractor;
    private final TSKCoreCheckedFunction<BlackboardArtifact, TimelineEventDescriptionWithTime> artifactParsingFunction;
    protected static final int MAX_SHORT_DESCRIPTION_LENGTH = 500;
    protected static final int MAX_MED_DESCRIPTION_LENGTH = 500;
    protected static final int MAX_FULL_DESCRIPTION_LENGTH = 1024;

    TimelineEventArtifactTypeImpl(int typeID, String displayName, TimelineEventType superType, BlackboardArtifact.Type artifactType, BlackboardAttribute.Type dateTimeAttributeType, TSKCoreCheckedFunction<BlackboardArtifact, String> shortExtractor, TSKCoreCheckedFunction<BlackboardArtifact, String> medExtractor, TSKCoreCheckedFunction<BlackboardArtifact, String> fullExtractor) {
        this(typeID, displayName, superType, artifactType, dateTimeAttributeType, shortExtractor, medExtractor, fullExtractor, null);
    }

    TimelineEventArtifactTypeImpl(int typeID, String displayName, TimelineEventType superType, BlackboardArtifact.Type artifactType, BlackboardAttribute.Type dateTimeAttributeType, TSKCoreCheckedFunction<BlackboardArtifact, String> shortExtractor, TSKCoreCheckedFunction<BlackboardArtifact, String> medExtractor, TSKCoreCheckedFunction<BlackboardArtifact, String> fullExtractor, TSKCoreCheckedFunction<BlackboardArtifact, TimelineEventDescriptionWithTime> eventPayloadFunction) {
        super(typeID, displayName, TimelineEventType.HierarchyLevel.EVENT, superType);
        this.artifactType = artifactType;
        this.dateTimeAttributeType = dateTimeAttributeType;
        this.shortExtractor = shortExtractor;
        this.medExtractor = medExtractor;
        this.fullExtractor = fullExtractor;
        this.artifactParsingFunction = eventPayloadFunction;
    }

    int getArtifactTypeID() {
        return this.getArtifactType().getTypeID();
    }

    BlackboardAttribute.Type getDateTimeAttributeType() {
        return this.dateTimeAttributeType;
    }

    String extractFullDescription(BlackboardArtifact artf) throws TskCoreException {
        return this.fullExtractor.apply(artf);
    }

    String extractMedDescription(BlackboardArtifact artf) throws TskCoreException {
        return this.medExtractor.apply(artf);
    }

    String extractShortDescription(BlackboardArtifact artf) throws TskCoreException {
        return this.shortExtractor.apply(artf);
    }

    BlackboardArtifact.Type getArtifactType() {
        return this.artifactType;
    }

    TimelineEventDescriptionWithTime makeEventDescription(BlackboardArtifact artifact) throws TskCoreException {
        Object fullDescription;
        Object medDescription;
        if (this.getArtifactTypeID() != artifact.getArtifactTypeID()) {
            throw new IllegalArgumentException();
        }
        BlackboardAttribute timeAttribute = artifact.getAttribute(this.getDateTimeAttributeType());
        if (timeAttribute == null) {
            return null;
        }
        if (this.artifactParsingFunction != null) {
            return this.artifactParsingFunction.apply(artifact);
        }
        String shortDescription = this.extractShortDescription(artifact);
        if (shortDescription.length() > 500) {
            shortDescription = shortDescription.substring(0, 500);
        }
        if (((String)(medDescription = shortDescription + " : " + this.extractMedDescription(artifact))).length() > 500) {
            medDescription = ((String)medDescription).substring(0, 500);
        }
        if (((String)(fullDescription = (String)medDescription + " : " + this.extractFullDescription(artifact))).length() > 1024) {
            fullDescription = ((String)fullDescription).substring(0, 1024);
        }
        return new TimelineEventDescriptionWithTime(timeAttribute.getValueLong(), shortDescription, (String)medDescription, (String)fullDescription);
    }

    static BlackboardAttribute getAttributeSafe(BlackboardArtifact artf, BlackboardAttribute.Type attrType) {
        try {
            return artf.getAttribute(attrType);
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, MessageFormat.format("Error getting attribute from artifact {0}.", artf.getArtifactID()), ex);
            return null;
        }
    }

    @FunctionalInterface
    static interface TSKCoreCheckedFunction<I, O> {
        public O apply(I var1) throws TskCoreException;
    }

    static final class TopPrivateDomainExtractor
    extends AttributeExtractor {
        private static final TopPrivateDomainExtractor instance = new TopPrivateDomainExtractor();

        static TopPrivateDomainExtractor getInstance() {
            return instance;
        }

        TopPrivateDomainExtractor() {
            super(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN));
        }

        @Override
        public String apply(BlackboardArtifact artf) throws TskCoreException {
            String domainString = StringUtils.substringBefore((String)super.apply(artf), (String)"/");
            if (InternetDomainName.isValid((String)domainString)) {
                InternetDomainName domain = InternetDomainName.from((String)domainString);
                return domain.isUnderPublicSuffix() ? domain.topPrivateDomain().toString() : domain.toString();
            }
            return domainString;
        }
    }

    static class AttributeExtractor
    implements TSKCoreCheckedFunction<BlackboardArtifact, String> {
        private final BlackboardAttribute.Type attributeType;

        AttributeExtractor(BlackboardAttribute.Type attribute) {
            this.attributeType = attribute;
        }

        @Override
        public String apply(BlackboardArtifact artf) throws TskCoreException {
            return Optional.ofNullable(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, this.attributeType)).map(BlackboardAttribute::getDisplayString).orElse("");
        }
    }
}

