/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Optional;
import org.sleuthkit.datamodel.TimelineEventDescription;
import org.sleuthkit.datamodel.TimelineEventType;
import org.sleuthkit.datamodel.TimelineEventTypeImpl;
import org.sleuthkit.datamodel.TimelineLevelOfDetail;

public final class TimelineEvent {
    private final long eventID;
    private final long contentObjID;
    private final Long artifactID;
    private final long dataSourceObjID;
    private final long time;
    private final TimelineEventType type;
    private final TimelineEventDescription descriptions;
    private final boolean eventSourceHashHitDetected;
    private final boolean eventSourceTagged;

    TimelineEvent(long eventID, long dataSourceObjID, long contentObjID, Long artifactID, long time, TimelineEventType type, String fullDescription, String medDescription, String shortDescription, boolean eventSourceHashHitDetected, boolean eventSourceTagged) {
        this.eventID = eventID;
        this.dataSourceObjID = dataSourceObjID;
        this.contentObjID = contentObjID;
        this.artifactID = Long.valueOf(0L).equals(artifactID) ? null : artifactID;
        this.time = time;
        this.type = type;
        this.descriptions = type instanceof TimelineEventTypeImpl ? ((TimelineEventTypeImpl)type).parseDescription(fullDescription, medDescription, shortDescription) : new TimelineEventDescription(fullDescription, medDescription, shortDescription);
        this.eventSourceHashHitDetected = eventSourceHashHitDetected;
        this.eventSourceTagged = eventSourceTagged;
    }

    public boolean eventSourceIsTagged() {
        return this.eventSourceTagged;
    }

    public boolean eventSourceHasHashHits() {
        return this.eventSourceHashHitDetected;
    }

    public Optional<Long> getArtifactID() {
        return Optional.ofNullable(this.artifactID);
    }

    public long getEventID() {
        return this.eventID;
    }

    public long getContentObjID() {
        return this.contentObjID;
    }

    public long getTime() {
        return this.time;
    }

    public TimelineEventType getEventType() {
        return this.type;
    }

    public String getDescription(TimelineLevelOfDetail levelOfDetail) {
        return this.descriptions.getDescription(levelOfDetail);
    }

    public long getDataSourceObjID() {
        return this.dataSourceObjID;
    }

    public long getEventTimeInMs() {
        return this.time * 1000L;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (int)(this.eventID ^ this.eventID >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineEvent other = (TimelineEvent)obj;
        return this.eventID == other.getEventID();
    }
}

