/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Objects;

public final class Host {
    private final long id;
    private final String name;
    private final HostDbStatus status;

    Host(long id, String name) {
        this(id, name, HostDbStatus.ACTIVE);
    }

    Host(long id, String name, HostDbStatus status) {
        this.id = id;
        this.name = name;
        this.status = status;
    }

    public long getHostId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    HostDbStatus getStatus() {
        return this.status;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (int)(this.id ^ this.id >>> 32);
        hash = 67 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Host other = (Host)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    static enum HostDbStatus {
        ACTIVE(0, "Active"),
        MERGED(1, "Merged"),
        DELETED(2, "Deleted");

        private final int id;
        private final String name;

        private HostDbStatus(int id, String name) {
            this.id = id;
            this.name = name;
        }

        int getId() {
            return this.id;
        }

        String getName() {
            return this.name;
        }

        static HostDbStatus fromID(int typeId) {
            for (HostDbStatus type : HostDbStatus.values()) {
                if (type.ordinal() != typeId) continue;
                return type;
            }
            return null;
        }
    }
}

