/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.Account;
import org.sleuthkit.datamodel.InvalidAccountIDException;

public final class CommunicationsUtils {
    private static final Set<String> TELEPHONY_CHARS = new HashSet<String>(Arrays.asList("-", "(", ")", "#", "*", ","));
    private static final int MIN_PHONENUMBER_LEN = 3;

    private CommunicationsUtils() {
    }

    public static String normalizePhoneNum(String phoneNumber) throws InvalidAccountIDException {
        if (StringUtils.isEmpty((CharSequence)phoneNumber)) {
            throw new InvalidAccountIDException(String.format("Input phone number is empty or null.", new Object[0]));
        }
        if (!CommunicationsUtils.isValidPhoneNumber(phoneNumber)) {
            throw new InvalidAccountIDException(String.format("Input string is not a valid phone number: %s", phoneNumber));
        }
        String normalizedNumber = phoneNumber.trim();
        normalizedNumber = normalizedNumber.replaceAll("\\s+", "");
        if ((normalizedNumber = normalizedNumber.replaceAll("[\\-()]", "")).length() < 3) {
            throw new InvalidAccountIDException("Invalid phone number string " + phoneNumber);
        }
        return normalizedNumber;
    }

    public static String normalizeEmailAddress(String emailAddress) throws InvalidAccountIDException {
        if (StringUtils.isEmpty((CharSequence)emailAddress)) {
            throw new InvalidAccountIDException(String.format("Input email address is empty or null.", new Object[0]));
        }
        if (!CommunicationsUtils.isValidEmailAddress(emailAddress)) {
            throw new InvalidAccountIDException(String.format("Input string is not a valid email address: %s", emailAddress));
        }
        return emailAddress.toLowerCase().replace(";", "").trim();
    }

    public static boolean isValidAccountId(Account.Type accountType, String accountUniqueID) {
        if (accountType == Account.Type.PHONE) {
            return CommunicationsUtils.isValidPhoneNumber(accountUniqueID);
        }
        if (accountType == Account.Type.EMAIL) {
            return CommunicationsUtils.isValidEmailAddress(accountUniqueID);
        }
        return !StringUtils.isEmpty((CharSequence)accountUniqueID);
    }

    public static boolean isValidPhoneNumber(String phoneNum) {
        if (StringUtils.isEmpty((CharSequence)phoneNum)) {
            return false;
        }
        String trimmedPhoneNum = phoneNum.trim();
        for (int i = 0; i < trimmedPhoneNum.length(); ++i) {
            if (trimmedPhoneNum.charAt(i) == '+' && i == 0 || CommunicationsUtils.isValidPhoneChar(trimmedPhoneNum.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPhoneChar(char ch) {
        return Character.isSpaceChar(ch) || Character.isDigit(ch) || TELEPHONY_CHARS.contains(String.valueOf(ch));
    }

    public static boolean isValidEmailAddress(String emailAddress) {
        if (StringUtils.isEmpty((CharSequence)emailAddress)) {
            return false;
        }
        if (!emailAddress.contains("@") || !emailAddress.contains(".")) {
            return false;
        }
        String[] tokens = emailAddress.split("@");
        if (tokens.length < 2 || StringUtils.isEmpty((CharSequence)tokens[0]) || StringUtils.isEmpty((CharSequence)tokens[1])) {
            return false;
        }
        String[] tokens2 = tokens[1].split("\\.");
        return tokens2.length >= 2 && !StringUtils.isEmpty((CharSequence)tokens2[0]) && !StringUtils.isEmpty((CharSequence)tokens2[1]);
    }
}

