/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Arrays;
import java.util.Objects;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TimeUtilities;

public abstract class AbstractAttribute {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private final BlackboardAttribute.Type attributeType;
    private final int valueInt;
    private final long valueLong;
    private final double valueDouble;
    private final String valueString;
    private final byte[] valueBytes;
    private SleuthkitCase sleuthkitCase;

    public AbstractAttribute(BlackboardAttribute.Type attributeType, int valueInt) {
        if (attributeType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.attributeType = attributeType;
        this.valueInt = valueInt;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = new byte[0];
    }

    public AbstractAttribute(BlackboardAttribute.Type attributeType, long valueLong) {
        if (attributeType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG && attributeType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.attributeType = attributeType;
        this.valueInt = 0;
        this.valueLong = valueLong;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = new byte[0];
    }

    public AbstractAttribute(BlackboardAttribute.Type attributeType, double valueDouble) {
        if (attributeType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.attributeType = attributeType;
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = valueDouble;
        this.valueString = "";
        this.valueBytes = new byte[0];
    }

    public AbstractAttribute(BlackboardAttribute.Type attributeType, String valueString) {
        if (attributeType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING && attributeType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.attributeType = attributeType;
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = valueString == null ? "" : AbstractAttribute.replaceNulls(valueString).trim();
        this.valueBytes = new byte[0];
    }

    public AbstractAttribute(BlackboardAttribute.Type attributeType, byte[] valueBytes) {
        if (attributeType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE) {
            throw new IllegalArgumentException("Type mismatched with value type");
        }
        this.attributeType = attributeType;
        this.valueInt = 0;
        this.valueLong = 0L;
        this.valueDouble = 0.0;
        this.valueString = "";
        this.valueBytes = valueBytes == null ? new byte[0] : valueBytes;
    }

    AbstractAttribute(BlackboardAttribute.Type attributeType, int valueInt, long valueLong, double valueDouble, String valueString, byte[] valueBytes, SleuthkitCase sleuthkitCase) {
        this.attributeType = attributeType;
        this.valueInt = valueInt;
        this.valueLong = valueLong;
        this.valueDouble = valueDouble;
        this.valueString = valueString == null ? "" : AbstractAttribute.replaceNulls(valueString).trim();
        this.valueBytes = valueBytes == null ? new byte[0] : valueBytes;
        this.sleuthkitCase = sleuthkitCase;
    }

    public String getDisplayString() {
        switch (this.attributeType.getValueType()) {
            case STRING: {
                return this.getValueString();
            }
            case INTEGER: {
                if (this.attributeType.getTypeID() == BlackboardAttribute.ATTRIBUTE_TYPE.TSK_READ_STATUS.getTypeID()) {
                    if (this.getValueInt() == 0) {
                        return "Unread";
                    }
                    return "Read";
                }
                return Integer.toString(this.getValueInt());
            }
            case LONG: {
                return Long.toString(this.getValueLong());
            }
            case DOUBLE: {
                return Double.toString(this.getValueDouble());
            }
            case BYTE: {
                return AbstractAttribute.bytesToHexString(this.getValueBytes());
            }
            case DATETIME: {
                return TimeUtilities.epochToTime(this.getValueLong());
            }
            case JSON: {
                return this.getValueString();
            }
        }
        return "";
    }

    public BlackboardAttribute.Type getAttributeType() {
        return this.attributeType;
    }

    public BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE getValueType() {
        return this.attributeType.getValueType();
    }

    public int getValueInt() {
        return this.valueInt;
    }

    public long getValueLong() {
        return this.valueLong;
    }

    public double getValueDouble() {
        return this.valueDouble;
    }

    public String getValueString() {
        return this.valueString;
    }

    public byte[] getValueBytes() {
        return Arrays.copyOf(this.valueBytes, this.valueBytes.length);
    }

    SleuthkitCase getCaseDatabase() {
        return this.sleuthkitCase;
    }

    void setCaseDatabase(SleuthkitCase sleuthkitCase) {
        this.sleuthkitCase = sleuthkitCase;
    }

    static String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    static String replaceNulls(String text) {
        return text.replace('\u0000', '\u001a');
    }

    boolean areValuesEqual(Object that) {
        if (that instanceof AbstractAttribute) {
            AbstractAttribute other = (AbstractAttribute)that;
            Object[] thisObject = new Object[]{this.getAttributeType(), this.getValueInt(), this.getValueLong(), this.getValueDouble(), this.getValueString(), this.getValueBytes()};
            Object[] otherObject = new Object[]{other.getAttributeType(), other.getValueInt(), other.getValueLong(), other.getValueDouble(), other.getValueString(), other.getValueBytes()};
            return Objects.deepEquals(thisObject, otherObject);
        }
        return false;
    }
}

