/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jpype.html.AttrParser;
import org.jpype.html.HtmlParser;
import org.jpype.html.Parser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class Html {
    public static final HashSet<String> VOID_ELEMENTS = new HashSet();
    public static final HashSet<String> OPTIONAL_ELEMENTS = new HashSet();
    public static final HashSet<String> OPTIONAL_CLOSE = new HashSet();
    public static Map<String, Integer> ENTITIES;

    public static Parser<Document> newParser() {
        return new HtmlParser();
    }

    public static List<Attr> parseAttributes(Document document, String string) {
        AttrParser attrParser = new AttrParser(document);
        attrParser.parse(string);
        return attrParser.attrs;
    }

    public static String decode(String string) {
        int n;
        int n2;
        if (!string.contains("&")) {
            return string;
        }
        int n3 = 0;
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (byArray[n2] != 38) continue;
            int n4 = n2;
            n = n2 + 1;
            if (n == byArray.length) break;
            if (byArray[n] == 35) {
                for (n2 = n + 1; n2 < byArray.length && Character.isDigit(byArray[n2]); ++n2) {
                }
            } else {
                for (n2 = n; n2 < byArray.length && byArray[n2] != 59; ++n2) {
                }
            }
            int n5 = n2;
            int n6 = 0;
            if (byArray[n] == 35) {
                ++n;
                try {
                    n6 = Integer.parseInt(new String(byArray, n, n5 - n, StandardCharsets.UTF_8));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                String string2 = new String(byArray, n, n5 - n, StandardCharsets.UTF_8);
                Integer n7 = ENTITIES.get(string2);
                if (n7 == null) {
                    throw new RuntimeException("Bad entity " + string2);
                }
                n6 = n7;
            }
            if (n6 < 128) {
                byArray[n4++] = (byte)n6;
            } else if (n6 < 2048) {
                byArray[n4++] = (byte)(192 + (n6 >> 6 & 0x1F));
                if (n4 < byArray.length) {
                    byArray[n4++] = (byte)(128 + (n6 & 0x3F));
                }
            } else {
                byArray[n4++] = (byte)(224 + (n6 >> 12 & 0xF));
                if (n4 < byArray.length) {
                    byArray[n4++] = (byte)(128 + (n6 >> 6 & 0x3F));
                }
                if (n4 < byArray.length) {
                    byArray[n4++] = (byte)(128 + (n6 & 0x3F));
                }
            }
            if (n5 < byArray.length && byArray[n5] == 59) {
                ++n5;
            }
            n3 += n5 - n4;
            while (n4 < n5) {
                byArray[n4] = 0;
                ++n4;
            }
            n2 = n5;
        }
        n2 = 0;
        byte[] byArray2 = new byte[byArray.length - n3];
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == 0) continue;
            byArray2[n2++] = byArray[n];
        }
        return new String(byArray2, StandardCharsets.UTF_8);
    }

    static {
        VOID_ELEMENTS.addAll(Arrays.asList("area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"));
        OPTIONAL_ELEMENTS.addAll(Arrays.asList("html", "head", "body", "p", "dt", "dd", "li", "option", "thead", "th", "tbody", "tr", "td", "tfoot", "colgroup"));
        OPTIONAL_CLOSE.addAll(Arrays.asList("li:li", "dt:dd", "p:address", "p:article", "p:aside", "p:blockquote", "p:details", "p:div", "p:dl", "p:fieldset", "p:figcaption", "p:figure", "p:footer", "p:form", "p:h1", "p:h2", "p:h3", "p:h4", "p:h5", "p:h6", "p:header", "p:hgroup", "p:hr", "p:main", "p:menu", "p:nav", "p:ol", "p:p", "p:pre", "p:section", "p:table", "p:ul", "dd:dt", "dd:dd", "dt:dt", "dt:dd", "rt:rt", "rt:rp", "rp:rt", "rp:rp", "optgroup:optgroup", "option:option", "option:optiongroup", "thread:tbody", "thread:tfoot", "tbody:tfoot", "tbody:tbody", "tr:tr", "td:td", "td:th", "th:td", "p:li"));
        ENTITIES = new HashMap<String, Integer>();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("org/jpype/html/entities.txt");
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                String[] stringArray = string.split("\\s+");
                ENTITIES.put(stringArray[0], Integer.parseInt(stringArray[1]));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

