/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.table;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.ui.table.LinkCheckBox;
import com.paterva.maltego.graph.table.ui.wizard.SampleHeader;
import java.util.List;

public final class ConnectivityDataItem {
    private final TabularGraphEntity source;
    private final SampleHeader title;
    private final LinkCheckBox[] links;

    public ConnectivityDataItem(TabularGraph tg, TabularGraphEntity source, List<TabularGraphEntity> targets, SampleHeader title) {
        this.source = source;
        this.title = title;
        this.links = new LinkCheckBox[targets.size() - 1];
        int linkIndex = 0;
        for (TabularGraphEntity target : targets) {
            if (target.equals(source)) continue;
            this.links[linkIndex] = new LinkCheckBox(source, target);
            ++linkIndex;
        }
    }

    public TabularGraphEntity getSource() {
        return this.source;
    }

    public Object getTableData(int index) {
        if (index == 0) {
            return this.title;
        }
        return this.links[index - 1].isSelected();
    }

    public LinkCheckBox getLinkBox(int index) {
        return this.links[index - 1];
    }

    public int getCount() {
        return this.links.length + 1;
    }
}

