/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class GraphStoreWriter {
    private static final Logger LOG = Logger.getLogger(GraphStoreWriter.class.getName());

    public static void addEntity(GraphID graphID, MaltegoEntity entity) {
        GraphStoreWriter.addEntities(graphID, Collections.singleton(entity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntities(GraphID graphID, Collection<MaltegoEntity> entities) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Adding Entities to {0}:", graphID);
            for (MaltegoEntity entity : entities) {
                LOG.finest(entity.toString());
            }
        }
        GraphStore graphStore = null;
        try {
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
            GraphStructureWriter structureWriter = graphStore.getGraphStructureStore().getStructureWriter();
            GraphDataStoreWriter dataWriter = graphStore.getGraphDataStore().getDataStoreWriter();
            HashSet<EntityID> ids = new HashSet<EntityID>();
            for (MaltegoEntity entity : entities) {
                EntityID entityID = (EntityID)entity.getID();
                ids.add(entityID);
            }
            layoutWriter.addEntities(ids);
            structureWriter.add(ids);
            dataWriter.putEntities(entities);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEntity(GraphID graphID, MaltegoEntity entity) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Updating Entity to {0}:", graphID);
            LOG.finest(entity.toString());
        }
        GraphDataStoreWriter dataWriter = null;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            dataWriter = graphStore.getGraphDataStore().getDataStoreWriter();
            dataWriter.beginUpdate();
            dataWriter.updateEntity(entity);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (dataWriter != null) {
                dataWriter.endUpdate(null);
            }
        }
    }

    public static void addLink(GraphID graphID, MaltegoLink link, LinkEntityIDs entities) {
        GraphStoreWriter.addLinks(graphID, Collections.singletonMap(link, entities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLinks(GraphID graphID, Map<MaltegoLink, LinkEntityIDs> links) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Adding Links to {0}:", graphID);
            for (Map.Entry<MaltegoLink, LinkEntityIDs> entry : links.entrySet()) {
                MaltegoLink link = entry.getKey();
                LinkEntityIDs entityIDs = entry.getValue();
                LOG.log(Level.FINEST, "{0}: {1}->{2}", new Object[]{link.getID(), entityIDs.getSourceID(), entityIDs.getTargetID()});
            }
        }
        GraphStore graphStore = null;
        try {
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
            GraphStructureWriter structureWriter = graphStore.getGraphStructureStore().getStructureWriter();
            GraphDataStoreWriter dataWriter = graphStore.getGraphDataStore().getDataStoreWriter();
            HashMap<Guid, LinkEntityIDs> connections = new HashMap<Guid, LinkEntityIDs>();
            for (Map.Entry<MaltegoLink, LinkEntityIDs> entry : links.entrySet()) {
                MaltegoLink link = entry.getKey();
                LinkEntityIDs entities = entry.getValue();
                connections.put(link.getID(), entities);
            }
            layoutWriter.addLinks(connections.keySet());
            structureWriter.connect(connections);
            dataWriter.putLinks(links.keySet());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate(null);
            }
        }
    }

    public static void removeEntities(GraphID graphID, Collection<EntityID> entities) {
        GraphStoreWriter.remove(graphID, entities, Collections.EMPTY_SET);
    }

    public static void removeLinks(GraphID graphID, Collection<LinkID> links) {
        GraphStoreWriter.remove(graphID, Collections.EMPTY_SET, links);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(GraphID graphID, Collection<EntityID> entities, Collection<LinkID> links) {
        if (LOG.isLoggable(Level.FINEST) && !entities.isEmpty()) {
            LOG.log(Level.FINEST, "Removing Entities from {0}:", graphID);
            for (EntityID entity : entities) {
                LOG.finest(entity.toString());
            }
        }
        if (LOG.isLoggable(Level.FINEST) && !links.isEmpty()) {
            LOG.log(Level.FINEST, "Removing Links from {0}:", graphID);
            for (LinkID link : links) {
                LOG.finest(link.toString());
            }
        }
        GraphStore graphStore = null;
        try {
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            GraphStructureWriter structureWriter = graphStore.getGraphStructureStore().getStructureWriter();
            GraphDataStoreWriter dataWriter = graphStore.getGraphDataStore().getDataStoreWriter();
            GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
            structureWriter.removeLinks(links);
            Set removedLinks = structureWriter.removeEntities(entities);
            removedLinks.addAll(links);
            layoutWriter.remove(entities, (Collection)removedLinks);
            dataWriter.removeLinks((Collection)removedLinks);
            dataWriter.removeEntities(entities);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate(null);
            }
        }
    }

    public static void clear(GraphID graphID) {
        LOG.log(Level.FINEST, "Clearing graph {0}", graphID);
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            HashSet<EntityID> entities = new HashSet<EntityID>(structureReader.getEntities());
            GraphStoreWriter.removeEntities(graphID, entities);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void initForCloud(GraphID graphID) {
        LOG.log(Level.FINEST, "Init graph for cloud: {0}", graphID);
        GraphStore graphStore = null;
        try {
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            GraphStructureWriter structureWriter = graphStore.getGraphStructureStore().getStructureWriter();
            structureWriter.initForCloud();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate(null);
            }
        }
    }
}

