/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class DominantColorFactory
extends EntityColorFactory {
    private LegendColorMap _colors;
    private static final EntityImageFactory _imageFactory = EntityImageFactory.getDefault();

    @Override
    public synchronized Color getTypeColor(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Type may not be null.");
        }
        if (this._colors == null) {
            this._colors = new LegendColorMap();
        }
        return this._colors.get(typeName, _imageFactory);
    }

    private static class LegendColorMap {
        private final Map<String, Integer> _colorIndexMap = new HashMap<String, Integer>();
        private final Map<Integer, Color> _colorMap = new HashMap<Integer, Color>();
        private final Map<Integer, Integer> _colorMapCount = new HashMap<Integer, Integer>();
        private final UIDefaults _laf = UIManager.getLookAndFeelDefaults();

        private LegendColorMap() {
        }

        public Color get(String typeName, EntityImageFactory imageFactory) {
            int index = this.getIndex(typeName, imageFactory);
            return this.getColorInDefaultPalette(index);
        }

        private int getIndex(String typeName, EntityImageFactory imageFactory) {
            int count = this._laf.getInt("graph-view-type-colors");
            Integer num = this._colorIndexMap.get(typeName);
            if (num == null || num > count) {
                for (int i = 1; i <= count; ++i) {
                    this._colorMap.put(i, this.getColorInDefaultPalette(i));
                    if (this._colorMapCount.get(i) != null) continue;
                    this._colorMapCount.put(i, 0);
                }
                Image image = imageFactory.getTypeImage(typeName, null);
                BufferedImage bufferedImage = ImageUtils.createBufferedImage((Image)image);
                Color dominantColor = ImageUtils.getDominantColor((BufferedImage)bufferedImage, (boolean)false);
                List<Integer> leastUsedColorsList = this.getLeastUsedColorsList(this._colorMapCount, count);
                double minDistance = Double.MAX_VALUE;
                int closestColorIndex = -1;
                for (Integer leastUsedColorIndex : leastUsedColorsList) {
                    double distance = ColorUtilities.getColorDistance((Color)dominantColor, (Color)this._colorMap.get(leastUsedColorIndex));
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    closestColorIndex = leastUsedColorIndex;
                }
                num = closestColorIndex != -1 ? Integer.valueOf(closestColorIndex) : Integer.valueOf(1 + (int)(Math.random() * (double)count));
                this._colorIndexMap.put(typeName, num);
                this._colorMapCount.put(num, this._colorMapCount.get(num) + 1);
            }
            return num;
        }

        private Color getColorInDefaultPalette(int position) {
            return this._laf.getColor(String.format("graph-view-type-color%s", position));
        }

        private List<Integer> getLeastUsedColorsList(Map<Integer, Integer> uniqueColors, int count) {
            Integer smallestVal = null;
            ArrayList<Integer> leastUsedColorsList = new ArrayList<Integer>();
            for (Map.Entry<Integer, Integer> i : uniqueColors.entrySet()) {
                if (i.getKey() > count) continue;
                if (smallestVal == null || i.getValue() < smallestVal) {
                    smallestVal = i.getValue();
                    leastUsedColorsList.clear();
                    leastUsedColorsList.add(i.getKey());
                    continue;
                }
                if (!Objects.equals(smallestVal, i.getValue())) continue;
                leastUsedColorsList.add(i.getKey());
            }
            return leastUsedColorsList;
        }
    }
}

