/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.serializers.graphml.GraphMLWriter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.serializer.AttachmentsPathRegistry;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.clipboard.GraphML;
import com.paterva.maltego.ui.graph.clipboard.GraphStringConverter;
import com.paterva.maltego.ui.graph.imex.MaltegoGraphIO;
import com.paterva.maltego.util.FileStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class GraphMLConverter {
    private GraphMLConverter() {
    }

    public static GraphML convertSelection(GraphID graphID, boolean withLinks) throws IOException {
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        return GraphMLConverter.convert(graphID, selection.getSelectedModelEntities(), withLinks);
    }

    public static GraphML convert(GraphID graphID) throws IOException {
        return GraphMLConverter.convert(graphID, GraphStoreHelper.getEntityIDs((GraphID)graphID), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphML convert(GraphID graphID, Collection<EntityID> entityIDs, boolean withLinks) throws IOException {
        ByteArrayOutputStream os = null;
        GraphML graphML = null;
        try {
            Set<Attachments> attss = GraphMLConverter.getAttachments(graphID);
            HashMap<Integer, String> paths = new HashMap<Integer, String>();
            for (Attachments atts : attss) {
                for (Attachment att : atts) {
                    int id = att.getId();
                    String filename = FileStore.getDefault().getRelativePath(id);
                    paths.put(id, filename);
                }
            }
            AttachmentsPathRegistry.lock();
            AttachmentsPathRegistry.setPaths(paths);
            graphML = new GraphML(GraphMLWriter.getDefault().toString(graphID, entityIDs, withLinks));
        }
        finally {
            if (os != null) {
                os.close();
            }
            AttachmentsPathRegistry.unlock();
        }
        return graphML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphID convert(GraphID contextGraphID, GraphML graphML) throws IOException {
        GraphID graphID = null;
        try (InputStream is = null;){
            is = new ByteArrayInputStream(graphML.getText().getBytes("UTF-8"));
            EntityFactory factory = contextGraphID != null ? EntityFactory.forGraphID((GraphID)contextGraphID) : EntityFactory.getDefault();
            graphID = GraphID.create();
            MaltegoGraphIO.read(graphID, is, factory, EntityRegistry.getDefault(), LinkRegistry.getDefault(), IconRegistry.getDefault());
        }
        return graphID;
    }

    public static GraphML convert(String text) throws IOException {
        GraphML graphML;
        if (text.matches("(?msd)^(<\\?xml[^<]*\\?>)?\\s*<graphml.*</graphml>\\s*$")) {
            graphML = new GraphML(text);
        } else {
            try {
                GraphID graphID = GraphStringConverter.convert(text);
                graphML = GraphMLConverter.convert(graphID);
            }
            catch (GraphStoreException ex) {
                throw new IOException(ex);
            }
        }
        return graphML;
    }

    private static Set<Attachments> getAttachments(GraphID graphID) {
        HashSet<Attachments> atts = new HashSet<Attachments>();
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID);
        for (MaltegoEntity entity : entities) {
            GraphMLConverter.appendAttachments((MaltegoPart<? extends Guid>)entity, atts);
        }
        Set links = GraphStoreHelper.getMaltegoLinks((GraphID)graphID);
        for (MaltegoLink link : links) {
            GraphMLConverter.appendAttachments((MaltegoPart<? extends Guid>)link, atts);
        }
        return atts;
    }

    private static void appendAttachments(MaltegoPart<? extends Guid> part, Set<Attachments> atts) {
        PropertyDescriptorCollection properties = part.getProperties();
        for (PropertyDescriptor pd : properties) {
            Object value;
            if (!Attachments.class.equals((Object)pd.getType()) || !((value = part.getValue(pd)) instanceof Attachments)) continue;
            atts.add((Attachments)value);
        }
    }
}

