/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.api.TransformServerMap;
import com.paterva.maltego.transform.runner.api.TransformServerMapProvider;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import java.util.Collections;
import java.util.Map;
import org.openide.util.Lookup;

public abstract class TransformInputProvider {
    public static TransformInputProvider getDefault() {
        TransformInputProvider manager = (TransformInputProvider)Lookup.getDefault().lookup(TransformInputProvider.class);
        if (manager == null) {
            manager = new TrivialTransformInputProvider();
        }
        return manager;
    }

    public abstract Map<TransformDefinition, DataSource> getInputs(TransformServerMap var1);

    public DataSource getInputs(TransformDefinition transform, TransformServerInfo transformServer) {
        TransformServerMap txMap = TransformServerMapProvider.getDefault().get(Collections.singleton(transform), transformServer);
        Map<TransformDefinition, DataSource> map = this.getInputs(txMap);
        if (map == null) {
            return null;
        }
        DataSource inputs = null;
        if (map.size() == 1) {
            inputs = map.entrySet().iterator().next().getValue();
        }
        if (inputs == null) {
            inputs = DataSources.empty();
        }
        return inputs;
    }

    private static class TrivialTransformInputProvider
    extends TransformInputProvider {
        private TrivialTransformInputProvider() {
        }

        @Override
        public Map<TransformDefinition, DataSource> getInputs(TransformServerMap transforms) {
            throw new UnsupportedOperationException("No TransformInputProvider registered.");
        }
    }
}

