/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.repository.serializer.TransformServerSeedStub;
import com.paterva.maltego.util.StringUtilities;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="MaltegoServer", strict=false)
class TransformServerInfoStub {
    @Attribute(name="name", required=false)
    private String _name;
    @Attribute(name="enabled", required=false)
    private boolean _enabled = true;
    @Attribute(name="description", required=false)
    private String _description;
    @Attribute(name="url")
    private URL _url;
    @Attribute(name="v3url", required=false)
    private URL _v3url = null;
    @Element(name="LastSync", required=false)
    private Date _lastSync;
    @Element(name="Protocol", required=false)
    private Protocol _protocol;
    @Element(name="Authentication", required=false)
    private Authentication _authentication;
    @ElementList(name="Transforms", type=TransformReferenceStub.class, required=false)
    private List<TransformReferenceStub> _transforms = new ArrayList<TransformReferenceStub>();
    @ElementList(name="Seeds", type=TransformServerSeedStub.class, required=false)
    private List<TransformServerSeedStub> _seedUrls;

    TransformServerInfoStub() {
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String displayName) {
        this._description = displayName;
    }

    public URL getUrl() {
        return this._url;
    }

    public void setUrl(URL url) {
        this._url = url;
    }

    public URL getV3Url() {
        return this._v3url;
    }

    public void setV3Url(URL v3url) {
        this._v3url = v3url;
    }

    public Date getLastSync() {
        return this._lastSync;
    }

    public void setLastSync(Date lastSync) {
        this._lastSync = lastSync;
    }

    public String getProtocolVersion() {
        if (this._protocol == null) {
            return null;
        }
        return this._protocol.getVersion();
    }

    public void setProtocolVersion(String version) {
        this._protocol = version != null ? new Protocol(version) : null;
    }

    public List<String> getTransforms() {
        ArrayList<String> transforms = new ArrayList<String>();
        for (TransformReferenceStub stub : this._transforms) {
            transforms.add(stub.getName());
        }
        return transforms;
    }

    public void addTransform(String name) {
        this._transforms.add(new TransformReferenceStub(name));
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this._authentication = authentication;
    }

    public List<String> getSeedUrls() {
        ArrayList<String> seedUrls = new ArrayList<String>();
        if (this._seedUrls != null) {
            for (TransformServerSeedStub seedUrl : this._seedUrls) {
                String url = StringUtilities.trim((String)seedUrl.getSeedUrl());
                if (StringUtilities.isNullOrEmpty((String)url)) continue;
                seedUrls.add(url);
            }
        }
        return seedUrls;
    }

    public void setSeedUrls(List<String> seedUrls) {
        this._seedUrls = new ArrayList<TransformServerSeedStub>(seedUrls.size());
        for (String seedUrl : seedUrls) {
            if (StringUtilities.isNullOrEmpty((String)(seedUrl = StringUtilities.trim((String)seedUrl)))) continue;
            this._seedUrls.add(new TransformServerSeedStub(seedUrl));
        }
    }

    @Root(name="Transform", strict=false)
    static class TransformReferenceStub {
        @Attribute(name="name")
        private String _name;

        public TransformReferenceStub() {
        }

        private TransformReferenceStub(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }
    }

    static class Authentication {
        @Attribute(name="type")
        private String _type;

        public Authentication() {
        }

        public Authentication(String type) {
            this._type = type;
        }

        public String getType() {
            return this._type;
        }

        public void setType(String type) {
            this._type = type;
        }
    }

    static class Protocol {
        @Attribute(name="version")
        private String _version;

        public Protocol() {
        }

        private Protocol(String version) {
            this._version = version;
        }

        public String getVersion() {
            return this._version;
        }

        public void setVersion(String version) {
            this._version = version;
        }
    }
}

