/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.LegacyNodeExports;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(value=LegacyNodeExports.class)
final class LegacyNodeExportsGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LegacyNodeExportsGen() {
    }

    static {
        LibraryExport.register(LegacyNodeExports.class, new NodeLibraryExports());
    }

    @GeneratedBy(value=LegacyNodeExports.class)
    private static final class NodeLibraryExports
    extends LibraryExport<NodeLibrary> {
        private NodeLibraryExports() {
            super(NodeLibrary.class, Node.class, true, false, 0);
        }

        @Override
        protected NodeLibrary createUncached(Object receiver) {
            assert (receiver instanceof Node);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NodeLibrary createCached(Object receiver) {
            assert (receiver instanceof Node);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LegacyNodeExports.class)
        private static final class Uncached
        extends NodeLibrary {
            private final Class<? extends Node> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((Node)receiver).getClass();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasScope(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.hasScope((Node)receiver, frame);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getScope(Object receiver, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.getScope((Node)receiver, frame, nodeEnter);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasReceiverMember(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.hasReceiverMember((Node)receiver, frame);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getReceiverMember(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.getReceiverMember((Node)receiver, frame);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasRootInstance(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.hasRootInstance((Node)receiver, frame);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getRootInstance(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.getRootInstance((Node)receiver, frame);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getView(Object receiver, Frame frame, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.getView((Node)receiver, frame, value);
            }
        }

        @GeneratedBy(value=LegacyNodeExports.class)
        private static final class Cached
        extends NodeLibrary {
            private final Class<? extends Node> receiverClass_;

            protected Cached(Object receiver) {
                Node castReceiver = (Node)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public boolean hasScope(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.hasScope(CompilerDirectives.castExact(receiver, this.receiverClass_), frame);
            }

            @Override
            public Object getScope(Object receiver, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.getScope(CompilerDirectives.castExact(receiver, this.receiverClass_), frame, nodeEnter);
            }

            @Override
            public boolean hasReceiverMember(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.hasReceiverMember(CompilerDirectives.castExact(receiver, this.receiverClass_), frame);
            }

            @Override
            public Object getReceiverMember(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.getReceiverMember(CompilerDirectives.castExact(receiver, this.receiverClass_), frame);
            }

            @Override
            public boolean hasRootInstance(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.hasRootInstance(CompilerDirectives.castExact(receiver, this.receiverClass_), frame);
            }

            @Override
            public Object getRootInstance(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.getRootInstance(CompilerDirectives.castExact(receiver, this.receiverClass_), frame);
            }

            @Override
            public Object getView(Object receiver, Frame frame, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LegacyNodeExports.getView(CompilerDirectives.castExact(receiver, this.receiverClass_), frame, value);
            }
        }
    }
}

