/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.core;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GenericPart;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.Utilities;

public class GenericEntity
extends GenericPart<EntityID>
implements MaltegoEntity {
    private String imageExpr;
    private Integer weight;
    private Object imageKeyCached;
    private OverlayDescriptorSet overlaySet;

    public GenericEntity(EntityID id) {
        super(id);
    }

    public GenericEntity(EntityID id, String type, PropertyDescriptorCollection collection) {
        super(id, type, collection);
        this.initialize();
    }

    public GenericEntity(EntityID id, String type) {
        super(id, type);
        this.initialize();
    }

    public GenericEntity(MaltegoEntity original) {
        super(original);
        this.imageExpr = original.getImageExpression().orElse(null);
        this.weight = original.getWeightValue().orElse(null);
        this.imageKeyCached = original.getCachedImageKey().orElse(null);
        OverlayDescriptorSet otherOverlays = original.getOverlaySet();
        if (otherOverlays == null || otherOverlays.isEmpty()) {
            return;
        }
        otherOverlays.forEach(overlay -> this.addOverlay((OverlayDescriptor)overlay));
    }

    private void initialize() {
        this.weight = 0;
        this.imageExpr = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.createClone();
    }

    @Override
    public GenericEntity createCopy() {
        GenericEntity entity = new GenericEntity(this);
        entity.setId(EntityID.create());
        return entity;
    }

    @Override
    public GenericEntity createClone() {
        return new GenericEntity(this);
    }

    @Override
    public boolean isCopy(MaltegoPart<EntityID> part) {
        if (part instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)part;
            if (!(Utilities.compareObjects((Object)this.imageExpr, (Object)genericEntity.imageExpr) && Utilities.compareObjects((Object)this.weight, (Object)genericEntity.weight) && Utilities.compareObjects((Object)this.overlaySet, (Object)genericEntity.overlaySet))) {
                return false;
            }
        } else {
            return false;
        }
        return super.isCopy(part);
    }

    @Override
    public Optional<Integer> getWeightValue() {
        return Optional.ofNullable(this.weight);
    }

    @Override
    public int getWeight() {
        return this.getWeightValue().orElse(0);
    }

    @Override
    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    @Override
    public Optional<String> getImageExpression() {
        return Optional.ofNullable(this.imageExpr);
    }

    @Override
    public Optional<String> getNonBlankImageExpression() {
        return this.getImageExpression().filter(StringUtils::isNotBlank);
    }

    @Override
    public void setImageExpression(String imgExpr) {
        if (!Objects.equals(this.imageExpr, imgExpr)) {
            this.imageExpr = imgExpr;
            this.firePropertyChange("image");
        }
    }

    @Override
    public Optional<Object> getCachedImageKey() {
        return Optional.ofNullable(this.imageKeyCached);
    }

    @Override
    public void setCachedImageKey(Object imgKey) {
        if (imgKey instanceof String && StringUtils.isBlank((CharSequence)((String)imgKey))) {
            imgKey = null;
        }
        this.imageKeyCached = imgKey;
    }

    @Override
    protected void checkSpecialPropertyUpdate(PropertyDescriptor descriptor) {
        super.checkSpecialPropertyUpdate(descriptor);
        if (descriptor.getName().equals(this.imageExpr)) {
            this.firePropertyChange("image");
        }
    }

    @Override
    public void addOverlay(OverlayDescriptor overlay) {
        if (this.overlaySet == null) {
            this.overlaySet = new OverlayDescriptorSet();
        }
        this.overlaySet.add(overlay);
    }

    @Override
    public OverlayDescriptorSet getOverlaySet() {
        return this.overlaySet;
    }
}

