/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.form.ControlAdapter;
import com.paterva.maltego.typing.editing.form.ControlAdapterFactory;
import com.paterva.maltego.typing.editing.form.adapters.AbstractFileBrowserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ArrayEditorAdapter;
import com.paterva.maltego.typing.editing.form.adapters.BinaryFileBrowserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.CharacterAdapter;
import com.paterva.maltego.typing.editing.form.adapters.CheckBoxAdapter;
import com.paterva.maltego.typing.editing.form.adapters.CheckListAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ColorChooserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ComboBoxAdapter;
import com.paterva.maltego.typing.editing.form.adapters.DatePickerAdapter;
import com.paterva.maltego.typing.editing.form.adapters.DateRangePickerAdapter;
import com.paterva.maltego.typing.editing.form.adapters.DateTimePickerAdapter;
import com.paterva.maltego.typing.editing.form.adapters.FastUrlTextBoxAdapter;
import com.paterva.maltego.typing.editing.form.adapters.FileBrowserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ImageBrowserAdapter;
import com.paterva.maltego.typing.editing.form.adapters.ImageViewAdapter;
import com.paterva.maltego.typing.editing.form.adapters.PasswordFieldAdapter;
import com.paterva.maltego.typing.editing.form.adapters.RadioButtonPanelAdapter;
import com.paterva.maltego.typing.editing.form.adapters.SpinnerAdapter;
import com.paterva.maltego.typing.editing.form.adapters.TextBoxAdapter;
import com.paterva.maltego.typing.editing.form.adapters.TimeSpanEditorAdapter;
import com.paterva.maltego.typing.editors.BooleanFormat;
import com.paterva.maltego.typing.editors.FileBrowserEditorDescriptor;
import com.paterva.maltego.typing.editors.OptionEditorDescriptor;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import com.paterva.maltego.typing.editors.PasswordEditorDescriptor;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.BinaryFile;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.IPAddress;
import com.paterva.maltego.typing.types.InternalFile;
import com.paterva.maltego.typing.types.PhoneNumber;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.FastURL;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.SpinnerNumberModel;

public class DefaultAdapterFactory
implements ControlAdapterFactory {
    private static DefaultAdapterFactory _instance;

    public static DefaultAdapterFactory instance() {
        if (_instance == null) {
            _instance = new DefaultAdapterFactory();
        }
        return _instance;
    }

    @Override
    public ControlAdapter create(DisplayDescriptor descriptor) throws UnsupportedEditorException {
        if (descriptor.getEditor() == null) {
            return this.createTypeAdapter(descriptor);
        }
        if (descriptor.getEditor() instanceof OptionEditorDescriptor) {
            OptionEditorDescriptor oe = (OptionEditorDescriptor)descriptor.getEditor();
            return this.createOptionEditor(descriptor, oe);
        }
        if (descriptor.getEditor() instanceof PasswordEditorDescriptor) {
            return new PasswordFieldAdapter();
        }
        if (descriptor.getEditor() instanceof FileBrowserEditorDescriptor) {
            return this.createFileBrowserAdapter(descriptor, (FileBrowserEditorDescriptor)descriptor.getEditor());
        }
        throw new UnsupportedEditorException(descriptor);
    }

    private ControlAdapter createFileBrowserAdapter(DisplayDescriptor descriptor, FileBrowserEditorDescriptor editor) throws UnsupportedEditorException {
        if (File.class.isAssignableFrom(descriptor.getType()) || BinaryFile.class.isAssignableFrom(descriptor.getType())) {
            AbstractFileBrowserAdapter adapter = (AbstractFileBrowserAdapter)this.createTypeAdapter(descriptor);
            adapter.setExtensions(editor.getExtensions());
            adapter.setFilterTitle(editor.getFilterTitle());
            adapter.setSelectDirectories(editor.isSelectDirectories());
            adapter.setSelectFiles(editor.isSelectFiles());
            return adapter;
        }
        throw new UnsupportedEditorException("FileBrowserEditor can only be used with types file and binary.");
    }

    private ControlAdapter createOptionEditor(DisplayDescriptor descriptor, OptionEditorDescriptor editor) {
        if (descriptor.getTypeDescriptor().isArrayType()) {
            if (editor.isUserSpecified()) {
                return new ArrayEditorAdapter(descriptor.getType(), descriptor.getFormat());
            }
            return new CheckListAdapter(editor.getItems());
        }
        return new ComboBoxAdapter(editor.getItems(), editor.isUserSpecified());
    }

    private SpinnerAdapter createNumericAdapter(DisplayDescriptor descriptor, Number stepSize) {
        Number defaultValue = (Number)descriptor.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = (Number)descriptor.getTypeDescriptor().getDefaultValue();
        }
        return this.createNumericAdapter(defaultValue, stepSize);
    }

    private SpinnerAdapter createNumericAdapter(Number defaultValue, final Number stepSize) {
        Comparable min = null;
        Comparable max = null;
        SpinnerAdapter<Number> adapter = new SpinnerAdapter<Number>(defaultValue);
        SpinnerNumberModel model = new SpinnerNumberModel(defaultValue, min, max, stepSize){

            @Override
            public Object getPreviousValue() {
                return this.customIncrValue(-1);
            }

            @Override
            public Object getNextValue() {
                return this.customIncrValue(1);
            }

            private Number customIncrValue(int dir) {
                Number newValue;
                Number localValue = this.getNumber();
                Comparable<?> localMin = this.getMinimum();
                Comparable<?> localMax = this.getMaximum();
                if (localValue instanceof Float || localValue instanceof Double) {
                    double v = localValue.doubleValue() + stepSize.doubleValue() * (double)dir;
                    newValue = localValue instanceof Double ? (Number)new Double(v) : (Number)new Float(v);
                } else if (localValue instanceof BigInteger) {
                    newValue = ((BigInteger)localValue).add(((BigInteger)stepSize).multiply(BigInteger.valueOf(dir)));
                } else {
                    long v = localValue.longValue() + stepSize.longValue() * (long)dir;
                    newValue = localValue instanceof Long ? (Number)v : (Number)(localValue instanceof Integer ? (Number)((int)v) : (Number)(localValue instanceof Short ? (Number)((short)v) : (Number)((byte)v)));
                }
                if (localMax != null && localMax.compareTo(newValue) < 0) {
                    return null;
                }
                if (localMin != null && localMin.compareTo(newValue) > 0) {
                    return null;
                }
                return newValue;
            }
        };
        adapter.setModel(model);
        return adapter;
    }

    private ControlAdapter createTypeAdapter(DisplayDescriptor descriptor) throws UnsupportedEditorException {
        Class type = descriptor.getType();
        if (descriptor.getType().isArray()) {
            return new ArrayEditorAdapter(descriptor.getType(), descriptor.getFormat());
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(descriptor, (Number)1);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(descriptor, (Number)0.1);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(descriptor, (Number)0.1);
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(descriptor, (Number)1);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(descriptor, (Number)1);
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return this.createNumericAdapter(descriptor, (Number)BigInteger.ONE);
        }
        if (String.class.isAssignableFrom(type)) {
            return new TextBoxAdapter();
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return new CharacterAdapter();
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return this.createBooleanAdapter(descriptor.getFormat());
        }
        if (Date.class.isAssignableFrom(type)) {
            return this.createDatePicker(descriptor.getFormat());
        }
        if (DateTime.class.isAssignableFrom(type)) {
            return this.createDateTimePicker(descriptor.getFormat());
        }
        if (DateRange.class.isAssignableFrom(type)) {
            return this.createDateRangePicker(descriptor.getFormat());
        }
        if (TimeSpan.class.isAssignableFrom(type)) {
            return new TimeSpanEditorAdapter();
        }
        if (FastURL.class.isAssignableFrom(type)) {
            return new FastUrlTextBoxAdapter();
        }
        if (Image.class.isAssignableFrom(type)) {
            if (descriptor.isReadonly()) {
                return new ImageViewAdapter();
            }
            return new ImageBrowserAdapter();
        }
        if (BinaryFile.class.isAssignableFrom(type)) {
            return new BinaryFileBrowserAdapter();
        }
        if (File.class.isAssignableFrom(type)) {
            return new FileBrowserAdapter();
        }
        if (Color.class.isAssignableFrom(type)) {
            return new ColorChooserAdapter();
        }
        if (Attachments.class.isAssignableFrom(type)) {
            return null;
        }
        if (InternalFile.class.isAssignableFrom(type)) {
            return null;
        }
        if (IPAddress.class.isAssignableFrom(type)) {
            return new TextBoxAdapter();
        }
        if (PhoneNumber.class.isAssignableFrom(type)) {
            return new TextBoxAdapter();
        }
        throw new UnsupportedEditorException(type);
    }

    private DatePickerAdapter createDatePicker(Format format) {
        DateFormat df = format == null ? new SimpleDateFormat(TypeRegistry.getDefaultDateFormat()) : (DateFormat)format;
        return new DatePickerAdapter(df);
    }

    private DateTimePickerAdapter createDateTimePicker(Format format) {
        DateFormat df = format == null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z") : (DateFormat)format;
        return new DateTimePickerAdapter(df);
    }

    private DateRangePickerAdapter createDateRangePicker(Format format) {
        DateFormat df = format == null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z") : (DateFormat)format;
        return new DateRangePickerAdapter(((SimpleDateFormat)df).toPattern());
    }

    @Override
    public ControlAdapter create(Class type) throws UnsupportedEditorException {
        return this.create(type, null);
    }

    @Override
    public ControlAdapter create(Class type, Format format) throws UnsupportedEditorException {
        if (Integer.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(0, (Number)1);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(0L, (Number)1L);
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return this.createNumericAdapter(BigInteger.ZERO, (Number)BigInteger.ONE);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(0.0, (Number)0.1);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter(Float.valueOf(0.0f), (Number)0.1);
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return this.createNumericAdapter((byte)0, (Number)1);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return this.createBooleanAdapter(format);
        }
        if (Image.class.isAssignableFrom(type)) {
            return new ImageBrowserAdapter();
        }
        if (Date.class.isAssignableFrom(type)) {
            return this.createDatePicker(format);
        }
        if (DateTime.class.isAssignableFrom(type)) {
            return this.createDateTimePicker(format);
        }
        if (DateRange.class.isAssignableFrom(type)) {
            return this.createDateRangePicker(format);
        }
        if (TimeSpan.class.isAssignableFrom(type)) {
            return new TimeSpanEditorAdapter();
        }
        if (Color.class.isAssignableFrom(type)) {
            return new ColorChooserAdapter();
        }
        return new TextBoxAdapter();
    }

    private ControlAdapter createBooleanAdapter(Format format) {
        if (format instanceof BooleanFormat) {
            OptionItemCollection items = new OptionItemCollection(Boolean.TYPE, format);
            items.add((Object)true);
            items.add((Object)false);
            return new RadioButtonPanelAdapter(items);
        }
        return new CheckBoxAdapter();
    }
}

