/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.editing.AbstractComponentFactory;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.form.ControlAdapter;
import com.paterva.maltego.typing.editing.form.ControlAdapterFactory;
import com.paterva.maltego.typing.editing.form.DefaultInputPanelBuilder;
import com.paterva.maltego.typing.editing.form.DisplayDescriptorInput;
import com.paterva.maltego.typing.editing.form.Input;
import com.paterva.maltego.typing.editing.form.adapters.DefaultAdapterFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class InputFormComponentFactory
extends AbstractComponentFactory {
    private ControlAdapterFactory _controlFactory;
    private Map<String, Object> _settings;
    private boolean _scrollable;

    public InputFormComponentFactory(boolean scrollable) {
        this(Collections.emptyMap(), scrollable);
    }

    public InputFormComponentFactory(Map<String, Object> settings, boolean scrollable) {
        this._settings = settings;
        this._controlFactory = DefaultAdapterFactory.instance();
        this._scrollable = scrollable;
    }

    @Override
    public Component createEditingComponent() {
        JPanel panel = new JPanel();
        return panel;
    }

    @Override
    public void updateEditingComponent(Component component, DataSource data, DisplayDescriptorEnumeration descriptors, GroupDefinitions groupings, Border border, LayoutManager layoutManager) {
        if (component instanceof JPanel) {
            DefaultInputPanelBuilder panelBuilder = new DefaultInputPanelBuilder(groupings, this._scrollable);
            panelBuilder.setShowHiddenFields(this.getSetting("showHiddenFields", Boolean.FALSE));
            panelBuilder.setRequiredFieldColor(this.getSetting("requiredFieldColor", Color.yellow));
            panelBuilder.setErrorColor(this.getSetting("errorColor", UIManager.getLookAndFeelDefaults().getColor("7-red")));
            panelBuilder.setShowDescriptions(this.getSetting("showDescriptions", Boolean.FALSE));
            panelBuilder.setUseRequiredFieldColor(this.getSetting("useRequiredFieldColor", Boolean.FALSE));
            panelBuilder.setUseErrorColor(this.getSetting("useErrorColor", Boolean.TRUE));
            JPanel panel = (JPanel)component;
            LinkedList<Input> inputs = new LinkedList<Input>();
            for (DisplayDescriptor field : descriptors) {
                try {
                    Input input = this.createInput(data, field);
                    if (input == null) continue;
                    inputs.add(input);
                }
                catch (UnsupportedEditorException ex) {
                    Logger.getLogger(InputFormComponentFactory.class.getName()).log(Level.SEVERE, "Could not create editing control", ex);
                }
            }
            if (layoutManager != null) {
                panelBuilder.setLayout(layoutManager);
            }
            if (border != null) {
                panelBuilder.setBorder(border);
            }
            panelBuilder.build(panel, inputs);
        }
    }

    protected Input createInput(DataSource data, DisplayDescriptor descriptor) throws UnsupportedEditorException {
        ControlAdapter adapter = this._controlFactory.create(descriptor);
        if (adapter != null) {
            return new DisplayDescriptorInput(descriptor, data, adapter);
        }
        return null;
    }

    private <T> T getSetting(String name, T defaultValue) {
        Object value = this._settings.get(name);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }
}

