/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.add;

import com.paterva.maltego.customicons.add.IconCategoryPanel;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.IconValidation;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import org.openide.WizardDescriptor;

public class IconCategoryController
extends ValidatingController<IconCategoryPanel> {
    public static final String ICON_CATEGORY = "iconCategory";

    public IconCategoryController() {
        this.setName("Select/Enter Icon Category");
    }

    protected IconCategoryPanel createComponent() {
        IconCategoryPanel panel = new IconCategoryPanel();
        panel.addChangeListener(this.changeListener());
        return panel;
    }

    protected String getFirstError(IconCategoryPanel component) {
        String category = component.getSelectedCategory().trim();
        return IconValidation.getCategoryError((String)category).orElse(null);
    }

    protected void readSettings(WizardDescriptor settings) {
        String category = (String)settings.getProperty(ICON_CATEGORY);
        Set categories = IconRegistry.getDefault().getCategories();
        LinkedList sorted = new LinkedList(categories);
        Collections.sort(sorted, new CaseInsensitiveComparator());
        ((IconCategoryPanel)this.component()).setCategories(sorted.toArray(new String[sorted.size()]));
        ((IconCategoryPanel)this.component()).setSelectedCategory(category);
    }

    protected void storeSettings(WizardDescriptor settings) {
        String category = ((IconCategoryPanel)this.component()).getSelectedCategory();
        settings.putProperty(ICON_CATEGORY, (Object)category);
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    }
}

