/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;

public class TableHeaders {
    private final List<Object> headerRow;

    public TableHeaders(TabularGraph tabularGraph, String sourceFile) {
        this(TableHeaders.getHeaderRow(tabularGraph, sourceFile));
    }

    public TableHeaders(List<Object> headerRow) {
        this.headerRow = headerRow;
    }

    public Optional<String> getHeaderDisplayName(TabularGraphEntity entity) {
        String headerValue;
        Object value;
        int column;
        if (this.headerRow != null && (column = entity.getColumns()[0]) < this.headerRow.size() && (value = this.headerRow.get(column)) != null && !(headerValue = value.toString()).isEmpty()) {
            return Optional.ofNullable(headerValue);
        }
        return Optional.empty();
    }

    public List<String> getHeaders() {
        return this.headerRow == null ? null : this.headerRow.stream().map(Object::toString).collect(Collectors.toList());
    }

    private static List<Object> getHeaderRow(TabularGraph tabularGraph, String sourceFile) {
        List<Object> row = null;
        if (tabularGraph.hasHeaderRow()) {
            TabularGraphFileImporter importer = TabularGraphFileImporterFactory.createImporter(new File(sourceFile)).get();
            try (TabularGraphIterator itr = importer.open();){
                for (int headerRowIndex = tabularGraph.getHeaderRowIndex(); headerRowIndex >= 0; --headerRowIndex) {
                    itr.next();
                    row = itr.getRow(null);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return row;
    }
}

