/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.collect;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainterAnimatorRegistry;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.WindowUtil;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import com.pinkmatter.api.flamingo.RibbonPresenters;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public final class CollectionToggleAction
extends CallableSystemAction
implements RibbonPresenter.Button {
    private final String ICON_DISABLED = "com/paterva/maltego/graph/store/views/resources/CollectionsDisabled.png";
    private final String ICON_ENABLED = "com/paterva/maltego/graph/store/views/resources/CollectionsEnabled.png";
    private static final int ICON_SIZE_LARGE_48 = IconSize.LARGE.getSize();
    private AbstractCommandButton _ribbonPresenter;
    private ResizableIcon _enabledIcon;
    private ResizableIcon _disabledIcon;
    private GraphID _topGraph = null;

    public CollectionToggleAction() {
        CollectionSettings.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CollectionToggleAction.this.update();
            }
        });
        GraphEditorRegistry.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("topmost".equals(evt.getPropertyName())) {
                    CollectionToggleAction.this.update();
                }
            }
        });
        this.update();
    }

    private void update() {
        this._topGraph = this.getViewGraphID();
        AbstractCommandButton ribbonPresenter = this.getRibbonButtonPresenter();
        ribbonPresenter.setEnabled(this._topGraph != null);
        ribbonPresenter.setIcon(this.getResizableIcon());
        ribbonPresenter.setText(this.getText());
        ribbonPresenter.setActionRichTooltip(this.getTooltip());
    }

    public void performAction() {
        try {
            WindowUtil.showWaitCursor();
            MainEntityPainterAnimatorRegistry.allowModifications = false;
            CollectionSettings.getDefault().setNextMode(this._topGraph);
            MainEntityPainterAnimatorRegistry.allowModifications = true;
            this.update();
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    public String getName() {
        return "Collection mode";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._ribbonPresenter == null) {
            this._ribbonPresenter = RibbonPresenters.createCommandButton((Action)((Object)this), (String)this.getText(), (ResizableIcon)this.getResizableIcon());
            this._ribbonPresenter.setActionRichTooltip(this.getTooltip());
        }
        return this._ribbonPresenter;
    }

    private GraphID getViewGraphID() {
        GraphCookie cookie;
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null && (cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class)) != null) {
            return cookie.getGraphID();
        }
        return null;
    }

    private ResizableIcon getResizableIcon() {
        if (this._topGraph != null && CollectionSettings.getDefault().isEnabled(this._topGraph)) {
            if (this._enabledIcon == null) {
                this._enabledIcon = ResizableIcons.fromResource((String)"com/paterva/maltego/graph/store/views/resources/CollectionsEnabled.png");
            }
            return this._enabledIcon;
        }
        if (this._disabledIcon == null) {
            this._disabledIcon = ResizableIcons.fromResource((String)"com/paterva/maltego/graph/store/views/resources/CollectionsDisabled.png");
        }
        return this._disabledIcon;
    }

    private ResizableIcon getResizableIconForTooltip() {
        boolean enabled = this._topGraph != null && CollectionSettings.getDefault().isEnabled(this._topGraph);
        return ResizableIcons.fromResource((String)(enabled ? "com/paterva/maltego/graph/store/views/resources/CollectionsEnabled.png" : "com/paterva/maltego/graph/store/views/resources/CollectionsDisabled.png"));
    }

    private RichTooltip getTooltip() {
        ResizableIcon resizableIcon = this.getResizableIconForTooltip();
        resizableIcon.setDimension(new Dimension(ICON_SIZE_LARGE_48, ICON_SIZE_LARGE_48));
        BufferedImage iconImage = new BufferedImage(ICON_SIZE_LARGE_48, ICON_SIZE_LARGE_48, 2);
        resizableIcon.paintIcon((Component)this._ribbonPresenter, (Graphics)iconImage.createGraphics(), 0, 0);
        String descr = "Enable or disable collection-node formation";
        RichTooltip tooltip = new RichTooltip("Collection-Node Mode", descr);
        tooltip.addFooterSection("Click the help button to get more help on Maltego features");
        tooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
        tooltip.setMainImage((Image)iconImage);
        return tooltip;
    }

    private String getText() {
        if (this._topGraph != null && CollectionSettings.getDefault().isEnabled(this._topGraph)) {
            return "Disable Collections";
        }
        return "Enable Collections";
    }
}

