/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.menu;

import com.paterva.maltego.util.IconSize;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class MultiActionMenuItem
extends JMenuItem {
    private Action[] _secondary;
    private Action _pressed;
    private Action _hover;
    private static final int ICON_WIDTH = IconSize.TINY.getSize();
    private static final int ICON_SPACING = 2;
    private static final int OFFSET_Y = 2;

    public MultiActionMenuItem(String title, String description) {
        super(title);
        this.setToolTipText(description);
    }

    public MultiActionMenuItem(Action ... actions) {
        super(MultiActionMenuItem.getFirst(actions));
        this._secondary = Arrays.copyOfRange(actions, 1, actions.length);
    }

    public MultiActionMenuItem(Action primary, Action[] secondary) {
        super(primary);
        this._secondary = secondary;
    }

    private static Action getFirst(Action[] actions) {
        if (actions.length > 0) {
            return actions[0];
        }
        throw new IllegalArgumentException("At least one action needs to be specified.");
    }

    private static String createHtml(String name, String description) {
        String label = "<html><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td><font color=\"#434A73\">" + name + "</font></td></tr><tr><td><font size=\"2\" color=\"#8F94AF\">" + description + "</font></td></tr></table></html>";
        return label;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width + this._secondary.length * ICON_WIDTH + Math.max(this._secondary.length - 1, 0) * 2, d.height);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle buttons = this.calcButtonsRect();
        int x = buttons.x;
        for (int i = 0; i < this._secondary.length; ++i) {
            Action action = this._secondary[i];
            int pressed = this._pressed == action ? 1 : 0;
            g.drawImage(MultiActionMenuItem.getIcon(action), x + pressed, 2 + pressed, null);
            x += ICON_WIDTH + 2;
        }
    }

    private static Image getIcon(Action action) {
        return (Image)action.getValue("SmallIcon");
    }

    private Rectangle calcButtonsRect() {
        int width = this._secondary.length * ICON_WIDTH + Math.max(this._secondary.length - 1, 0) * 2;
        Rectangle buttons = new Rectangle(this.getWidth() - width, 2, width, ICON_WIDTH);
        return buttons;
    }

    private Action hitTest(Point point) {
        Rectangle buttons = this.calcButtonsRect();
        int x = buttons.x;
        if (buttons.contains(point)) {
            for (int i = 0; i < this._secondary.length; ++i) {
                if (point.x >= x && point.x < x + ICON_WIDTH) {
                    return this._secondary[i];
                }
                x += ICON_WIDTH + 2;
            }
        }
        return null;
    }

    private void fireMouseEntered() {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void fireMouseExited() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setHover(Action action) {
        if (action != this._hover) {
            this._hover = action;
            if (action != null) {
                this.fireMouseEntered();
            } else {
                this.fireMouseExited();
            }
        }
    }

    private void setPressed(Action value) {
        if (value != this._pressed) {
            this._pressed = value;
            this.repaint();
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 503) {
            Action action = this.hitTest(e.getPoint());
            this.setHover(action);
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this._pressed != null && (e.getID() == 502 || e.getID() == 500) && e.getButton() == 1) {
            Action action = this._pressed;
            this.setPressed(null);
            this.fireAction(action, e);
        } else if (e.getID() == 501 && e.getButton() == 1) {
            this.setPressed(this.hitTest(e.getPoint()));
        } else {
            super.processMouseEvent(e);
        }
    }

    private void fireAction(final Action action, final MouseEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                action.actionPerformed(new ActionEvent(this, e.getID(), "click"));
            }
        });
    }

    @Override
    protected final void paintComponent(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        Object oldHint = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintComponent(graphics);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldHint);
    }
}

