/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.transforms;

import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.manager.imex.transforms.TransformConfig;
import com.paterva.maltego.transform.manager.imex.transforms.TransformExistInfo;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class TransformNode
extends ConfigNode {
    private TransformConfig _config;

    public TransformNode(TransformConfig config, TransformDescriptor transform, TransformExistInfo existInfo) {
        this(transform, new InstanceContent(), existInfo);
        this._config = config;
    }

    private TransformNode(TransformDescriptor transform, InstanceContent content, TransformExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)transform);
        content.add((Object)this);
        String displayName = transform.getDisplayName();
        if (existInfo != null && existInfo.exist(transform)) {
            displayName = "<exist> " + displayName;
        }
        this.setDisplayName(displayName);
        this.setShortDescription(transform.getDescription());
    }

    public void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            TransformDescriptor transform = (TransformDescriptor)this.getLookup().lookup(TransformDescriptor.class);
            if (selected.booleanValue()) {
                this._config.select(transform);
            } else {
                this._config.unselect(transform);
            }
        }
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/Transform.png");
    }
}

