/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.constraints.execution.property;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.constraints.ConstraintTargetTypeEnum;
import com.maltego.tx3.java.api.constraints.ConstraintTypeEnum;
import com.maltego.tx3.java.api.constraints.LogicalOperation;
import com.maltego.tx3.java.api.constraints.execution.InputConstraint;
import com.maltego.tx3.java.api.execution.Entity;

public class PropertyExists
extends InputConstraint {
    private final String propertyName;

    @JsonCreator
    public PropertyExists(@JsonProperty(value="propertyName") String propertyName) {
        this.propertyName = propertyName;
        this.constraintType = ConstraintTypeEnum.PROPERTY;
        this.constraintTargetType = ConstraintTargetTypeEnum.PROPERTY_NAME;
    }

    @Override
    public boolean evaluate(Object inputValue) {
        if (inputValue instanceof Entity) {
            Entity entity = (Entity)inputValue;
            return entity.getProperties().stream().anyMatch(prop -> prop.getName().equalsIgnoreCase(this.propertyName));
        }
        return false;
    }

    @Override
    public LogicalOperation getConstraintOperation() {
        return LogicalOperation.ALL;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

