/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.descriptor;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ListMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class TypeSpec {
    protected String _typeName;
    protected String _displayName;
    protected ListMap<String, DisplayDescriptor> _specialProperties;
    protected DisplayDescriptorCollection _properties;
    protected GroupDefinitions _propertyGroups;
    protected String _defaultCategory;
    protected boolean _visible = true;

    public TypeSpec() {
        this("", (DisplayDescriptorCollection)new DisplayDescriptorList());
    }

    public TypeSpec(String name, DisplayDescriptorCollection properties) {
        this(name, properties, null);
    }

    public TypeSpec(String name, DisplayDescriptorCollection properties, GroupDefinitions groups) {
        this._typeName = name;
        this._properties = properties;
        this._propertyGroups = groups;
    }

    public TypeSpec(String name, PropertyConfiguration properties) {
        this._typeName = name;
        if (properties != null) {
            this._properties = new DisplayDescriptorList((Iterable)properties.getProperties());
            this._propertyGroups = properties.getGroups();
            this._specialProperties = properties.getSpecialProperties();
        } else {
            this._properties = new DisplayDescriptorList();
        }
    }

    public TypeSpec(TypeSpec other) {
        this._typeName = other._typeName;
        this._displayName = other._displayName;
        if (other._properties != null) {
            this._properties = new DisplayDescriptorList();
            for (DisplayDescriptor dd : other._properties) {
                this._properties.add(new DisplayDescriptor(dd));
            }
        }
        if (other._specialProperties != null) {
            this._specialProperties = new ListMap();
            for (Map.Entry entry : other._specialProperties.entrySet()) {
                DisplayDescriptor dd = (DisplayDescriptor)entry.getValue();
                if (dd == null) {
                    throw new IllegalArgumentException("Display descriptor for entity with type name " + this._typeName + " cannot be null");
                }
                this._specialProperties.put(entry.getKey(), (Object)new DisplayDescriptor(dd));
            }
        }
        this._propertyGroups = other._propertyGroups;
        this._defaultCategory = other._defaultCategory;
        this._visible = other._visible;
    }

    public boolean isCopy(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeSpec)) {
            return false;
        }
        TypeSpec other = (TypeSpec)obj;
        if (this._visible != other._visible) {
            return false;
        }
        if (!Objects.equals(this._typeName, other._typeName)) {
            return false;
        }
        if (!Objects.equals(this._displayName, other._displayName)) {
            return false;
        }
        if (!Objects.equals(this._defaultCategory, other._defaultCategory)) {
            return false;
        }
        if (this._properties == null ^ other._properties == null) {
            return false;
        }
        if (this._specialProperties == null ^ other._specialProperties == null) {
            return false;
        }
        if (this._properties != other._properties) {
            if (this._properties.size() != other._properties.size()) {
                return false;
            }
            Iterator thisIterator = this._properties.iterator();
            Iterator otherIterator = other._properties.iterator();
            while (thisIterator.hasNext() && otherIterator.hasNext()) {
                DisplayDescriptor otherDescriptor;
                DisplayDescriptor thisDescriptor = (DisplayDescriptor)thisIterator.next();
                if (thisDescriptor.deepEquals((PropertyDescriptor)(otherDescriptor = (DisplayDescriptor)otherIterator.next()))) continue;
                return false;
            }
        }
        if (this._specialProperties != other._specialProperties) {
            if (this._specialProperties.size() != other._specialProperties.size()) {
                return false;
            }
            for (Map.Entry tuple : this._specialProperties.entrySet()) {
                if (Objects.equals(tuple.getValue(), other._specialProperties.get(tuple.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    public String getDefaultCategory() {
        return this._defaultCategory;
    }

    public void setDefaultCategory(String defaultCategory) {
        this._defaultCategory = defaultCategory;
    }

    public DisplayDescriptor getSpecialProperty(String name) {
        if (this._specialProperties == null) {
            return null;
        }
        return (DisplayDescriptor)this._specialProperties.get((Object)name);
    }

    public void setSpecialProperty(String name, DisplayDescriptor property) {
        if (this._specialProperties == null) {
            this._specialProperties = new ListMap();
        }
        if (property == null) {
            this._specialProperties.remove((Object)name);
        } else {
            this._specialProperties.put((Object)name, (Object)property);
        }
    }

    public PropertyConfiguration getPropertyConfiguration() {
        return new PropertyConfiguration((DisplayDescriptorEnumeration)this._properties, this._propertyGroups, this._specialProperties);
    }

    public String getTypeName() {
        return this._typeName;
    }

    public void setTypeName(String typeName) {
        this._typeName = typeName;
    }

    public String getID() {
        return TypeSpec.parseTypeName(this._typeName)[1];
    }

    public String getNamespace() {
        return TypeSpec.parseTypeName(this._typeName)[0];
    }

    private static String[] parseTypeName(String s) {
        if (s == null) {
            return new String[]{"", ""};
        }
        int last = s.lastIndexOf(46);
        if (last < 0) {
            return new String[]{"", s};
        }
        String namespace = s.substring(0, last);
        String id = last + 1 > s.length() ? "" : s.substring(last + 1, s.length());
        return new String[]{namespace, id};
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.getTypeName() != null ? this.getTypeName().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeSpec)) {
            return false;
        }
        TypeSpec other = (TypeSpec)obj;
        return Objects.equals(this.getTypeName(), other.getTypeName());
    }

    public String getDisplayName() {
        if (this._displayName == null) {
            return this.getTypeName();
        }
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public DisplayDescriptorCollection getProperties() {
        return this._properties;
    }

    public GroupDefinitions getPropertyGroups() {
        if (this._propertyGroups == null) {
            this._propertyGroups = new GroupDefinitions();
        }
        return this._propertyGroups;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }
}

