/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphLogger;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedProvider;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.runner.TransformMessageWindow;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformsRunContext;
import com.paterva.maltego.transform.runner.api.impl.DefaultTransformMessageHandler;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.StringUtilities;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class UITransformMessageHandler
extends DefaultTransformMessageHandler {
    private long dismissTime = 0L;

    protected void display(TransformRunContext ctx, TransformMessage message, MaltegoEntity inputEntity) {
        Args.notNull((Object)ctx, (String)"ctx");
        Args.notNull((Object)message, (String)"message");
        TransformsRunContext transformsContext = ctx.getTransformsContext();
        if (ctx.getInputEntities().isEmpty()) {
            this.display(transformsContext, message);
        } else {
            Map<Guid, MaltegoEntity> inputEntities = inputEntity == null ? ctx.getInputEntities() : Collections.singletonMap(inputEntity.getID(), inputEntity);
            this.displayWithEntities(transformsContext, message, inputEntities);
        }
    }

    protected void display(TransformsRunContext ctx, TransformMessage message) {
        TransformMessageWindow window = TransformMessageWindow.getDefault();
        this.displayLog(ctx, message);
        window.write(message);
    }

    protected void displayWithEntities(TransformsRunContext ctx, TransformMessage message, Map<EntityID, MaltegoEntity> inputEntities) {
        TransformMessageWindow window = TransformMessageWindow.getDefault();
        this.displayLog(ctx, message);
        window.writeWithEntities(message, ctx.getTargetGraphID(), inputEntities);
    }

    private void displayLog(TransformsRunContext ctx, TransformMessage message) {
        if (message.mustLog()) {
            GraphID graphID = ctx.getTargetGraphID();
            GraphLogger.getDefault().log(graphID, message.getText());
        }
    }

    protected void popupErrors(TransformDefinition transform, List<TransformMessage> messages) {
        if (System.nanoTime() - this.dismissTime < Duration.ofSeconds(1L).toNanos()) {
            return;
        }
        HubSeedDescriptor hubSeed = null;
        List hubSeeds = HubSeedRegistry.getDefault().getHubSeeds((TransformDescriptor)transform);
        if (!hubSeeds.isEmpty()) {
            hubSeed = (HubSeedDescriptor)hubSeeds.get(0);
        }
        StringBuilder errors = new StringBuilder();
        errors.append("The following error(s) occurred with the transform '");
        errors.append(transform.getDisplayName()).append("'");
        boolean ioException = this.containsIOExceptionMessage(messages);
        if (hubSeed != null && !ioException) {
            errors.append(" for the hub item ").append(hubSeed.getDisplayName()).append(".\n\n");
            HubSeedProvider provider = hubSeed.getProvider();
            if (provider != null) {
                String providerName = provider.getName();
                String providerEmail = provider.getEmail();
                if (!StringUtilities.isNullOrEmpty((String)providerName) || !StringUtilities.isNullOrEmpty((String)providerEmail)) {
                    errors.append("Please contact the transforms developer");
                    if (!StringUtilities.isNullOrEmpty((String)providerName)) {
                        errors.append(" ").append(providerName);
                    }
                    if (!StringUtilities.isNullOrEmpty((String)providerEmail)) {
                        errors.append(" at ").append(providerEmail);
                    }
                    errors.append(" to report the issue.\n\n");
                }
            }
        } else {
            errors.append(".\n\n");
        }
        errors.append("Error(s):\n");
        for (TransformMessage message : messages) {
            if (message.getSeverity() != TransformMessage.Severity.Error) continue;
            errors.append("   - ");
            errors.append(message.getText());
            errors.append("\n");
        }
        String message = errors.toString();
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
        String dismissOption = "Dismiss All";
        nd.setOptions((Object[])new String[]{"OK", dismissOption});
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (dismissOption.equals(result)) {
            this.dismissTime = System.nanoTime();
        }
    }

    private boolean containsIOExceptionMessage(List<TransformMessage> messages) {
        boolean unknownHost = false;
        for (TransformMessage message : messages) {
            String text = message.getText();
            if (text == null || !text.contains("IOException connection problem")) continue;
            unknownHost = true;
            break;
        }
        return unknownHost;
    }
}

