/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractHttpProtocolHandler;
import org.xlightweb.BadMessageException;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.FullMessageBodyParser;
import org.xlightweb.FullMessageChunkedBodyParser;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpResponseHeaderParser;
import org.xlightweb.MultipartByteRangeMessageBodyParser;
import org.xlightweb.SimpleMessageBodyParser;
import org.xlightweb.SimpleResponseMessageException;
import org.xsocket.connection.INonBlockingConnection;

final class HttpProtocolHandlerClientSide
extends AbstractHttpProtocolHandler {
    private static final Logger LOG = Logger.getLogger(HttpProtocolHandlerClientSide.class.getName());

    HttpProtocolHandlerClientSide() {
    }

    protected void onData(AbstractHttpConnection httpConnection, INonBlockingConnection underlyingConnection, ComposedByteBuffer rawData) throws BadMessageException, IOException {
        try {
            switch (this.getState()) {
                case 0: {
                    this.setHeaderParser(HttpResponseHeaderParser.newInstance());
                    this.setState(5);
                    this.onData(httpConnection, underlyingConnection, rawData);
                    return;
                }
                case 5: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + httpConnection.getId() + "] parsing header (available network data " + rawData.available() + ")");
                    }
                    this.parseHeader(httpConnection, underlyingConnection, rawData);
                    break;
                }
                default: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + httpConnection.getId() + "] parsing body (available network data " + rawData.available() + ")");
                    }
                    this.parserBody(rawData);
                    break;
                }
            }
        }
        catch (BufferUnderflowException ignore) {
            // empty catch block
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + httpConnection.getId() + "] after parse (available network data " + rawData.available() + ")");
        }
    }

    private void parseHeader(AbstractHttpConnection httpConnection, INonBlockingConnection underlyingConnection, ComposedByteBuffer rawData) throws BadMessageException, IOException {
        HttpResponseHeader responseHeader = null;
        try {
            responseHeader = (HttpResponseHeader)this.getHeaderParser().parse(underlyingConnection, rawData);
        }
        catch (SimpleResponseMessageException sre) {
            httpConnection.setLastTimeHeaderReceivedMillis(System.currentTimeMillis());
            httpConnection.incCountMessageReceived();
            responseHeader = new HttpResponseHeader(200);
            responseHeader.setProtocolVersionSilence("0.9");
            responseHeader.setSimpleResponse(true);
            this.setBodyParser(new SimpleMessageBodyParser(httpConnection, responseHeader));
            HttpResponse response = new HttpResponse(responseHeader);
            response.setBodyDataSourceSilence(this.getBodyParser().getDataSource());
            this.setState(10);
            this.parserBody(rawData);
            AbstractHttpConnection.IMessageHandler messageHandler = httpConnection.getMessageHandler();
            if (messageHandler == null) {
                throw new IOException("no message handler set");
            }
            messageHandler.onMessage(response);
            return;
        }
        if (responseHeader != null) {
            httpConnection.setLastTimeHeaderReceivedMillis(System.currentTimeMillis());
            httpConnection.incCountMessageReceived();
            AbstractHttpConnection.IMessageHandler messageHandler = httpConnection.getMessageHandler();
            if (messageHandler == null) {
                throw new IOException("no message handler set");
            }
            try {
                HttpResponse response = null;
                switch (HttpProtocolHandlerClientSide.getBodyType(httpConnection, responseHeader, messageHandler.isBodylessMessageExpected())) {
                    case 0: {
                        response = new HttpResponse(responseHeader);
                        this.reset();
                        break;
                    }
                    case 1: {
                        this.setBodyParser(new FullMessageBodyParser(httpConnection, responseHeader));
                        response = new HttpResponse(responseHeader);
                        response.setBodyDataSourceSilence(this.getBodyParser().getDataSource());
                        this.setState(10);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        this.parserBody(rawData);
                        break;
                    }
                    case 3: {
                        this.setBodyParser(new SimpleMessageBodyParser(httpConnection, responseHeader));
                        response = new HttpResponse(responseHeader);
                        response.setBodyDataSourceSilence(this.getBodyParser().getDataSource());
                        this.setState(10);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        this.parserBody(rawData);
                        break;
                    }
                    case 4: {
                        this.setBodyParser(new MultipartByteRangeMessageBodyParser(httpConnection, responseHeader));
                        response = new HttpResponse(responseHeader);
                        response.setBodyDataSourceSilence(this.getBodyParser().getDataSource());
                        this.setState(10);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        this.parserBody(rawData);
                        break;
                    }
                    default: {
                        this.setBodyParser(new FullMessageChunkedBodyParser(httpConnection, responseHeader));
                        response = new HttpResponse(responseHeader);
                        response.setBodyDataSourceSilence(this.getBodyParser().getDataSource());
                        this.setState(10);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        this.parserBody(rawData);
                    }
                }
                messageHandler.onMessage(response);
                return;
            }
            catch (BadMessageException bme) {
                throw bme;
            }
            catch (IOException ioe) {
                messageHandler.onException(ioe);
                throw ioe;
            }
        }
    }

    private static int getBodyType(AbstractHttpConnection httpConnection, HttpResponseHeader responseHeader, boolean isBodylessMessageExcpected) throws BadMessageException {
        if (isBodylessMessageExcpected) {
            return 0;
        }
        int status = responseHeader.getStatus();
        if (status == 304 || status == 204 || status == 100 || status == 101) {
            return 0;
        }
        if (responseHeader.getContentLength() != -1) {
            if (responseHeader.getContentLength() > 0) {
                return 1;
            }
            return 0;
        }
        String transferEncoding = responseHeader.getTransferEncoding();
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            return 2;
        }
        if (responseHeader.getStatus() == 206 && responseHeader.getContentType() != null && responseHeader.getContentType().toLowerCase().startsWith("multipart/byteranges")) {
            return 4;
        }
        if (responseHeader.getConnection() != null && responseHeader.getConnection().equalsIgnoreCase("close")) {
            httpConnection.setPersistent(false);
            return 3;
        }
        if (responseHeader.getContentType() != null) {
            httpConnection.setPersistent(false);
            return 3;
        }
        throw new BadMessageException(responseHeader.toString());
    }
}

