/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.ComplexTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import com.pinkmatter.types.DateRange;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.FieldValueQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

class DateRangeConverter
extends ComplexTypeConverter<DateRange> {
    protected static final String FROM = "from";
    protected static final String TO = "to";
    private static final Date MIN_DATE = new Date(Long.MIN_VALUE);
    private static final Date MAX_DATE = new Date(Long.MAX_VALUE);

    public DateRangeConverter() {
        super("daterange", DateRange.class);
    }

    @Override
    protected void writeImpl(DateRange value, String field, Document to) throws PandoraException {
        Date fromDate = value.getFrom() == null ? MIN_DATE : value.getFrom();
        Date toDate = value.getTo() == null ? MAX_DATE : value.getTo();
        this.writeChild(field, FROM, fromDate, to);
        this.writeChild(field, TO, toDate, to);
    }

    @Override
    protected Object readComplexImpl(List<IndexableField> from, String prefix) throws PandoraException {
        Map<String, Object> values = super.readChildrenAsMap(from, prefix);
        return this.createDateRange((Date)values.get(FROM), (Date)values.get(TO));
    }

    private DateRange createDateRange(Date from, Date to) {
        if (from == MIN_DATE) {
            from = null;
        }
        if (to == MAX_DATE) {
            to = null;
        }
        return new DateRange(from, to);
    }

    @Override
    protected SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        SortField[] fromFields = DateRangeConverter.getSortFields(Date.class, this.getQualifiedChildProperty(property, FROM), reverse, emptyFirst);
        SortField[] toFields = DateRangeConverter.getSortFields(Date.class, this.getQualifiedChildProperty(property, TO), reverse, emptyFirst);
        SortField[] all = new SortField[fromFields.length + toFields.length];
        if (!reverse) {
            System.arraycopy(fromFields, 0, all, 0, fromFields.length);
            System.arraycopy(toFields, 0, all, fromFields.length, toFields.length);
        } else {
            System.arraycopy(toFields, 0, all, 0, toFields.length);
            System.arraycopy(fromFields, 0, all, toFields.length, fromFields.length);
        }
        return all;
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) throws PandoraException {
        if (DateRange.class.isAssignableFrom(parameters.getType())) {
            String property = parameters.getProperty();
            if (parameters instanceof PandoraFilter.Contains) {
                PandoraFilter.Contains params = (PandoraFilter.Contains)parameters;
                return this.createContainsFilter(property, (DateRange)params.getValue());
            }
            if (parameters instanceof PandoraFilter.Within) {
                PandoraFilter.Within params = (PandoraFilter.Within)parameters;
                return this.createWithinFilter(property, (DateRange)params.getValue());
            }
            if (parameters instanceof PandoraFilter.Intersects) {
                PandoraFilter.Intersects params = (PandoraFilter.Intersects)parameters;
                return this.createIntersectFilter(property, (DateRange)params.getValue());
            }
        } else if (Date.class.isAssignableFrom(parameters.getType())) {
            String property = parameters.getProperty();
            if (parameters instanceof PandoraFilter.Contains) {
                PandoraFilter.Contains params = (PandoraFilter.Contains)parameters;
                DateRange pointRange = new DateRange((Date)params.getValue(), (Date)params.getValue());
                return this.createContainsFilter(property, pointRange);
            }
            if (parameters instanceof PandoraFilter.Within) {
                PandoraFilter.Within params = (PandoraFilter.Within)parameters;
                DateRange pointRange = new DateRange((Date)params.getValue(), (Date)params.getValue());
                return this.createWithinFilter(property, pointRange);
            }
            if (parameters instanceof PandoraFilter.Intersects) {
                PandoraFilter.Intersects params = (PandoraFilter.Intersects)parameters;
                DateRange pointRange = new DateRange((Date)params.getValue(), (Date)params.getValue());
                return this.createIntersectFilter(property, pointRange);
            }
        }
        return null;
    }

    private Query createContainsFilter(String property, DateRange range) throws PandoraException {
        Query fromFilter = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.LessThan(this.getQualifiedChildProperty(property, FROM), (Object)range.getFrom(), true));
        Query toFilter = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.GreaterThan(this.getQualifiedChildProperty(property, TO), (Object)range.getTo(), true));
        return FilterHelper.createAndFilter(fromFilter, toFilter);
    }

    private Query createWithinFilter(String property, DateRange range) throws PandoraException {
        FieldValueQuery toFilter;
        FieldValueQuery fromFilter;
        if (range.equals((Object)DateRange.forever())) {
            TypeConverter dateConverter = TypeConverter.get(Date.class);
            fromFilter = new FieldValueQuery(this.getQualifiedChildProperty(property, dateConverter.getIndexField(FROM)));
            toFilter = new FieldValueQuery(this.getQualifiedChildProperty(property, dateConverter.getIndexField(TO)));
        } else {
            fromFilter = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.GreaterThan(this.getQualifiedChildProperty(property, FROM), (Object)range.getFrom(), true));
            toFilter = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.LessThan(this.getQualifiedChildProperty(property, TO), (Object)range.getTo(), true));
        }
        return FilterHelper.createAndFilter(new Query[]{fromFilter, toFilter});
    }

    private Query createIntersectFilter(String property, DateRange range) throws PandoraException {
        FieldValueQuery toFilter;
        FieldValueQuery fromFilter;
        if (range.equals((Object)DateRange.forever())) {
            TypeConverter dateConverter = TypeConverter.get(Date.class);
            fromFilter = new FieldValueQuery(this.getQualifiedChildProperty(property, dateConverter.getIndexField(FROM)));
            toFilter = new FieldValueQuery(this.getQualifiedChildProperty(property, dateConverter.getIndexField(TO)));
        } else {
            fromFilter = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.LessThan(this.getQualifiedChildProperty(property, FROM), (Object)range.getTo(), true));
            toFilter = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.GreaterThan(this.getQualifiedChildProperty(property, TO), (Object)range.getFrom(), true));
        }
        return FilterHelper.createAndFilter(new Query[]{fromFilter, toFilter});
    }

    @Override
    protected Query createEmptyFilterImpl(String property) throws PandoraException {
        Query emptyFilterFrom = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.Empty(this.getQualifiedChildProperty(property, FROM)));
        Query emptyFilterTo = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.Empty(this.getQualifiedChildProperty(property, TO)));
        return FilterHelper.createAndFilter(emptyFilterFrom, emptyFilterTo);
    }

    @Override
    protected Query createNotEmptyFilterImpl(String property) throws PandoraException {
        Query emptyFilterFrom = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.NotEmpty(this.getQualifiedChildProperty(property, FROM)));
        Query emptyFilterTo = DateRangeConverter.getFilter(Date.class, (PandoraFilter.Simple)new PandoraFilter.NotEmpty(this.getQualifiedChildProperty(property, TO)));
        return FilterHelper.createOrQuery(emptyFilterFrom, emptyFilterTo);
    }
}

