/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub;

import com.paterva.maltego.seeds.ui.HubItemDescriptor;
import com.paterva.maltego.seeds.ui.HubSeedsHomePanel;
import com.paterva.maltego.seeds.ui.hub.HubSeedsPanel;
import com.paterva.maltego.seeds.ui.hub.SeedItemDescriptor;
import com.paterva.maltego.util.ui.button.CollapseExpandButton;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HubItemsPanel
extends JPanel {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final String expandedPrefName;
    private final HubSeedsPanel seedsPanel = new HubSeedsPanel();
    private JPanel centerPanel;
    private JButton collapseButton;
    private JLabel itemsShownLabel;
    private JPanel northPanel;
    private JLabel titleLabel;

    public HubItemsPanel(String title, String expandedPrefName) {
        this.expandedPrefName = expandedPrefName;
        this.initComponents();
        this.centerPanel.add(this.seedsPanel);
        this.titleLabel.setFont(this.getFontScaled("hub-sections-title-font"));
        this.titleLabel.setText(title);
        this.northPanel.setBorder(new EmptyBorder(0, HubSeedsHomePanel.HUB_PADDING_SIDES, 0, HubSeedsHomePanel.HUB_PADDING_SIDES));
    }

    public int getResetCount(List<HubItemDescriptor> items) {
        return this.getFilteredItems(items, false).size();
    }

    public void setItems(List<HubItemDescriptor> items, int resetCount) {
        items = this.getFilteredItems(items, true);
        this.seedsPanel.setItems(items, this.includeAddPlaceholder());
        this.itemsShownLabel.setText(items.size() + "/" + resetCount + " shown");
    }

    private List<HubItemDescriptor> getFilteredItems(List<HubItemDescriptor> items, boolean tagFilter) {
        return items.stream().filter(item -> item instanceof SeedItemDescriptor).map(item -> (SeedItemDescriptor)item).filter(item -> this.filter((SeedItemDescriptor)item, tagFilter)).collect(Collectors.toList());
    }

    protected boolean filter(SeedItemDescriptor item, boolean tagFilter) {
        return true;
    }

    protected boolean includeAddPlaceholder() {
        return false;
    }

    protected void setBackgroundColor(Color bgColor) {
        this.seedsPanel.setBackground(bgColor);
        this.northPanel.setBackground(bgColor);
        this.collapseButton.putClientProperty("inHubPanel", Boolean.TRUE);
    }

    private Font getFontScaled(String key) {
        return LAF.getFont(key);
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        this.northPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.collapseButton = new CollapseExpandButton((JComponent)this.centerPanel, this.expandedPrefName);
        this.itemsShownLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new BorderLayout());
        this.add((Component)this.centerPanel, "Center");
        this.northPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(HubItemsPanel.class, (String)"HubItemsPanel.titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.northPanel.add((Component)this.titleLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.collapseButton, (String)NbBundle.getMessage(HubItemsPanel.class, (String)"HubItemsPanel.collapseButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.northPanel.add((Component)this.collapseButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.itemsShownLabel, (String)NbBundle.getMessage(HubItemsPanel.class, (String)"HubItemsPanel.itemsShownLabel.text"));
        this.itemsShownLabel.setToolTipText(NbBundle.getMessage(HubItemsPanel.class, (String)"HubItemsPanel.itemsShownLabel.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.northPanel.add((Component)this.itemsShownLabel, gridBagConstraints);
        this.add((Component)this.northPanel, "North");
    }
}

