/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.archiver;

import gov.nist.isg.archiver.FilesArchiver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryArchiver
implements FilesArchiver {
    private final File directory;
    private static final Logger logger = Logger.getLogger(DirectoryArchiver.class.getName());

    public DirectoryArchiver(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("The path '" + directory + "' is not a directory.");
            }
        } else {
            int attempts = 0;
            while (!directory.exists()) {
                ++attempts;
                boolean created = directory.mkdirs();
                if (created) continue;
                if (attempts > 10) {
                    throw new IOException("Cannot create directory '" + directory + "'");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    throw new IOException("Interrupted while waiting to create directory " + directory, ex);
                }
            }
            if (attempts == 0) {
                logger.log(Level.FINEST, "Directory was created (but not by this thread)");
            } else {
                logger.log(Level.FINEST, "Directory was created after {0} attempts", attempts);
            }
        }
        this.directory = directory;
    }

    @Override
    public <T> T appendFile(String path, FilesArchiver.FileAppender<T> appender) throws IOException {
        boolean created;
        File file = new File(this.directory, path);
        File parent = file.getParentFile();
        if (!parent.exists() && !(created = parent.mkdirs())) {
            if (!parent.exists()) {
                throw new IOException("Cannot create directory " + parent);
            }
            logger.log(Level.FINEST, "Directory was created (but not by us)");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            T t = appender.append(fos);
            return t;
        }
    }

    @Override
    public <T> T appendBigFile(String path, FilesArchiver.FileAppender<T> appender) throws IOException {
        return this.appendFile(path, appender);
    }

    @Override
    public void appendFile(String path, File file) throws IOException {
        File outputFile = new File(this.directory, path);
        Files.copy(file.toPath(), outputFile.toPath(), new CopyOption[0]);
    }

    @Override
    public void close() throws IOException {
    }
}

