#!/usr/bin/env python

import os

class ModuleError(Exception):
	pass

class FStealerModule:
	def __init__(self, fstealer, modulepath):
		self.fstealer = fstealer
		self.modulepath = modulepath
		if hasattr(self, "initialize"):
			self.initialize()

	def addPath(self, path, priority=5):
		self.fstealer.addPath(path, priority)

	def delPath(self, path):
		self.fstealer.delPath(path)

	def blacklistPath(self, path):
		self.fstealer.blacklistPath(path)

	def tagPath(self, path, tag):
		self.fstealer.tagPath(path, tag)

	def openModuleFile(self, filename, mode):
		try:
			return open(os.path.join(self.modulepath, filename), mode)
		except IOError:
			raise ModuleError("Could not open module data: %s"%(filename))

module = None
