#!/usr/bin/env python

import re
from module import FStealerModule

class GenericModule(FStealerModule):
	def initialize(self):
		self.pathpattern = re.compile("((/[a-zA-Z0-9_\.]+)+)")

	def postGetFile(self, path, data):
		matches = map(lambda x: x[0], self.pathpattern.findall(data))
		for match in matches:
			self.addPath(match,1)
		self.tagPath(path, str(matches))

module = GenericModule
