import os
from modules import *

class ModuleFactory:
	def __init__(self, fstealer):
		self.fstealer = fstealer

	def create(self, cls, modulepath):
		return cls(self.fstealer, modulepath)

class ModuleContainer(list):
	def __init__(self, factory, moduledatapath):
		list.__init__(self)
		self.loadModules(factory, moduledatapath)

	def loadModules(self, factory, moduledatapath):
		lib = __import__("libfstealer")
		subdir = getattr(lib, "modules")
		modules = getattr(subdir, "__all__")
		for modulefile in modules:
			module = getattr(subdir, modulefile)
			module_class = getattr(module, "module")
			if module_class is not None:
				instance = factory.create(module_class, os.path.join(moduledatapath, module_class.__name__))
				self.append(instance)

	def notify(self, eventname, *args):
		for module in self:
			if hasattr(module, eventname):
				method = getattr(module, eventname)
				method(*args)
			
