#!/usr/bin/env python

import re

class BlacklistEntry:
	def __init__(self, pattern):
		self.rawpattern = pattern
		self.pattern = re.compile(pattern)

	def match(self, path):
		return self.pattern.match(path) is not None

	def __eq__(self, entry):
		return self.rawpattern == entry.rawpattern

	def __hash__(self):
		return hash(self.rawpattern)

class Blacklist(set):
	def __init__(self, blacklist):
		set.__init__(self)

		f = open(blacklist, "r")
		for line in f:
			self.add(line.strip())

	def blacklisted(self, path):
		for entry in self:
			if entry.match(path):
				return True
		return False

	def add(self, item, noregex = False):
		if noregex:
			set.add(self, BlacklistEntry("^%s$"%item))
		else:
			set.add(self, BlacklistEntry(item))


