/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.eclipse.packager.rpm.RpmBaseTag;
import org.eclipse.packager.rpm.RpmTag;
import org.eclipse.packager.rpm.parse.RpmInputStream;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.ArchiveExtractionException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ArchiveAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveAnalyzer.class);
    private static final AtomicInteger DIRECTORY_COUNT = new AtomicInteger(0);
    private File tempFileLocation = null;
    private int maxScanDepth;
    private FileFilter fileFilter = null;
    private static final Set<String> KNOWN_ZIP_EXT = Collections.unmodifiableSet(ArchiveAnalyzer.newHashSet("zip", "ear", "war", "jar", "sar", "apk", "nupkg", "aar"));
    private static final Set<String> ADDITIONAL_ZIP_EXT = new HashSet<String>();
    private static final Set<String> EXTENSIONS = Collections.unmodifiableSet(ArchiveAnalyzer.newHashSet("tar", "gz", "tgz", "bz2", "tbz2", "rpm"));
    private static final FileFilter REMOVE_FROM_ANALYSIS = FileFilterBuilder.newInstance().addExtensions("zip", "tar", "gz", "tgz", "bz2", "tbz2", "nupkg", "rpm").build();
    private static final FileFilter ZIP_FILTER = FileFilterBuilder.newInstance().addExtensions("zip").build();
    private static final String ANALYZER_NAME = "Archive Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INITIAL;

    @Override
    public void initialize(Settings settings) {
        super.initialize(settings);
        this.initializeSettings();
    }

    @Override
    protected FileFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.archive.enabled";
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        try {
            File baseDir = this.getSettings().getTempDirectory();
            this.tempFileLocation = File.createTempFile("check", "tmp", baseDir);
            if (!this.tempFileLocation.delete()) {
                this.setEnabled(false);
                String msg = String.format("Unable to delete temporary file '%s'.", this.tempFileLocation.getAbsolutePath());
                throw new InitializationException(msg);
            }
            if (!this.tempFileLocation.mkdirs()) {
                this.setEnabled(false);
                String msg = String.format("Unable to create directory '%s'.", this.tempFileLocation.getAbsolutePath());
                throw new InitializationException(msg);
            }
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to create a temporary file", ex);
        }
    }

    @Override
    public void closeAnalyzer() throws Exception {
        if (this.tempFileLocation != null && this.tempFileLocation.exists()) {
            String[] l;
            LOGGER.debug("Attempting to delete temporary files from `{}`", (Object)this.tempFileLocation.toString());
            boolean success = FileUtils.delete((File)this.tempFileLocation);
            if (!success && this.tempFileLocation.exists() && (l = this.tempFileLocation.list()) != null && l.length > 0) {
                LOGGER.warn("Failed to delete the Archive Analyzer's temporary files from `{}`, see the log for more details", (Object)this.tempFileLocation.toString());
            }
        }
    }

    @Override
    public boolean accept(File pathname) {
        boolean accept = super.accept(pathname);
        boolean npmEnabled = this.getSettings().getBoolean("analyzer.node.audit.enabled", false);
        boolean yarnEnabled = this.getSettings().getBoolean("analyzer.yarn.audit.enabled", false);
        boolean pnpmEnabled = this.getSettings().getBoolean("analyzer.pnpm.audit.enabled", false);
        if (accept && (npmEnabled || yarnEnabled || pnpmEnabled)) {
            try {
                accept = AbstractNpmAnalyzer.shouldProcess(pathname);
            }
            catch (AnalysisException ex) {
                throw new UnexpectedAnalysisException(ex.getMessage(), ex.getCause());
            }
        }
        return accept;
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        this.extractAndAnalyze(dependency, engine, 0);
        engine.sortDependencies();
    }

    private void extractAndAnalyze(Dependency dependency, Engine engine, int scanDepth) throws AnalysisException {
        File f = new File(dependency.getActualFilePath());
        File tmpDir = this.getNextTempDirectory();
        this.extractFiles(f, tmpDir, engine);
        List<Dependency> dependencySet = ArchiveAnalyzer.findMoreDependencies(engine, tmpDir);
        if (dependencySet != null && !dependencySet.isEmpty()) {
            for (Dependency d : dependencySet) {
                if (d.getFilePath().startsWith(tmpDir.getAbsolutePath())) {
                    String displayPath = String.format("%s%s", dependency.getFilePath(), d.getActualFilePath().substring(tmpDir.getAbsolutePath().length()));
                    String displayName = String.format("%s: %s", dependency.getFileName(), d.getFileName());
                    d.setFilePath(displayPath);
                    d.setFileName(displayName);
                    d.addAllProjectReferences(dependency.getProjectReferences());
                    if (!this.accept(d.getActualFile()) || scanDepth >= this.maxScanDepth) continue;
                    this.extractAndAnalyze(d, engine, scanDepth + 1);
                    continue;
                }
                dependencySet.stream().filter(sub -> sub.getFilePath().startsWith(tmpDir.getAbsolutePath())).forEach(sub -> {
                    String displayPath = String.format("%s%s", dependency.getFilePath(), sub.getActualFilePath().substring(tmpDir.getAbsolutePath().length()));
                    String displayName = String.format("%s: %s", dependency.getFileName(), sub.getFileName());
                    sub.setFilePath(displayPath);
                    sub.setFileName(displayName);
                });
            }
        }
        if (REMOVE_FROM_ANALYSIS.accept(dependency.getActualFile())) {
            this.addDisguisedJarsToDependencies(dependency, engine);
            engine.removeDependency(dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDisguisedJarsToDependencies(Dependency dependency, Engine engine) throws AnalysisException {
        if (ZIP_FILTER.accept(dependency.getActualFile()) && this.isZipFileActuallyJarFile(dependency)) {
            File tempDir = this.getNextTempDirectory();
            String fileName = dependency.getFileName();
            LOGGER.info("The zip file '{}' appears to be a JAR file, making a copy and analyzing it as a JAR.", (Object)fileName);
            File tmpLoc = new File(tempDir, fileName.substring(0, fileName.length() - 3) + "jar");
            String archiveMd5 = dependency.getMd5sum();
            String archiveSha1 = dependency.getSha1sum();
            String archiveSha256 = dependency.getSha256sum();
            try {
                dependency.setMd5sum("");
                dependency.setSha1sum("");
                dependency.setSha256sum("");
                Files.copy(dependency.getActualFile().toPath(), tmpLoc.toPath(), new CopyOption[0]);
                List<Dependency> dependencySet = ArchiveAnalyzer.findMoreDependencies(engine, tmpLoc);
                if (dependencySet != null && !dependencySet.isEmpty()) {
                    dependencySet.forEach(d -> {
                        if (d.getActualFile().equals(tmpLoc)) {
                            d.setFilePath(dependency.getFilePath());
                            d.setDisplayFileName(dependency.getFileName());
                        } else {
                            d.getRelatedDependencies().stream().filter(rel -> rel.getActualFile().equals(tmpLoc)).forEach(rel -> {
                                rel.setFilePath(dependency.getFilePath());
                                rel.setDisplayFileName(dependency.getFileName());
                            });
                        }
                    });
                }
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to perform deep copy on '{}'", (Object)dependency.getActualFile().getPath(), (Object)ex);
            }
            finally {
                dependency.setMd5sum(archiveMd5);
                dependency.setSha1sum(archiveSha1);
                dependency.setSha256sum(archiveSha256);
            }
        }
    }

    private static List<Dependency> findMoreDependencies(Engine engine, File file) {
        return engine.scan(file);
    }

    private File getNextTempDirectory() throws AnalysisException {
        File directory = new File(this.tempFileLocation, String.valueOf(DIRECTORY_COUNT.incrementAndGet()));
        if (directory.exists()) {
            return this.getNextTempDirectory();
        }
        if (!directory.mkdirs()) {
            String msg = String.format("Unable to create temp directory '%s'.", directory.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        return directory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractFiles(File archive, File destination, Engine engine) throws AnalysisException {
        BZip2CompressorInputStream bzin;
        GzipCompressorInputStream gin;
        TarArchiveInputStream tin;
        ZipInputStream zin;
        BufferedInputStream in;
        FileInputStream fis;
        block17: {
            if (archive == null) return;
            if (destination == null) return;
            String archiveExt = FileUtils.getFileExtension((String)archive.getName());
            if (archiveExt == null) {
                return;
            }
            archiveExt = archiveExt.toLowerCase();
            try {
                fis = new FileInputStream(archive);
            }
            catch (FileNotFoundException ex) {
                String msg = String.format("Error extracting file `%s`: %s", archive.getAbsolutePath(), ex.getMessage());
                LOGGER.debug(msg, (Throwable)ex);
                throw new AnalysisException(msg);
            }
            in = null;
            zin = null;
            tin = null;
            gin = null;
            bzin = null;
            RpmInputStream rin = null;
            CpioArchiveInputStream cain = null;
            try {
                if (KNOWN_ZIP_EXT.contains(archiveExt) || ADDITIONAL_ZIP_EXT.contains(archiveExt)) {
                    in = new BufferedInputStream(fis);
                    this.ensureReadableJar(archiveExt, in);
                    zin = new ZipInputStream(in);
                    this.extractArchive(zin, destination, engine);
                    break block17;
                }
                if ("tar".equals(archiveExt)) {
                    in = new BufferedInputStream(fis);
                    tin = new TarArchiveInputStream((InputStream)in);
                    this.extractArchive((ArchiveInputStream)tin, destination, engine);
                    break block17;
                }
                if ("gz".equals(archiveExt) || "tgz".equals(archiveExt)) {
                    String uncompressedName = GzipUtils.getUncompressedFilename((String)archive.getName());
                    File f = new File(destination, uncompressedName);
                    if (engine.accept(f)) {
                        String destPath = destination.getCanonicalPath();
                        if (!f.getCanonicalPath().startsWith(destPath)) {
                            String msg = String.format("Archive (%s) contains a file that would be written outside of the destination directory", archive.getPath());
                            throw new AnalysisException(msg);
                        }
                        in = new BufferedInputStream(fis);
                        gin = new GzipCompressorInputStream((InputStream)in);
                        this.decompressFile((CompressorInputStream)gin, f);
                    }
                    break block17;
                }
                if ("bz2".equals(archiveExt) || "tbz2".equals(archiveExt)) {
                    String uncompressedName = BZip2Utils.getUncompressedFilename((String)archive.getName());
                    File f = new File(destination, uncompressedName);
                    if (engine.accept(f)) {
                        String destPath = destination.getCanonicalPath();
                        if (!f.getCanonicalPath().startsWith(destPath)) {
                            String msg = String.format("Archive (%s) contains a file that would be written outside of the destination directory", archive.getPath());
                            throw new AnalysisException(msg);
                        }
                        in = new BufferedInputStream(fis);
                        bzin = new BZip2CompressorInputStream((InputStream)in);
                        this.decompressFile((CompressorInputStream)bzin, f);
                    }
                    break block17;
                }
                if ("rpm".equals(archiveExt)) {
                    rin = new RpmInputStream((InputStream)fis);
                    rin.getPayloadHeader().getTag((RpmBaseTag)RpmTag.NAME);
                    cain = new CpioArchiveInputStream((InputStream)rin);
                    this.extractArchive((ArchiveInputStream)cain, destination, engine);
                }
            }
            catch (ArchiveExtractionException ex) {
                try {
                    LOGGER.error("Exception extracting archive '{}'.", (Object)archive.getName());
                    LOGGER.debug("", (Throwable)ex);
                    throw new AnalysisException(ex.getMessage(), ex);
                    catch (IOException ex2) {
                        LOGGER.error("Exception reading archive '{}'.", (Object)archive.getName());
                        LOGGER.debug("", (Throwable)ex2);
                        throw new AnalysisException(ex2.getMessage(), ex2);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.close((Closeable)fis);
                    FileUtils.close(in);
                    FileUtils.close(zin);
                    FileUtils.close(tin);
                    FileUtils.close(gin);
                    FileUtils.close(bzin);
                    throw throwable;
                }
            }
        }
        FileUtils.close((Closeable)fis);
        FileUtils.close((Closeable)in);
        FileUtils.close((Closeable)zin);
        FileUtils.close((Closeable)tin);
        FileUtils.close(gin);
        FileUtils.close(bzin);
    }

    private void ensureReadableJar(String archiveExt, BufferedInputStream in) throws IOException {
        if (("war".equals(archiveExt) || "jar".equals(archiveExt)) && in.markSupported()) {
            in.mark(7);
            byte[] b = new byte[7];
            int read = in.read(b);
            if (read == 7 && b[0] == 35 && b[1] == 33 && b[2] == 47 && b[3] == 98 && b[4] == 105 && b[5] == 110 && b[6] == 47) {
                int chr;
                boolean stillLooking = true;
                while (stillLooking && (chr = in.read()) != -1) {
                    int nxtChr;
                    if (chr != 10 && chr != 13) continue;
                    in.mark(4);
                    chr = in.read();
                    if (chr == -1 || chr != 80 || (chr = in.read()) == -1 || chr != 75 || (chr = in.read()) == -1 || chr != 3 && chr != 5 && chr != 7 || (nxtChr = in.read()) == -1 || nxtChr != chr + 1) continue;
                    stillLooking = false;
                    in.reset();
                }
            } else {
                in.reset();
            }
        }
    }

    private void extractArchive(ZipInputStream input, File destination, Engine engine) throws ArchiveExtractionException {
        try {
            ZipEntry entry;
            Path d = destination.toPath();
            while ((entry = input.getNextEntry()) != null) {
                Path f = d.resolve(entry.getName()).normalize();
                if (!f.startsWith(d)) {
                    LOGGER.debug("ZipSlip detected\n-Destination: " + d + "\n-Path: " + f);
                    String msg = String.format("Archive contains a file (%s) that would be extracted outside of the target directory.", entry.getName());
                    throw new ArchiveExtractionException(msg);
                }
                File file = f.toFile();
                if (entry.isDirectory()) {
                    if (file.exists() || file.mkdirs()) continue;
                    String msg = String.format("Unable to create directory '%s'.", file.getAbsolutePath());
                    throw new AnalysisException(msg);
                }
                if (!engine.accept(file)) continue;
                ArchiveAnalyzer.extractAcceptedFile(input, file);
            }
        }
        catch (IOException | AnalysisException ex) {
            throw new ArchiveExtractionException(ex);
        }
        finally {
            FileUtils.close((Closeable)input);
        }
    }

    private void extractArchive(ArchiveInputStream input, File destination, Engine engine) throws ArchiveExtractionException {
        try {
            ArchiveEntry entry;
            Path d = destination.toPath();
            while ((entry = input.getNextEntry()) != null) {
                Path f = d.resolve(entry.getName()).normalize();
                if (!f.startsWith(d)) {
                    LOGGER.debug("ZipSlip detected\n-Destination: " + d + "\n-Path: " + f);
                    String msg = String.format("Archive contains a file (%s) that would be extracted outside of the target directory.", entry.getName());
                    throw new ArchiveExtractionException(msg);
                }
                File file = f.toFile();
                if (entry.isDirectory()) {
                    if (file.exists() || file.mkdirs()) continue;
                    String msg = String.format("Unable to create directory '%s'.", file.getAbsolutePath());
                    throw new AnalysisException(msg);
                }
                if (!engine.accept(file)) continue;
                ArchiveAnalyzer.extractAcceptedFile(input, file);
            }
        }
        catch (IOException | AnalysisException ex) {
            throw new ArchiveExtractionException(ex);
        }
        finally {
            FileUtils.close((Closeable)input);
        }
    }

    private static void extractAcceptedFile(ZipInputStream input, File file) throws AnalysisException {
        LOGGER.debug("Extracting '{}'", (Object)file.getPath());
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            String msg = String.format("Unable to build directory '%s'.", parent.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)input, (OutputStream)fos);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            String msg = String.format("Unable to find file '%s'.", file.getName());
            throw new AnalysisException(msg, ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            String msg = String.format("IO Exception while parsing file '%s'.", file.getName());
            throw new AnalysisException(msg, ex);
        }
    }

    private static void extractAcceptedFile(ArchiveInputStream input, File file) throws AnalysisException {
        LOGGER.debug("Extracting '{}'", (Object)file.getPath());
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            String msg = String.format("Unable to build directory '%s'.", parent.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)input, (OutputStream)fos);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            String msg = String.format("Unable to find file '%s'.", file.getName());
            throw new AnalysisException(msg, ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            String msg = String.format("IO Exception while parsing file '%s'.", file.getName());
            throw new AnalysisException(msg, ex);
        }
    }

    private void decompressFile(CompressorInputStream inputStream, File outputFile) throws ArchiveExtractionException {
        LOGGER.debug("Decompressing '{}'", (Object)outputFile.getPath());
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new ArchiveExtractionException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFileActuallyJarFile(Dependency dependency) {
        ZipFile zip;
        boolean isJar;
        block5: {
            isJar = false;
            zip = null;
            try {
                zip = new ZipFile(dependency.getActualFilePath());
                if (zip.getEntry("META-INF/MANIFEST.MF") == null && zip.getEntry("META-INF/maven") == null) break block5;
                Enumeration entries = zip.getEntries();
                while (entries.hasMoreElements()) {
                    String name;
                    ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                    if (entry.isDirectory() || !(name = entry.getName().toLowerCase()).endsWith(".class")) continue;
                    isJar = true;
                    break;
                }
            }
            catch (IOException ex) {
                try {
                    LOGGER.debug("Unable to unzip zip file '{}'", (Object)dependency.getFilePath(), (Object)ex);
                }
                catch (Throwable throwable) {
                    ZipFile.closeQuietly(zip);
                    throw throwable;
                }
                ZipFile.closeQuietly((ZipFile)zip);
            }
        }
        ZipFile.closeQuietly((ZipFile)zip);
        return isJar;
    }

    private void initializeSettings() {
        this.maxScanDepth = this.getSettings().getInt("archive.scan.depth", 3);
        HashSet<String> extensions = new HashSet<String>(EXTENSIONS);
        extensions.addAll(KNOWN_ZIP_EXT);
        String additionalZipExt = this.getSettings().getString("extensions.zip");
        if (additionalZipExt != null) {
            String[] ext = additionalZipExt.split("\\s*,\\s*");
            Collections.addAll(extensions, ext);
            Collections.addAll(ADDITIONAL_ZIP_EXT, ext);
        }
        this.fileFilter = FileFilterBuilder.newInstance().addExtensions(extensions).build();
    }
}

